/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.tests.engine.util;

import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.TriggerSupportMatrix;

public class TriggerSupportMatrixTest
extends TestCase {
    private static final String HTML_PATH = "org/eclipse/birt/chart/tests/engine/util/TriggerSupportMatrix_golden.htm";
    private static final ActionType[] ACTION_TYPES = new ActionType[]{ActionType.URL_REDIRECT_LITERAL, ActionType.SHOW_TOOLTIP_LITERAL, ActionType.INVOKE_SCRIPT_LITERAL, ActionType.TOGGLE_VISIBILITY_LITERAL, ActionType.TOGGLE_DATA_POINT_VISIBILITY_LITERAL, ActionType.HIGHLIGHT_LITERAL, ActionType.CALL_BACK_LITERAL};
    private static final String SPLITOR = "\n";

    public void testMatrixAll() {
        StringBuffer sb = new StringBuffer();
        sb.append(new InteractivityTypeInnerTest(1).getMatrixGeneratedString());
        sb.append(new InteractivityTypeInnerTest(8).getMatrixGeneratedString());
        sb.append(new InteractivityTypeInnerTest(16).getMatrixGeneratedString());
        sb.append(new InteractivityTypeInnerTest(2).getMatrixGeneratedString());
        sb.append(new InteractivityTypeInnerTest(4).getMatrixGeneratedString());
        sb.append(new InteractivityTypeInnerTest(32).getMatrixGeneratedString());
        sb.append(new InteractivityTypeInnerTest(64).getMatrixGeneratedString());
        String[] populatedArray = sb.toString().split(SPLITOR);
        String[] goldenArray = this.getMatrixGoldenString().split(SPLITOR);
        TriggerSupportMatrixTest.assertEquals((String)"check line of code", (int)goldenArray.length, (int)populatedArray.length);
        if (goldenArray.length == populatedArray.length) {
            int i = 0;
            while (i < populatedArray.length) {
                String golden = goldenArray[i].replaceAll("\r", "");
                TriggerSupportMatrixTest.assertEquals((String)("check line " + (i + 1) + ":"), (String)golden, (String)populatedArray[i]);
                ++i;
            }
        }
    }

    private String getMatrixGoldenString() {
        StringBuffer sb = new StringBuffer();
        try {
            InputStream is = TriggerSupportMatrixTest.class.getClassLoader().getResourceAsStream(HTML_PATH);
            int c = 0;
            while ((c = is.read()) != -1) {
                sb.append((char)c);
            }
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public void testSupportedActionsDisplayName() {
        TriggerSupportMatrix matSVG = new TriggerSupportMatrix("svg", 1);
        TriggerSupportMatrix matSwing = new TriggerSupportMatrix("png", 1);
        String[] actions = matSVG.getSupportedActionsDisplayName(TriggerCondition.ONCLICK_LITERAL);
        TriggerSupportMatrixTest.assertEquals((int)6, (int)actions.length);
        actions = matSwing.getSupportedActionsDisplayName(TriggerCondition.ONCLICK_LITERAL);
        TriggerSupportMatrixTest.assertEquals((int)2, (int)actions.length);
        TriggerSupportMatrixTest.assertEquals((String)LiteralHelper.actionTypeSet.getDisplayNameByName(ActionType.URL_REDIRECT_LITERAL.getName()), (String)actions[0]);
        TriggerSupportMatrixTest.assertEquals((String)LiteralHelper.actionTypeSet.getDisplayNameByName(ActionType.INVOKE_SCRIPT_LITERAL.getName()), (String)actions[1]);
    }

    private static class InteractivityTypeInnerTest {
        private TriggerSupportMatrix matSVG = null;
        private TriggerSupportMatrix matSwing = null;
        private final int iInteractivityType;

        public InteractivityTypeInnerTest(int iInteractivityType) {
            this.iInteractivityType = iInteractivityType;
            this.matSVG = new TriggerSupportMatrix("svg", iInteractivityType);
            this.matSwing = new TriggerSupportMatrix("png", iInteractivityType);
        }

        public String getMatrixGeneratedString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Type: " + this.getInteractivityTypeName() + TriggerSupportMatrixTest.SPLITOR);
            sb.append("<table border=\"1\">\n");
            sb.append(" <tr>\n");
            this.printTd(sb, "&nbsp;");
            int i = 0;
            while (i < ACTION_TYPES.length) {
                this.printTd(sb, ACTION_TYPES[i].getLiteral());
                ++i;
            }
            sb.append(" </tr>\n");
            this.printTriggerCondition(sb, TriggerCondition.ONCLICK_LITERAL);
            this.printTriggerCondition(sb, TriggerCondition.ONDBLCLICK_LITERAL);
            this.printTriggerCondition(sb, TriggerCondition.ONMOUSEDOWN_LITERAL);
            this.printTriggerCondition(sb, TriggerCondition.ONMOUSEUP_LITERAL);
            this.printTriggerCondition(sb, TriggerCondition.ONMOUSEOVER_LITERAL);
            this.printTriggerCondition(sb, TriggerCondition.ONMOUSEMOVE_LITERAL);
            this.printTriggerCondition(sb, TriggerCondition.ONMOUSEOUT_LITERAL);
            this.printTriggerCondition(sb, TriggerCondition.ONFOCUS_LITERAL);
            this.printTriggerCondition(sb, TriggerCondition.ONBLUR_LITERAL);
            this.printTriggerCondition(sb, TriggerCondition.ONKEYDOWN_LITERAL);
            this.printTriggerCondition(sb, TriggerCondition.ONKEYUP_LITERAL);
            this.printTriggerCondition(sb, TriggerCondition.ONKEYPRESS_LITERAL);
            this.printTriggerCondition(sb, TriggerCondition.ONLOAD_LITERAL);
            sb.append("</table>\n");
            return sb.toString();
        }

        private void printTd(StringBuffer sb, String str) {
            sb.append("  <td>" + str + "</td>" + TriggerSupportMatrixTest.SPLITOR);
        }

        private void printTriggerCondition(StringBuffer sb, TriggerCondition condition) {
            sb.append(" <tr>\n");
            this.printTd(sb, condition.getLiteral());
            int i = 0;
            while (i < ACTION_TYPES.length) {
                this.printTd(sb, this.getSupportRenderer(condition, ACTION_TYPES[i]));
                ++i;
            }
            sb.append(" </tr>\n");
        }

        private String getSupportRenderer(TriggerCondition condition, ActionType actionType) {
            boolean supportSVG = this.matSVG.check(condition, actionType);
            boolean supportSwing = this.matSwing.check(condition, actionType);
            if (supportSVG && supportSwing) {
                return "All";
            }
            if (supportSVG) {
                return "SVG";
            }
            if (supportSwing) {
                return "Swing";
            }
            return "&nbsp;";
        }

        private String getInteractivityTypeName() {
            switch (this.iInteractivityType) {
                case 8: {
                    return "Axis";
                }
                case 4: {
                    return "Chart Area";
                }
                case 2: {
                    return "Chart Title";
                }
                case 1: {
                    return "Data Point";
                }
                case 16: {
                    return "Legend";
                }
                case 32: {
                    return "Marker Line";
                }
                case 64: {
                    return "Marker Range";
                }
            }
            return "";
        }
    }
}

