/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Time;
import java.sql.Timestamp;
import junit.framework.TestCase;
import org.eclipse.birt.report.data.oda.jdbc.Connection;
import org.eclipse.birt.report.data.oda.jdbc.ParameterMetaData;
import org.eclipse.birt.report.data.oda.jdbc.Statement;
import org.eclipse.birt.report.data.oda.jdbc.TestUtil;

public class ParameterMetaDataTest
extends TestCase {
    private Connection conn = null;
    private Statement stmt = null;
    private ParameterMetaData Pmd = null;
    private java.sql.Connection jdbcConn = null;
    private PreparedStatement jdbcPreparedStmt = null;
    private java.sql.ParameterMetaData jdbcPmd = null;

    protected void setUp() throws Exception {
        TestUtil.createTestData();
        String sql = "insert into \"test_oda_jdbc\" values(?,?,?,?,?,?,?)";
        Date datenow = new Date(System.currentTimeMillis());
        Time timenow = new Time(System.currentTimeMillis());
        Timestamp timestampnow = new Timestamp(System.currentTimeMillis());
        this.conn = TestUtil.openConnection();
        this.stmt = (Statement)this.conn.newQuery("");
        this.stmt.prepare(sql);
        this.stmt.setBigDecimal(1, new BigDecimal(0));
        this.stmt.setDate(2, datenow);
        this.stmt.setDouble(3, 1.01);
        this.stmt.setInt(4, 11);
        this.stmt.setString(5, "0asdas");
        this.stmt.setTime(6, timenow);
        this.stmt.setTimestamp(7, timestampnow);
        this.stmt.execute();
        this.Pmd = (ParameterMetaData)this.stmt.getParameterMetaData();
        this.jdbcConn = TestUtil.openJDBCConnection();
        this.jdbcPreparedStmt = this.jdbcConn.prepareStatement(sql);
        this.jdbcPreparedStmt.setBigDecimal(1, new BigDecimal(110));
        this.jdbcPreparedStmt.setDate(2, datenow);
        this.jdbcPreparedStmt.setDouble(3, 1.012);
        this.jdbcPreparedStmt.setInt(4, 111);
        this.jdbcPreparedStmt.setString(5, "asdasd");
        this.jdbcPreparedStmt.setTime(6, timenow);
        this.jdbcPreparedStmt.setTimestamp(7, timestampnow);
        this.jdbcPreparedStmt.execute();
        this.jdbcPmd = this.jdbcPreparedStmt.getParameterMetaData();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.conn.close();
        this.stmt.close();
        this.jdbcConn.close();
        this.jdbcPreparedStmt.close();
        TestUtil.deleteTestData();
        super.tearDown();
    }

    public void testGetParameterCount() throws Exception {
        ParameterMetaDataTest.assertEquals((int)this.Pmd.getParameterCount(), (int)this.jdbcPmd.getParameterCount());
    }

    public void testGetParameterMode() throws Exception {
        int i = 1;
        while (i < this.Pmd.getParameterCount() + 1) {
            ParameterMetaDataTest.assertEquals((int)this.Pmd.getParameterMode(i), (int)this.jdbcPmd.getParameterMode(i));
            ++i;
        }
    }

    public void testGetParameterType() throws Exception {
        int i = 1;
        while (i < this.Pmd.getParameterCount() + 1) {
            ParameterMetaDataTest.assertEquals((int)this.Pmd.getParameterType(i), (int)this.jdbcPmd.getParameterType(i));
            ++i;
        }
    }

    public void testGetParameterTypeName() throws Exception {
        int i = 1;
        while (i < this.Pmd.getParameterCount() + 1) {
            ParameterMetaDataTest.assertEquals((String)this.Pmd.getParameterTypeName(i), (String)this.jdbcPmd.getParameterTypeName(i));
            ++i;
        }
    }

    public void testGetPrecision() throws Exception {
        int i = 1;
        while (i < this.Pmd.getParameterCount() + 1) {
            ParameterMetaDataTest.assertEquals((int)this.Pmd.getPrecision(i), (int)this.jdbcPmd.getPrecision(i));
            ++i;
        }
    }

    public void testGetScale() throws Exception {
        int i = 1;
        while (i < this.Pmd.getParameterCount() + 1) {
            ParameterMetaDataTest.assertEquals((int)this.Pmd.getScale(i), (int)this.jdbcPmd.getScale(i));
            ++i;
        }
    }

    public void testIsNullable() throws Exception {
        int i = 1;
        while (i < this.Pmd.getParameterCount() + 1) {
            int result = 2;
            if (this.Pmd.isNullable(i) == 2) {
                result = 1;
            }
            if (this.Pmd.isNullable(i) == 1) {
                result = 0;
            }
            ParameterMetaDataTest.assertEquals((int)result, (int)this.jdbcPmd.isNullable(i));
            ++i;
        }
    }
}

