/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.sql.SQLException;
import junit.framework.TestCase;
import org.eclipse.birt.report.data.oda.jdbc.Connection;
import org.eclipse.birt.report.data.oda.jdbc.JDBCException;
import org.eclipse.birt.report.data.oda.jdbc.ResultSet;
import org.eclipse.birt.report.data.oda.jdbc.Statement;
import org.eclipse.birt.report.data.oda.jdbc.TestUtil;

public class ResultSetTest
extends TestCase {
    private Connection conn = null;
    private Statement stmt = null;
    private ResultSet rs = null;
    private java.sql.Connection jdbcConn = null;
    private java.sql.Statement jdbcStmt = null;
    private java.sql.ResultSet jdbcRs = null;

    protected void setUp() throws Exception {
        super.setUp();
        TestUtil.createTestData();
        this.conn = TestUtil.openConnection();
        this.stmt = (Statement)this.conn.newQuery("");
        String sql = "select * from \"test_oda_jdbc\"";
        this.stmt.prepare(sql);
        this.rs = (ResultSet)this.stmt.executeQuery();
        this.jdbcConn = TestUtil.openJDBCConnection();
        this.jdbcStmt = this.jdbcConn.createStatement(1005, 1008);
        this.jdbcRs = this.jdbcStmt.executeQuery(sql);
    }

    protected void tearDown() throws Exception {
        try {
            this.rs.close();
            this.jdbcRs.close();
        }
        catch (Exception exception) {
            System.out.println("Close result set failed. Might have already been closed in testClose().");
        }
        this.stmt.close();
        this.conn.close();
        this.jdbcStmt.close();
        this.jdbcConn.close();
        TestUtil.deleteTestData();
        super.tearDown();
    }

    public ResultSetTest(String arg0) {
        super(arg0);
    }

    public void testResultValuesByIndex() throws Exception {
        ResultSetTest.assertEquals((int)this.rs.getRow(), (int)this.jdbcRs.getRow());
        String sqlState = null;
        try {
            this.rs.getString(1);
            ResultSetTest.fail((String)"Call \"getString\" before \"next\". Should have thrown JDBCException, but havn't.");
        }
        catch (JDBCException e) {
            sqlState = e.getSQLState();
        }
        try {
            this.jdbcRs.getString(1);
            ResultSetTest.fail();
        }
        catch (SQLException e) {
            ResultSetTest.assertEquals((String)e.getSQLState(), (String)sqlState);
        }
        while (this.rs.next()) {
            this.jdbcRs.next();
            ResultSetTest.assertEquals((boolean)this.rs.wasNull(), (boolean)this.jdbcRs.wasNull());
            ResultSetTest.assertEquals((int)this.rs.getRow(), (int)this.jdbcRs.getRow());
            ResultSetTest.assertEquals((Object)this.rs.getBigDecimal(1), (Object)this.jdbcRs.getBigDecimal(1));
            ResultSetTest.assertEquals((Object)this.rs.getDate(2), (Object)this.jdbcRs.getDate(2));
            ResultSetTest.assertEquals((double)this.rs.getDouble(3), (double)this.jdbcRs.getDouble(3), (double)Double.MIN_VALUE);
            ResultSetTest.assertEquals((int)this.rs.getInt(4), (int)this.jdbcRs.getInt(4));
            ResultSetTest.assertEquals((String)this.rs.getString(5), (String)this.jdbcRs.getString(5));
            ResultSetTest.assertEquals((Object)this.rs.getTime(6), (Object)this.jdbcRs.getTime(6));
            ResultSetTest.assertEquals((Object)this.rs.getTimestamp(7), (Object)this.jdbcRs.getTimestamp(7));
        }
    }

    public void testResultValuesByColName() throws Exception {
        int i = 0;
        while (this.rs.next()) {
            this.jdbcRs.next();
            String colName = "col" + i;
            ++i;
            ResultSetTest.assertEquals((String)this.rs.getString(colName), (String)this.jdbcRs.getString(colName));
        }
    }

    public void testGetMetaData() throws Exception {
        ResultSetTest.assertNotNull((Object)this.rs.getMetaData());
    }

    public void testClose() throws Exception {
        this.rs.close();
        this.jdbcRs.close();
        String sqlState = null;
        try {
            this.rs.next();
            ResultSetTest.fail((String)"Call \"getRow\" when the result set is closed. Should have thrown JDBCException, but havn't.");
        }
        catch (JDBCException e) {
            sqlState = e.getSQLState();
        }
        try {
            this.jdbcRs.next();
            ResultSetTest.fail();
        }
        catch (SQLException e) {
            ResultSetTest.assertEquals((String)e.getSQLState(), (String)sqlState);
        }
    }

    public void testSetMaxRows() throws Exception {
        int max = 0;
        this.rs.setMaxRows(max);
        int rowCount = 0;
        while (this.jdbcRs.next()) {
            ResultSetTest.assertTrue((boolean)this.rs.next());
            ++rowCount;
        }
        ResultSetTest.assertFalse((boolean)this.rs.next());
        this.rs.close();
        this.stmt.close();
        String sql = "select * from \"test_oda_jdbc\"";
        this.stmt.prepare(sql);
        this.rs = (ResultSet)this.stmt.executeQuery();
        max = 1;
        this.rs.setMaxRows(max);
        ResultSetTest.assertTrue((boolean)this.rs.next());
        ResultSetTest.assertFalse((boolean)this.rs.next());
        this.rs.close();
        this.stmt.close();
        sql = "select * from \"test_oda_jdbc\"";
        this.stmt.prepare(sql);
        this.rs = (ResultSet)this.stmt.executeQuery();
        max = rowCount;
        this.rs.setMaxRows(max);
        int i = 0;
        while (i < rowCount) {
            ResultSetTest.assertTrue((boolean)this.rs.next());
            ++i;
        }
        ResultSetTest.assertFalse((boolean)this.rs.next());
        this.rs.close();
        this.stmt.close();
        sql = "select * from \"test_oda_jdbc\"";
        this.stmt.prepare(sql);
        this.rs = (ResultSet)this.stmt.executeQuery();
        max = rowCount + 10;
        this.rs.setMaxRows(max);
        i = 0;
        while (i < rowCount) {
            ResultSetTest.assertTrue((boolean)this.rs.next());
            ++i;
        }
        ResultSetTest.assertFalse((boolean)this.rs.next());
        this.rs.close();
        this.stmt.close();
        sql = "select * from \"test_oda_jdbc\"";
        this.stmt.prepare(sql);
        this.rs = (ResultSet)this.stmt.executeQuery();
        max = -1;
        this.rs.setMaxRows(max);
        i = 0;
        while (i < rowCount) {
            ResultSetTest.assertTrue((boolean)this.rs.next());
            ++i;
        }
        ResultSetTest.assertFalse((boolean)this.rs.next());
    }

    public void testFindColumn() throws Exception {
        int columnCount = this.jdbcRs.getMetaData().getColumnCount();
        int i = 0;
        while (i < columnCount) {
            ResultSetTest.assertEquals((int)this.rs.findColumn(this.jdbcRs.getMetaData().getColumnName(i + 1)), (int)(i + 1));
            ++i;
        }
    }
}

