/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.APISamples;

import com.ibm.icu.util.ULocale;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.elements.structures.FilterCondition;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;

public class ProjectAnalysis {
    ReportDesignHandle designHandle = null;
    ElementFactory elementFactory = null;
    StructureFactory structFactory = null;
    MetaDataDictionary dict = null;
    private static final String ODA_EXTENSION_ID = "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet";

    public static void main(String[] args) throws SemanticException, IOException {
        new ProjectAnalysis().buildReport();
    }

    void buildReport() throws SemanticException, IOException {
        SessionHandle session = DesignEngine.newSession((ULocale)ULocale.ENGLISH);
        this.designHandle = session.createDesign();
        this.elementFactory = this.designHandle.getElementFactory();
        this.structFactory = new StructureFactory();
        this.dict = MetaDataDictionary.getInstance();
        this.buildMasterPages();
        this.buildDataSources();
        this.buildDataSets();
        this.buildImages();
        this.buildStyles();
        this.buildBody();
        this.designHandle.saveAs("projectAnalysis.rptdesign");
    }

    void buildImages() throws IOException, SemanticException {
        EmbeddedImage image = StructureFactory.createEmbeddedImage();
        image.setType("image/jpeg");
        image.setData(this.load("images/abos_logo.jpg"));
        image.setName("abos_logo");
        this.designHandle.addImage(image);
    }

    public byte[] load(String fileName) throws IOException {
        BufferedInputStream is = null;
        is = new BufferedInputStream(this.getClass().getResourceAsStream(fileName));
        byte[] data = null;
        if (is != null) {
            data = new byte[((InputStream)is).available()];
            ((InputStream)is).read(data);
        }
        return data;
    }

    void buildDataSources() throws SemanticException {
        OdaDataSourceHandle dsHandle = this.elementFactory.newOdaDataSource("Data source", "org.eclipse.birt.report.data.oda.jdbc");
        UserPropertyDefn userPropDefn = new UserPropertyDefn();
        userPropDefn.setName("valid");
        userPropDefn.setType(this.dict.getPropertyType(0));
        dsHandle.addUserPropertyDefn(userPropDefn);
        dsHandle.setProperty("valid", (Object)"true");
        dsHandle.setProperty("odaDriverClass", (Object)"net.sourceforge.jtds.jdbc.Driver");
        dsHandle.setProperty("odaURL", (Object)"jdbc:jtds:sqlserver://spmdb/gui");
        dsHandle.setProperty("odaUser", (Object)"root");
        dsHandle.setProperty("odaPassword", (Object)"root");
        this.designHandle.getDataSources().add((DesignElementHandle)dsHandle);
    }

    void buildDataSets() throws SemanticException {
        OdaDataSetHandle dsHandle = this.elementFactory.newOdaDataSet("Data Set", ODA_EXTENSION_ID);
        dsHandle.setDataSource("Data source");
        dsHandle.setQueryText("SELECT [Project].[Number],[Project].[Manager],[Project].[Type],[Project].[Status], [Project].[Starting_dt],[Project].[Closing_dt], [Project].[Value],[Project].[Billing],[ProjectDetails].[Region],[ProjectDetails].[Budget],[ProjectDetails].[Expense],[ProjectDetails].[Completion] FROM [Project],[ProjectDetails]WHERE [Project].[Number] =  [ProjectDetails].[Project_Number]");
        new StructureFactory();
        FilterCondition fc = StructureFactory.createFilterCond();
        fc.setOperator("eq");
        fc.setExpr("row[\"Number\"]");
        fc.setValue1("23575");
        PropertyHandle filterHandle = dsHandle.getPropertyHandle("filter");
        filterHandle.addItem((IStructure)fc);
        this.designHandle.getDataSets().add((DesignElementHandle)dsHandle);
    }

    void buildMasterPages() throws ContentException, NameException {
        SimpleMasterPageHandle simpleMasterPage = this.elementFactory.newSimpleMasterPage("Simple MasterPage");
        this.designHandle.getMasterPages().add((DesignElementHandle)simpleMasterPage);
    }

    void buildStyles() throws SemanticException {
        SharedStyleHandle style1 = this.elementFactory.newStyle("BorderTopBottom");
        style1.setProperty("borderBottomStyle", (Object)"solid");
        style1.setProperty("borderLeftStyle", (Object)"none");
        style1.setProperty("borderTopStyle", (Object)"solid");
        style1.setProperty("borderBottomWidth", (Object)"1px");
        style1.setProperty("borderTopWidth", (Object)"1px");
        SharedStyleHandle style2 = this.elementFactory.newStyle("BorderL");
        style2.setProperty("borderBottomStyle", (Object)"solid");
        style2.setProperty("borderLeftStyle", (Object)"solid");
        style2.setProperty("borderTopStyle", (Object)"solid");
        style2.setProperty("borderBottomWidth", (Object)"1px");
        style2.setProperty("borderLeftWidth", (Object)"1px");
        style2.setProperty("borderTopWidth", (Object)"1px");
        SharedStyleHandle style3 = this.elementFactory.newStyle("BorderR");
        style3.setProperty("borderBottomStyle", (Object)"solid");
        style3.setProperty("borderRightStyle", (Object)"solid");
        style3.setProperty("borderTopStyle", (Object)"solid");
        style3.setProperty("borderBottomWidth", (Object)"1px");
        style3.setProperty("borderRightWidth", (Object)"1px");
        style3.setProperty("borderTopWidth", (Object)"1px");
        SharedStyleHandle style4 = this.elementFactory.newStyle("Date");
        style4.setDateTimeFormat("MM-dd-yyyy");
        style4.setDateTimeFormatCategory("Custom");
        this.designHandle.getStyles().add((DesignElementHandle)style1);
        this.designHandle.getStyles().add((DesignElementHandle)style2);
        this.designHandle.getStyles().add((DesignElementHandle)style3);
        this.designHandle.getStyles().add((DesignElementHandle)style4);
    }

    void buildBody() throws SemanticException {
        this.buildBodyGrid();
        TextItemHandle text = this.elementFactory.newTextItem(null);
        text.setContentType("html");
        text.setContent("<br></br>");
        this.designHandle.getBody().add((DesignElementHandle)text);
        this.buildBodyTable();
    }

    private void buildBodyTable() throws SemanticException {
        TableHandle table = this.elementFactory.newTableItem(null, 6, 1, 1, 2);
        this.designHandle.getBody().add((DesignElementHandle)table);
        table.setProperty("fontFamily", (Object)"Georgia");
        table.setProperty("fontSize", (Object)"smaller");
        table.setProperty("textAlign", (Object)"center");
        table.setProperty("verticalAlign", (Object)"center");
        table.setWidth("100%");
        table.setProperty("dataSet", (Object)"Data Set");
        RowHandle headerRow1 = (RowHandle)table.getHeader().get(0);
        headerRow1.setProperty("backgroundColor", (Object)"#C0C0C0");
        CellHandle cell = (CellHandle)headerRow1.getCells().get(0);
        cell.setStyleName("BorderL");
        cell.setProperty("paddingTop", (Object)"0.5cm");
        LabelHandle label = this.elementFactory.newLabel(null);
        label.setProperty("fontWeight", (Object)"bold");
        label.setProperty("textAlign", (Object)"left");
        label.setText("Region");
        cell.getContent().add((DesignElementHandle)label);
        cell = (CellHandle)headerRow1.getCells().get(1);
        cell.setStyleName("BorderL");
        cell.setProperty("paddingTop", (Object)"0.5cm");
        label = this.elementFactory.newLabel(null);
        label.setProperty("fontWeight", (Object)"bold");
        label.setProperty("textAlign", (Object)"left");
        label.setText("Budget($)");
        cell.getContent().add((DesignElementHandle)label);
        cell = (CellHandle)headerRow1.getCells().get(2);
        cell.setStyleName("BorderL");
        cell.setProperty("paddingTop", (Object)"0.5cm");
        label = this.elementFactory.newLabel(null);
        label.setProperty("fontWeight", (Object)"bold");
        label.setProperty("textAlign", (Object)"left");
        label.setText("Current Expenses ($)");
        cell.getContent().add((DesignElementHandle)label);
        cell = (CellHandle)headerRow1.getCells().get(3);
        cell.setStyleName("BorderL");
        cell.setProperty("paddingTop", (Object)"0.5cm");
        label = this.elementFactory.newLabel(null);
        label.setProperty("fontWeight", (Object)"bold");
        label.setProperty("textAlign", (Object)"left");
        label.setText("% Completion of Project");
        cell.getContent().add((DesignElementHandle)label);
        cell = (CellHandle)headerRow1.getCells().get(4);
        cell.setStyleName("BorderL");
        cell.setProperty("paddingTop", (Object)"0.5cm");
        label = this.elementFactory.newLabel(null);
        label.setProperty("fontWeight", (Object)"bold");
        label.setProperty("textAlign", (Object)"left");
        label.setText("Possible Expenses ($)");
        cell.getContent().add((DesignElementHandle)label);
        cell = (CellHandle)headerRow1.getCells().get(5);
        cell.setStyleName("BorderL");
        cell.setProperty("paddingTop", (Object)"0.5cm");
        label = this.elementFactory.newLabel(null);
        label.setProperty("fontWeight", (Object)"bold");
        label.setProperty("textAlign", (Object)"left");
        label.setText("Under (Over) Budget ($)");
        cell.getContent().add((DesignElementHandle)label);
        RowHandle detailRow1 = (RowHandle)table.getDetail().get(0);
        cell = (CellHandle)detailRow1.getCells().get(0);
        DataItemHandle data = this.elementFactory.newDataItem(null);
        data.setProperty("textAlign", (Object)"left");
        data.setValueExpr("row[\"Region\"]");
        cell.getContent().add((DesignElementHandle)data);
        cell = (CellHandle)detailRow1.getCells().get(1);
        data = this.elementFactory.newDataItem(null);
        data.setProperty("textAlign", (Object)"center");
        data.setValueExpr("row[\"Budget\"]");
        data.getPrivateStyle().setNumberFormatCategory("Custom");
        data.getPrivateStyle().setNumberFormat("###,###.00");
        cell.getContent().add((DesignElementHandle)data);
        cell = (CellHandle)detailRow1.getCells().get(2);
        data = this.elementFactory.newDataItem(null);
        data.setProperty("textAlign", (Object)"center");
        data.setValueExpr("row[\"Expense\"]");
        data.getPrivateStyle().setNumberFormatCategory("Custom");
        data.getPrivateStyle().setNumberFormat("###,###.00");
        cell.getContent().add((DesignElementHandle)data);
        cell = (CellHandle)detailRow1.getCells().get(3);
        data = this.elementFactory.newDataItem(null);
        data.setProperty("textAlign", (Object)"center");
        data.setValueExpr("row[\"Completion\"] * 100 +\"%\"");
        cell.getContent().add((DesignElementHandle)data);
        cell = (CellHandle)detailRow1.getCells().get(4);
        data = this.elementFactory.newDataItem(null);
        data.setProperty("textAlign", (Object)"center");
        data.setValueExpr("row[\"Expense\"]/row[\"Completion\"]");
        data.getPrivateStyle().setNumberFormatCategory("Custom");
        data.getPrivateStyle().setNumberFormat("###,###.00");
        cell.getContent().add((DesignElementHandle)data);
        cell = (CellHandle)detailRow1.getCells().get(5);
        data = this.elementFactory.newDataItem(null);
        data.setProperty("textAlign", (Object)"center");
        data.setValueExpr("row[\"Budget\"] - row[\"Expense\"]/row[\"Completion\"]");
        data.getPrivateStyle().setNumberFormatCategory("Custom");
        data.getPrivateStyle().setNumberFormat("###,###.00");
        cell.getContent().add((DesignElementHandle)data);
        RowHandle footerRow1 = (RowHandle)table.getFooter().get(0);
        cell = (CellHandle)footerRow1.getCells().get(0);
        cell.setColumnSpan(6);
        cell.setRowSpan(1);
        TextItemHandle text = this.elementFactory.newTextItem(null);
        text.setContentType("html");
        text.setContent("<br></br>");
        cell.getContent().add((DesignElementHandle)text);
        RowHandle footerRow2 = (RowHandle)table.getFooter().get(1);
        footerRow2.setProperty("backgroundColor", (Object)"#C0C0C0");
        cell = (CellHandle)footerRow2.getCells().get(0);
        cell.setStyleName("BorderL");
        label = this.elementFactory.newLabel(null);
        label.setProperty("fontWeight", (Object)"bold");
        label.setText("Total:");
        cell.getContent().add((DesignElementHandle)label);
        cell = (CellHandle)footerRow2.getCells().get(1);
        cell.setStyleName("BorderTopBottom");
        data = this.elementFactory.newDataItem(null);
        data.setProperty("fontWeight", (Object)"bold");
        data.setValueExpr("Total.sum(row[\"Budget\"])");
        data.getPrivateStyle().setNumberFormatCategory("Custom");
        data.getPrivateStyle().setNumberFormat("$###,###.00");
        cell.getContent().add((DesignElementHandle)data);
        cell = (CellHandle)footerRow2.getCells().get(2);
        cell.setStyleName("BorderTopBottom");
        data = this.elementFactory.newDataItem(null);
        data.setProperty("fontWeight", (Object)"bold");
        data.setValueExpr("Total.sum(row[\"Expense\"])");
        data.getPrivateStyle().setNumberFormatCategory("Custom");
        data.getPrivateStyle().setNumberFormat("$###,###.00");
        cell.getContent().add((DesignElementHandle)data);
        cell = (CellHandle)footerRow2.getCells().get(3);
        cell.setStyleName("BorderTopBottom");
        data = this.elementFactory.newDataItem(null);
        data.setProperty("fontWeight", (Object)"bold");
        data.setValueExpr("Total.ave(row[\"Completion\"] * 100) + \"%\"");
        cell.getContent().add((DesignElementHandle)data);
        cell = (CellHandle)footerRow2.getCells().get(4);
        cell.setStyleName("BorderTopBottom");
        data = this.elementFactory.newDataItem(null);
        data.setProperty("fontWeight", (Object)"bold");
        data.setValueExpr("Total.sum(row[\"Expense\"]/row[\"Completion\"])");
        data.getPrivateStyle().setNumberFormatCategory("Custom");
        data.getPrivateStyle().setNumberFormat("$###,###.00");
        cell.getContent().add((DesignElementHandle)data);
        cell = (CellHandle)footerRow2.getCells().get(5);
        cell.setStyleName("BorderR");
        data = this.elementFactory.newDataItem(null);
        data.setProperty("fontWeight", (Object)"bold");
        data.setValueExpr("Total.sum(row[\"Budget\"] - row[\"Expense\"]/row[\"Completion\"])");
        data.getPrivateStyle().setNumberFormatCategory("Custom");
        data.getPrivateStyle().setNumberFormat("$###,###.00");
        cell.getContent().add((DesignElementHandle)data);
    }

    void buildBodyGrid() throws SemanticException {
        GridHandle grid = this.elementFactory.newGridItem(null, 1, 1);
        grid.setWidth("100%");
        this.designHandle.getBody().add((DesignElementHandle)grid);
        CellHandle cell = grid.getCell(0, 0);
        cell.setColumnSpan(1);
        cell.setRowSpan(1);
        cell.setProperty("textAlign", (Object)"center");
        GridHandle grid2 = this.elementFactory.newGridItem(null, 4, 5);
        grid2.setProperty("textAlign", (Object)"left");
        grid2.setWidth("80%");
        grid2.setProperty("dataSet", (Object)"Data Set");
        cell.getContent().add((DesignElementHandle)grid2);
        RowHandle row1 = (RowHandle)grid2.getRows().get(0);
        CellHandle row1Cell1 = (CellHandle)row1.getCells().get(0);
        ImageHandle image = this.elementFactory.newImage("Logo");
        image.setImageName("abos_logo");
        row1Cell1.getContent().add((DesignElementHandle)image);
        CellHandle row1Cell2 = (CellHandle)row1.getCells().get(1);
        row1Cell2.setColumnSpan(2);
        row1Cell2.setRowSpan(1);
        TextItemHandle text = this.elementFactory.newTextItem(null);
        text.setProperty("fontFamily", (Object)"Georgia");
        text.setProperty("textAlign", (Object)"center");
        text.setContentType("html");
        text.setContent("<CENTER><STRONG><H2>ABOS Marketing<br>Project Analysis Report<br></H2></STRONG>Run Date: <value-of>new Date()</value-of></CENTER><br></br>");
        row1Cell2.getContent().add((DesignElementHandle)text);
        RowHandle row2 = (RowHandle)grid2.getRows().get(1);
        CellHandle row2Cell1 = (CellHandle)row2.getCells().get(0);
        row2Cell1.setProperty("borderLeftColor", (Object)"#808080");
        row2Cell1.setProperty("borderLeftStyle", (Object)"solid");
        row2Cell1.setProperty("borderLeftWidth", (Object)"thin");
        row2Cell1.setProperty("borderTopColor", (Object)"#808080");
        row2Cell1.setProperty("borderTopStyle", (Object)"solid");
        row2Cell1.setProperty("borderTopWidth", (Object)"thin");
        LabelHandle row2Cell1Lable = this.elementFactory.newLabel(null);
        row2Cell1Lable.setProperty("fontFamily", (Object)"Georgia");
        row2Cell1Lable.setProperty("fontSize", (Object)"smaller");
        row2Cell1Lable.setProperty("fontWeight", (Object)"bold");
        row2Cell1Lable.setProperty("paddingLeft", (Object)"1cm");
        row2Cell1Lable.setText("Project Number:");
        row2Cell1.getContent().add((DesignElementHandle)row2Cell1Lable);
        CellHandle row2Cell2 = (CellHandle)row2.getCells().get(1);
        row2Cell2.setProperty("borderTopColor", (Object)"#808080");
        row2Cell2.setProperty("borderTopStyle", (Object)"solid");
        row2Cell2.setProperty("borderTopWidth", (Object)"thin");
        DataItemHandle row2Cell2Data = this.elementFactory.newDataItem(null);
        row2Cell2Data.setProperty("fontFamily", (Object)"Georgia");
        row2Cell2Data.setProperty("fontSize", (Object)"smaller");
        row2Cell2Data.setValueExpr("row[\"Number\"]");
        row2Cell2.getContent().add((DesignElementHandle)row2Cell2Data);
        CellHandle row2Cell3 = (CellHandle)row2.getCells().get(2);
        row2Cell3.setProperty("borderTopColor", (Object)"#808080");
        row2Cell3.setProperty("borderTopStyle", (Object)"solid");
        row2Cell3.setProperty("borderTopWidth", (Object)"thin");
        LabelHandle row2Cell3Lable = this.elementFactory.newLabel(null);
        row2Cell3Lable.setProperty("fontFamily", (Object)"Georgia");
        row2Cell3Lable.setProperty("fontSize", (Object)"smaller");
        row2Cell3Lable.setProperty("fontWeight", (Object)"bold");
        row2Cell3Lable.setText("Starting Date:");
        row2Cell3.getContent().add((DesignElementHandle)row2Cell3Lable);
        CellHandle row2Cell4 = (CellHandle)row2.getCells().get(3);
        row2Cell4.setProperty("borderRightColor", (Object)"#808080");
        row2Cell4.setProperty("borderRightStyle", (Object)"solid");
        row2Cell4.setProperty("borderRightWidth", (Object)"thin");
        row2Cell4.setProperty("borderTopColor", (Object)"#808080");
        row2Cell4.setProperty("borderTopStyle", (Object)"solid");
        row2Cell4.setProperty("borderTopWidth", (Object)"thin");
        DataItemHandle row2Cell4Data = this.elementFactory.newDataItem(null);
        row2Cell4Data.setStyleName("Date");
        row2Cell4Data.setProperty("fontFamily", (Object)"Georgia");
        row2Cell4Data.setProperty("fontSize", (Object)"smaller");
        row2Cell4Data.setValueExpr("row[\"Starting_dt\"]");
        row2Cell4.getContent().add((DesignElementHandle)row2Cell4Data);
        RowHandle row3 = (RowHandle)grid2.getRows().get(2);
        CellHandle row3Cell1 = (CellHandle)row3.getCells().get(0);
        row3Cell1.setProperty("borderLeftColor", (Object)"#808080");
        row3Cell1.setProperty("borderLeftStyle", (Object)"solid");
        row3Cell1.setProperty("borderLeftWidth", (Object)"thin");
        LabelHandle row3Cell1Lable = this.elementFactory.newLabel(null);
        row3Cell1Lable.setProperty("fontFamily", (Object)"Georgia");
        row3Cell1Lable.setProperty("fontSize", (Object)"smaller");
        row3Cell1Lable.setProperty("fontWeight", (Object)"bold");
        row3Cell1Lable.setProperty("paddingLeft", (Object)"1cm");
        row3Cell1Lable.setText("Project Manager:");
        row3Cell1.getContent().add((DesignElementHandle)row3Cell1Lable);
        CellHandle row3Cell2 = (CellHandle)row3.getCells().get(1);
        DataItemHandle row3Cell2Data = this.elementFactory.newDataItem(null);
        row3Cell2Data.setProperty("fontFamily", (Object)"Georgia");
        row3Cell2Data.setProperty("fontSize", (Object)"smaller");
        row3Cell2Data.setValueExpr("row[\"Manager\"]");
        row3Cell2.getContent().add((DesignElementHandle)row3Cell2Data);
        CellHandle row3Cell3 = (CellHandle)row3.getCells().get(2);
        LabelHandle row3Cell3Lable = this.elementFactory.newLabel(null);
        row3Cell3Lable.setProperty("fontFamily", (Object)"Georgia");
        row3Cell3Lable.setProperty("fontSize", (Object)"smaller");
        row3Cell3Lable.setProperty("fontWeight", (Object)"bold");
        row3Cell3Lable.setText("Closing Date:");
        row3Cell3.getContent().add((DesignElementHandle)row3Cell3Lable);
        CellHandle row3Cell4 = (CellHandle)row3.getCells().get(3);
        row3Cell4.setProperty("borderRightColor", (Object)"#808080");
        row3Cell4.setProperty("borderRightStyle", (Object)"solid");
        row3Cell4.setProperty("borderRightWidth", (Object)"thin");
        DataItemHandle row3Cell4Data = this.elementFactory.newDataItem(null);
        row3Cell4Data.setStyleName("Date");
        row3Cell4Data.setProperty("fontFamily", (Object)"Georgia");
        row3Cell4Data.setProperty("fontSize", (Object)"smaller");
        row3Cell4Data.setValueExpr("row[\"Closing_dt\"]");
        row3Cell4.getContent().add((DesignElementHandle)row3Cell4Data);
        RowHandle row4 = (RowHandle)grid2.getRows().get(3);
        CellHandle row4Cell1 = (CellHandle)row4.getCells().get(0);
        row4Cell1.setProperty("borderLeftColor", (Object)"#808080");
        row4Cell1.setProperty("borderLeftStyle", (Object)"solid");
        row4Cell1.setProperty("borderLeftWidth", (Object)"thin");
        LabelHandle row4Cell1Lable = this.elementFactory.newLabel(null);
        row4Cell1Lable.setProperty("fontFamily", (Object)"Georgia");
        row4Cell1Lable.setProperty("fontSize", (Object)"smaller");
        row4Cell1Lable.setProperty("fontWeight", (Object)"bold");
        row4Cell1Lable.setProperty("paddingLeft", (Object)"1cm");
        row4Cell1Lable.setText("Project Type:");
        row4Cell1.getContent().add((DesignElementHandle)row4Cell1Lable);
        CellHandle row4Cell2 = (CellHandle)row4.getCells().get(1);
        DataItemHandle row4Cell2Data = this.elementFactory.newDataItem(null);
        row4Cell2Data.setProperty("fontFamily", (Object)"Georgia");
        row4Cell2Data.setProperty("fontSize", (Object)"smaller");
        row4Cell2Data.setValueExpr("row[\"Type\"]");
        row4Cell2.getContent().add((DesignElementHandle)row4Cell2Data);
        CellHandle row4Cell3 = (CellHandle)row4.getCells().get(2);
        LabelHandle row4Cell3Lable = this.elementFactory.newLabel(null);
        row4Cell3Lable.setProperty("fontFamily", (Object)"Georgia");
        row4Cell3Lable.setProperty("fontSize", (Object)"smaller");
        row4Cell3Lable.setProperty("fontWeight", (Object)"bold");
        row4Cell3Lable.setText("Contract Value:");
        row4Cell3.getContent().add((DesignElementHandle)row4Cell3Lable);
        CellHandle row4Cell4 = (CellHandle)row4.getCells().get(3);
        row4Cell4.setProperty("borderRightColor", (Object)"#808080");
        row4Cell4.setProperty("borderRightStyle", (Object)"solid");
        row4Cell4.setProperty("borderRightWidth", (Object)"thin");
        DataItemHandle row4Cell4Data = this.elementFactory.newDataItem(null);
        row4Cell4Data.setStyleName("Date");
        row4Cell4Data.setProperty("fontFamily", (Object)"Georgia");
        row4Cell4Data.setProperty("fontSize", (Object)"smaller");
        row4Cell4Data.getPrivateStyle().setDateTimeFormatCategory("Custom");
        row4Cell4Data.getPrivateStyle().setDateTimeFormat("$###,###.00");
        row4Cell4Data.setValueExpr("row[\"Value\"]");
        row4Cell4.getContent().add((DesignElementHandle)row4Cell4Data);
        RowHandle row5 = (RowHandle)grid2.getRows().get(4);
        CellHandle row5Cell1 = (CellHandle)row5.getCells().get(0);
        row5Cell1.setProperty("borderBottomColor", (Object)"#808080");
        row5Cell1.setProperty("borderBottomStyle", (Object)"solid");
        row5Cell1.setProperty("borderBottomWidth", (Object)"thin");
        row5Cell1.setProperty("borderLeftColor", (Object)"#808080");
        row5Cell1.setProperty("borderLeftStyle", (Object)"solid");
        row5Cell1.setProperty("borderLeftWidth", (Object)"thin");
        LabelHandle row5Cell1Lable = this.elementFactory.newLabel(null);
        row5Cell1Lable.setProperty("fontFamily", (Object)"Georgia");
        row5Cell1Lable.setProperty("fontSize", (Object)"smaller");
        row5Cell1Lable.setProperty("fontWeight", (Object)"bold");
        row5Cell1Lable.setProperty("paddingLeft", (Object)"1cm");
        row5Cell1Lable.setText("Project Status:");
        row5Cell1.getContent().add((DesignElementHandle)row5Cell1Lable);
        CellHandle row5Cell2 = (CellHandle)row5.getCells().get(1);
        row5Cell2.setProperty("borderBottomColor", (Object)"#808080");
        row5Cell2.setProperty("borderBottomStyle", (Object)"solid");
        row5Cell2.setProperty("borderBottomWidth", (Object)"thin");
        DataItemHandle row5Cell2Data = this.elementFactory.newDataItem(null);
        row5Cell2Data.setProperty("fontFamily", (Object)"Georgia");
        row5Cell2Data.setProperty("fontSize", (Object)"smaller");
        row5Cell2Data.setValueExpr("row[\"Status\"]");
        row5Cell2.getContent().add((DesignElementHandle)row5Cell2Data);
        CellHandle row5Cell3 = (CellHandle)row5.getCells().get(2);
        row5Cell3.setProperty("borderBottomColor", (Object)"#808080");
        row5Cell3.setProperty("borderBottomStyle", (Object)"solid");
        row5Cell3.setProperty("borderBottomWidth", (Object)"thin");
        LabelHandle row5Cell3Lable = this.elementFactory.newLabel(null);
        row5Cell3Lable.setProperty("fontFamily", (Object)"Georgia");
        row5Cell3Lable.setProperty("fontSize", (Object)"smaller");
        row5Cell3Lable.setProperty("fontWeight", (Object)"bold");
        row5Cell3Lable.setText("Expected Gross:");
        row5Cell3.getContent().add((DesignElementHandle)row5Cell3Lable);
        CellHandle row5Cell4 = (CellHandle)row5.getCells().get(3);
        row5Cell4.setProperty("borderBottomColor", (Object)"#808080");
        row5Cell4.setProperty("borderBottomStyle", (Object)"solid");
        row5Cell4.setProperty("borderBottomWidth", (Object)"thin");
        row5Cell4.setProperty("borderRightColor", (Object)"#808080");
        row5Cell4.setProperty("borderRightStyle", (Object)"solid");
        row5Cell4.setProperty("borderRightWidth", (Object)"thin");
        DataItemHandle row5Cell4Data = this.elementFactory.newDataItem(null);
        row5Cell4Data.setStyleName("Date");
        row5Cell4Data.setProperty("fontFamily", (Object)"Georgia");
        row5Cell4Data.setProperty("fontSize", (Object)"smaller");
        row5Cell4Data.getPrivateStyle().setDateTimeFormatCategory("Custom");
        row5Cell4Data.getPrivateStyle().setDateTimeFormat("$###,###.00");
        row5Cell4Data.setValueExpr("row[\"Billing\"]");
        row5Cell4.getContent().add((DesignElementHandle)row5Cell4Data);
    }
}

