/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.api;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class DesignIncludeLibraryTest
extends BaseTestCase {
    String fileName = "DesignIncludeLibraryTest.xml";
    private String inputLibraryName = "LibA.xml";
    private String outFileName = "DesignIncludeLibraryDpt.xml";
    private String goldenFileName = "DesignIncludeLibraryDpt_golden.xml";

    public DesignIncludeLibraryTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(DesignIncludeLibraryTest.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyResource_INPUT(this.fileName, this.fileName);
        this.copyResource_INPUT(this.inputLibraryName, this.inputLibraryName);
        this.copyResource_GOLDEN(this.goldenFileName, this.goldenFileName);
    }

    public void testDesignIncludeLibrary() throws Exception {
        this.openDesign(this.fileName);
        this.designHandle.includeLibrary(this.inputLibraryName, "LibA");
        LibraryHandle libAHandle = this.designHandle.getLibrary("LibA");
        TextItemHandle textLibA = (TextItemHandle)libAHandle.findElement("text1");
        DesignIncludeLibraryTest.assertNotNull((String)"Text should not be null", (Object)textLibA);
        TableHandle tableLibA = (TableHandle)libAHandle.findElement("table1");
        DesignIncludeLibraryTest.assertNotNull((String)"Table should not be null", (Object)tableLibA);
        ParameterHandle parameterLibA = libAHandle.findParameter("par1");
        DesignIncludeLibraryTest.assertNotNull((String)"Parameter should not be null", (Object)parameterLibA);
        LabelHandle labelLibA = (LabelHandle)libAHandle.findElement("label1");
        DesignIncludeLibraryTest.assertNotNull((String)"Label should not be null", (Object)labelLibA);
        ImageHandle imageLibA = (ImageHandle)libAHandle.findElement("pic1");
        DesignIncludeLibraryTest.assertNotNull((String)"Image should not be null", (Object)imageLibA);
        DataItemHandle dataLibA = (DataItemHandle)libAHandle.findElement("data1");
        DesignIncludeLibraryTest.assertNotNull((String)"Data should not be null", (Object)dataLibA);
        DataSourceHandle dataSourceLibA = libAHandle.findDataSource("sqlds1");
        DesignIncludeLibraryTest.assertNotNull((String)"Datasource should not be null", (Object)dataSourceLibA);
        DataSetHandle dataSetLibA = libAHandle.findDataSet("sqldst1");
        DesignIncludeLibraryTest.assertNotNull((String)"Dataset should not be null", (Object)dataSetLibA);
        ListHandle listLibA = (ListHandle)libAHandle.findElement("list1");
        DesignIncludeLibraryTest.assertNotNull((String)"List should not be null", (Object)listLibA);
        GridHandle gridLibA = (GridHandle)libAHandle.findElement("grid1");
        DesignIncludeLibraryTest.assertNotNull((String)"Grid should not be null", (Object)gridLibA);
        TextItemHandle textLibAHandle = (TextItemHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)textLibA, "text1");
        TableHandle tableLibAHandle = (TableHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)tableLibA, "table1");
        ParameterHandle parameterLibAHandle = (ParameterHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)parameterLibA, "par1");
        LabelHandle labelLibAHandle = (LabelHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)labelLibA, "label1");
        ImageHandle imageLibAHandle = (ImageHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)imageLibA, "pic1");
        DataItemHandle dataLibAHandle = (DataItemHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)dataLibA, "data1");
        OdaDataSourceHandle dataSourceLibAHandle = this.designHandle.getElementFactory().newOdaDataSource("sqlds1");
        OdaDataSetHandle dataSetLibAHandle = this.designHandle.getElementFactory().newOdaDataSet("sqldst1");
        ListHandle listLibAHandle = (ListHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)listLibA, "list1");
        GridHandle gridLibAHandle = (GridHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)gridLibA, "grid1");
        this.designHandle.getDataSources().add((DesignElementHandle)dataSourceLibAHandle);
        this.designHandle.getDataSets().add((DesignElementHandle)dataSetLibAHandle);
        this.designHandle.getBody().add((DesignElementHandle)dataLibAHandle);
        this.designHandle.getParameters().add((DesignElementHandle)parameterLibAHandle);
        this.designHandle.getBody().add((DesignElementHandle)textLibAHandle);
        this.designHandle.getBody().add((DesignElementHandle)labelLibAHandle);
        this.designHandle.getBody().add((DesignElementHandle)tableLibAHandle);
        this.designHandle.getBody().add((DesignElementHandle)imageLibAHandle);
        this.designHandle.getBody().add((DesignElementHandle)listLibAHandle);
        this.designHandle.getBody().add((DesignElementHandle)gridLibAHandle);
        DesignIncludeLibraryTest.assertEquals((String)"sqlds11", (String)dataSourceLibAHandle.getName());
        DesignIncludeLibraryTest.assertEquals((String)"sqldst11", (String)dataSetLibAHandle.getName());
        DesignIncludeLibraryTest.assertEquals((String)"data11", (String)dataLibAHandle.getName());
        DesignIncludeLibraryTest.assertEquals((String)"par11", (String)parameterLibAHandle.getName());
        DesignIncludeLibraryTest.assertEquals((String)"text11", (String)textLibAHandle.getName());
        DesignIncludeLibraryTest.assertEquals((String)"label11", (String)labelLibAHandle.getName());
        DesignIncludeLibraryTest.assertEquals((String)"table11", (String)tableLibAHandle.getName());
        DesignIncludeLibraryTest.assertEquals((String)"pic11", (String)imageLibAHandle.getName());
        DesignIncludeLibraryTest.assertEquals((String)"list11", (String)listLibAHandle.getName());
        DesignIncludeLibraryTest.assertEquals((String)"grid11", (String)gridLibAHandle.getName());
        LabelHandle labelDesignHandle = (LabelHandle)this.designHandle.findElement("designlabel");
        DesignIncludeLibraryTest.assertNotNull((String)"designlabel should not be null", (Object)labelDesignHandle);
        DesignIncludeLibraryTest.assertEquals((String)"#FFA500", (String)labelDesignHandle.getStringProperty("color"));
        DesignIncludeLibraryTest.assertEquals((String)"#0000FF", (String)labelDesignHandle.getStringProperty("backgroundColor"));
        SharedStyleHandle styleLibA = libAHandle.findStyle("style1");
        DesignIncludeLibraryTest.assertNotNull((String)"Style should not be null", (Object)styleLibA);
        SharedStyleHandle styleLibAHandle = this.designHandle.getElementFactory().newStyle("style1");
        this.designHandle.getStyles().add((DesignElementHandle)styleLibAHandle);
        DesignIncludeLibraryTest.assertEquals((String)"#FFA500", (String)labelDesignHandle.getStringProperty("color"));
        DesignIncludeLibraryTest.assertEquals((String)"#0000FF", (String)labelDesignHandle.getStringProperty("backgroundColor"));
        SharedStyleHandle styleDesignHandle = this.designHandle.findStyle("style1");
        DesignIncludeLibraryTest.assertNotNull((String)"style1 shoule not be null", (Object)styleDesignHandle);
        styleDesignHandle.drop();
        DesignIncludeLibraryTest.assertEquals((String)"black", (String)labelDesignHandle.getStringProperty("color"));
        DesignIncludeLibraryTest.assertEquals(null, (String)labelDesignHandle.getStringProperty("backgroundColor"));
        super.saveAs(this.outFileName);
    }

    public void testDuplicateDesign() throws Exception {
        this.openDesign(this.fileName);
        this.designHandle.includeLibrary(this.inputLibraryName, "LibA");
        LibraryHandle libAHandle = this.designHandle.getLibrary("LibA");
        TextItemHandle text1LibA = (TextItemHandle)libAHandle.findElement("text1");
        DesignIncludeLibraryTest.assertNotNull((String)"Text should not be null", (Object)text1LibA);
        TextItemHandle text1LibAHandle = (TextItemHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)text1LibA, "");
        this.designHandle.getBody().add((DesignElementHandle)text1LibAHandle);
        text1LibAHandle.setName("text4");
        TextItemHandle text4LibA = (TextItemHandle)libAHandle.findElement("text4");
        DesignIncludeLibraryTest.assertNotNull((String)"Text should not be null", (Object)text4LibA);
        try {
            TextItemHandle text4LibAHandle = (TextItemHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)text4LibA, "");
            this.designHandle.getBody().add((DesignElementHandle)text4LibAHandle);
        }
        catch (Exception e) {
            DesignIncludeLibraryTest.assertNotNull((Object)e);
        }
    }

    public void testNoLibrary() throws Exception {
        this.openDesign(this.fileName);
        try {
            this.designHandle.includeLibrary("../input/LibX.xml", "LibA");
            this.designHandle.getLibrary("LibA");
        }
        catch (Exception e) {
            DesignIncludeLibraryTest.assertNotNull((Object)e);
        }
    }

    public void testDBRefer() throws Exception {
        this.openDesign(this.fileName);
        this.designHandle.includeLibrary(this.inputLibraryName, "LibA");
        LibraryHandle libAHandle = this.designHandle.getLibrary("LibA");
        DataSourceHandle dataSourceLibA = libAHandle.findDataSource("sqlds1");
        DesignIncludeLibraryTest.assertNotNull((String)"Datasource should not be null", (Object)dataSourceLibA);
        DataSetHandle dataSetLibA = libAHandle.findDataSet("sqldst1");
        DesignIncludeLibraryTest.assertNotNull((String)"Dataset should not be null", (Object)dataSetLibA);
        OdaDataSetHandle dataSetLibAHandle = this.designHandle.getElementFactory().newOdaDataSet("sqldst1");
        this.designHandle.getDataSets().add((DesignElementHandle)dataSetLibAHandle);
        TableHandle tableHandle = this.designHandle.getElementFactory().newTableItem("mytable1");
        this.designHandle.getBody().add((DesignElementHandle)tableHandle);
        dataSetLibAHandle.setDataSource("LibA.sqlds1");
        tableHandle.setDataSet(dataSetLibA);
    }
}

