/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.api;

import com.ibm.icu.util.ULocale;
import java.io.InputStream;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.css.StyleSheetParserException;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class ExternalCssStyleSheet1Test
extends BaseTestCase {
    private static String fileName = "ExternalCssStyleSheet1Test.css";
    private CssStyleSheetHandle cssStyleSheetHandle = null;
    private SharedStyleHandle style1 = null;
    private SharedStyleHandle style2 = null;
    private SharedStyleHandle style3 = null;

    public ExternalCssStyleSheet1Test(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ExternalCssStyleSheet1Test.class);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyInputToFile("input/" + fileName);
        SessionHandle designSession = DesignEngine.newSession((ULocale)ULocale.ENGLISH);
        this.designHandle = designSession.createDesign();
        this.cssStyleSheetHandle = this.loadStyleSheet(fileName);
        this.style1 = this.cssStyleSheetHandle.findStyle("table1");
        this.style2 = this.cssStyleSheetHandle.findStyle("table2");
        this.style3 = this.cssStyleSheetHandle.findStyle("table3");
    }

    private CssStyleSheetHandle loadStyleSheet(String fileName) throws Exception {
        fileName = "input/" + fileName;
        InputStream is = ExternalCssStyleSheet1Test.class.getResourceAsStream(fileName);
        return this.designHandle.openCssStyleSheet(is);
    }

    public void testParserForSupportedProperties() throws Exception {
        ExternalCssStyleSheet1Test.assertNotNull((Object)this.style1);
        ExternalCssStyleSheet1Test.assertNotNull((Object)this.style2);
        ExternalCssStyleSheet1Test.assertNotNull((Object)this.style3);
        ExternalCssStyleSheet1Test.assertEquals((Object)"cursive", (Object)this.style1.getProperty("fontFamily"));
        ExternalCssStyleSheet1Test.assertEquals((String)"\"arial\"", (String)this.style2.getProperty("fontFamily").toString());
        ExternalCssStyleSheet1Test.assertEquals((String)"small", (String)this.style1.getStringProperty("fontSize"));
        ExternalCssStyleSheet1Test.assertEquals((String)"12pt", (String)this.style2.getStringProperty("fontSize"));
        ExternalCssStyleSheet1Test.assertEquals((String)"italic", (String)this.style1.getStringProperty("fontStyle"));
        ExternalCssStyleSheet1Test.assertEquals((String)"bolder", (String)this.style1.getStringProperty("fontWeight"));
        ExternalCssStyleSheet1Test.assertEquals((String)"small-caps", (String)this.style1.getStringProperty("fontVariant"));
        ExternalCssStyleSheet1Test.assertEquals((String)"red", (String)this.style1.getStringProperty("color"));
        ExternalCssStyleSheet1Test.assertEquals((String)"#FF0000", (String)this.style2.getStringProperty("color"));
        ExternalCssStyleSheet1Test.assertEquals((String)"underline", (String)this.style1.getStringProperty("textUnderline"));
        ExternalCssStyleSheet1Test.assertEquals((String)"overline", (String)this.style1.getStringProperty("textOverline"));
        ExternalCssStyleSheet1Test.assertEquals((String)"line-through", (String)this.style1.getStringProperty("textLineThrough"));
        ExternalCssStyleSheet1Test.assertEquals((String)"fixed", (String)this.style1.getStringProperty("backgroundAttachment"));
        ExternalCssStyleSheet1Test.assertEquals((String)"green", (String)this.style1.getStringProperty("backgroundColor"));
        ExternalCssStyleSheet1Test.assertEquals((String)"#00FF00", (String)this.style2.getStringProperty("backgroundColor"));
        ExternalCssStyleSheet1Test.assertEquals((String)"logo.gif", (String)this.style1.getStringProperty("backgroundImage"));
        ExternalCssStyleSheet1Test.assertEquals((String)"center", (String)this.style1.getStringProperty("backgroundPositionX"));
        ExternalCssStyleSheet1Test.assertEquals((String)"center", (String)this.style1.getStringProperty("backgroundPositionY"));
        ExternalCssStyleSheet1Test.assertEquals((String)"25%", (String)this.style2.getStringProperty("backgroundPositionX"));
        ExternalCssStyleSheet1Test.assertEquals((String)"25%", (String)this.style2.getStringProperty("backgroundPositionY"));
        ExternalCssStyleSheet1Test.assertEquals((String)"no-repeat", (String)this.style1.getStringProperty("backgroundRepeat"));
        ExternalCssStyleSheet1Test.assertEquals((String)"normal", (String)this.style1.getStringProperty("letterSpacing"));
        ExternalCssStyleSheet1Test.assertEquals((String)"12em", (String)this.style2.getStringProperty("letterSpacing"));
        ExternalCssStyleSheet1Test.assertEquals((String)"normal", (String)this.style1.getStringProperty("lineHeight"));
        ExternalCssStyleSheet1Test.assertEquals((String)"12px", (String)this.style2.getStringProperty("lineHeight"));
        ExternalCssStyleSheet1Test.assertEquals((String)"justify", (String)this.style1.getStringProperty("textAlign"));
        ExternalCssStyleSheet1Test.assertEquals((String)"12mm", (String)this.style1.getStringProperty("textIndent"));
        ExternalCssStyleSheet1Test.assertEquals((String)"uppercase", (String)this.style1.getStringProperty("textTransform"));
        ExternalCssStyleSheet1Test.assertEquals((String)"middle", (String)this.style1.getStringProperty("verticalAlign"));
        ExternalCssStyleSheet1Test.assertEquals((String)"align", (String)this.style2.getStringProperty("verticalAlign"));
        ExternalCssStyleSheet1Test.assertEquals((String)"nowrap", (String)this.style1.getStringProperty("whiteSpace"));
        ExternalCssStyleSheet1Test.assertEquals((String)"inherit", (String)this.style1.getStringProperty("widows"));
        ExternalCssStyleSheet1Test.assertEquals((String)"3", (String)this.style2.getStringProperty("widows"));
        ExternalCssStyleSheet1Test.assertEquals((String)"inherit", (String)this.style1.getStringProperty("orphans"));
        ExternalCssStyleSheet1Test.assertEquals((String)"1", (String)this.style2.getStringProperty("orphans"));
        ExternalCssStyleSheet1Test.assertEquals((String)"normal", (String)this.style1.getStringProperty("wordSpacing"));
        ExternalCssStyleSheet1Test.assertEquals((String)"12in", (String)this.style2.getStringProperty("wordSpacing"));
        ExternalCssStyleSheet1Test.assertEquals((String)"solid", (String)this.style1.getStringProperty("borderTopStyle"));
        ExternalCssStyleSheet1Test.assertEquals((String)"thick", (String)this.style1.getStringProperty("borderTopWidth"));
        ExternalCssStyleSheet1Test.assertEquals((String)"1mm", (String)this.style2.getStringProperty("borderTopWidth"));
        ExternalCssStyleSheet1Test.assertEquals((String)"blue", (String)this.style1.getStringProperty("borderTopColor"));
        ExternalCssStyleSheet1Test.assertEquals((String)"#0000FF", (String)this.style2.getStringProperty("borderTopColor"));
        ExternalCssStyleSheet1Test.assertEquals((String)"dotted", (String)this.style1.getStringProperty("borderLeftStyle"));
        ExternalCssStyleSheet1Test.assertEquals((String)"medium", (String)this.style1.getStringProperty("borderLeftWidth"));
        ExternalCssStyleSheet1Test.assertEquals((String)"1in", (String)this.style2.getStringProperty("borderLeftWidth"));
        ExternalCssStyleSheet1Test.assertEquals((String)"red", (String)this.style1.getStringProperty("borderLeftColor"));
        ExternalCssStyleSheet1Test.assertEquals((String)"#FF0000", (String)this.style2.getStringProperty("borderLeftColor"));
        ExternalCssStyleSheet1Test.assertEquals((String)"dashed", (String)this.style1.getStringProperty("borderBottomStyle"));
        ExternalCssStyleSheet1Test.assertEquals((String)"thin", (String)this.style1.getStringProperty("borderBottomWidth"));
        ExternalCssStyleSheet1Test.assertEquals((String)"1cm", (String)this.style2.getStringProperty("borderBottomWidth"));
        ExternalCssStyleSheet1Test.assertEquals((String)"green", (String)this.style1.getStringProperty("borderBottomColor"));
        ExternalCssStyleSheet1Test.assertEquals((String)"#00FF00", (String)this.style2.getStringProperty("borderBottomColor"));
        ExternalCssStyleSheet1Test.assertEquals((String)"double", (String)this.style1.getStringProperty("borderRightStyle"));
        ExternalCssStyleSheet1Test.assertEquals((String)"thin", (String)this.style1.getStringProperty("borderRightWidth"));
        ExternalCssStyleSheet1Test.assertEquals((String)"1px", (String)this.style2.getStringProperty("borderRightWidth"));
        ExternalCssStyleSheet1Test.assertEquals((String)"blue", (String)this.style1.getStringProperty("borderRightColor"));
        ExternalCssStyleSheet1Test.assertEquals((String)"#0000FF", (String)this.style2.getStringProperty("borderRightColor"));
        ExternalCssStyleSheet1Test.assertEquals((String)"auto", (String)this.style1.getStringProperty("marginTop"));
        ExternalCssStyleSheet1Test.assertEquals((String)"1em", (String)this.style2.getStringProperty("marginTop"));
        ExternalCssStyleSheet1Test.assertEquals((String)"auto", (String)this.style1.getStringProperty("marginBottom"));
        ExternalCssStyleSheet1Test.assertEquals((String)"1em", (String)this.style2.getStringProperty("marginBottom"));
        ExternalCssStyleSheet1Test.assertEquals((String)"auto", (String)this.style1.getStringProperty("marginLeft"));
        ExternalCssStyleSheet1Test.assertEquals((String)"1em", (String)this.style2.getStringProperty("marginLeft"));
        ExternalCssStyleSheet1Test.assertEquals((String)"auto", (String)this.style1.getStringProperty("marginRight"));
        ExternalCssStyleSheet1Test.assertEquals((String)"1em", (String)this.style2.getStringProperty("marginRight"));
        ExternalCssStyleSheet1Test.assertEquals((String)"1pt", (String)this.style1.getStringProperty("paddingTop"));
        ExternalCssStyleSheet1Test.assertEquals((String)"1pt", (String)this.style1.getStringProperty("paddingLeft"));
        ExternalCssStyleSheet1Test.assertEquals((String)"1pt", (String)this.style1.getStringProperty("paddingBottom"));
        ExternalCssStyleSheet1Test.assertEquals((String)"1pt", (String)this.style1.getStringProperty("paddingRight"));
    }

    public void testParserForNoSupportedProperties() throws Exception {
        List warningList = this.cssStyleSheetHandle.getWarnings(this.style3.getName());
        ExternalCssStyleSheet1Test.assertNotNull((Object)warningList);
        int i = 0;
        while (i < warningList.size()) {
            StyleSheetParserException error = (StyleSheetParserException)warningList.get(i);
            if (i == 0) {
                ExternalCssStyleSheet1Test.assertEquals((String)"border-spacing", (String)error.getCSSPropertyName());
                ExternalCssStyleSheet1Test.assertEquals((String)"12pt", (String)error.getCSSValue());
            } else if (i == 1) {
                ExternalCssStyleSheet1Test.assertEquals((String)"border-collapse", (String)error.getCSSPropertyName());
                ExternalCssStyleSheet1Test.assertEquals((String)"separate", (String)error.getCSSValue());
            } else {
                ExternalCssStyleSheet1Test.assertEquals((String)"caption-side", (String)error.getCSSPropertyName());
                ExternalCssStyleSheet1Test.assertEquals((String)"bottom", (String)error.getCSSValue());
            }
            Object var3_3 = null;
            ++i;
        }
    }
}

