/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.regression;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.util.ElementExportUtil;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class Regression_122357
extends BaseTestCase {
    private static String INPUT = "Regression_122357.xml";
    private static String LIB = "regression_122357_exportlib.xml";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyInputToFile("input/" + INPUT);
    }

    public void test_regression_122357() throws DesignFileException, SemanticException, IOException {
        DesignEngine engine = new DesignEngine(new DesignConfig());
        SessionHandle session = engine.newSessionHandle(ULocale.ENGLISH);
        ReportDesignHandle design = session.openDesign(String.valueOf(this.getTempFolder()) + "/" + "input" + "/" + INPUT);
        String output = this.genOutputFile(LIB);
        File outputFile = new File(output);
        if (outputFile.exists()) {
            outputFile.delete();
        }
        ElementExportUtil.exportDesign((ReportDesignHandle)design, (String)output, (boolean)true, (boolean)true);
        LibraryHandle lib = session.openLibrary(output);
        DesignElementHandle chart = lib.getComponents().get(0);
        Regression_122357.assertEquals((String)"NewChart", (String)chart.getName());
        Regression_122357.assertEquals((String)"Chart", (String)((ExtendedItemHandle)chart).getExtensionName());
    }
}

