/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.regression;

import com.ibm.icu.util.ULocale;
import java.io.IOException;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class Regression_132938
extends BaseTestCase {
    private static final String INPUT = "regression_132938.xml";
    private static final String LIBRARY_A = "regression_132938_libA.xml";
    private static final String LIBRARY_B = "regression_132938_libB.xml";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyInputToFile("input/regression_132938.xml");
        this.copyInputToFile("input/regression_132938_libA.xml");
        this.copyInputToFile("input/regression_132938_libB.xml");
    }

    public void test_regression_132938() throws DesignFileException, SemanticException, IOException {
        String report = String.valueOf(this.getTempFolder()) + "/" + "input" + "/" + INPUT;
        String cfr_ignored_0 = String.valueOf(this.getTempFolder()) + "/" + "input" + "/" + LIBRARY_A;
        String libB = String.valueOf(this.getTempFolder()) + "/" + "input" + "/" + LIBRARY_B;
        this.sessionHandle = new DesignEngine(new DesignConfig()).newSessionHandle(ULocale.ENGLISH);
        this.designHandle = this.sessionHandle.openDesign(report);
        this.designHandle.includeLibrary(LIBRARY_A, "regression_132938_libA");
        this.libraryHandle = this.designHandle.getLibrary("regression_132938_libA");
        LabelHandle label = (LabelHandle)this.libraryHandle.findElement("NewLabel");
        Regression_132938.assertNotNull((Object)label);
        ElementFactory factory = this.designHandle.getElementFactory();
        LabelHandle rLabel = (LabelHandle)factory.newElementFrom((DesignElementHandle)label, "rLabel");
        Regression_132938.assertEquals((String)"bbb", (String)rLabel.getText());
        this.designHandle.saveAs(String.valueOf(this.getTempFolder()) + "/" + "input" + "/" + INPUT);
        this.libraryHandle = this.sessionHandle.openLibrary(libB);
        LabelHandle label_lib2 = (LabelHandle)this.libraryHandle.findElement("NewLabel");
        label_lib2.setText("aaa");
        this.libraryHandle.saveAs(String.valueOf(this.getTempFolder()) + "/" + "input" + "/" + LIBRARY_B);
        this.designHandle.reloadLibrary(this.libraryHandle);
        ElementFactory factory1 = this.designHandle.getElementFactory();
        LabelHandle l = (LabelHandle)factory1.newElementFrom((DesignElementHandle)label, "rlabel");
        Regression_132938.assertEquals((String)"aaa", (String)l.getText());
    }
}

