/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.regression;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.TemplateReportItemHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class Regression_148761
extends BaseTestCase {
    private static final String TEMPLATE = "regression_148761_template.xml";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyInputToFile("input/regression_148761_template.xml");
    }

    @Override
    public void tearDown() {
        this.removeResource();
    }

    public void test_regression_148761() throws DesignFileException, SemanticException {
        DesignEngine engine = new DesignEngine(new DesignConfig());
        SessionHandle session = engine.newSessionHandle(ULocale.ENGLISH);
        String inputPath = String.valueOf(this.getTempFolder()) + "/" + "input" + "/";
        ReportDesignHandle template = session.openDesign(String.valueOf(inputPath) + TEMPLATE);
        TextItemHandle text1 = (TextItemHandle)template.findElement("t1");
        TemplateReportItemHandle templateText1 = (TemplateReportItemHandle)text1.createTemplateElement("templateText1");
        IDesignElement copy = templateText1.copyDefaultElement();
        templateText1.transformToReportItem((ReportItemHandle)copy.getHandle(template.getModule()));
        TextItemHandle text2 = (TextItemHandle)template.findElement("t1");
        ReportDesignHandle newDesignHandle = session.createDesign();
        newDesignHandle.getBody().paste(text2.copy().getHandle((Module)this.design));
        TextItemHandle pastedText = (TextItemHandle)newDesignHandle.findElement("t1");
        Regression_148761.assertNotNull((Object)pastedText);
        Regression_148761.assertEquals((String)"sample text", (String)pastedText.getContent());
    }
}

