/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.html;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.IRunTask;

public abstract class HTMLReportEmitterTestCase
extends TestCase {
    protected static final String REPORT_DESIGN = "design.rptdesign";
    protected static final String REPORT_DOCUMENT = "reportdocument";
    protected IReportEngine engine;

    public abstract String getWorkSpace();

    public void setUp() {
        this.removeFile(REPORT_DOCUMENT);
        this.removeFile(REPORT_DESIGN);
        EngineConfig config = new EngineConfig();
        this.engine = this.createReportEngine(config);
    }

    public void tearDown() {
        this.engine.shutdown();
        this.removeFile(REPORT_DESIGN);
        this.removeFile(REPORT_DOCUMENT);
        this.removeFile(new File(this.getWorkSpace()));
    }

    public byte[] loadResource(String src) {
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(src);
        HTMLReportEmitterTestCase.assertTrue((in != null ? 1 : 0) != 0);
        try {
            int size = in.available();
            byte[] buffer = new byte[size];
            in.read(buffer);
            in.close();
            return buffer;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            HTMLReportEmitterTestCase.fail();
            return null;
        }
    }

    public void unzip(String src, String folder) {
    }

    public IReportEngine createReportEngine() {
        return this.createReportEngine(null);
    }

    public IReportEngine createReportEngine(EngineConfig config) {
        Object factory;
        if (config == null) {
            config = new EngineConfig();
        }
        if ((factory = Platform.createFactoryObject((String)"org.eclipse.birt.report.engine.ReportEngineFactory")) instanceof IReportEngineFactory) {
            return ((IReportEngineFactory)factory).createReportEngine(config);
        }
        return null;
    }

    protected IReportDocument createReportDocument(String designFileName) throws EngineException {
        this.useDesignFile(designFileName);
        this.createReportDocument();
        return this.engine.openReportDocument(REPORT_DOCUMENT);
    }

    protected IRunAndRenderTask createRunAndRenderTask(String designFileName) throws EngineException {
        this.useDesignFile(designFileName);
        IReportRunnable reportRunnable = this.engine.openReportDesign(REPORT_DESIGN);
        return this.engine.createRunAndRenderTask(reportRunnable);
    }

    protected IRenderTask createRenderTask(String designFileName) throws EngineException {
        IReportDocument document = this.createReportDocument(designFileName);
        return this.engine.createRenderTask(document);
    }

    protected void useDesignFile(String fileName) {
        this.removeFile(REPORT_DESIGN);
        this.removeFile(REPORT_DOCUMENT);
        this.copyResource(fileName, REPORT_DESIGN);
    }

    protected void createReportDocument() throws EngineException {
        IReportRunnable report = this.engine.openReportDesign(REPORT_DESIGN);
        IRunTask task = this.engine.createRunTask(report);
        task.run(REPORT_DOCUMENT);
        task.close();
    }

    public String loadReportContent() {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(String.valueOf(this.getWorkSpace()) + "/" + "report.html"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return this.loadStreamContent(in);
    }

    protected String loadBodyContent() {
        String content = this.loadReportContent();
        int indexOfBody = content.indexOf("<body>");
        int indexOfEndBody = content.indexOf("</body>");
        return content.substring(indexOfBody + 6, indexOfEndBody);
    }

    protected String loadGoldenContent(String name) {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(name);
        return this.loadStreamContent(in);
    }

    protected String loadStreamContent(InputStream in) {
        try {
            int chr;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((chr = in.read()) != -1) {
                out.write(chr);
            }
            in.close();
            return out.toString().replaceAll("[\\s|\\t]*\\n[\\s|\\t]*", "");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void copyResource(String src, String tgt) {
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(src);
        HTMLReportEmitterTestCase.assertTrue((in != null ? 1 : 0) != 0);
        try {
            FileOutputStream fos = new FileOutputStream(tgt);
            byte[] fileData = new byte[5120];
            int readCount = -1;
            while ((readCount = in.read(fileData)) != -1) {
                fos.write(fileData, 0, readCount);
            }
            fos.close();
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            HTMLReportEmitterTestCase.fail();
        }
    }

    public void removeFile(File file) {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                this.removeFile(children[i]);
                ++i;
            }
        }
        if (file.exists() && !file.delete()) {
            System.out.println(String.valueOf(file.toString()) + " can't be removed");
        }
    }

    public void removeFile(String file) {
        this.removeFile(new File(file));
    }

    public void render(String design, IRenderOption options) throws EngineException {
        IReportDocument document = this.createReportDocument(design);
        IRenderTask render = this.engine.createRenderTask(document);
        render.setRenderOption(options);
        render.render();
        render.close();
    }

    public void runAndRender(String design, IRenderOption options) throws EngineException {
        IReportRunnable reportRunnable = this.engine.openReportDesign(design);
        IRunAndRenderTask runAndRenderTask = this.engine.createRunAndRenderTask(reportRunnable);
        runAndRenderTask.setRenderOption(options);
        runAndRenderTask.run();
        runAndRenderTask.close();
    }
}

