/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.html;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.emitter.html.HTMLReportEmitterTestCase;

public class MetadataEmitterTest
extends HTMLReportEmitterTestCase {
    static String noMetadata1 = "<div([^<>]* id=\"";
    static String noMetadata2 = "\"[^<>]*)>[^<>]*</div>";
    static String metadata1 = "<div([^<>]* id=\"";
    static String metadata2 = "\"[^<>]*)>[^<>]*";
    static String template1 = metadata1;
    static String template2 = "\"[^<>]*)>";
    static String table1 = "<table( [^<>]*id=\"";
    static String table2 = "\"[^<>]*)>";
    static String list1 = "<div([^<>]* id=\"";
    static String list2 = "\"[^<>]*)>";
    static String imageMetadata1 = "<img([^<>]* id=\"";
    static String imageMetadata2 = "\"[^<>]*)>[^<>]*";
    static String imageNoMetadata1 = "<div>[^<>]*<img([^<>]* id=\"";
    static String imageNoMetadata2 = "\"[^<>]*)>[^<>]*</div>";
    static String chartMetadata1 = "<embed([^<>]* id=\"";
    static String chartMetadata2 = "\"[^<>]*)>[^<>]*";

    @Override
    public String getWorkSpace() {
        return "./metadataTest";
    }

    public void testAllItems() throws EngineException, IOException {
        String designFile = "org/eclipse/birt/report/engine/emitter/html/ActiveId_Test.xml";
        String[][] bookmarksWithMetadata = new String[][]{{"label", "LABEL"}, {"table", "TABLE"}, {"chart", "Chart"}, {"list", "LIST"}, {"HTML text", "TEXT"}, {"data", "DATA"}, {"AUTOGENBOOKMARK_1", "TEMPLATE"}, {"AUTOGENBOOKMARK_2", "TEMPLATE"}, {"AUTOGENBOOKMARK_3", "TEMPLATE"}, {"AUTOGENBOOKMARK_4", "TEMPLATE"}, {"AUTOGENBOOKMARK_5", "TEMPLATE"}, {"AUTOGENBOOKMARK_6", "TEMPLATE"}, {"AUTOGENBOOKMARK_7", "TEMPLATE"}, {"AUTOGENBOOKMARK_8", "TEMPLATE"}, {"AUTOGENBOOKMARK_9", "TEMPLATE"}};
        String[][] bookmarksWithoutMetadata = new String[][]{{"grid", "GRID"}, {"dynamic text", "DYNAMIC_TEXT"}, {"image", "IMAGE"}, {"static text", "STATIC_TEXT"}};
        this.checkAllTask(designFile, bookmarksWithMetadata, bookmarksWithoutMetadata);
    }

    public void testDataItem() throws EngineException, IOException {
        String designFile = "org/eclipse/birt/report/engine/emitter/html/dataItemMetadata_Test.xml";
        String[][] bookmarksWithMetadata = new String[][]{{"topLevelData", "DATA"}, {"dataInTableHeader", "DATA", "192"}, {"dataInGridInTableHeader", "DATA", "204"}, {"dataInTableGroupHeader", "DATA", "190"}, {"dataInGridInGridInTableGroupHeader", "DATA", "214"}, {"dataInTableGroupFooter", "DATA", "191"}, {"dataInTableFooter", "DATA", "193"}};
        String[][] bookmarksWithoutMetadata = new String[][]{{"dataInTableHeaderWithDataSet", "DATA"}, {"dataInTableDetail", "DATA"}, {"dataInListHeader", "DATA"}, {"dataInListGroupHeader", "DATA"}, {"dataInListDetail", "DATA"}, {"dataInListGroupFooter", "DATA"}, {"dataInListFooter", "DATA"}};
        this.checkAllTask(designFile, bookmarksWithMetadata, bookmarksWithoutMetadata);
    }

    public void testDataItemWithoutBookmark() throws EngineException, IOException {
        String designFile = "org/eclipse/birt/report/engine/emitter/html/dataItemWithoutBookmarkMetadata_Test.xml";
        String[][] bookmarksWithMetadata = new String[][]{{"__bookmark_1", "DATA", "176"}, {"__bookmark_2", "TABLE", "177"}, {"AUTOGENBOOKMARK_1", "DATA", "192"}, {"AUTOGENBOOKMARK_3", "DATA", "204"}, {"AUTOGENBOOKMARK_4", "DATA", "190"}, {"AUTOGENBOOKMARK_7", "DATA", "214"}, {"AUTOGENBOOKMARK_8", "DATA", "191"}, {"AUTOGENBOOKMARK_9", "DATA", "193"}, {"__bookmark_4", "LIST", "228"}};
        String[][] bookmarksWithoutMetadata = new String[][]{};
        this.checkAllTask(designFile, bookmarksWithMetadata, bookmarksWithoutMetadata);
    }

    public void testDisplayGroupIcon() throws EngineException, IOException {
        String designFile = "org/eclipse/birt/report/engine/emitter/html/displayGroupIcon_Test.xml";
        this.checkDisplyGroupIcon(designFile, true, true);
        this.checkDisplyGroupIcon(designFile, true, false);
        this.checkDisplyGroupIcon(designFile, false, true);
        this.checkDisplyGroupIcon(designFile, false, false);
    }

    public void testDisplayGroupIconWithGroupKey() throws EngineException, IOException {
        String designFile = "org/eclipse/birt/report/engine/emitter/html/displayGroupIcon_Test1.xml";
        HTMLRenderOption options = new HTMLRenderOption();
        options.setDisplayGroupIcon(true);
        String[] iconKeys = new String[]{"group key1 in data item", "group key2 in grid without query", "group key3 in data item", "group key4 with same expression"};
        String content = this.getRenderResult((String)designFile, (boolean)false, (HTMLRenderOption)options).content;
        this.checkAllGroupIconDisplayed(options, content, iconKeys);
        content = this.getRenderResult((String)designFile, (boolean)true, (HTMLRenderOption)options).content;
        this.checkAllGroupIconDisplayed(options, content, iconKeys);
    }

    public void testDefaultGroupIconPlace() throws EngineException, IOException {
        String designFile = "org/eclipse/birt/report/engine/emitter/html/displayGroupIcon_Test3.xml";
        HTMLRenderOption options = new HTMLRenderOption();
        options.setDisplayGroupIcon(true);
        String content = this.getRenderResult((String)designFile, (boolean)true, (HTMLRenderOption)options).content;
        content = content.replaceAll("\n", "\"\n\"+\\\\n");
        String regex = "<table[^<>]*>[^<>]*<tr[^<>]*>[^<>]*<td[^<>]*>[^<>]*<img[^<>]* src=\"./images/iv/collapsexpand.gif\"[^<>]*>[^<>]*</img>[^<>]*</td[^<>]*>[^<>]*<td[^<>]*>[^<>]*<div[^<>]*>[^<>]*GroupHead";
        Matcher matcher = Pattern.compile(regex).matcher(content);
        MetadataEmitterTest.assertEquals((boolean)true, (boolean)matcher.find());
    }

    public void testWrapTemplateTable() throws EngineException, IOException {
        String designFile = "org/eclipse/birt/report/engine/emitter/html/wrapTemplateTable_test.xml";
        HTMLRenderOption options = new HTMLRenderOption();
        options.setWrapTemplateTable(true);
        String content = this.getRenderResult((String)designFile, (boolean)true, (HTMLRenderOption)options).content;
        content = content.replaceAll("\n", "\"\n\"+\\\\n");
        String regex = "<table[^<>]*>[^<>]*<tbody[^<>]*>[^<>]*<tr[^<>]*>[^<>]*<td[^<>]*>[^<>]*<img[^<>]* src=\"./images/bizRD/sidetab_active.gif\"[^<>]*>";
        Matcher matcher = Pattern.compile(regex).matcher(content);
        MetadataEmitterTest.assertEquals((boolean)true, (boolean)matcher.find());
    }

    private void checkAllGroupIconDisplayed(HTMLRenderOption options, String content, String[] keys) throws EngineException, IOException {
        int i = 0;
        while (i < keys.length) {
            this.assertHasGroupkey(content, options, keys[i]);
            ++i;
        }
    }

    private void assertHasGroupkey(String content, HTMLRenderOption options, String identityString) throws EngineException, IOException {
        String prefix = "<td[^<>]*>[^<>]*<img src=\"./images/iv/collapsexpand.gif\"[^<>]*>[^<>]*</img>[^<>]*</td>[^<>]*<td[^<>]*>[^<>]*<div[^<>]*>";
        Pattern pattern = Pattern.compile(String.valueOf(prefix) + identityString);
        if (!pattern.matcher(content).find()) {
            MetadataEmitterTest.fail((String)("Group icon \"" + identityString + "\" is not displayed."));
        }
    }

    private void checkDisplyGroupIcon(String designFile, boolean displayFilterIcon, boolean isRenderTask) throws EngineException, IOException {
        HTMLRenderOption options = new HTMLRenderOption();
        options.setDisplayGroupIcon(displayFilterIcon);
        String content = this.getRenderResult((String)designFile, (boolean)isRenderTask, (HTMLRenderOption)options).content;
        content = content.replaceAll("\n", "\"\n\"+\\\\n");
        String regex = "<table[^<>]*>[^<>]*<tr[^<>]*>[^<>]*<td[^<>]*>[^<>]*<img[^<>]* src=\"./images/iv/collapsexpand.gif\"[^<>]*>";
        this.assertString(displayFilterIcon, content, regex);
        String imageRegex = " src=\"./images/iv/collapsexpand.gif\"";
        this.assertString(displayFilterIcon, content, imageRegex);
    }

    private void assertString(boolean displayFilterIcon, String content, String regex) {
        Matcher matcher = Pattern.compile(regex).matcher(content);
        MetadataEmitterTest.assertEquals((boolean)displayFilterIcon, (boolean)matcher.find());
    }

    private void checkAllTask(String designFile, String[][] bookmarksWithMetadata, String[][] bookmarksWithoutMetadata) throws EngineException, IOException {
        this.checkRenderTask(designFile, bookmarksWithMetadata, bookmarksWithoutMetadata);
        this.checkRunAndRenderTask(designFile, bookmarksWithMetadata, bookmarksWithoutMetadata);
    }

    private void checkOutput(String content, List instanceIds, String[][] bookmarksWithMetadata, String[][] bookmarksWithoutMetadata) {
        int i = 0;
        while (i < bookmarksWithMetadata.length) {
            if (bookmarksWithMetadata[0].length >= 3) {
                this.assertMetadataOutput(content, instanceIds, bookmarksWithMetadata[i][0], bookmarksWithMetadata[i][1], bookmarksWithMetadata[i][2]);
            } else {
                this.assertMetadataOutput(content, instanceIds, bookmarksWithMetadata[i][0], bookmarksWithMetadata[i][1], null);
            }
            ++i;
        }
        i = 0;
        while (i < bookmarksWithoutMetadata.length) {
            this.assertMetadataNotOutput(content, instanceIds, bookmarksWithoutMetadata[i][0], bookmarksWithoutMetadata[i][1]);
            ++i;
        }
    }

    private void checkRunAndRenderTask(String designFile, String[][] bookmarksWithMetadata, String[][] bookmarksWithoutMetadata) throws EngineException, IOException {
        this.checkTask(designFile, bookmarksWithMetadata, bookmarksWithoutMetadata, true);
    }

    private void checkRenderTask(String designFile, String[][] bookmarksWithMetadata, String[][] bookmarksWithoutMetadata) throws EngineException, IOException {
        this.checkTask(designFile, bookmarksWithMetadata, bookmarksWithoutMetadata, true);
    }

    private void checkTask(String designFile, String[][] bookmarksWithMetadata, String[][] bookmarksWithoutMetadata, boolean isRenderTask) throws EngineException, IOException {
        HTMLRenderOption options = new HTMLRenderOption();
        options.setSupportedImageFormats("PNG;GIF;JPG;BMP;SWF;SVG");
        RenderResult result = this.getRenderResult(designFile, isRenderTask, options);
        this.checkOutput(result.content, result.instanceIDs, bookmarksWithMetadata, bookmarksWithoutMetadata);
    }

    private RenderResult getRenderResult(String designFile, boolean isRenderTask, HTMLRenderOption options) throws EngineException, IOException {
        IRenderTask task;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ArrayList instanceIDs = new ArrayList();
        options.setInstanceIDs(instanceIDs);
        options.setOutputStream((OutputStream)output);
        options.setEnableMetadata(true);
        if (isRenderTask) {
            task = this.createRenderTask(designFile);
            task.setRenderOption((IRenderOption)options);
            task.render();
            task.close();
        } else {
            task = this.createRunAndRenderTask(designFile);
            task.setRenderOption((IRenderOption)options);
            task.run();
            task.close();
        }
        String content = new String(output.toByteArray());
        output.close();
        return new RenderResult(instanceIDs, content);
    }

    private void assertMetadataOutput(String content, List instanceIds, String bookmark, String type, String id) {
        MetadataEmitterTest.assertEquals((int)1, (int)this.getCount(instanceIds, bookmark, type, id));
        MetadataEmitterTest.assertTrue((boolean)this.metaDataOutputInHtml(content, bookmark, type));
    }

    private void assertMetadataNotOutput(String content, List instanceIds, String bookmark, String type) {
        MetadataEmitterTest.assertEquals((int)0, (int)this.getCount(instanceIds, bookmark, type, null));
        MetadataEmitterTest.assertTrue((boolean)this.metadataNotOutputInHtml(content, bookmark, type));
    }

    private boolean metaDataOutputInHtml(String content, String bookmark, String type) {
        String elementType;
        String attributes;
        String resultPattern = this.getMetaDataPattern(bookmark, type);
        Pattern pattern = Pattern.compile(resultPattern);
        Matcher matcher = pattern.matcher(content);
        boolean result = false;
        if (matcher.find() && (attributes = matcher.group(1)).indexOf(elementType = " element_type=\"" + type + "\"") >= 0) {
            result = true;
        }
        MetadataEmitterTest.assertFalse((boolean)matcher.find());
        return result;
    }

    private boolean metadataNotOutputInHtml(String content, String bookmark, String type) {
        Pattern metadataPattern = Pattern.compile(this.getMetaDataPattern(bookmark, type));
        MetadataEmitterTest.assertFalse((boolean)metadataPattern.matcher(content).matches());
        String patternString = this.getNoMetaDataPattern(bookmark, type);
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String elementType;
            String attributes = matcher.group(1);
            if (attributes.indexOf(elementType = " element_type=\"" + type + "\"") < 0) continue;
            return false;
        }
        return true;
    }

    private String getMetaDataPattern(String bookmark, String type) {
        String[] patternStrings = this.getMetadataString(type);
        String resultPattern = null;
        resultPattern = bookmark.startsWith("AUTOGENBOOKMARK_") ? String.valueOf(patternStrings[0]) + bookmark + "_.{8}-.{4}-.{4}-.{4}-.{12}" + patternStrings[1] : String.valueOf(patternStrings[0]) + bookmark + patternStrings[1];
        return resultPattern;
    }

    private String getNoMetaDataPattern(String bookmark, String type) {
        String[] patternStrings = this.getNoMetadataString(type);
        String resultPattern = String.valueOf(patternStrings[0]) + bookmark + patternStrings[1];
        return resultPattern;
    }

    private int getCount(List list, String bookmark, String type, String id) {
        if (bookmark == null || type == null) {
            return 0;
        }
        int count = 0;
        int i = 0;
        while (i < list.size()) {
            String value = (String)list.get(i);
            String[] fields = value.split(",");
            if (fields.length < 3) {
                return 0;
            }
            if (this.isSameBookmark(bookmark, fields[0]) && type.equals(fields[1]) && (id == null || fields[2].equals(id))) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private boolean isSameBookmark(String golden, String bookmark) {
        int cutPoint;
        if (golden.startsWith("AUTOGENBOOKMARK_") && bookmark.startsWith("AUTOGENBOOKMARK_") && golden.equals(bookmark.substring(0, cutPoint = bookmark.lastIndexOf(95)))) {
            return true;
        }
        return bookmark.equals(golden);
    }

    private String[] getMetadataString(String type) {
        if ("TABLE".equals(type) || "GRID".equals(type)) {
            return new String[]{table1, table2};
        }
        if ("LIST".equals(type)) {
            return new String[]{list1, list2};
        }
        if ("IMAGE".equals(type) || "EXTENDED".equals(type)) {
            return new String[]{imageMetadata1, imageMetadata2};
        }
        if ("Chart".equals(type)) {
            return new String[]{chartMetadata1, chartMetadata2};
        }
        if ("TEMPLATE".equals(type)) {
            return new String[]{template1, template2};
        }
        if ("LABEL".equals(type) || "DATA".equals(type) || "TEMPLATE".equals(type) || "TEXT".equals(type) || "STATIC_TEXT".equals(type) || "DYNAMIC_TEXT".equals(type)) {
            return new String[]{metadata1, metadata2};
        }
        MetadataEmitterTest.fail();
        return null;
    }

    private String[] getNoMetadataString(String type) {
        if ("TABLE".equals(type) || "GRID".equals(type)) {
            return new String[]{table1, table2};
        }
        if ("LIST".equals(type)) {
            return new String[]{list1, list2};
        }
        if ("IMAGE".equals(type)) {
            return new String[]{imageNoMetadata1, imageNoMetadata2};
        }
        if ("LABEL".equals(type) || "DATA".equals(type) || "TEMPLATE".equals(type) || "STATIC_TEXT".equals(type) || "DYNAMIC_TEXT".equals(type)) {
            return new String[]{metadata1, metadata2};
        }
        MetadataEmitterTest.fail();
        return null;
    }

    private class RenderResult {
        List instanceIDs;
        String content;

        public RenderResult(List instanceIDs, String content) {
            this.instanceIDs = instanceIDs;
            this.content = content;
        }
    }
}

