/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.html;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.emitter.html.HTMLReportEmitterTestCase;

public class StyleTest
extends HTMLReportEmitterTestCase {
    private static String designFile = "org/eclipse/birt/report/engine/emitter/html/styleTest.xml";

    @Override
    public String getWorkSpace() {
        return "./styleTest";
    }

    public void testInlineStyle() throws EngineException, IOException {
        HTMLRenderOption options = new HTMLRenderOption();
        options.setEmbeddable(true);
        options.setEnableInlineStyle(true);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ArrayList instanceIDs = new ArrayList();
        options.setInstanceIDs(instanceIDs);
        options.setOutputStream((OutputStream)output);
        IRenderTask task = this.createRenderTask(designFile);
        task.setRenderOption((IRenderOption)options);
        task.render();
        task.close();
        String content = new String(output.toByteArray());
        output.close();
        String regex = "<style type=\"text/css\">";
        Matcher matcher = Pattern.compile(regex).matcher(content);
        StyleTest.assertEquals((boolean)false, (boolean)matcher.find());
        regex = "<div[^<>]*style=\"[^<>]*color: rgb(255, 0, 0)[^<>]*>aaaa</div>";
        matcher = Pattern.compile(regex).matcher(content);
        StyleTest.assertEquals((boolean)false, (boolean)matcher.find());
    }

    public void testCSSStyleClass() throws EngineException, IOException {
        HTMLRenderOption options = new HTMLRenderOption();
        options.setEmbeddable(true);
        options.setEnableInlineStyle(false);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ArrayList instanceIDs = new ArrayList();
        options.setInstanceIDs(instanceIDs);
        options.setOutputStream((OutputStream)output);
        IRenderTask task = this.createRenderTask(designFile);
        task.setRenderOption((IRenderOption)options);
        task.render();
        task.close();
        String content = new String(output.toByteArray());
        output.close();
        String regex = "<style type=\"text/css\">";
        Matcher matcher = Pattern.compile(regex).matcher(content);
        StyleTest.assertEquals((boolean)true, (boolean)matcher.find());
        regex = "<div[^<>]*class=\"[^<>]*CustomerStyle[^<>]*>aaaa</div>";
        matcher = Pattern.compile(regex).matcher(content);
        StyleTest.assertEquals((boolean)false, (boolean)matcher.find());
        regex = "<div[^<>]*style=\"[^<>]*color: rgb(255, 0, 0)[^<>]*>aaaa</div>";
        matcher = Pattern.compile(regex).matcher(content);
        StyleTest.assertEquals((boolean)false, (boolean)matcher.find());
    }
}

