/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine;

import java.util.ArrayList;
import java.util.Collection;

public class RunnableMonitor {
    ArrayList runnables = new ArrayList();
    ArrayList failedRunnables = new ArrayList();

    public synchronized void attachRunnable(Runnable runnable) {
        this.runnables.add(runnable);
    }

    public synchronized void detachRunnable(Runnable runnable) {
        this.runnables.remove(runnable);
        if (runnable.failedException != null) {
            this.failedRunnables.add(runnable);
        }
        if (this.runnables.size() == 0) {
            this.notifyAll();
        }
    }

    public synchronized void start() {
        this.failedRunnables.clear();
        Runnable[] threads = this.runnables.toArray(new Runnable[0]);
        int i = 0;
        while (i < threads.length) {
            new Thread(threads[i]).start();
            ++i;
        }
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {}
    }

    public Collection getFailedRunnables() {
        return this.failedRunnables;
    }

    public void printStackTrace() {
        for (Runnable runnable : this.failedRunnables) {
            Exception ex = runnable.getFailedException();
            ex.printStackTrace();
        }
    }

    public static abstract class Runnable
    implements java.lang.Runnable {
        Exception failedException;
        RunnableMonitor monitor;

        public Runnable(RunnableMonitor monitor) {
            this.monitor = monitor;
            this.monitor.attachRunnable(this);
        }

        @Override
        public void run() {
            this.failedException = null;
            try {
                try {
                    this.doRun();
                }
                catch (Exception ex) {
                    this.failedException = ex;
                    this.monitor.detachRunnable(this);
                }
            }
            finally {
                this.monitor.detachRunnable(this);
            }
        }

        public Exception getFailedException() {
            return this.failedException;
        }

        public abstract void doRun() throws Exception;

        public void sleep(long millis) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

