/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.engine.api.IPageHandler;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportDocumentInfo;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.IStatusHandler;

public class EngineTaskCancelTest
extends EngineCase {
    static final String PAGE_HANDLER_CANCEL = "org/eclipse/birt/report/engine/api/six_pages_design.xml";
    static final String REPORT_DESIGN = "design.rptdesign";
    static final String REPORT_DOCUMENT = "./reportdocument.folder/";
    static final String SCRIPT_CANCEL = "org/eclipse/birt/report/engine/api/ScriptCancel.xml";

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testScriptCancel() throws Exception {
        this.copyResource(SCRIPT_CANCEL, REPORT_DESIGN);
        this.removeFile(REPORT_DOCUMENT);
        IReportRunnable runnable = this.engine.openReportDesign(REPORT_DESIGN);
        IRunTask runTask = this.engine.createRunTask(runnable);
        ScriptCancelHanlder handler = new ScriptCancelHanlder();
        runTask.setStatusHandler((IStatusHandler)handler);
        runTask.run(REPORT_DOCUMENT);
        runTask.close();
        EngineTaskCancelTest.assertTrue((boolean)handler.status);
        EngineTaskCancelTest.assertEquals((int)4, (int)runTask.getStatus());
        this.removeFile(REPORT_DESIGN);
        this.removeFile(REPORT_DOCUMENT);
    }

    public void testCancelInPageHandler() throws Exception {
        this.copyResource(PAGE_HANDLER_CANCEL, REPORT_DESIGN);
        this.removeFile(REPORT_DOCUMENT);
        IReportRunnable runnable = this.engine.openReportDesign(REPORT_DESIGN);
        IRunTask runTask = this.engine.createRunTask(runnable);
        runTask.setPageHandler((IPageHandler)new CancelPageHandler((IEngineTask)runTask));
        runTask.run(REPORT_DOCUMENT);
        runTask.close();
        EngineTaskCancelTest.assertEquals((int)4, (int)runTask.getStatus());
        IReportDocument reportDoc = this.engine.openReportDocument(REPORT_DOCUMENT);
        EngineTaskCancelTest.assertTrue((reportDoc.getPageCount() < 6L ? 1 : 0) != 0);
        reportDoc.close();
        this.removeFile(REPORT_DESIGN);
        this.removeFile(REPORT_DOCUMENT);
    }

    private class CancelPageHandler
    implements IPageHandler {
        IEngineTask task;

        CancelPageHandler(IEngineTask task) {
            this.task = task;
        }

        public void onPage(int pageNumber, boolean checkpoint, IReportDocumentInfo doc) {
            if (pageNumber == 2) {
                this.task.cancel();
            }
        }
    }

    private class ScriptCancelHanlder
    implements IStatusHandler {
        public boolean status = false;

        private ScriptCancelHanlder() {
        }

        public void initialize() {
        }

        public void showStatus(String s) {
            this.status = true;
            EngineTaskCancelTest.assertTrue((s != null && s.length() > 0 ? 1 : 0) != 0);
        }

        public void finish() {
        }
    }
}

