/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import java.io.File;
import org.eclipse.birt.report.engine.api.ReportRunner;

public class RunAndRenderApp {
    protected void run(String design) {
        File file = new File(design);
        String name = file.getName();
        if (name.endsWith(".rptdesign")) {
            name = name.substring(0, name.length() - 10);
        }
        String parent = file.getParentFile().getAbsolutePath();
        String outputFolder = String.valueOf(parent) + File.separatorChar + name;
        String document = String.valueOf(outputFolder) + File.separatorChar + name + ".zip";
        int result = new ReportRunner(new String[]{"-o", outputFolder, design}).execute();
        if (result != -1 && (result = new ReportRunner(new String[]{"-m", "run", "-o", document, design}).execute()) != -1) {
            result = new ReportRunner(new String[]{"-m", "render", "-o", outputFolder, document}).execute();
            return;
        }
        System.out.print("execute " + design + " failed");
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("RunAndRenderApp <design file | design folder>");
            return;
        }
        RunAndRenderApp app = new RunAndRenderApp();
        File file = new File(args[0]);
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                int i = 0;
                while (i < files.length) {
                    if (files[i].isFile()) {
                        app.run(files[i].getAbsolutePath());
                    }
                    ++i;
                }
            } else {
                app.run(file.getAbsolutePath());
            }
        }
    }
}

