/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IDataExtractionTask;
import org.eclipse.birt.report.engine.api.IDataIterator;
import org.eclipse.birt.report.engine.api.IExtractionResults;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IResultMetaData;
import org.eclipse.birt.report.engine.api.IResultSetItem;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.TableHandle;

public class DataExtractionTaskTest
extends EngineCase {
    static final String REPORT_DESIGN_RESOURCE = "org/eclipse/birt/report/engine/api/impl/TestDataExtractionTask.xml";
    IReportDocument document;
    IDataExtractionTask dataExTask;

    public void setUp() throws Exception {
        super.setUp();
        this.removeFile("reportdocument");
        this.removeFile("design.rptdesign");
        this.copyResource(REPORT_DESIGN_RESOURCE, "design.rptdesign");
        this.createReportDocument();
        this.document = this.engine.openReportDocument("reportdocument");
        this.dataExTask = this.engine.createDataExtractionTask(this.document);
    }

    public void tearDown() {
        this.dataExTask.close();
        this.document.close();
        this.removeFile("design.rptdesign");
        this.removeFile("reportdocument");
    }

    public void testExtractionFromInstanceId() throws Exception {
        Set<InstanceID> instanceIds = this.getAllInstanceIds(this.document);
        for (InstanceID iid : instanceIds) {
            long designId = iid.getComponentID();
            IReportRunnable runnable = this.document.getReportRunnable();
            ReportDesignHandle report = (ReportDesignHandle)runnable.getDesignHandle();
            DesignElementHandle element = report.getElementByID(designId);
            if (!(element instanceof TableHandle)) continue;
            this.dataExTask.setInstanceID(iid);
            ArrayList resultSetList = (ArrayList)this.dataExTask.getResultSetList();
            DataExtractionTaskTest.assertEquals((int)1, (int)resultSetList.size());
            IExtractionResults results = this.dataExTask.extract();
            int rowCount = this.checkExtractionResults(results);
            DataExtractionTaskTest.assertTrue((rowCount > 0 ? 1 : 0) != 0);
        }
    }

    public void testExtractionFromInstanceIdWithFilter() throws Exception {
        Set<InstanceID> instanceIds = this.getAllInstanceIds(this.document);
        for (InstanceID iid : instanceIds) {
            long designId = iid.getComponentID();
            IReportRunnable runnable = this.document.getReportRunnable();
            ReportDesignHandle report = (ReportDesignHandle)runnable.getDesignHandle();
            DesignElementHandle element = report.getElementByID(designId);
            if (element instanceof TableHandle) {
                if (iid.getComponentID() != 280L) continue;
                this.dataExTask.setInstanceID(iid);
                ArrayList resultSetList = (ArrayList)this.dataExTask.getResultSetList();
                DataExtractionTaskTest.assertEquals((int)1, (int)resultSetList.size());
                IFilterDefinition[] FilterExpression = new IFilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row[\"CUSTOMERNUMBER_1\"]", 1, "\"SubQuery_Name: 128\""))};
                this.dataExTask.setFilters(FilterExpression);
                IExtractionResults results = this.dataExTask.extract();
                int rowCount = this.checkExtractionResults(results);
                DataExtractionTaskTest.assertTrue((rowCount == 1 ? 1 : 0) != 0);
                continue;
            }
            if (!(element instanceof ListHandle) || iid.getComponentID() != 277L) continue;
            this.dataExTask.setInstanceID(iid);
            this.doTestExtractionTaskWithFilters(1);
        }
    }

    public void testDataExtractionFromRsetName() throws Exception {
        ArrayList resultSetList = (ArrayList)this.dataExTask.getResultSetList();
        DataExtractionTaskTest.assertEquals((String)"Result set number error", (int)4, (int)resultSetList.size());
        IResultSetItem resultItem1 = (IResultSetItem)resultSetList.get(0);
        IResultSetItem resultItem2 = (IResultSetItem)resultSetList.get(1);
        IResultSetItem resultItem = resultItem1;
        if (!resultItem.getResultSetName().equalsIgnoreCase("ELEMENT_219")) {
            resultItem = resultItem2;
        }
        String dispName = resultItem.getResultSetName();
        DataExtractionTaskTest.assertEquals((String)"ELEMENT_219", (String)dispName);
        IResultMetaData resultMeta = resultItem.getResultMetaData();
        DataExtractionTaskTest.assertEquals((int)5, (int)resultMeta.getColumnCount());
        this.dataExTask.selectResultSet(dispName);
        IExtractionResults results = this.dataExTask.extract();
        int rowCount = this.checkExtractionResults(results);
        DataExtractionTaskTest.assertTrue((rowCount > 0 ? 1 : 0) != 0);
        DataExtractionTaskTest.assertEquals((int)7, (int)rowCount);
        resultItem = resultItem1;
        if (!resultItem.getResultSetName().equalsIgnoreCase("ELEMENT_277")) {
            resultItem = resultItem2;
        }
        dispName = resultItem.getResultSetName();
        DataExtractionTaskTest.assertEquals((String)"ELEMENT_277", (String)dispName);
        resultMeta = resultItem.getResultMetaData();
        DataExtractionTaskTest.assertEquals((int)2, (int)resultMeta.getColumnCount());
        this.dataExTask.selectResultSet(dispName);
        results = this.dataExTask.extract();
        rowCount = this.checkExtractionResults(results);
        DataExtractionTaskTest.assertEquals((int)122, (int)rowCount);
    }

    public void testExtractionWithFilters() throws Exception {
        this.dataExTask.selectResultSet("ELEMENT_277");
        this.doTestExtractionTaskWithFilters(4);
    }

    public void testExtractionWithDistinct() throws Exception {
        this.dataExTask.selectResultSet("ELEMENT_339");
        this.dataExTask.setDistinctValuesOnly(true);
        this.dataExTask.selectColumns(new String[]{"COUNTRY"});
        IExtractionResults results = this.dataExTask.extract();
        IDataIterator itr = results.nextResultIterator();
        HashSet<Object> set = new HashSet<Object>();
        while (itr.next()) {
            Object value = itr.getValue(0);
            if (set.contains(value)) {
                DataExtractionTaskTest.fail((String)"fail test on DataExtraction's distinct");
                continue;
            }
            set.add(value);
        }
    }

    public void testDataExtractionWithSorts() throws Exception {
        IDataIterator iData;
        this.dataExTask.selectResultSet("ELEMENT_277");
        SortDefinition sort = new SortDefinition();
        sort.setColumn("CUSTOMERNUMBER");
        sort.setSortDirection(1);
        this.dataExTask.setSorts(new ISortDefinition[]{sort});
        IExtractionResults result = this.dataExTask.extract();
        int previous = 0;
        int current = 0;
        if (result != null && (iData = result.nextResultIterator()) != null) {
            while (iData.next()) {
                current = (Integer)iData.getValue("CUSTOMERNUMBER");
                if (previous != 0) {
                    DataExtractionTaskTest.assertTrue((previous >= current ? 1 : 0) != 0);
                }
                previous = current;
            }
        }
    }

    public void testDataExtractionWithSelectedColumns() throws Exception {
        this.dataExTask.selectResultSet("ELEMENT_219");
        String[] columnNames = new String[]{"OFFICECODE", "CITY"};
        this.dataExTask.selectColumns(columnNames);
        IExtractionResults result = this.dataExTask.extract();
        IResultMetaData metaData = result.getResultMetaData();
        int count = metaData.getColumnCount();
        DataExtractionTaskTest.assertEquals((int)2, (int)count);
        String columnName = metaData.getColumnName(0);
        DataExtractionTaskTest.assertEquals((String)"OFFICECODE", (String)columnName);
        columnName = metaData.getColumnName(1);
        DataExtractionTaskTest.assertEquals((String)"CITY", (String)columnName);
    }

    public void testFilters() throws BirtException {
        this.dataExTask.selectResultSet("ELEMENT_219");
        this.testFilter("OFFICECODE", 7, "1", "4", "OFFICECODE", new String[]{"1", "2", "3", "4"});
        this.testFilter("OFFICECODE", 15, (Object)"2", new String[]{"1", "2"});
        this.testFilter("OFFICECODE", 17, (Object)"30", new String[]{"1", "2"});
        this.testFilter("CITY", 1, (Object)"\"Boston\"", new String[]{"Boston"});
        this.testNoOperandFilter("row[\"OFFICECODE\"] != 7", 12, "OFFICECODE", new String[]{"7"});
        this.testFilter("OFFICECODE", 5, (Object)"6", new String[]{"6", "7"});
        this.testFilter("OFFICECODE", 6, (Object)"6", "7");
        this.testFilter("OFFICECODE", 22, (Object)new String[]{"1", "3"}, new String[]{"1", "3"});
        this.testFilter("OFFICECODE", 4, (Object)"2", new String[]{"1", "2"});
        this.testFilter("OFFICECODE", 3, (Object)"2", "1");
        this.testFilter("CITY", 13, (Object)"\"S%\"", new String[]{"San Francisco", "Sydney"});
        this.testFilter("CITY", 19, (Object)"\"S+\"", new String[]{"San Francisco", "Sydney"});
        this.testFilter("OFFICECODE", 2, (Object)"7", new String[]{"1", "2", "3", "4", "5", "6"});
        this.testFilter("OFFICECODE", 8, (Object)new String[]{"2", "6"}, new String[]{"1", "7"});
        this.testFilter("OFFICECODE", 23, (Object)new String[]{"2", "6"}, new String[]{"1", "3", "4", "5", "7"});
        this.testFilter("CITY", 20, (Object)"\"S%\"", new String[]{"Boston", "NYC", "Paris", "Tokyo", "London"});
        this.testFilter("CITY", 21, (Object)"\"S+\"", new String[]{"Boston", "NYC", "Paris", "Tokyo", "London"});
        this.testFilter("STATE", 10, null, new String[]{"CA", "MA", "NY", "Chiyoda-Ku"});
        this.testFilter("STATE", 9, null, "OFFICECODE", new String[]{"4", "6", "7"});
        this.testFilter("OFFICECODE", 14, (Object)"2", new String[]{"6", "7"});
        this.testFilter("OFFICECODE", 16, (Object)"30", new String[]{"6", "7"});
        this.testNoOperandFilter("row[\"OFFICECODE\"] != 7", 11, "OFFICECODE", new String[]{"1", "2", "3", "4", "5", "6"});
    }

    private void testNoOperandFilter(String expression, int operator, String expectedColumn, String[] expectedResult) throws EngineException, BirtException {
        IFilterDefinition[] simpleFilterExpression = this.createFilter(expression, operator);
        this.testFilterCondition(simpleFilterExpression, expectedColumn, expectedResult);
    }

    private void testFilter(String columnName, int operator, Object operand1, String expectedResult) throws EngineException, BirtException {
        this.testFilter(columnName, operator, operand1, new String[]{expectedResult});
    }

    private void testFilter(String columnName, int operator, Object operand1, String[] expectedResult) throws EngineException, BirtException {
        this.testFilter(columnName, operator, operand1, null, columnName, expectedResult);
    }

    private void testFilter(String columnName, int operator, Object operand1, String expectedColumn, String[] expectedResult) throws EngineException, BirtException {
        this.testFilter(columnName, operator, operand1, null, expectedColumn, expectedResult);
    }

    private void testFilter(String columnName, int operator, Object operand1, Object operand2, String expectedColumn, String[] expectedResult) throws EngineException, BirtException {
        IFilterDefinition[] simpleFilterExpression = this.createFilter(columnName, operator, operand1, operand2);
        this.testFilterCondition(simpleFilterExpression, expectedColumn, expectedResult);
    }

    private void testFilterCondition(IFilterDefinition[] simpleFilterExpression, String expectedColumn, String[] expectedResult) throws EngineException, BirtException {
        this.dataExTask.setFilters(simpleFilterExpression);
        IExtractionResults results = this.dataExTask.extract();
        IDataIterator iterator = results.nextResultIterator();
        ArrayList<String> actualResults = new ArrayList<String>();
        while (iterator.next()) {
            actualResults.add(iterator.getValue(expectedColumn).toString());
        }
        iterator.close();
        DataExtractionTaskTest.assertEquals((int)expectedResult.length, (int)actualResults.size());
        int i = 0;
        while (i < expectedResult.length) {
            DataExtractionTaskTest.assertEquals((String)expectedResult[i], (String)((String)actualResults.get(i)));
            ++i;
        }
    }

    private void doTestExtractionTaskWithFilters(int resultSetCount) throws EngineException, BirtException {
        IDataIterator iData;
        ArrayList resultSetList = (ArrayList)this.dataExTask.getResultSetList();
        DataExtractionTaskTest.assertEquals((int)resultSetCount, (int)resultSetList.size());
        IFilterDefinition[] FilterExpression = new IFilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row[\"CUSTOMERNUMBER\"]", 5, "201", null)), new FilterDefinition((IBaseExpression)new ConditionalExpression("row[\"CUSTOMERNUMBER\"]", 3, "300", null))};
        this.dataExTask.setFilters(FilterExpression);
        IExtractionResults result = this.dataExTask.extract();
        String value = null;
        if (result != null && (iData = result.nextResultIterator()) != null) {
            iData.next();
            try {
                value = (String)DataTypeUtil.convert((Object)iData.getValue("CUSTOMERNUMBER"), (int)5);
            }
            catch (Exception exception) {
                value = null;
            }
            DataExtractionTaskTest.assertEquals((String)"201", (String)value);
            while (iData.next()) {
                try {
                    value = (String)DataTypeUtil.convert((Object)iData.getValue("CUSTOMERNUMBER"), (int)5);
                }
                catch (Exception exception) {
                    value = null;
                }
            }
        }
        DataExtractionTaskTest.assertEquals((String)"299", value);
    }

    protected int checkExtractionResults(IExtractionResults results) throws Exception {
        int rowCount = 0;
        IDataIterator dataIter = results.nextResultIterator();
        if (dataIter != null) {
            while (dataIter.next()) {
                IResultMetaData resultMeta = dataIter.getResultMetaData();
                int i = 0;
                while (i < resultMeta.getColumnCount()) {
                    dataIter.getValue(resultMeta.getColumnName(i));
                    String type = resultMeta.getColumnTypeName(i);
                    DataExtractionTaskTest.assertTrue((type != null ? 1 : 0) != 0);
                    ++i;
                }
                ++rowCount;
            }
            dataIter.close();
        }
        results.close();
        return rowCount;
    }

    private Set<InstanceID> getAllInstanceIds(IReportDocument document) throws EngineException, UnsupportedEncodingException {
        HashSet<InstanceID> instanceIds = new HashSet<InstanceID>();
        IRenderTask task = this.engine.createRenderTask(document);
        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        HTMLRenderOption option = new HTMLRenderOption();
        option.setOutputFormat("html");
        option.setOutputStream((OutputStream)ostream);
        option.setEnableMetadata(true);
        task.setRenderOption((IRenderOption)option);
        DataExtractionTaskTest.assertTrue((boolean)task.getRenderOption().equals(option));
        task.render();
        task.close();
        String content = ostream.toString("utf-8");
        Pattern iidPattern = Pattern.compile("iid=\"([^\"]*)\"");
        Matcher matcher = iidPattern.matcher(content);
        while (matcher.find()) {
            String strIid = matcher.group(1);
            InstanceID iid = InstanceID.parse((String)strIid);
            instanceIds.add(iid);
        }
        return instanceIds;
    }

    private IFilterDefinition[] createFilter(String columnName, int operator, Object operand) {
        return this.createFilter(columnName, operator, operand, null);
    }

    private IFilterDefinition[] createFilter(String expression, int operator) {
        ConditionalExpression conditionalExpression = new ConditionalExpression(expression, operator);
        return new IFilterDefinition[]{new FilterDefinition((IBaseExpression)conditionalExpression)};
    }

    private IFilterDefinition[] createFilter(String columnName, int operator, Object operand1, Object operand2) {
        ConditionalExpression conditionalExpression = null;
        if (!(operand1 instanceof String[])) {
            conditionalExpression = new ConditionalExpression("row[\"" + columnName + "\"]", operator, (String)operand1, (String)operand2);
        } else {
            List<String> operand = Arrays.asList((String[])operand1);
            conditionalExpression = new ConditionalExpression("row[\"" + columnName + "\"]", operator, operand);
        }
        return new IFilterDefinition[]{new FilterDefinition((IBaseExpression)conditionalExpression)};
    }
}

