/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import com.ibm.icu.util.ULocale;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IDataIterator;
import org.eclipse.birt.report.engine.api.IDatasetPreviewTask;
import org.eclipse.birt.report.engine.api.IExtractionResults;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IResultMetaData;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.SessionHandle;

public class DatasetPreviewTaskTest
extends EngineCase {
    static final String REPORT_DESIGN_RESOURCE = "org/eclipse/birt/report/engine/api/impl/TestDataExtractionTask.xml";
    static final String REPORT_LIBRARY_RESOURCE = "org/eclipse/birt/report/engine/api/impl/library.xml";
    IReportDocument document;
    IDatasetPreviewTask previewTask;

    public void setUp() throws Exception {
        super.setUp();
        this.removeFile("design.rptdesign");
    }

    public void tearDown() {
    }

    protected ModuleHandle getHandle(String fileName) throws Exception {
        SessionHandle sessionHandle = new DesignEngine(new DesignConfig()).newSessionHandle(ULocale.getDefault());
        ModuleHandle designHandle = sessionHandle.openModule(fileName);
        return designHandle;
    }

    public void testPreviewDatasetInLib() throws Exception {
        this.copyResource(REPORT_LIBRARY_RESOURCE, "design.rptdesign");
        this.previewTask = this.engine.createDatasetPreviewTask();
        ModuleHandle muduleHandle = this.getHandle("design.rptdesign");
        List ds = muduleHandle.getAllDataSets();
        for (Object obj : ds) {
            DataSetHandle dataset = (DataSetHandle)obj;
            if (!dataset.getName().equals("Data Set")) continue;
            this.previewTask.setDataSet(dataset);
        }
        this.previewTask.setMaxRow(20);
        IExtractionResults results = this.previewTask.execute();
        int rowCount = this.checkExtractionResults(results);
        DatasetPreviewTaskTest.assertTrue((rowCount == 20 ? 1 : 0) != 0);
        this.previewTask.close();
        this.removeFile("design.rptdesign");
    }

    public void testPreviewDatasetInReport() throws Exception {
        this.copyResource(REPORT_DESIGN_RESOURCE, "design.rptdesign");
        this.previewTask = this.engine.createDatasetPreviewTask();
        IReportRunnable reportDesign = this.engine.openReportDesign("design.rptdesign");
        List ds = reportDesign.getDesignHandle().getModuleHandle().getAllDataSets();
        for (Object obj : ds) {
            DataSetHandle dataset = (DataSetHandle)obj;
            if (!dataset.getName().equals("DataSet")) continue;
            this.previewTask.setDataSet(dataset);
        }
        this.previewTask.setMaxRow(5);
        IExtractionResults results = this.previewTask.execute();
        int rowCount = this.checkExtractionResults(results);
        DatasetPreviewTaskTest.assertTrue((rowCount == 5 ? 1 : 0) != 0);
        this.previewTask.close();
        this.removeFile("design.rptdesign");
    }

    protected int checkExtractionResults(IExtractionResults results) throws Exception {
        int rowCount = 0;
        IDataIterator dataIter = results.nextResultIterator();
        if (dataIter != null) {
            while (dataIter.next()) {
                IResultMetaData resultMeta = dataIter.getResultMetaData();
                int i = 0;
                while (i < resultMeta.getColumnCount()) {
                    Object obj = dataIter.getValue(resultMeta.getColumnName(i));
                    String type = resultMeta.getColumnTypeName(i);
                    DatasetPreviewTaskTest.assertTrue((type != null ? 1 : 0) != 0);
                    System.out.print(obj + " ");
                    ++i;
                }
                ++rowCount;
                System.out.println();
            }
            dataIter.close();
        }
        results.close();
        return rowCount;
    }

    private Set<InstanceID> getAllInstanceIds(IReportDocument document) throws EngineException, UnsupportedEncodingException {
        HashSet<InstanceID> instanceIds = new HashSet<InstanceID>();
        IRenderTask task = this.engine.createRenderTask(document);
        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        HTMLRenderOption option = new HTMLRenderOption();
        option.setOutputFormat("html");
        option.setOutputStream((OutputStream)ostream);
        option.setEnableMetadata(true);
        task.setRenderOption((IRenderOption)option);
        DatasetPreviewTaskTest.assertTrue((boolean)task.getRenderOption().equals(option));
        task.render();
        task.close();
        String content = ostream.toString("utf-8");
        Pattern iidPattern = Pattern.compile("iid=\"([^\"]*)\"");
        Matcher matcher = iidPattern.matcher(content);
        while (matcher.find()) {
            String strIid = matcher.group(1);
            InstanceID iid = InstanceID.parse((String)strIid);
            instanceIds.add(iid);
        }
        return instanceIds;
    }
}

