/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.IDataExtractionTask;
import org.eclipse.birt.report.engine.api.IExtractionOption;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.dataextraction.CSVDataExtractionOption;

public class DateFormatterTest
extends EngineCase {
    static final String REPORT_DESIGN_RESOURCE = "org/eclipse/birt/report/engine/api/impl/date_formatter.xml";
    IReportDocument document;
    IDataExtractionTask dataExTask;

    public void setUp() throws Exception {
        super.setUp();
        this.removeFile("reportdocument");
        this.removeFile("design.rptdesign");
        this.copyResource(REPORT_DESIGN_RESOURCE, "design.rptdesign");
        this.createReportDocument();
        this.document = this.engine.openReportDocument("reportdocument");
        this.dataExTask = this.engine.createDataExtractionTask(this.document);
    }

    public void tearDown() {
        this.dataExTask.close();
        this.document.close();
        this.removeFile("design.rptdesign");
        this.removeFile("reportdocument");
    }

    public void testDateFormatterExtraction() throws Exception {
        this.dataExTask.selectResultSet("ELEMENT_69");
        String[] columnNames = new String[]{"CUSTOMERNUMBER", "CHECKNUMBER", "PAYMENTDATE", "now", "now"};
        this.dataExTask.setTimeZone(TimeZone.getTimeZone((String)"GMT+8"));
        this.dataExTask.selectColumns(columnNames);
        this.dataExTask.setLocale(ULocale.CHINESE);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        CSVDataExtractionOption option = new CSVDataExtractionOption();
        option.setTimeZone(java.util.TimeZone.getTimeZone("GMT+5"));
        option.setLocale(Locale.ENGLISH);
        option.setOutputFormat("csv");
        option.setOutputStream((OutputStream)out);
        HashMap<Object, String> formatters = new HashMap<Object, String>();
        formatters.put(1, "Fixed");
        formatters.put(2, "<");
        formatters.put(3, "yyyy-MM-dd");
        formatters.put("now", "yyyy-MM-dd HH:mm:ss.sss ZZZ");
        formatters.put(5, "Long Date");
        option.setFormatter(formatters);
        this.dataExTask.extract((IExtractionOption)option);
        String result = new String(out.toByteArray());
        System.out.println(result);
    }
}

