/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.impl.PageSequenceParse;

public class PageSequenceParseTest
extends TestCase {
    public void testIncorrectPageNumberRange() {
        boolean exceptionFlag = false;
        try {
            PageSequenceParse.parsePageSequence((String)"20-25", (long)15L);
        }
        catch (EngineException engineException) {
            exceptionFlag = true;
        }
        assert (exceptionFlag);
        exceptionFlag = false;
        try {
            PageSequenceParse.parsePageSequence((String)"12-10", (long)15L);
        }
        catch (EngineException engineException) {
            exceptionFlag = true;
        }
        assert (exceptionFlag);
        exceptionFlag = false;
        try {
            PageSequenceParse.parsePageSequence((String)"10-", (long)15L);
        }
        catch (EngineException engineException) {
            exceptionFlag = true;
        }
        assert (exceptionFlag);
        exceptionFlag = false;
        try {
            PageSequenceParse.parsePageSequence((String)"16", (long)15L);
        }
        catch (EngineException engineException) {
            exceptionFlag = true;
        }
        assert (exceptionFlag);
    }

    public void testCorrectPageNumberRange() {
        block10: {
            try {
                List pageRangeList = PageSequenceParse.parsePageSequence((String)"13-15,3,8-11", (long)15L);
                assert (pageRangeList != null);
                assert (3 == pageRangeList.size());
                long[] pageRange = (long[])pageRangeList.get(0);
                assert (3L == pageRange[0]);
                assert (3L == pageRange[1]);
                pageRange = (long[])pageRangeList.get(1);
                assert (8L == pageRange[0]);
                assert (11L == pageRange[1]);
                pageRange = (long[])pageRangeList.get(2);
                assert (13L == pageRange[0]);
                assert (15L == pageRange[1]);
            }
            catch (EngineException engineException) {
                if ($assertionsDisabled) break block10;
                throw new AssertionError();
            }
        }
    }
}

