/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.iv;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.archive.compound.ArchiveReader;
import org.eclipse.birt.core.archive.compound.ArchiveWriter;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.RunnableMonitor;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.ReportEngine;

public class IVTest
extends EngineCase {
    static final String REPORT_DESIGN_RESOURCE = "org/eclipse/birt/report/engine/api/iv/IV_SalesByProducts.rptdesign";
    static final String REPORT_DESIGN_WITH_PARAM_RESOURCE = "org/eclipse/birt/report/engine/api/iv/IV_ReportWithParam.rptdesign";
    static final String TEST_FOLDER = "./utest/";
    static final String REPORT_DESIGN = "./utest/design.rptdesign";
    static final String REPORT_DOCUMENT = "./utest/reportdocument.rptdocument";
    IReportEngine engine;
    static final String REPORT_DESIGN_NO_FILTER_RESOURCE = "org/eclipse/birt/report/engine/api/iv/IV_DesignNoFilter.rptdesign";
    static final String REPORT_DESIGN_WITH_FILTER_RESOURCE = "org/eclipse/birt/report/engine/api/iv/IV_DesignWithFilter.rptdesign";
    static final String REPORT_DESIGN_WITHOUT_CC_RESOURCE = "org/eclipse/birt/report/engine/api/iv/IV_DesignWithoutCC.rptdesign";
    static final String REPORT_DESIGN_WITH_CC_RESOURCE = "org/eclipse/birt/report/engine/api/iv/IV_DesignWithCC.rptdesign";

    public void setUp() {
        this.removeFile(TEST_FOLDER);
        EngineConfig config = new EngineConfig();
        this.engine = new ReportEngine(config);
    }

    public void tearDown() {
        this.engine.destroy();
        this.removeFile(TEST_FOLDER);
    }

    protected void createIVReportDocument() throws Exception {
        this.createReportDocument(new HashMap());
    }

    protected void createReportDocument(Map paramValues) throws Exception {
        IReportRunnable report = this.engine.openReportDesign(REPORT_DESIGN);
        IRunTask task = this.engine.createRunTask(report);
        try {
            task.setParameterValues(paramValues);
            task.run(REPORT_DOCUMENT);
        }
        finally {
            task.close();
        }
    }

    public void testMutipleRun() throws Exception {
        this.copyResource(REPORT_DESIGN_RESOURCE, REPORT_DESIGN);
        this.createIVReportDocument();
        RunnableMonitor monitor = new RunnableMonitor();
        int i = 0;
        while (i < 8) {
            new IVRunnable(this.engine, monitor);
            ++i;
        }
        monitor.start();
        monitor.printStackTrace();
        IVTest.assertTrue((boolean)monitor.getFailedRunnables().isEmpty());
    }

    public void testRun() throws Exception {
        this.copyResource(REPORT_DESIGN_RESOURCE, REPORT_DESIGN);
        this.createIVReportDocument();
        new IVTask(this.engine, REPORT_DOCUMENT).run();
    }

    public void testRunWithParamters() throws Exception {
        this.copyResource(REPORT_DESIGN_WITH_PARAM_RESOURCE, REPORT_DESIGN);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("param", new Integer(100));
        this.createReportDocument(params);
        new IVTask(this.engine, REPORT_DOCUMENT).run();
    }

    public void testFilters() throws Exception {
        this.doTestIV(REPORT_DESIGN_NO_FILTER_RESOURCE, REPORT_DESIGN_WITH_FILTER_RESOURCE);
    }

    protected void doTestIV(String originalDesign, String changedDesign) throws Exception {
        this.copyResource(originalDesign, REPORT_DESIGN);
        IReportRunnable report = this.engine.openReportDesign(REPORT_DESIGN);
        IRunTask task = this.engine.createRunTask(report);
        task.run(REPORT_DOCUMENT);
        task.close();
        this.copyResource(changedDesign, REPORT_DESIGN);
        report = this.engine.openReportDesign(REPORT_DESIGN);
        task = this.engine.createRunTask(report);
        ArchiveFile archive = new ArchiveFile(REPORT_DOCUMENT, "rw+");
        task.setDataSource((IDocArchiveReader)new ArchiveReader((IArchiveFile)archive));
        task.run((IDocArchiveWriter)new ArchiveWriter((IArchiveFile)archive));
        task.close();
        archive.close();
        IReportDocument doc = this.engine.openReportDocument(REPORT_DOCUMENT);
        long pageCount = doc.getPageCount();
        int i = 1;
        while ((long)i <= pageCount) {
            IRenderTask renderTask = this.engine.createRenderTask(doc);
            HTMLRenderOption option = new HTMLRenderOption();
            option.setOutputFormat("html");
            option.setOutputFileName("./utest/output" + i + ".html");
            renderTask.setRenderOption((IRenderOption)option);
            renderTask.setPageNumber((long)i);
            renderTask.render();
            List errors = renderTask.getErrors();
            IVTest.assertEquals((int)0, (int)errors.size());
            renderTask.close();
            ++i;
        }
        doc.close();
    }

    private static class IVRunnable
    extends RunnableMonitor.Runnable {
        static int TOTAL_THREAD = 0;
        int threadNumber = TOTAL_THREAD++;
        IReportEngine engine;

        IVRunnable(IReportEngine engine, RunnableMonitor monitor) {
            super(monitor);
            this.engine = engine;
        }

        @Override
        public void doRun() throws Exception {
            new IVTask(this.engine, IVTest.REPORT_DOCUMENT + this.threadNumber).run();
        }
    }

    private static class IVTask {
        IReportEngine engine;
        String fileName;

        IVTask(IReportEngine engine, String fileName) {
            this.engine = engine;
            if (fileName == null) {
                fileName = IVTest.REPORT_DOCUMENT;
            }
            this.fileName = fileName;
        }

        public void run() throws Exception {
            ArchiveFile archive = null;
            if (!IVTest.REPORT_DOCUMENT.equals(this.fileName)) {
                archive = new ArchiveFile(IVTest.REPORT_DOCUMENT, "r");
                archive.saveAs(this.fileName);
                archive.close();
            }
            archive = new ArchiveFile(this.fileName, "rw+");
            ArchiveReader reader = new ArchiveReader((IArchiveFile)archive);
            IReportDocument doc = this.engine.openReportDocument(null, (IDocArchiveReader)reader, new HashMap());
            IReportRunnable report = doc.getReportRunnable();
            doc.close();
            IRunTask task = this.engine.createRunTask(report);
            task.setDataSource((IDocArchiveReader)new ArchiveReader((IArchiveFile)archive));
            task.run((IDocArchiveWriter)new ArchiveWriter((IArchiveFile)archive));
            task.close();
            doc = this.engine.openReportDocument(null, (IDocArchiveReader)reader, new HashMap());
            long pageCount = doc.getPageCount();
            int i = 1;
            while ((long)i <= pageCount) {
                IRenderTask renderTask = this.engine.createRenderTask(doc);
                HTMLRenderOption option = new HTMLRenderOption();
                option.setOutputFormat("html");
                option.setOutputStream((OutputStream)new ByteArrayOutputStream());
                renderTask.setRenderOption((IRenderOption)option);
                renderTask.setPageNumber((long)i);
                renderTask.render();
                List errors = renderTask.getErrors();
                IVTest.assertEquals((int)0, (int)errors.size());
                renderTask.close();
                ++i;
            }
            doc.close();
            archive.close();
        }
    }

    private static class RenderTask {
        IReportEngine engine;
        String fileName;

        RenderTask(IReportEngine engine, String fileName) {
            this.engine = engine;
            this.fileName = fileName;
        }

        public void run() throws Exception {
            IReportDocument doc = this.engine.openReportDocument(this.fileName);
            long pageCount = doc.getPageCount();
            int i = 1;
            while ((long)i <= pageCount) {
                IRenderTask renderTask = this.engine.createRenderTask(doc);
                HTMLRenderOption option = new HTMLRenderOption();
                option.setOutputFormat("html");
                option.setOutputStream((OutputStream)new ByteArrayOutputStream());
                renderTask.setRenderOption((IRenderOption)option);
                renderTask.setPageNumber((long)i);
                renderTask.render();
                List errors = renderTask.getErrors();
                IVTest.assertEquals((int)0, (int)errors.size());
                renderTask.close();
                ++i;
            }
            doc.close();
        }
    }
}

