/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.iv;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.compound.ArchiveReader;
import org.eclipse.birt.core.archive.compound.ArchiveView;
import org.eclipse.birt.core.archive.compound.ArchiveWriter;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.ReportEngine;

public class IVViewTest
extends EngineCase {
    static final String ORIGINAL_REPORT_DESIGN_RESOURCE = "org/eclipse/birt/report/engine/api/iv/originalReport.rptdesign";
    static final String ORIGINAL_REPORT_DESIGN = "originalReport.rptdesign";
    static final String CHANGED_REPORT_DESIGN_RESOURCE = "org/eclipse/birt/report/engine/api/iv/changedReport.rptdesign";
    static final String CHANGED_REPORT_DESIGN = "changedReport.rptdesign";
    static final String ORIGINAL_REPORT_DOCUMENT = "originalReport.rptdocument";
    static final String CHANGED_REPORT_DOCUMENT = "changedReport.rptdocument";
    static final String ARCHIVE_VIEW_DOCUMENT = "archiveView.rptdocument";
    IReportEngine engine;

    public void setUp() {
        this.removeFile(ORIGINAL_REPORT_DESIGN);
        this.removeFile(CHANGED_REPORT_DESIGN);
        EngineConfig config = new EngineConfig();
        this.engine = new ReportEngine(config);
    }

    public void tearDown() {
        this.removeFile(ORIGINAL_REPORT_DESIGN);
        this.removeFile(CHANGED_REPORT_DESIGN);
        this.engine.destroy();
    }

    public void testRunWithArchiveView() throws Exception {
        this.copyResource(ORIGINAL_REPORT_DESIGN_RESOURCE, ORIGINAL_REPORT_DESIGN);
        IReportRunnable report = this.engine.openReportDesign(ORIGINAL_REPORT_DESIGN);
        IRunTask task = this.engine.createRunTask(report);
        try {
            task.run(ORIGINAL_REPORT_DOCUMENT);
        }
        finally {
            task.close();
        }
        this.copyResource(CHANGED_REPORT_DESIGN_RESOURCE, CHANGED_REPORT_DESIGN);
        ArchiveView view = new ArchiveView(ARCHIVE_VIEW_DOCUMENT, ORIGINAL_REPORT_DOCUMENT, "rw");
        try {
            report = this.engine.openReportDesign(CHANGED_REPORT_DESIGN);
            task = this.engine.createRunTask(report);
            try {
                ArchiveWriter writer = new ArchiveWriter((IArchiveFile)view);
                task.setDataSource((IDocArchiveReader)new ArchiveReader((IArchiveFile)view));
                task.run((IDocArchiveWriter)writer);
            }
            finally {
                task.close();
            }
            report = this.engine.openReportDesign(CHANGED_REPORT_DESIGN);
            task = this.engine.createRunTask(report);
            try {
                task.run(CHANGED_REPORT_DOCUMENT);
            }
            finally {
                task.close();
            }
            IReportDocument goldenDocument = this.engine.openReportDocument(CHANGED_REPORT_DOCUMENT);
            try {
                IReportDocument ivDocument = this.engine.openReportDocument(null, (IDocArchiveReader)new ArchiveReader((IArchiveFile)view), new HashMap());
                try {
                    this.compare(goldenDocument, ivDocument);
                }
                finally {
                    ivDocument.close();
                }
            }
            finally {
                goldenDocument.close();
            }
        }
        finally {
            view.close();
        }
    }

    protected void compare(IReportDocument src, IReportDocument tgt) throws Exception {
        IVViewTest.assertTrue((src.getPageCount() == tgt.getPageCount() ? 1 : 0) != 0);
        long pageCount = src.getPageCount();
        long index = 1L;
        while (index <= pageCount) {
            String golden = this.renderPage(src, index);
            String target = this.renderPage(tgt, index);
            IVViewTest.assertEquals((String)golden, (String)target);
            ++index;
        }
    }

    protected String renderPage(IReportDocument doc, long pageNo) throws Exception {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        IVViewTest.assertTrue((pageNo <= doc.getPageCount() ? 1 : 0) != 0);
        IRenderTask renderTask = this.engine.createRenderTask(doc);
        try {
            HTMLRenderOption options = new HTMLRenderOption();
            options.setOutputFormat("html");
            options.setOutputStream((OutputStream)buffer);
            renderTask.setRenderOption((IRenderOption)options);
            renderTask.setPageNumber(pageNo);
            renderTask.render();
            List errors = renderTask.getErrors();
            IVViewTest.assertEquals((int)0, (int)errors.size());
        }
        finally {
            renderTask.close();
        }
        return new String(buffer.toString("UTF-8"));
    }
}

