/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.script;

import java.math.BigDecimal;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.report.engine.api.DataSetID;
import org.eclipse.birt.report.engine.api.script.IRowData;
import org.eclipse.birt.report.engine.api.script.ScriptException;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.script.internal.RowData;
import org.mozilla.javascript.Scriptable;

public class RowDataTest
extends TestCase {
    private Map testExpressions;
    private IRowData rowData;

    protected void setUp() {
        this.testExpressions = new HashMap();
        this.testExpressions.put("row[9999]", "1");
        this.testExpressions.put("row[\"test\"]", "2");
        this.testExpressions.put("test", "3");
        this.testExpressions.put("row[\"test1\"]", "4");
        this.testExpressions.put("ROW[\"test\"]", "5");
        this.testExpressions.put("ROw[\"test\"]", "6");
        this.testExpressions.put("row[\"test_1\"]", "7");
        this.testExpressions.put("row[\"test\"] + test", "8");
        this.testExpressions.put("row[\"test\"] + row[\"testit\"]", "9");
        FakeResultIteratorTest iterator = new FakeResultIteratorTest(this.testExpressions);
        FakeResultSetTest rset = new FakeResultSetTest(iterator);
        ArrayList expressions = new ArrayList();
        expressions.addAll(this.testExpressions.keySet());
        this.rowData = new RowData((IBaseResultSet)rset, null);
    }

    public void testIndex() throws ScriptException {
    }

    public void testWithQuotes() throws ScriptException {
    }

    public void testWithoutQuotes() throws ScriptException {
    }

    public void testWithoutRow() throws ScriptException {
        RowDataTest.assertEquals((Object)"3", (Object)this.rowData.getColumnValue("test"));
    }

    public void testWithNumber() throws ScriptException {
    }

    public void testWithCapital() throws ScriptException {
    }

    public void testWithMixed() throws ScriptException {
    }

    public void testWithUnderscore() throws ScriptException {
    }

    public void testWithMultipleParts1() throws ScriptException {
    }

    public void testWithMultipleParts2() throws ScriptException {
    }

    private class FakeResultIteratorTest
    implements IResultIterator {
        private Map expressions;

        public FakeResultIteratorTest(Map expressions) {
            this.expressions = expressions;
        }

        public IQueryResults getQueryResults() {
            return null;
        }

        public Scriptable getScope() {
            return null;
        }

        public IResultMetaData getResultMetaData() throws BirtException {
            return null;
        }

        public boolean next() throws BirtException {
            return false;
        }

        public Boolean getBoolean(IBaseExpression dataExpr) throws BirtException {
            return null;
        }

        public Integer getInteger(IBaseExpression dataExpr) throws BirtException {
            return null;
        }

        public Double getDouble(IBaseExpression dataExpr) throws BirtException {
            return null;
        }

        public String getString(IBaseExpression dataExpr) throws BirtException {
            return null;
        }

        public BigDecimal getBigDecimal(IBaseExpression dataExpr) throws BirtException {
            return null;
        }

        public Date getDate(IBaseExpression dataExpr) throws BirtException {
            return null;
        }

        public Blob getBlob(IBaseExpression dataExpr) throws BirtException {
            return null;
        }

        public byte[] getBytes(IBaseExpression dataExpr) throws BirtException {
            return null;
        }

        public void skipToEnd(int groupLevel) throws BirtException {
        }

        public int getStartingGroupLevel() throws BirtException {
            return 0;
        }

        public int getEndingGroupLevel() throws BirtException {
            return 0;
        }

        public IResultIterator getSecondaryIterator(String subQueryName, Scriptable scope) throws BirtException {
            return null;
        }

        public void close() throws BirtException {
        }

        public boolean findGroup(Object[] groupKeyValues) throws BirtException {
            return false;
        }

        public int getRowId() throws BirtException {
            return 0;
        }

        public int getRowIndex() throws BirtException {
            return 0;
        }

        public void moveTo(int rowIndex) throws BirtException {
        }

        public Object getValue(String name) throws BirtException {
            return this.expressions.get(name);
        }

        public Boolean getBoolean(String name) throws BirtException {
            return null;
        }

        public Integer getInteger(String name) throws BirtException {
            return null;
        }

        public Double getDouble(String name) throws BirtException {
            return null;
        }

        public String getString(String name) throws BirtException {
            return null;
        }

        public BigDecimal getBigDecimal(String name) throws BirtException {
            return null;
        }

        public Date getDate(String name) throws BirtException {
            return null;
        }

        public Blob getBlob(String name) throws BirtException {
            return null;
        }

        public byte[] getBytes(String name) throws BirtException {
            return null;
        }

        public Object getValue(IBaseExpression dataExpr) throws BirtException {
            return null;
        }

        public boolean isEmpty() throws BirtException {
            return true;
        }

        public boolean isFirst() throws BirtException {
            return false;
        }

        public boolean isBeforeFirst() throws BirtException {
            return false;
        }

        public IResultIterator getSecondaryIterator(ScriptContext scriptContext, String subQueryName) throws BirtException {
            return null;
        }
    }

    private class FakeResultSetTest
    implements IQueryResultSet {
        protected IResultIterator rs = null;

        public FakeResultSetTest(IResultIterator rs) {
            this.rs = rs;
        }

        public IBaseResultSet getParent() {
            return null;
        }

        public DataSetID getID() {
            return null;
        }

        public long getCurrentPosition() {
            return 0L;
        }

        public boolean skipTo(long rows) {
            return false;
        }

        public boolean next() {
            return false;
        }

        public int getStartingGroupLevel() {
            return 0;
        }

        public int getEndingGroupLevel() {
            return 0;
        }

        public IResultMetaData getResultMetaData() throws BirtException {
            return null;
        }

        public Object getValue(String name) throws BirtException {
            return this.rs.getValue(name);
        }

        public Boolean getBoolean(String name) throws BirtException {
            return null;
        }

        public Integer getInteger(String name) throws BirtException {
            return null;
        }

        public Double getDouble(String name) throws BirtException {
            return null;
        }

        public String getString(String name) throws BirtException {
            return null;
        }

        public BigDecimal getBigDecimal(String name) throws BirtException {
            return null;
        }

        public Date getDate(String name) throws BirtException {
            return null;
        }

        public Blob getBlob(String name) throws BirtException {
            return null;
        }

        public byte[] getBytes(String name) throws BirtException {
            return null;
        }

        public void close() {
        }

        public Object evaluate(String expr) {
            try {
                return this.rs.getValue(expr);
            }
            catch (BirtException birtException) {
                return null;
            }
        }

        public Object evaluate(String language, String expr) throws BirtException {
            try {
                return this.rs.getValue(expr);
            }
            catch (BirtException birtException) {
                return null;
            }
        }

        public Object evaluate(IBaseExpression expr) {
            return null;
        }

        public String getGroupId(int groupLevel) {
            return null;
        }

        public boolean isEmpty() throws BirtException {
            return this.rs.isEmpty();
        }

        public boolean isFirst() throws BirtException {
            return this.rs.isFirst();
        }

        public boolean isBeforeFirst() throws BirtException {
            return this.rs.isBeforeFirst();
        }

        public String getBaseRSetID() {
            return null;
        }

        public IResultIterator getResultIterator() {
            return null;
        }

        public long getRowIndex() {
            return 0L;
        }

        public void setBaseRSetID(String id) {
        }

        public IBaseQueryResults getQueryResults() {
            return null;
        }

        public String getRawID() throws BirtException {
            return null;
        }

        public int getType() {
            return 0;
        }
    }
}

