/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.css;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import junit.framework.TestCase;
import org.eclipse.birt.report.engine.css.engine.BIRTCSSEngine;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class CSSPaserTest
extends TestCase {
    CSSEngine engine = new BIRTCSSEngine();

    private String parseStyle(String cssText) {
        try {
            CSSStyleDeclaration style = this.engine.parseStyleDeclaration(cssText);
            return style.getCssText();
        }
        catch (Exception exception) {
            return "";
        }
    }

    private String parseProperty(String text) {
        int at = text.indexOf(58);
        if (at != -1) {
            String name = text.substring(0, at);
            String valueText = text.substring(at + 1).trim();
            int idx = this.engine.getPropertyIndex(name);
            if (idx != -1) {
                CSSValue value = this.engine.parsePropertyValue(idx, valueText);
                return String.valueOf(name) + ": " + value.getCssText();
            }
        }
        return "";
    }

    public void testPropertyParser() throws Exception {
        InputStream stream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/eclipse/birt/report/engine/css/css_property_test.txt");
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String input = this.readLine(reader);
        while (input != null) {
            String golden = this.readLine(reader);
            String output = this.parseProperty(input);
            CSSPaserTest.assertEquals((String)golden, (String)output);
            input = this.readLine(reader);
        }
    }

    public void testStyleParser() throws Exception {
        InputStream stream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/eclipse/birt/report/engine/css/css_style_test.txt");
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String input = this.readLine(reader);
        while (input != null) {
            String golden = this.readLine(reader);
            String output = this.parseStyle(input);
            CSSPaserTest.assertEquals((String)golden, (String)output);
            input = this.readLine(reader);
        }
    }

    protected String readLine(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        while (line != null) {
            if (line.trim().length() != 0 && !line.startsWith("#")) {
                return line.trim();
            }
            line = reader.readLine();
        }
        return null;
    }
}

