/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.ir;

import org.eclipse.birt.report.engine.ir.ActionDesign;
import org.eclipse.birt.report.engine.ir.Expression;
import org.eclipse.birt.report.engine.ir.ImageItemDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.ReportItemTestCase;

public class ImageItemTest
extends ReportItemTestCase {
    public ImageItemTest() {
        super((ReportItemDesign)new ImageItemDesign());
    }

    public void testAction() {
        ImageItemDesign image = new ImageItemDesign();
        ActionDesign action = new ActionDesign();
        image.setAction(action);
        ImageItemTest.assertEquals((Object)image.getAction(), (Object)action);
    }

    public void testAltText() {
        ImageItemDesign image = new ImageItemDesign();
        String key = "TestKey";
        String text = "AltText";
        image.setAltText((Expression)Expression.newConstant((String)text));
        image.setAltTextKey(key);
        ImageItemTest.assertEquals((Object)image.getAltText(), (Object)text);
        ImageItemTest.assertEquals((String)image.getAltTextKey(), (String)key);
    }

    public void testExpression() {
        ImageItemDesign image = new ImageItemDesign();
        Expression.Script exp = Expression.newScript((String)"exp");
        Expression.Script typeExp = Expression.newScript((String)"typeExp");
        image.setImageExpression((Expression)exp, (Expression)typeExp);
        ImageItemTest.assertEquals((int)image.getImageSource(), (int)2);
        ImageItemTest.assertEquals((Object)image.getImageFormat(), (Object)typeExp);
    }

    public void testName() {
        ImageItemDesign image = new ImageItemDesign();
        Expression.Script imageName = Expression.newScript((String)"TestImage.bmp");
        image.setImageName((Expression)imageName);
        ImageItemTest.assertEquals((Object)image.getImageName(), (Object)imageName);
        ImageItemTest.assertEquals((int)image.getImageSource(), (int)1);
    }

    public void testUri() {
        ImageItemDesign image = new ImageItemDesign();
        image.setImageUri((Expression)Expression.newConstant((String)"http://www.actuate.com/images/navimages/v8/logo.gif"));
        ImageItemTest.assertEquals((String)image.getImageUri().getScriptText(), (String)"http://www.actuate.com/images/navimages/v8/logo.gif");
        ImageItemTest.assertEquals((int)image.getImageSource(), (int)0);
        Expression.Script imageUriExpr = Expression.newScript((String)"http://www.actuate.com/images/navimages/v8/logo.gif");
        image.setImageUri((Expression)imageUriExpr);
        ImageItemTest.assertEquals((Object)image.getImageUri(), (Object)imageUriExpr);
        ImageItemTest.assertEquals((int)image.getImageSource(), (int)0);
    }
}

