/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.emitter;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.eclipse.birt.report.engine.layout.emitter.CellArea;
import org.eclipse.birt.report.engine.layout.emitter.TableBorderEx;

public class TableBorderExTest
extends TestCase {
    private CellArea[] cells = new CellArea[9];
    int tableX = 10;
    int tableY = 10;
    PdfContentByte cb;
    int pageHeight = 1000;
    int pageWidth = 1000;

    protected void setUp() throws Exception {
        super.setUp();
        this.cells[0] = new CellArea(10, 10, 40, 40);
        this.cells[0].defineBorder(0, 2);
        this.cells[0].defineBorder(0, Color.blue);
        this.cells[0].defineBorder(3, 6);
        this.cells[0].defineBorder(3, Color.orange);
        this.cells[1] = new CellArea(50, 10, 40, 40);
        this.cells[1].defineBorder(0, 4);
        this.cells[1].defineBorder(0, Color.blue);
        this.cells[2] = new CellArea(90, 10, 40, 40);
        this.cells[2].defineBorder(0, 6);
        this.cells[2].defineBorder(0, Color.blue);
        this.cells[2].defineBorder(1, 6);
        this.cells[2].defineBorder(1, Color.orange);
        this.cells[3] = new CellArea(10, 50, 40, 80);
        this.cells[3].defineBorder(3, 6);
        this.cells[3].defineBorder(3, Color.orange);
        this.cells[3].defineBorder(2, 6);
        this.cells[3].defineBorder(2, Color.blue);
        this.cells[4] = new CellArea(50, 50, 40, 40);
        this.cells[4].defineBorder(0, 2);
        this.cells[4].defineBorder(0, Color.green);
        this.cells[5] = new CellArea(90, 50, 40, 40);
        this.cells[5].defineBorder(3, 0);
        this.cells[5].defineBorder(0, 0);
        this.cells[5].defineBorder(1, 6);
        this.cells[5].defineBorder(1, Color.orange);
        this.cells[6] = null;
        this.cells[7] = new CellArea(50, 90, 40, 40);
        this.cells[7].defineBorder(2, 4);
        this.cells[7].defineBorder(2, Color.blue);
        this.cells[8] = new CellArea(90, 90, 40, 40);
        this.cells[8].defineBorder(0, 0);
        this.cells[8].defineBorder(3, 2);
        this.cells[8].defineBorder(3, Color.red);
        this.cells[8].defineBorder(2, 2);
        this.cells[8].defineBorder(2, Color.blue);
        this.cells[8].defineBorder(1, 6);
        this.cells[8].defineBorder(1, Color.orange);
        Document document = new Document();
        try {
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream("TableBorderTestEx.pdf"));
            Rectangle pageSize = new Rectangle((float)this.pageWidth, (float)this.pageHeight);
            document.setPageSize(pageSize);
            document.open();
            this.cb = writer.getDirectContent();
            this.testBorderDraw();
        }
        catch (DocumentException de) {
            System.err.println(de.getMessage());
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
        document.close();
    }

    public void testBorderDraw() {
        TableBorderEx currentTableBorder = new TableBorderEx(this.tableX, this.tableY);
        int i = 0;
        while (i < this.cells.length) {
            CellArea cell = this.cells[i];
            if (cell != null) {
                currentTableBorder.addRow(cell.y + cell.height);
                currentTableBorder.addColumn(cell.x + cell.width);
                if (cell.borders[0].borderWidth != 0) {
                    currentTableBorder.setRowBorder(cell.y, cell.x, cell.x + cell.width, cell.borders[0].borderStyle, cell.borders[0].borderWidth, cell.borders[0].borderColor);
                }
                if (cell.borders[3].borderWidth != 0) {
                    currentTableBorder.setColumnBorder(cell.x, cell.y, cell.y + cell.height, cell.borders[3].borderStyle, cell.borders[3].borderWidth, cell.borders[3].borderColor);
                }
                if (cell.borders[2].borderWidth != 0) {
                    currentTableBorder.setRowBorder(cell.y + cell.height, cell.x, cell.x + cell.width, cell.borders[2].borderStyle, cell.borders[2].borderWidth, cell.borders[2].borderColor);
                }
                if (cell.borders[1].borderWidth != 0) {
                    currentTableBorder.setColumnBorder(cell.x + cell.width, cell.y, cell.y + cell.height, cell.borders[1].borderStyle, cell.borders[1].borderWidth, cell.borders[1].borderColor);
                }
            }
            ++i;
        }
        currentTableBorder.findBreakPoints();
        this.drawBorder(currentTableBorder);
    }

    void drawBorder(TableBorderEx tb) {
        TableBorderEx.Border be;
        TableBorderEx.BorderSegment seg;
        TableBorderEx.Border be2;
        TableBorderEx.Border bs;
        TableBorderEx.BorderSegment seg2;
        TableBorderEx.Border border = null;
        tb.columnBorders.size();
        for (Integer pos : tb.columnBorders.keySet()) {
            if (pos == tb.tableLRX) continue;
            border = (TableBorderEx.Border)tb.columnBorders.get(pos);
            int j = 0;
            while (j < border.segments.size()) {
                seg2 = (TableBorderEx.BorderSegment)border.segments.get(j);
                bs = (TableBorderEx.Border)tb.rowBorders.get(seg2.start);
                be2 = (TableBorderEx.Border)tb.rowBorders.get(seg2.end);
                int sy = bs.position + bs.width / 2;
                int ey = be2.position + be2.width / 2;
                int x = border.position + seg2.width / 2;
                if (border.breakPoints.contains(new Integer(seg2.start))) {
                    sy = bs.position;
                }
                if (border.breakPoints.contains(new Integer(seg2.end))) {
                    if (seg2.end == tb.tableLRY) {
                        ey = be2.position;
                    } else {
                        int reWidth = this.getMaxSiblingBorderWidth(border, be2);
                        ey = be2.position + reWidth;
                    }
                }
                this.drawLine(x, sy, x, ey, seg2.style, seg2.width, seg2.color);
                ++j;
            }
        }
        border = (TableBorderEx.Border)tb.columnBorders.get(tb.tableLRX);
        int j = 0;
        while (j < border.segments.size()) {
            seg = (TableBorderEx.BorderSegment)border.segments.get(j);
            TableBorderEx.Border bs2 = (TableBorderEx.Border)tb.rowBorders.get(seg.start);
            be = (TableBorderEx.Border)tb.rowBorders.get(seg.end);
            int sy = bs2.position + bs2.width / 2;
            int ey = be.position + be.width / 2;
            int x = border.position - seg.width / 2;
            if (border.breakPoints.contains(new Integer(seg.start))) {
                sy = bs2.position;
            }
            if (border.breakPoints.contains(new Integer(seg.end))) {
                if (seg.end == tb.tableLRY) {
                    ey = be.position;
                } else {
                    int reWidth = this.getMaxSiblingBorderWidth(border, be);
                    ey = be.position + reWidth;
                }
            }
            this.drawLine(x, sy, x, ey, seg.style, seg.width, seg.color);
            ++j;
        }
        tb.rowBorders.size();
        for (Integer pos : tb.rowBorders.keySet()) {
            if (pos == tb.tableLRY) continue;
            border = (TableBorderEx.Border)tb.rowBorders.get(pos);
            int j2 = 0;
            while (j2 < border.segments.size()) {
                seg2 = (TableBorderEx.BorderSegment)border.segments.get(j2);
                bs = (TableBorderEx.Border)tb.columnBorders.get(seg2.start);
                be2 = (TableBorderEx.Border)tb.columnBorders.get(seg2.end);
                int sx = bs.position + bs.width / 2;
                int ex = be2.position + be2.width / 2;
                int y = border.position + seg2.width / 2;
                if (border.breakPoints.contains(new Integer(seg2.start))) {
                    sx = bs.position;
                }
                if (border.breakPoints.contains(new Integer(seg2.end))) {
                    if (seg2.end == tb.tableLRX) {
                        ex = be2.position;
                    } else {
                        int ceWidth = this.getMaxSiblingBorderWidth(border, be2);
                        ex = be2.position + ceWidth;
                    }
                }
                this.drawLine(sx, y, ex, y, seg2.style, seg2.width, seg2.color);
                ++j2;
            }
        }
        border = (TableBorderEx.Border)tb.rowBorders.get(tb.tableLRY);
        j = 0;
        while (j < border.segments.size()) {
            seg = (TableBorderEx.BorderSegment)border.segments.get(j);
            TableBorderEx.Border bs3 = (TableBorderEx.Border)tb.columnBorders.get(seg.start);
            be = (TableBorderEx.Border)tb.columnBorders.get(seg.end);
            int sx = bs3.position + bs3.width / 2;
            int ex = be.position + be.width / 2;
            int y = border.position - seg.width / 2;
            if (border.breakPoints.contains(new Integer(seg.start))) {
                sx = bs3.position;
            }
            if (border.breakPoints.contains(new Integer(seg.end))) {
                if (seg.end == tb.tableLRX) {
                    ex = be.position;
                } else {
                    int ceWidth = this.getMaxSiblingBorderWidth(border, be);
                    ex = be.position + ceWidth;
                }
            }
            this.drawLine(sx, y, ex, y, seg.style, seg.width, seg.color);
            ++j;
        }
    }

    private int getMaxSiblingBorderWidth(TableBorderEx.Border self, TableBorderEx.Border be) {
        TableBorderEx.BorderSegment bs1 = be.getSegmentByEnd(self.position);
        TableBorderEx.BorderSegment bs2 = be.getSegmentByStart(self.position);
        int bs1Width = bs1 == null ? 0 : bs1.width;
        int bs2Width = bs2 == null ? 0 : bs2.width;
        return Math.max(bs1Width, bs2Width);
    }

    private void drawLine(float startX, float startY, float endX, float endY, int style, float width, Color color) {
        startY = this.transformY(startY);
        endY = this.transformY(endY);
        this.cb.moveTo(startX, startY);
        this.cb.setLineWidth(width);
        this.cb.lineTo(endX, endY);
        this.cb.setColorStroke(color);
        this.cb.stroke();
    }

    private float transformY(float y) {
        return (float)this.pageHeight - y;
    }
}

