/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.parser;

import junit.framework.TestCase;
import org.eclipse.birt.report.engine.parser.TextParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TextParserTest
extends TestCase {
    public void testParseHTMLstream() {
        Document doc = new TextParser().parse(((Object)((Object)this)).getClass().getResourceAsStream("htmlparser_html.txt"), "Auto");
        Element root = (Element)doc.getFirstChild();
        Node child = root.getFirstChild();
        TextParserTest.assertTrue((boolean)child.getNodeName().equals("script"));
        child = child.getNextSibling();
        String res = "";
        while (child.getNodeType() == 3) {
            res = String.valueOf(res) + child.getNodeValue();
            child = child.getNextSibling();
        }
        TextParserTest.assertEquals((String)"&first", (String)res);
        TextParserTest.assertEquals((String)"h6", (String)child.getNodeName());
        TextParserTest.assertEquals((String)"h6-1", (String)child.getFirstChild().getNodeValue());
        child = child.getNextSibling();
        TextParserTest.assertEquals((String)"b", (String)child.getNodeName());
        TextParserTest.assertEquals((String)"bold text", (String)child.getFirstChild().getNodeValue());
        res = "";
        child = child.getNextSibling();
        while (child != null && child.getNodeType() == 3) {
            res = String.valueOf(res) + child.getNodeValue();
            child = child.getNextSibling();
        }
        TextParserTest.assertEquals((String)"second", (String)res);
    }

    public void testParsePlainstream() {
        Document doc = new TextParser().parse(((Object)((Object)this)).getClass().getResourceAsStream("htmlparser_plain.txt"), null);
        Element root = (Element)doc.getFirstChild();
        Node child = root.getFirstChild();
        String res = "";
        while (child != null && child.getNodeType() == 3) {
            res = String.valueOf(res) + child.getNodeValue();
            child = child.getNextSibling();
        }
        TextParserTest.assertEquals((String)"plain text.", (String)res);
    }

    public void testParsePlainTextString() {
        String text = "first \r\tsecond\nthird\r\n";
        Document doc = new TextParser().parse(text, "auto");
        Element root = (Element)doc.getFirstChild();
        Node child = root.getFirstChild();
        TextParserTest.assertEquals((String)"first ", (String)child.getNodeValue());
        child = child.getNextSibling();
        TextParserTest.assertEquals((String)"br", (String)child.getNodeName());
        child = child.getNextSibling();
        TextParserTest.assertEquals((String)"\tsecond", (String)child.getNodeValue());
        child = child.getNextSibling();
        TextParserTest.assertEquals((String)"br", (String)child.getNodeName());
        child = child.getNextSibling();
        TextParserTest.assertEquals((String)"third", (String)child.getNodeValue());
    }

    public void testParseHTMLString() {
        String html = "first<div>div1</div>second";
        Document doc = new TextParser().parse(html, "Html");
        Element root = (Element)doc.getFirstChild();
        Node child = root.getFirstChild();
        String res = "";
        while (child.getNodeType() == 3) {
            res = String.valueOf(res) + child.getNodeValue();
            child = child.getNextSibling();
        }
        TextParserTest.assertEquals((String)"first", (String)res);
        TextParserTest.assertEquals((String)"div", (String)child.getNodeName());
        TextParserTest.assertEquals((String)"div1", (String)child.getFirstChild().getNodeValue());
        child = child.getNextSibling();
        TextParserTest.assertEquals((String)"second", (String)child.getNodeValue());
    }

    public void testParseHTMLStringAuto() {
        String html = " \t \r \r\n \t\t <html><body>first<div>div1</div>second</body></html>";
        Document doc = new TextParser().parse(html, null);
        Element root = (Element)doc.getFirstChild();
        Node child = root.getFirstChild();
        String res = "";
        while (child.getNodeType() == 3) {
            res = String.valueOf(res) + child.getNodeValue();
            child = child.getNextSibling();
        }
        TextParserTest.assertEquals((String)"first", (String)res);
        TextParserTest.assertEquals((String)"div", (String)child.getNodeName());
        TextParserTest.assertEquals((String)"div1", (String)child.getFirstChild().getNodeValue());
        child = child.getNextSibling();
        TextParserTest.assertEquals((String)"second", (String)child.getNodeValue());
    }

    public void testParseEmptyHTML() {
        String html = "   \t ";
        Document doc = new TextParser().parse(html, "html");
        Element root = (Element)doc.getFirstChild();
        TextParserTest.assertEquals((int)root.getChildNodes().getLength(), (int)0);
        html = " <!--html><body></body>-->";
        doc = new TextParser().parse(html, "html");
        root = (Element)doc.getFirstChild();
        TextParserTest.assertEquals((int)root.getChildNodes().getLength(), (int)1);
    }
}

