/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.toc;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.archive.compound.ArchiveReader;
import org.eclipse.birt.core.archive.compound.ArchiveWriter;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.report.engine.toc.ITOCWriter;
import org.eclipse.birt.report.engine.toc.ITreeNode;
import org.eclipse.birt.report.engine.toc.TOCBuilder;
import org.eclipse.birt.report.engine.toc.TOCEntry;
import org.eclipse.birt.report.engine.toc.TOCReader;
import org.eclipse.birt.report.engine.toc.TOCTestCase;
import org.eclipse.birt.report.engine.toc.TOCWriter;

public class HugeTOCTest
extends TOCTestCase {
    static final int TOC_SIZE = 1000;
    static final String TOC_FILE = "./utest/test.toc";

    public void testHugeTOC() throws IOException {
        new File(TOC_FILE).delete();
        ArchiveFile archive = new ArchiveFile(TOC_FILE, "rw");
        System.out.println("create TOC with 1000000 entries");
        try {
            TOCWriter writer = new TOCWriter((IDocArchiveWriter)new ArchiveWriter((IArchiveFile)archive));
            try {
                TOCBuilder builder = new TOCBuilder((ITOCWriter)writer);
                int i = 0;
                while (i < 1000) {
                    TOCEntry level1 = this.startEntry(builder, null, "TOC_" + i);
                    int j = 0;
                    while (j < 1000) {
                        this.createEntry(builder, level1, "TOC_" + i + "_" + j);
                        ++j;
                    }
                    this.closeEntry(builder, level1);
                    ++i;
                }
            }
            finally {
                writer.close();
            }
            System.out.println("file length:" + new File(TOC_FILE).length());
            System.out.println("read TOC with 1000000 entries");
            TOCReader reader = new TOCReader((IDocArchiveReader)new ArchiveReader((IArchiveFile)archive), ClassLoader.getSystemClassLoader());
            try {
                ITreeNode root = reader.readTree();
                HugeTOCTest.assertEquals((String)"/", (String)root.getNodeId());
                Collection nodes1 = root.getChildren();
                HugeTOCTest.assertEquals((int)1000, (int)nodes1.size());
                int index1 = 0;
                for (ITreeNode node1 : nodes1) {
                    HugeTOCTest.assertEquals((Object)("TOC_" + index1), (Object)node1.getTOCValue());
                    Collection nodes2 = node1.getChildren();
                    HugeTOCTest.assertEquals((int)1000, (int)nodes2.size());
                    int index2 = 0;
                    for (ITreeNode node2 : nodes2) {
                        HugeTOCTest.assertEquals((Object)("TOC_" + index1 + "_" + index2), (Object)node2.getTOCValue());
                        HugeTOCTest.assertTrue((boolean)node2.getChildren().isEmpty());
                        ++index2;
                    }
                    ++index1;
                }
            }
            finally {
                reader.close();
            }
        }
        finally {
            archive.close();
        }
    }
}

