/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.chart;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import junit.framework.TestCase;

public class ChartTestCase
extends TestCase {
    protected static final String TEST_FOLDER = "src";
    protected static final String OUTPUT_FOLDER = "output";
    protected static final String INPUT_FOLDER = "input";
    protected static final String GOLDEN_FOLDER = "golden";
    protected static final String PLUGIN_NAME = "org.eclipse.birt.report.tests.chart";

    protected void setUp() throws Exception {
        super.setUp();
        String tempDir = System.getProperty("java.io.tmpdir");
        if (!tempDir.endsWith(File.separator)) {
            tempDir = String.valueOf(tempDir) + File.separator;
        }
        String outputPath = this.genOutputFolder();
        outputPath = outputPath.replace('\\', '/');
        File outputFolder = new File(outputPath);
        File parent = new File(outputPath).getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        if (!outputFolder.exists() && !outputFolder.mkdir()) {
            throw new IOException("Can not create the output folder");
        }
    }

    protected boolean compare(byte[] bytes1, byte[] bytes2) {
        if (bytes1.length != bytes2.length) {
            return false;
        }
        int i = 0;
        while (i < bytes1.length) {
            if (bytes1[i] != bytes2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean compareBytes(String golden, String output) throws Exception {
        FileInputStream is2;
        String className = this.getFullQualifiedClassName();
        className = className.replace('.', '/');
        golden = String.valueOf(className) + "/" + GOLDEN_FOLDER + "/" + golden;
        InputStream is1 = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(golden);
        boolean compareResult = this.compare(is1, is2 = new FileInputStream(this.genOutputFile(output)));
        if (!compareResult) {
            InputStream in;
            String goldenFrom = golden;
            String goldenTo = String.valueOf(this.getOutputResourceFolder()) + "/" + this.getFullQualifiedClassName() + "/" + "diffGolden/" + output;
            String outputFrom = this.genOutputFile(output);
            String outputTo = String.valueOf(this.getOutputResourceFolder()) + "/" + this.getFullQualifiedClassName() + "/diffOutput/" + output;
            File parentOutput = new File(outputTo).getParentFile();
            if (parentOutput != null) {
                parentOutput.mkdirs();
            }
            this.copyFile(outputFrom, outputTo);
            File parentGolden = new File(goldenTo).getParentFile();
            if (parentGolden != null) {
                parentGolden.mkdirs();
            }
            ChartTestCase.assertTrue(((in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(goldenFrom)) != null ? 1 : 0) != 0);
            try {
                FileOutputStream fos = new FileOutputStream(goldenTo);
                byte[] fileData = new byte[5120];
                int readCount = -1;
                while ((readCount = in.read(fileData)) != -1) {
                    fos.write(fileData, 0, readCount);
                }
                fos.close();
                in.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                ChartTestCase.fail();
            }
        }
        return compareResult;
    }

    protected boolean compare(InputStream golden, InputStream output) throws Exception {
        int goldenChar = -1;
        while ((goldenChar = golden.read()) != -1) {
            if (goldenChar == output.read()) continue;
            return false;
        }
        return true;
    }

    protected String getClassFolder() {
        CodeSource source;
        String pathBase = null;
        ProtectionDomain domain = ((Object)((Object)this)).getClass().getProtectionDomain();
        if (domain != null && (source = domain.getCodeSource()) != null) {
            URL url = source.getLocation();
            pathBase = url.getPath();
            if (pathBase.endsWith("bin/")) {
                pathBase = pathBase.substring(0, pathBase.length() - 4);
            }
            if (pathBase.endsWith("bin")) {
                pathBase = pathBase.substring(0, pathBase.length() - 3);
            }
        }
        pathBase = String.valueOf(pathBase) + TEST_FOLDER;
        String className = ((Object)((Object)this)).getClass().getName();
        int lastDotIndex = className.lastIndexOf(".");
        className = className.substring(0, lastDotIndex);
        className = String.valueOf(pathBase) + "/" + className.replace('.', '/');
        return className;
    }

    protected String getClassFolder2() {
        String className = ((Object)((Object)this)).getClass().getName();
        int lastDotIndex = className.lastIndexOf(".");
        className = className.substring(0, lastDotIndex);
        className = TEST_FOLDER + className.replace('.', '/');
        return className;
    }

    protected String getFullQualifiedClassName() {
        String className = ((Object)((Object)this)).getClass().getName();
        int lastDotIndex = className.lastIndexOf(".");
        className = PLUGIN_NAME + className.substring(PLUGIN_NAME.length(), lastDotIndex).replace('.', '/');
        return className;
    }

    public String tempFolder() {
        String tempDir = System.getProperty("java.io.tmpdir");
        if (!tempDir.endsWith(File.separator)) {
            tempDir = String.valueOf(tempDir) + File.separator;
        }
        return tempDir;
    }

    public String getInputResourceFolder() {
        String resourceFolder = String.valueOf(this.tempFolder()) + PLUGIN_NAME + ".RESOURCE";
        return resourceFolder;
    }

    public String getOutputResourceFolder() {
        String outputFolder = String.valueOf(this.tempFolder()) + PLUGIN_NAME + ".OUTPUT";
        return outputFolder;
    }

    protected String genOutputFolder() {
        String outputFolder = String.valueOf(this.getOutputResourceFolder()) + File.separator + this.getFullQualifiedClassName() + "/" + OUTPUT_FOLDER;
        return outputFolder;
    }

    protected String genInputFolder() {
        String inputFolder = String.valueOf(this.getInputResourceFolder()) + File.separator + this.getFullQualifiedClassName() + "/" + INPUT_FOLDER;
        return inputFolder;
    }

    protected String genGoldenFolder() {
        String goldenFolder = String.valueOf(this.getInputResourceFolder()) + File.separator + this.getFullQualifiedClassName() + "/" + GOLDEN_FOLDER;
        return goldenFolder;
    }

    protected String genOutputFile(String output) {
        String outputFile = String.valueOf(this.genOutputFolder()) + File.separator + output;
        return outputFile;
    }

    protected String genInputFile(String input) {
        String inputFile = String.valueOf(this.genInputFolder()) + File.separator + input;
        return inputFile;
    }

    protected String genGoldenFile(String golden) {
        String goldenFile = String.valueOf(this.genGoldenFolder()) + File.separator + golden;
        return goldenFile;
    }

    protected void copyResource(String src, String tgt, String folder) {
        InputStream in;
        String className = this.getFullQualifiedClassName();
        tgt = String.valueOf(this.getInputResourceFolder()) + File.separator + className + "/" + folder + "/" + tgt;
        className = className.replace('.', '/');
        src = String.valueOf(className) + "/" + folder + "/" + src;
        File parent = new File(tgt).getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        ChartTestCase.assertTrue(((in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(src)) != null ? 1 : 0) != 0);
        try {
            FileOutputStream fos = new FileOutputStream(tgt);
            byte[] fileData = new byte[5120];
            int readCount = -1;
            while ((readCount = in.read(fileData)) != -1) {
                fos.write(fileData, 0, readCount);
            }
            fos.close();
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ChartTestCase.fail();
        }
    }

    protected void copyResource_INPUT(String input_resource, String input) {
        this.copyResource(input_resource, input, INPUT_FOLDER);
    }

    protected void copyResource_GOLDEN(String input_resource, String golden) {
        this.copyResource(input_resource, golden, GOLDEN_FOLDER);
    }

    protected void copyResource_SCRIPT(String input_resource, String script) {
        this.copyResource(input_resource, script, "input/scripts");
    }

    public void removeFile(File file) {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                this.removeFile(children[i]);
                ++i;
            }
        }
        if (file.exists() && !file.delete()) {
            System.out.println(String.valueOf(file.toString()) + " can't be removed");
        }
    }

    public void removeFile(String file) {
        this.removeFile(new File(file));
    }

    public void removeResource() {
        this.removeFile(this.getInputResourceFolder());
    }

    protected final void copyFile(String from, String to) throws IOException {
        File parent = new File(to).getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            new File(to).createNewFile();
            bis = new BufferedInputStream(new FileInputStream(from));
            bos = new BufferedOutputStream(new FileOutputStream(to));
            int nextByte = 0;
            while ((nextByte = bis.read()) != -1) {
                ((BufferedOutputStream)bos).write(nextByte);
            }
        }
        catch (Throwable throwable) {
            try {
                if (bis != null) {
                    bis.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (bis != null) {
                bis.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
        catch (IOException iOException) {}
    }
}

