/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.chart.api.script;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.impl.LineSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.report.tests.chart.ChartTestCase;

public class BeforeDrawDataPoint
extends ChartTestCase {
    private static String OUTPUT = "BeforeDrawDataPoint.jpg";
    private static final long serialVersionUID = 1L;
    private Chart cm = null;
    private IDeviceRenderer dRenderer = null;
    private GeneratedChartState gcs = null;

    public static void main(String[] args) {
        new BeforeDrawDataPoint();
    }

    public BeforeDrawDataPoint() {
        PluginSettings ps = PluginSettings.instance();
        try {
            this.dRenderer = ps.getDevice("dv.JPG");
        }
        catch (ChartException ex) {
            ex.printStackTrace();
        }
        this.cm = BeforeDrawDataPoint.createLineChart();
        BufferedImage img = new BufferedImage(500, 500, 2);
        Graphics g = img.getGraphics();
        Graphics2D g2d = (Graphics2D)g;
        this.dRenderer.setProperty("device.output.context", (Object)g2d);
        this.dRenderer.setProperty("device.file.identifier", (Object)this.genOutputFile(OUTPUT));
        Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)500.0, (double)500.0);
        bo.scale(72.0 / (double)this.dRenderer.getDisplayServer().getDpiResolution());
        Generator gr = Generator.instance();
        try {
            this.gcs = gr.build(this.dRenderer.getDisplayServer(), this.cm, bo, null, null, null);
            gr.render(this.dRenderer, this.gcs);
        }
        catch (ChartException e) {
            e.printStackTrace();
        }
    }

    public static final Chart createLineChart() {
        ChartWithAxes cwaLine = ChartWithAxesImpl.create();
        cwaLine.setType("Line Chart");
        cwaLine.setScript("function beforeDrawDataPoint( dph, fill, context ){importPackage(Packages.org.eclipse.birt.chart.model.attribute); importPackage(Packages.org.eclipse.birt.chart.model.attribute.impl); value = dph.getDisplayValue();if ( ( value >= 50 ) & ( value <= 100 ) ){fill.set(22,22,22);}else if ( ( value >= 100 ) & ( value <= 150 ) ){fill.set(0,0,0);}else if ( value > 150 ){fill.set(150,150,150);}else if ( value < 50 ){fill.set(0,80,230);}}");
        cwaLine.getTitle().getLabel().getCaption().setValue("Computer Hardware Sales");
        cwaLine.getBlock().setBackground((Fill)ColorDefinitionImpl.WHITE());
        cwaLine.getPlot().getClientArea().getOutline().setVisible(false);
        cwaLine.getPlot().getClientArea().setBackground((Fill)ColorDefinitionImpl.create((int)255, (int)255, (int)225));
        Legend lg = cwaLine.getLegend();
        lg.setVisible(true);
        Axis xAxisPrimary = ((ChartWithAxesImpl)cwaLine).getPrimaryBaseAxes()[0];
        xAxisPrimary.getTitle().setVisible(false);
        xAxisPrimary.setType(AxisType.TEXT_LITERAL);
        xAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        xAxisPrimary.getMajorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        xAxisPrimary.getMajorGrid().getLineAttributes().setStyle(LineStyle.DOTTED_LITERAL);
        xAxisPrimary.getMajorGrid().getLineAttributes().setColor(ColorDefinitionImpl.GREY());
        xAxisPrimary.getMajorGrid().getLineAttributes().setVisible(true);
        xAxisPrimary.setLineAttributes(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.create((int)239, (int)33, (int)3), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
        Axis yAxisPrimary = ((ChartWithAxesImpl)cwaLine).getPrimaryOrthogonalAxis(xAxisPrimary);
        yAxisPrimary.getTitle().setVisible(false);
        yAxisPrimary.setType(AxisType.LINEAR_LITERAL);
        yAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        yAxisPrimary.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        yAxisPrimary.getMajorGrid().getLineAttributes().setStyle(LineStyle.DOTTED_LITERAL);
        yAxisPrimary.getMajorGrid().getLineAttributes().setColor(ColorDefinitionImpl.GREY());
        yAxisPrimary.getMajorGrid().getLineAttributes().setVisible(true);
        TextDataSet dsStringValue = TextDataSetImpl.create((Object)new String[]{"Keyboards", "Moritors", "Printers", "Mortherboards"});
        NumberDataSet dsNumericValues1 = NumberDataSetImpl.create((Object)new double[]{143.26, 156.55, 95.25, 47.56});
        Series seBase = SeriesImpl.create();
        seBase.setDataSet((DataSet)dsStringValue);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        xAxisPrimary.getSeriesDefinitions().add((Object)sdX);
        sdX.getSeries().add((Object)seBase);
        LineSeries ls = (LineSeries)LineSeriesImpl.create();
        ls.setSeriesIdentifier((Object)"Actuate");
        ls.getLabel().getCaption().setColor(ColorDefinitionImpl.RED());
        ls.setLineAttributes(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.create((int)220, (int)50, (int)227), (LineStyle)LineStyle.DOTTED_LITERAL, (int)3));
        ls.getLabel().setBackground((Fill)ColorDefinitionImpl.CYAN());
        ls.getLabel().setVisible(true);
        ls.setDataSet((DataSet)dsNumericValues1);
        ls.setStacked(true);
        SeriesDefinition sdY = SeriesDefinitionImpl.create();
        yAxisPrimary.getSeriesDefinitions().add((Object)sdY);
        sdY.getSeriesPalette().update((Fill)ColorDefinitionImpl.BLUE());
        sdY.getSeries().add((Object)ls);
        return cwaLine;
    }
}

