/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.chart.api.script;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.MarkerRange;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.MarkerRangeImpl;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.impl.BarSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.report.tests.chart.ChartTestCase;

public class BeforeDrawLegendEntry
extends ChartTestCase {
    private static String OUTPUT = "BeforeDrawLegendEntry.jpg";
    private static final long serialVersionUID = 1L;
    private Chart cm = null;
    private IDeviceRenderer dRenderer = null;
    private GeneratedChartState gcs = null;

    public static void main(String[] args) {
        new BeforeDrawLegendEntry();
    }

    public BeforeDrawLegendEntry() {
        PluginSettings ps = PluginSettings.instance();
        try {
            this.dRenderer = ps.getDevice("dv.JPG");
        }
        catch (ChartException ex) {
            ex.printStackTrace();
        }
        this.cm = BeforeDrawLegendEntry.createBarChart();
        BufferedImage img = new BufferedImage(600, 600, 2);
        Graphics g = img.getGraphics();
        Graphics2D g2d = (Graphics2D)g;
        this.dRenderer.setProperty("device.output.context", (Object)g2d);
        this.dRenderer.setProperty("device.file.identifier", (Object)this.genOutputFile(OUTPUT));
        Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)600.0, (double)600.0);
        bo.scale(72.0 / (double)this.dRenderer.getDisplayServer().getDpiResolution());
        Generator gr = Generator.instance();
        try {
            this.gcs = gr.build(this.dRenderer.getDisplayServer(), this.cm, bo, null, null, null);
            gr.render(this.dRenderer, this.gcs);
        }
        catch (ChartException e) {
            e.printStackTrace();
        }
    }

    public static final Chart createBarChart() {
        ChartWithAxes cwaBar = ChartWithAxesImpl.create();
        cwaBar.setScript("function beforeDrawLegendEntry(label, scriptContext){label.getCaption( ).getColor().set( 35, 184, 245 ); label.getCaption().getFont().setBold(true); label.getCaption().getFont().setItalic(true); label.getOutline().setVisible(true); label.getOutline().getColor().set( 177, 12, 187);}");
        cwaBar.setType("Bar Chart");
        cwaBar.setSubType("Stacked");
        cwaBar.setDimension(ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL);
        cwaBar.setFloorFill((Fill)ColorDefinitionImpl.ORANGE());
        cwaBar.setWallFill((Fill)ColorDefinitionImpl.GREY());
        cwaBar.getTitle().getLabel().getCaption().setValue("Computer Hardware Sales");
        cwaBar.getBlock().setBackground((Fill)ColorDefinitionImpl.WHITE());
        cwaBar.getPlot().getClientArea().getOutline().setVisible(false);
        cwaBar.getPlot().getClientArea().setBackground((Fill)ColorDefinitionImpl.create((int)255, (int)255, (int)225));
        Legend lg = cwaBar.getLegend();
        lg.setItemType(LegendItemType.CATEGORIES_LITERAL);
        Axis xAxisPrimary = ((ChartWithAxesImpl)cwaBar).getPrimaryBaseAxes()[0];
        xAxisPrimary.getTitle().setVisible(false);
        xAxisPrimary.setType(AxisType.TEXT_LITERAL);
        xAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        xAxisPrimary.getLabel().getCaption().setColor(ColorDefinitionImpl.GREEN().darker());
        xAxisPrimary.getMajorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        xAxisPrimary.getMajorGrid().getLineAttributes().setStyle(LineStyle.DOTTED_LITERAL);
        xAxisPrimary.getMajorGrid().getLineAttributes().setColor(ColorDefinitionImpl.GREY());
        xAxisPrimary.getMajorGrid().getLineAttributes().setVisible(true);
        MarkerRange mr = MarkerRangeImpl.create((Axis)xAxisPrimary, (DataElement)NumberDataElementImpl.create((double)2.0), (DataElement)NumberDataElementImpl.create((double)3.0), null);
        mr.setOutline(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.create((int)239, (int)33, (int)3), (LineStyle)LineStyle.DOTTED_LITERAL, (int)2));
        Axis yAxisPrimary = ((ChartWithAxesImpl)cwaBar).getPrimaryOrthogonalAxis(xAxisPrimary);
        yAxisPrimary.getLabel().getCaption().setValue("Sales Growth");
        yAxisPrimary.getLabel().getCaption().setColor(ColorDefinitionImpl.BLUE());
        yAxisPrimary.getTitle().setVisible(false);
        yAxisPrimary.setType(AxisType.LINEAR_LITERAL);
        yAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        yAxisPrimary.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        yAxisPrimary.getMajorGrid().getLineAttributes().setStyle(LineStyle.DOTTED_LITERAL);
        yAxisPrimary.getMajorGrid().getLineAttributes().setColor(ColorDefinitionImpl.GREY());
        yAxisPrimary.getMajorGrid().getLineAttributes().setVisible(true);
        TextDataSet dsStringValue = TextDataSetImpl.create((Object)new String[]{"Keyboards", "Moritors", "Printers", "Mortherboards"});
        NumberDataSet dsNumericValues1 = NumberDataSetImpl.create((Object)new double[]{143.26, 156.55, 95.25, 47.56});
        Series seBase = SeriesImpl.create();
        seBase.setDataSet((DataSet)dsStringValue);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        xAxisPrimary.getSeriesDefinitions().add((Object)sdX);
        sdX.getSeries().add((Object)seBase);
        BarSeries bs = (BarSeries)BarSeriesImpl.create();
        bs.setSeriesIdentifier((Object)"Actuate");
        bs.getLabel().getCaption().setColor(ColorDefinitionImpl.RED());
        bs.getLabel().setBackground((Fill)ColorDefinitionImpl.CYAN());
        bs.getLabel().setVisible(true);
        bs.setDataSet((DataSet)dsNumericValues1);
        bs.setStacked(true);
        SeriesDefinition sdY = SeriesDefinitionImpl.create();
        yAxisPrimary.getSeriesDefinitions().add((Object)sdY);
        sdY.getSeriesPalette().update((Fill)ColorDefinitionImpl.GREEN());
        sdY.getSeries().add((Object)bs);
        return cwaBar;
    }
}

