/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.chart.regression;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.HorizontalAlignment;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.TextAlignment;
import org.eclipse.birt.chart.model.attribute.VerticalAlignment;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.InsetsImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.attribute.impl.TextAlignmentImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.impl.BarSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.report.tests.chart.ChartTestCase;

public class Regression_133237
extends ChartTestCase {
    private static String GOLDEN = "Regression_133237.jpg";
    private static String OUTPUT = "Regression_133237.jpg";
    private static final long serialVersionUID = 1L;
    private Chart cm = null;
    private IDeviceRenderer dRenderer = null;
    private GeneratedChartState gcs = null;

    public static void main(String[] args) {
        new Regression_133237();
    }

    public Regression_133237() {
        PluginSettings ps = PluginSettings.instance();
        try {
            this.dRenderer = ps.getDevice("dv.JPG");
        }
        catch (ChartException ex) {
            ex.printStackTrace();
        }
        this.cm = Regression_133237.createBarChart();
        BufferedImage img = new BufferedImage(500, 500, 2);
        Graphics g = img.getGraphics();
        Graphics2D g2d = (Graphics2D)g;
        this.dRenderer.setProperty("device.output.context", (Object)g2d);
        this.dRenderer.setProperty("device.file.identifier", (Object)this.genOutputFile(OUTPUT));
        Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)500.0, (double)500.0);
        bo.scale(72.0 / (double)this.dRenderer.getDisplayServer().getDpiResolution());
        Generator gr = Generator.instance();
        try {
            this.gcs = gr.build(this.dRenderer.getDisplayServer(), this.cm, bo, null, null, null);
            gr.render(this.dRenderer, this.gcs);
        }
        catch (ChartException e) {
            e.printStackTrace();
        }
    }

    public void test_regression_133237() throws Exception {
        Regression_133237 st = new Regression_133237();
        Regression_133237.assertTrue((boolean)st.compareBytes(GOLDEN, OUTPUT));
    }

    public static final Chart createBarChart() {
        ChartWithAxes cwaBar = ChartWithAxesImpl.create();
        cwaBar.setType("Bar Chart");
        cwaBar.setSubType("Stacked");
        cwaBar.getTitle().getLabel().getCaption().setValue("Computer Hardware Sales");
        cwaBar.getTitle().setOutline(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.create((int)239, (int)33, (int)3), (LineStyle)LineStyle.SOLID_LITERAL, (int)3));
        cwaBar.getTitle().setInsets(InsetsImpl.create((double)13.0, (double)13.0, (double)13.0, (double)13.0));
        cwaBar.getTitle().getLabel().setInsets(InsetsImpl.create((double)10.0, (double)13.0, (double)10.0, (double)13.0));
        cwaBar.getTitle().getLabel().setOutline(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.create((int)239, (int)33, (int)3), (LineStyle)LineStyle.SOLID_LITERAL, (int)3));
        TextAlignment ta = TextAlignmentImpl.create();
        ta.setHorizontalAlignment(HorizontalAlignment.RIGHT_LITERAL);
        ta.setVerticalAlignment(VerticalAlignment.TOP_LITERAL);
        cwaBar.getTitle().getLabel().getCaption().getFont().setAlignment(ta);
        cwaBar.getBlock().setBackground((Fill)ColorDefinitionImpl.WHITE());
        Axis xAxisPrimary = ((ChartWithAxesImpl)cwaBar).getPrimaryBaseAxes()[0];
        xAxisPrimary.getTitle().setVisible(false);
        xAxisPrimary.setType(AxisType.TEXT_LITERAL);
        xAxisPrimary.getOrigin().setType(IntersectionType.MIN_LITERAL);
        xAxisPrimary.getLabel().getCaption().setColor(ColorDefinitionImpl.GREEN().darker());
        Axis yAxisPrimary = ((ChartWithAxesImpl)cwaBar).getPrimaryOrthogonalAxis(xAxisPrimary);
        yAxisPrimary.getLabel().getCaption().setValue("Sales Growth");
        yAxisPrimary.getLabel().getCaption().setColor(ColorDefinitionImpl.BLUE());
        yAxisPrimary.getTitle().setVisible(false);
        yAxisPrimary.setType(AxisType.LINEAR_LITERAL);
        yAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        TextDataSet dsStringValue = TextDataSetImpl.create((Object)new String[]{"Keyboards", "Moritors", "Printers", "Mortherboards"});
        NumberDataSet dsNumericValues1 = NumberDataSetImpl.create((Object)new double[]{143.26, 156.55, 95.25, 47.56});
        Series seBase = SeriesImpl.create();
        seBase.setDataSet((DataSet)dsStringValue);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        xAxisPrimary.getSeriesDefinitions().add((Object)sdX);
        sdX.getSeries().add((Object)seBase);
        BarSeries bs = (BarSeries)BarSeriesImpl.create();
        bs.setSeriesIdentifier((Object)"Actuate");
        bs.getLabel().getCaption().setColor(ColorDefinitionImpl.RED());
        bs.getLabel().setBackground((Fill)ColorDefinitionImpl.CYAN());
        bs.getLabel().setVisible(true);
        bs.setDataSet((DataSet)dsNumericValues1);
        bs.setStacked(true);
        SeriesDefinition sdY = SeriesDefinitionImpl.create();
        yAxisPrimary.getSeriesDefinitions().add((Object)sdY);
        sdY.getSeriesPalette().update((Fill)ColorDefinitionImpl.BLUE());
        sdY.getSeries().add((Object)bs);
        return cwaBar;
    }
}

