/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.chart.regression;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.GregorianCalendar;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Date;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.DateTimeDataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.DateTimeDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.type.ScatterSeries;
import org.eclipse.birt.chart.model.type.impl.ScatterSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.report.tests.chart.ChartTestCase;

public class Regression_152033
extends ChartTestCase {
    private static String OUTPUT = "Regression_152033.jpg";
    private static final long serialVersionUID = 1L;
    private Chart cm = null;
    private IDeviceRenderer dRenderer = null;
    private GeneratedChartState gcs = null;

    public static void main(String[] args) {
        new Regression_152033();
    }

    public Regression_152033() {
        PluginSettings ps = PluginSettings.instance();
        try {
            this.dRenderer = ps.getDevice("dv.JPG");
        }
        catch (ChartException ex) {
            ex.printStackTrace();
        }
        this.cm = Regression_152033.createDateTimeScatter();
        BufferedImage img = new BufferedImage(600, 600, 2);
        Graphics g = img.getGraphics();
        Graphics2D g2d = (Graphics2D)g;
        this.dRenderer.setProperty("device.output.context", (Object)g2d);
        this.dRenderer.setProperty("device.file.identifier", (Object)this.getClassFolder2());
        Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)600.0, (double)600.0);
        bo.scale(72.0 / (double)this.dRenderer.getDisplayServer().getDpiResolution());
        Generator gr = Generator.instance();
        try {
            this.gcs = gr.build(this.dRenderer.getDisplayServer(), this.cm, bo, null, null, null);
            gr.render(this.dRenderer, this.gcs);
        }
        catch (ChartException e) {
            e.printStackTrace();
        }
    }

    public static final Chart createDateTimeScatter() {
        ChartWithAxes cwaScatter = ChartWithAxesImpl.create();
        cwaScatter.setScript("function beforeDrawAxisLabel(axis, label, context){label.getCaption().setValue(\"ABC\"); axis.setLabel(label);}");
        cwaScatter.getPlot().getClientArea().getOutline().setVisible(true);
        cwaScatter.getTitle().setVisible(false);
        Axis xAxisPrimary = ((ChartWithAxesImpl)cwaScatter).getPrimaryBaseAxes()[0];
        xAxisPrimary.getTitle().getCaption().setValue("Time");
        xAxisPrimary.setType(AxisType.DATE_TIME_LITERAL);
        xAxisPrimary.getTitle().setVisible(true);
        xAxisPrimary.getOrigin().setType(IntersectionType.MIN_LITERAL);
        Axis yAxisPrimary = ((ChartWithAxesImpl)cwaScatter).getPrimaryOrthogonalAxis(xAxisPrimary);
        yAxisPrimary.getTitle().getCaption().setValue("Score");
        yAxisPrimary.getTitle().setBackground((Fill)ColorDefinitionImpl.WHITE());
        yAxisPrimary.getTitle().setVisible(true);
        yAxisPrimary.setType(AxisType.LINEAR_LITERAL);
        yAxisPrimary.getOrigin().setType(IntersectionType.MIN_LITERAL);
        int seriesLen = 10;
        double[] yseries = new double[seriesLen];
        Calendar[] datetime = new Calendar[seriesLen];
        int i = 0;
        while (i < seriesLen) {
            yseries[i] = i;
            datetime[i] = new GregorianCalendar();
            datetime[i].setTime(new Date(i));
            ++i;
        }
        NumberDataSet dsNumericValues2 = NumberDataSetImpl.create((Object)yseries);
        DateTimeDataSet dsDateTime = DateTimeDataSetImpl.create((Object)datetime);
        Series seBase = SeriesImpl.create();
        seBase.setDataSet((DataSet)dsDateTime);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        xAxisPrimary.getSeriesDefinitions().add((Object)sdX);
        sdX.getSeries().add((Object)seBase);
        ScatterSeries ss = (ScatterSeries)ScatterSeriesImpl.create();
        ss.setDataSet((DataSet)dsNumericValues2);
        SeriesDefinition sdY = SeriesDefinitionImpl.create();
        yAxisPrimary.getSeriesDefinitions().add((Object)sdY);
        sdY.getSeries().add((Object)ss);
        return cwaScatter;
    }
}

