/*
 * Decompiled with CFR 0.152.
 */
package testutil;

import com.ibm.icu.text.SimpleDateFormat;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Date;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.BaseExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryDefinition;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.mozilla.javascript.Scriptable;
import testutil.BaseTestCase;
import testutil.JDBCDataSource;
import testutil.TestDataSource;

public abstract class APITestCase
extends BaseTestCase {
    protected String DriverClass;
    protected String URL;
    protected String User;
    protected String Password;
    private String tableName;
    protected TestDataSource dataSourceInstance;
    protected DataEngine dataEngine;
    protected BaseDataSourceDesign dataSource;
    protected BaseDataSetDesign dataSet;
    protected static final String INPUT_FOLDER = "input";
    protected static final String GOLDEN_FOLDER = "golden";
    protected static final String OUTPUT_FOLDER = "output";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.dataEngine = DataEngine.newDataEngine((DataEngineContext)DataEngineContext.newInstance((int)3, (Scriptable)this.jsScope, null, null));
        this.prepareDataSource();
    }

    @Override
    protected void tearDown() throws Exception {
        this.dataEngine.shutdown();
        this.closeDataSource();
        super.tearDown();
    }

    private void prepareDataSource() throws Exception {
        DataSourceInfo dataSourceInfo = this.getDataSourceInfo();
        if (dataSourceInfo != null) {
            this.prepareDataSet(dataSourceInfo);
            this.dataSource = this.dataSourceInstance.getOdaDataSourceDesign();
            this.dataSet = this.dataSourceInstance.getOdaDataSetDesign();
            ((OdaDataSetDesign)this.dataSet).setQueryText("select * from " + dataSourceInfo.tableName);
            this.dataEngine.defineDataSource((IBaseDataSourceDesign)this.dataSource);
            this.dataEngine.defineDataSet((IBaseDataSetDesign)this.dataSet);
        }
    }

    protected void prepareDataSet(DataSourceInfo dataSourceInfo) throws Exception {
        if (dataSourceInfo != null && dataSourceInfo.tableName != null && dataSourceInfo.createSql != null && dataSourceInfo.dataFileName != null) {
            this.tableName = dataSourceInfo.tableName;
            this.prepareTestTable(dataSourceInfo.tableName, dataSourceInfo.createSql, dataSourceInfo.dataFileName);
        }
    }

    private void prepareTestTable(String tableName, String createSql, String dataFileName) throws Exception {
        if (this.dataSourceInstance == null) {
            this.dataSourceInstance = JDBCDataSource.newInstance();
        }
        this.dataSourceInstance.createTable(tableName, createSql, true);
        this.dataSourceInstance.populateTable(tableName, this.getInputFolder(dataFileName));
    }

    protected abstract DataSourceInfo getDataSourceInfo();

    protected void closeDataSource() throws Exception {
        if (this.dataSourceInstance != null) {
            if (this.tableName != null) {
                this.dataSourceInstance.dropTable(this.tableName);
            }
            this.dataSourceInstance.close(true);
            this.dataSourceInstance = null;
        }
    }

    protected String getTestTableName() {
        return this.tableName;
    }

    protected OdaDataSetDesign newDataSet(String datasetName, String queryText) throws Exception {
        OdaDataSetDesign dset = new OdaDataSetDesign(datasetName);
        dset.setDataSource(this.dataSource.getName());
        dset.setQueryText(queryText);
        dset.setExtensionID("org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        this.dataEngine.defineDataSet((IBaseDataSetDesign)dset);
        return dset;
    }

    protected QueryDefinition newReportQuery() {
        QueryDefinition queryDefn = new QueryDefinition();
        queryDefn.setDataSetName(this.dataSet.getName());
        return queryDefn;
    }

    protected QueryDefinition newReportQuery(IBaseDataSetDesign dataset) {
        QueryDefinition queryDefn = new QueryDefinition();
        if (dataset == null) {
            queryDefn.setDataSetName(this.dataSet.getName());
        } else {
            queryDefn.setDataSetName(dataset.getName());
        }
        return queryDefn;
    }

    protected IResultIterator executeQuery(IQueryDefinition query) throws Exception {
        IPreparedQuery preparedQuery = this.dataEngine.prepare(query);
        IQueryResults queryResults = preparedQuery.execute(null);
        return queryResults.getResultIterator();
    }

    protected void outputQueryResult(IResultIterator resultIt, String[] expressions) throws Exception {
        assert (this.testOut != null);
        this.testPrintln("*****A new Report Start!*****");
        while (resultIt.next()) {
            this.testPrint("S:");
            this.testPrint(Integer.toString(resultIt.getStartingGroupLevel()));
            this.testPrint(" E:");
            this.testPrint(Integer.toString(resultIt.getEndingGroupLevel()));
            this.testPrint(" ");
            int i = 0;
            while (i < expressions.length) {
                this.testPrint(this.evalAsString(expressions[i], resultIt));
                this.testPrint("    ");
                ++i;
            }
            this.testPrintln("");
        }
        this.testPrintln("");
    }

    protected void executeQuery(QueryDefinition queryDefn, String[] exprName) throws Exception {
        IResultIterator resultIt = this.executeQuery((IQueryDefinition)queryDefn);
        this.testPrintln("*****A new Report Start!*****");
        while (resultIt.next()) {
            this.testPrint("S:");
            this.testPrint(Integer.toString(resultIt.getStartingGroupLevel()));
            this.testPrint(" E:");
            this.testPrint(Integer.toString(resultIt.getEndingGroupLevel()));
            this.testPrint(" ");
            int i = 0;
            while (i < exprName.length) {
                this.testPrint(this.evalAsString(exprName[i], resultIt));
                this.testPrint("    ");
                ++i;
            }
            this.testPrintln("");
        }
        this.testPrintln("");
    }

    protected String evalAsString(String name, IResultIterator result) {
        Object val;
        block3: {
            try {
                val = result.getValue(name);
                if (val != null) break block3;
                return "<null>";
            }
            catch (Exception exception) {
                return "<EXCEPTION>";
            }
        }
        return val.toString();
    }

    protected IQueryDefinition getDefaultQueryDefn(String dataSetName) {
        return Util.instance.getDefaultQueryDefn(dataSetName);
    }

    protected IQueryDefinition getDefaultQueryDefnWithSubQuery(String dataSetName) {
        return Util.instance.getDefaultQueryDefnWithSubQuery(dataSetName);
    }

    protected BaseExpression[] getExpressionsOfDefaultQuery() {
        return Util.instance.getExpressionsOfDefaultQuery();
    }

    protected String[] getBindingExpressionName() {
        return Util.instance.getBindingExpressionName();
    }

    protected void populateQueryExprMapping(SubqueryDefinition subqueryDefn) {
        Util.instance.populateQueryExprMapping(subqueryDefn);
    }

    protected void createAndRunQuery(String[] bindingNameGroup, IBaseExpression[] bindingExprGroup, GroupDefinition[] groupDefn, String[] bindingNameSort, IBaseExpression[] bindingExprSort, SortDefinition[] sortDefn, String[] bindingNameFilter, IBaseExpression[] bindingExprFilter, FilterDefinition[] filterDefn, String[] bindingNameRow, IBaseExpression[] bindingExprRow) throws Exception {
        this.executeQuery(this.createQuery(bindingNameGroup, bindingExprGroup, groupDefn, bindingNameSort, bindingExprSort, sortDefn, bindingNameFilter, bindingExprFilter, filterDefn, bindingNameRow, bindingExprRow), bindingNameRow);
    }

    protected QueryDefinition createQuery(String[] bindingNameGroup, IBaseExpression[] bindingExprGroup, GroupDefinition[] groupDefn, String[] bindingNameSort, IBaseExpression[] bindingExprSort, SortDefinition[] sortDefn, String[] bindingNameFilter, IBaseExpression[] bindingExprFilter, FilterDefinition[] filterDefn, String[] bindingNameRow, IBaseExpression[] bindingExprRow) throws Exception {
        int i;
        QueryDefinition queryDefn = this.newReportQuery();
        if (groupDefn != null) {
            if (bindingNameGroup != null) {
                i = 0;
                while (i < bindingNameGroup.length) {
                    queryDefn.addResultSetExpression(bindingNameGroup[i], bindingExprGroup[i]);
                    ++i;
                }
            }
            i = 0;
            while (i < groupDefn.length) {
                queryDefn.addGroup(groupDefn[i]);
                ++i;
            }
        }
        if (sortDefn != null) {
            if (bindingNameSort != null) {
                i = 0;
                while (i < bindingNameSort.length) {
                    queryDefn.addResultSetExpression(bindingNameSort[i], bindingExprSort[i]);
                    ++i;
                }
            }
            i = 0;
            while (i < sortDefn.length) {
                queryDefn.addSort(sortDefn[i]);
                ++i;
            }
        }
        if (filterDefn != null) {
            if (bindingNameFilter != null) {
                i = 0;
                while (i < bindingNameFilter.length) {
                    queryDefn.addResultSetExpression(bindingNameFilter[i], bindingExprFilter[i]);
                    ++i;
                }
            }
            i = 0;
            while (i < filterDefn.length) {
                queryDefn.addFilter((IFilterDefinition)filterDefn[i]);
                ++i;
            }
        }
        if (bindingNameRow != null) {
            i = 0;
            while (i < bindingNameRow.length) {
                queryDefn.addResultSetExpression(bindingNameRow[i], bindingExprRow[i]);
                ++i;
            }
        }
        return queryDefn;
    }

    public String getOutputStrForFlatfileTest(int expectedLen, IResultSet result, int ColumnCount, String[] columnStr, int dateTypeColumnNum) throws Exception {
        StringBuffer sBuffer = new StringBuffer();
        String metaData = "";
        int i = 0;
        while (i < ColumnCount) {
            metaData = String.valueOf(metaData) + APITestCase.formatStr(columnStr[i], expectedLen);
            ++i;
        }
        sBuffer.append(metaData);
        sBuffer.append("\n");
        while (result.next()) {
            String rowData = "";
            int i2 = 1;
            while (i2 <= ColumnCount) {
                String value;
                if (result.getString(i2) != null) {
                    if (!result.getString(i2).equals("DATE") && dateTypeColumnNum == i2) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
                        value = sdf.format((Date)result.getDate(i2));
                    } else {
                        value = result.getString(i2);
                    }
                } else {
                    value = "";
                }
                rowData = String.valueOf(rowData) + APITestCase.formatStr(value, expectedLen);
                ++i2;
            }
            sBuffer.append(rowData);
            sBuffer.append("\n");
        }
        return new String(sBuffer);
    }

    public String getOutputStrForGroupTest(int expectedLen, QueryDefinition qd, int groupDefCount, String[] beArray, String[] columStr) throws Exception {
        StringBuffer sBuffer = new StringBuffer();
        IResultIterator ri = this.executeQuery((IQueryDefinition)qd);
        String metaData = "";
        int i = 0;
        while (i < columStr.length) {
            metaData = String.valueOf(metaData) + APITestCase.formatStr(columStr[i], expectedLen);
            ++i;
        }
        sBuffer.append(metaData);
        sBuffer.append("\n");
        int groupCount = groupDefCount;
        while (ri.next()) {
            String value;
            SimpleDateFormat sdf;
            int j;
            String rowData = "";
            int startLevel = ri.getStartingGroupLevel();
            if (startLevel <= groupCount) {
                if (startLevel == 0) {
                    startLevel = 1;
                }
                j = 0;
                while (j < startLevel - 1) {
                    rowData = String.valueOf(rowData) + APITestCase.formatStr("", expectedLen);
                    ++j;
                }
                j = startLevel - 1;
                while (j < beArray.length) {
                    if (ri.getValue(beArray[j]) != null) {
                        if (ri.getValue(beArray[j]) instanceof Date) {
                            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
                            value = sdf.format(ri.getValue(beArray[j]));
                        } else {
                            value = ri.getValue(beArray[j]).toString();
                        }
                    } else {
                        value = "null";
                    }
                    rowData = String.valueOf(rowData) + APITestCase.formatStr(value, expectedLen);
                    ++j;
                }
            } else {
                j = 0;
                while (j < groupCount) {
                    rowData = String.valueOf(rowData) + APITestCase.formatStr("", expectedLen);
                    ++j;
                }
                j = groupCount;
                while (j < beArray.length) {
                    if (ri.getValue(beArray[j]) instanceof Date) {
                        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
                        value = sdf.format(ri.getValue(beArray[j]));
                    } else {
                        value = ri.getValue(beArray[j]).toString();
                    }
                    rowData = String.valueOf(rowData) + APITestCase.formatStr(value, expectedLen);
                    ++j;
                }
            }
            sBuffer.append(rowData);
            sBuffer.append("\n");
        }
        return new String(sBuffer);
    }

    private static String formatStr(String inputStr, int length) {
        if (inputStr == null) {
            return null;
        }
        int inputLen = inputStr.length();
        if (inputLen >= length) {
            return inputStr;
        }
        int appendLen = length - inputLen;
        char[] appendChar = new char[appendLen];
        int i = 0;
        while (i < appendLen) {
            appendChar[i] = 32;
            ++i;
        }
        String result = String.valueOf(inputStr) + new String(appendChar);
        return result;
    }

    protected void copyResource(String src, String tgt, String folder) {
        InputStream in;
        String className = this.getFullQualifiedClassName();
        tgt = String.valueOf(className) + "/" + folder + "/" + tgt;
        className = className.replace('.', '/');
        src = String.valueOf(className) + "/" + folder + "/" + src;
        System.out.println("src: " + src);
        System.out.println("tgt: " + tgt);
        File parent = new File(tgt).getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        APITestCase.assertTrue(((in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(src)) != null ? 1 : 0) != 0);
        try {
            FileOutputStream fos = new FileOutputStream(tgt);
            byte[] fileData = new byte[5120];
            int readCount = -1;
            while ((readCount = in.read(fileData)) != -1) {
                fos.write(fileData, 0, readCount);
            }
            fos.close();
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            APITestCase.fail();
        }
    }

    protected void copyResource_INPUT(String input_resource, String input) {
        this.copyResource(input_resource, input, INPUT_FOLDER);
    }

    protected void copyResource_GOLDEN(String input_resource, String golden) {
        this.copyResource(input_resource, golden, GOLDEN_FOLDER);
    }

    public void removeFile(File file) {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                this.removeFile(children[i]);
                ++i;
            }
        }
        if (file.exists() && !file.delete()) {
            System.out.println(String.valueOf(file.toString()) + " can't be removed");
        }
    }

    protected String getFullQualifiedClassName() {
        String className = ((Object)((Object)this)).getClass().getName();
        int lastDotIndex = className.lastIndexOf(".");
        className = className.substring(0, lastDotIndex);
        return className;
    }

    public void removeResource() {
        String className = this.getFullQualifiedClassName();
        this.removeFile(className);
    }

    public void removeFile(String file) {
        this.removeFile(new File(file));
    }

    protected String genOutputFile(String output) {
        String outputFile;
        File fullpath;
        String tempDirgetFullQualifiedClassName;
        File path;
        String tempDir = System.getProperty("java.io.tmpdir");
        if (!tempDir.endsWith(File.separator)) {
            tempDir = String.valueOf(tempDir) + File.separator;
        }
        if ((path = new File(tempDirgetFullQualifiedClassName = String.valueOf(tempDir) + this.getFullQualifiedClassName())).exists()) {
            path.deleteOnExit();
        }
        if (!path.exists()) {
            path.mkdir();
        }
        if ((fullpath = new File(outputFile = String.valueOf(tempDir) + this.getFullQualifiedClassName() + "/" + OUTPUT_FOLDER + "/" + output)).exists()) {
            fullpath.delete();
        }
        return outputFile;
    }

    public class DataSourceInfo {
        private String tableName;
        private String createSql;
        private String dataFileName;

        public DataSourceInfo(String tableName, String createSql, String dataFileName) {
            this.tableName = tableName;
            this.createSql = createSql;
            this.dataFileName = dataFileName;
        }
    }

    private static class Util {
        private static Util instance = new Util();
        private static BaseExpression[] expressions;
        private static String[] bindingNameRow;

        private Util() {
        }

        protected IQueryDefinition getDefaultQueryDefn(String dataSetName) {
            String[] bindingNameGroup = new String[]{"GROUP_COL0", "GROUP_COL1", "GROUP_COL2"};
            IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COL0"), new ScriptExpression("dataSetRow.COL1"), new ScriptExpression("dataSetRow.COL2")};
            GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group1"), new GroupDefinition("group2"), new GroupDefinition("group3")};
            groupDefn[0].setKeyExpression("row.GROUP_COL0");
            groupDefn[1].setKeyExpression("row.GROUP_COL1");
            groupDefn[2].setKeyExpression("row.GROUP_COL2");
            String[] bindingNameSort = new String[]{"SORT_COL3"};
            IBaseExpression[] bindingExprSort = new IBaseExpression[]{new ScriptExpression("dataSetRow.COL3")};
            SortDefinition[] sortDefn = new SortDefinition[]{new SortDefinition()};
            sortDefn[0].setColumn("SORT_COL3");
            sortDefn[0].setSortDirection(0);
            bindingNameRow = new String[4];
            Util.bindingNameRow[0] = "ROW_COL0";
            Util.bindingNameRow[1] = "ROW_COL1";
            Util.bindingNameRow[2] = "ROW_COL2";
            Util.bindingNameRow[3] = "ROW_COL3";
            expressions = new BaseExpression[]{new ScriptExpression("dataSetRow.COL0", 0), new ScriptExpression("dataSetRow.COL1", 0), new ScriptExpression("dataSetRow.COL2", 0), new ScriptExpression("dataSetRow.COL3", 0)};
            return this.getQueryDefinition(bindingNameGroup, bindingExprGroup, groupDefn, bindingNameSort, bindingExprSort, sortDefn, null, null, null, bindingNameRow, (IBaseExpression[])expressions, dataSetName);
        }

        private QueryDefinition getQueryDefinition(String[] bindingNameGroup, IBaseExpression[] bindingExprGroup, GroupDefinition[] groupDefn, String[] bindingNameSort, IBaseExpression[] bindingExprSort, SortDefinition[] sortDefn, String[] bindingNameFilter, IBaseExpression[] bindingExprFilter, FilterDefinition[] filterDefn, String[] bindingNameRow, IBaseExpression[] bindingExprRow, String dataSetName) {
            int i;
            QueryDefinition queryDefn = new QueryDefinition();
            queryDefn.setDataSetName(dataSetName);
            if (groupDefn != null) {
                if (bindingNameGroup != null) {
                    i = 0;
                    while (i < bindingNameGroup.length) {
                        queryDefn.addResultSetExpression(bindingNameGroup[i], bindingExprGroup[i]);
                        ++i;
                    }
                }
                i = 0;
                while (i < groupDefn.length) {
                    queryDefn.addGroup(groupDefn[i]);
                    ++i;
                }
            }
            if (sortDefn != null) {
                if (bindingNameSort != null) {
                    i = 0;
                    while (i < bindingNameSort.length) {
                        queryDefn.addResultSetExpression(bindingNameSort[i], bindingExprSort[i]);
                        ++i;
                    }
                }
                i = 0;
                while (i < sortDefn.length) {
                    queryDefn.addSort(sortDefn[i]);
                    ++i;
                }
            }
            if (bindingNameRow != null) {
                i = 0;
                while (i < bindingNameRow.length) {
                    queryDefn.addResultSetExpression(bindingNameRow[i], (IBaseExpression)expressions[i]);
                    ++i;
                }
            }
            return queryDefn;
        }

        protected IQueryDefinition getDefaultQueryDefnWithSubQuery(String dataSetName) {
            IQueryDefinition queryDefn = this.getDefaultQueryDefn(dataSetName);
            GroupDefinition groupDefn = (GroupDefinition)queryDefn.getGroups().get(1);
            SubqueryDefinition subqueryDefn = new SubqueryDefinition("IAMTEST");
            groupDefn.addSubquery(subqueryDefn);
            String[] bindingNameGroup = new String[]{"GROUP_COL2"};
            IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COL2")};
            GroupDefinition[] subGroupDefn = new GroupDefinition[]{new GroupDefinition("group2")};
            subGroupDefn[0].setKeyExpression("row.GROUP_COL2");
            int k = 0;
            while (k < subGroupDefn.length) {
                int i;
                if (bindingNameGroup != null) {
                    i = 0;
                    while (i < bindingNameGroup.length) {
                        subqueryDefn.addResultSetExpression(bindingNameGroup[i], bindingExprGroup[i]);
                        ++i;
                    }
                }
                i = 0;
                while (i < subGroupDefn.length) {
                    subqueryDefn.addGroup(subGroupDefn[i]);
                    ++i;
                }
                ++k;
            }
            this.populateQueryExprMapping(subqueryDefn);
            SubqueryDefinition subSubqueryDefn = new SubqueryDefinition("IAMTEST2");
            subGroupDefn[0].addSubquery(subSubqueryDefn);
            bindingNameGroup = new String[]{"GROUP_COL3"};
            bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COL3")};
            GroupDefinition[] subSubGroupDefn = new GroupDefinition[]{new GroupDefinition("group3")};
            subSubGroupDefn[0].setKeyExpression("row.GROUP_COL3");
            int k2 = 0;
            while (k2 < subSubGroupDefn.length) {
                int i;
                if (bindingNameGroup != null) {
                    i = 0;
                    while (i < bindingNameGroup.length) {
                        subSubqueryDefn.addResultSetExpression(bindingNameGroup[i], bindingExprGroup[i]);
                        ++i;
                    }
                }
                i = 0;
                while (i < subSubGroupDefn.length) {
                    subSubqueryDefn.addGroup(subSubGroupDefn[i]);
                    ++i;
                }
                ++k2;
            }
            this.populateQueryExprMapping(subSubqueryDefn);
            return queryDefn;
        }

        protected void populateQueryExprMapping(SubqueryDefinition subqueryDefn) {
            int i = 0;
            while (i < bindingNameRow.length) {
                subqueryDefn.addResultSetExpression(bindingNameRow[i], (IBaseExpression)expressions[i]);
                ++i;
            }
        }

        protected BaseExpression[] getExpressionsOfDefaultQuery() {
            return expressions;
        }

        protected String[] getBindingExpressionName() {
            return bindingNameRow;
        }
    }
}

