/*
 * Decompiled with CFR 0.152.
 */
package testutil;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;

public class JDBCDataSourceUtil {
    private Connection conn;
    private PreparedStatement prepStmt;
    private List tableNameList = new ArrayList();
    private List procedureNameList = new ArrayList();

    JDBCDataSourceUtil() throws Exception {
        this.conn = this.createDBConnection();
        System.out.println("Test against JDBC database: url=" + JDBCDataSourceUtil.getURL() + " user=" + JDBCDataSourceUtil.getUser() + " driverClass=" + JDBCDataSourceUtil.getDriverClassName());
    }

    public void createTable(String tableName, String createSql, boolean dropTable) throws SQLException {
        if (tableName != null) {
            if (dropTable) {
                this.dropTable(tableName);
            }
            this.statementExecute(createSql);
            this.tableNameList.add(tableName);
        }
    }

    public void createStoredProcedure(String proName, String createSql, boolean dropProc) throws SQLException {
        if (proName != null) {
            if (dropProc) {
                this.dropStoredProcedure(proName);
            }
            this.statementExecute(createSql);
            this.procedureNameList.add(proName);
        }
    }

    public void populateTable(String testTableName, InputStream testTableDataFile) throws SQLException, IOException {
        String str;
        InputStreamReader inputFile = new InputStreamReader(testTableDataFile);
        BufferedReader lineReader = new BufferedReader(inputFile);
        lineReader.readLine();
        String metaData = lineReader.readLine();
        while ((str = lineReader.readLine()) != null) {
            if (str.charAt(0) == '#') continue;
            String sql = "insert into " + testTableName + " values(" + str + ")";
            boolean isBlob = false;
            String[] dataType = metaData.split(",");
            int i = 0;
            while (i < dataType.length) {
                dataType[i] = dataType[i].trim();
                if (dataType[i].toUpperCase().equals("BLOB")) {
                    isBlob = true;
                    break;
                }
                ++i;
            }
            if (!isBlob) {
                this.statementExecute(sql);
                continue;
            }
            Object[] ob = this.getPreparedData(testTableName, dataType, str);
            this.statementExecute((String)ob[0], (Object[])ob[1]);
        }
        lineReader.close();
        inputFile.close();
        testTableDataFile.close();
    }

    private Object[] getPreparedData(String testTableName, String[] dataType, String dataStr) {
        String replaceStr = "";
        int i = 0;
        while (i < dataType.length) {
            replaceStr = String.valueOf(replaceStr) + "?";
            if (i < dataType.length - 1) {
                replaceStr = String.valueOf(replaceStr) + ",";
            }
            ++i;
        }
        String insertSql = "insert into " + testTableName + " values(" + replaceStr + ")";
        Object[] value = new Object[dataType.length];
        String[] data = dataStr.split(",");
        int i2 = 0;
        while (i2 < dataType.length) {
            data[i2] = data[i2].trim();
            if (dataType[i2].toUpperCase().equals("INT")) {
                value[i2] = Integer.valueOf(data[i2]);
            } else if (dataType[i2].toUpperCase().equals("CLOB")) {
                value[i2] = data[i2];
            } else if (dataType[i2].toUpperCase().equals("BLOB")) {
                value[i2] = data[i2].toString().getBytes();
            } else {
                throw new IllegalArgumentException("");
            }
            ++i2;
        }
        return new Object[]{insertSql, value};
    }

    public void dropTable(String tableName) {
        String sql = "drop table " + tableName;
        try {
            this.statementExecute(sql);
            this.tableNameList.remove(tableName);
        }
        catch (SQLException sQLException) {}
    }

    public void dropStoredProcedure(String proName) {
        String sql = "drop procedure " + proName;
        try {
            this.statementExecute(sql);
            this.procedureNameList.remove(proName);
        }
        catch (SQLException sQLException) {}
    }

    private void statementExecute(String exeStr) throws SQLException {
        this.prepStmt = this.conn.prepareStatement(exeStr);
        this.prepStmt.execute();
    }

    private void statementExecute(String exeStr, Object[] value) throws SQLException {
        this.prepStmt = this.conn.prepareStatement(exeStr);
        int i = 0;
        while (i < value.length) {
            int pos = i + 1;
            if (value[i] instanceof Integer) {
                this.prepStmt.setInt(pos, (Integer)value[i]);
            } else if (value[i] instanceof String) {
                this.prepStmt.setString(pos, (String)value[i]);
            } else if (value[i] instanceof byte[]) {
                this.prepStmt.setBytes(pos, (byte[])value[i]);
            } else {
                throw new IllegalArgumentException("not support data type" + value[i].getClass().getName());
            }
            ++i;
        }
        this.prepStmt.execute();
    }

    public void close(boolean droptable) throws SQLException {
        if (this.conn != null) {
            if (this.prepStmt != null) {
                if (droptable) {
                    int i = 0;
                    while (i < this.tableNameList.size()) {
                        this.prepStmt = this.conn.prepareStatement("drop table " + this.tableNameList.get(i));
                        this.prepStmt.executeUpdate();
                        ++i;
                    }
                }
                this.prepStmt.close();
            }
            this.conn.close();
        }
    }

    private Connection createDBConnection() throws Exception {
        if (JDBCDataSourceUtil.getURL().startsWith("jdbc:derby")) {
            return this.createDerbyConnection();
        }
        this.loadJdbcDrivers();
        Properties props = new Properties();
        props.put("user", JDBCDataSourceUtil.getUser());
        props.put("password", JDBCDataSourceUtil.getPassword());
        return DriverManager.getConnection(JDBCDataSourceUtil.getURL(), props);
    }

    private Connection createDerbyConnection() throws Exception {
        Class.forName(JDBCDataSourceUtil.getDriverClassName());
        String nsURL = String.valueOf(JDBCDataSourceUtil.getURL()) + ";create=true";
        Properties props = new Properties();
        props.put("user", JDBCDataSourceUtil.getUser());
        props.put("password", JDBCDataSourceUtil.getPassword());
        return DriverManager.getConnection(nsURL, props);
    }

    static String getDriverClassName() {
        String clsName = System.getProperty("DTETest.driver");
        if (clsName == null) {
            clsName = "org.apache.derby.jdbc.EmbeddedDriver";
        }
        return clsName;
    }

    public static String getURL() {
        String url = System.getProperty("DTETest.url");
        if (url == null) {
            url = "jdbc:derby:" + System.getProperty("java.io.tmpdir") + File.separator + "DTETest";
        }
        return url;
    }

    static String getUser() {
        String user = System.getProperty("DTETest.user");
        if (user != null) {
            return user;
        }
        return "user";
    }

    static String getPassword() {
        String pwd = System.getProperty("DTETest.password");
        if (pwd != null) {
            return pwd;
        }
        return "password";
    }

    private void loadJdbcDrivers() throws Exception {
        try {
            if ("true".equals(System.getProperty("DTETest.otherDB"))) {
                File driverHomeDir = this.getDriverHomeDir();
                URL[] urlList = this.getDriverFileURLs(driverHomeDir);
                URLClassLoader urlClassLoader = new URLClassLoader(urlList, this.getClass().getClassLoader());
                Class<?> c = urlClassLoader.loadClass(JDBCDataSourceUtil.getDriverClassName());
                DriverExt driverExt = new DriverExt((Driver)c.newInstance());
                DriverManager.registerDriver(driverExt);
            } else {
                Class.forName(JDBCDataSourceUtil.getDriverClassName());
            }
        }
        catch (ClassNotFoundException e) {
            System.out.println("Due to licence issue, Driver lib for " + JDBCDataSourceUtil.getDriverClassName() + " can not be ");
            System.out.println("checked into Eclipse CVS. Please manually download this driver lib and put it ");
            System.out.println("into test\\plugins\\org.eclipse.birt.report.data.oda.jdbc\\drivers directory.");
            throw e;
        }
    }

    private File getDriverHomeDir() throws OdaException, IOException {
        File driverHomeDir = null;
        ExtensionManifest extMF = ManifestExplorer.getInstance().getExtensionManifest("org.eclipse.birt.report.data.oda.jdbc");
        if (extMF != null) {
            URL url = extMF.getRuntimeInterface().getLibraryLocation();
            try {
                URI uri = new URI(url.toString());
                driverHomeDir = new File(uri.getPath(), "drivers");
            }
            catch (URISyntaxException uRISyntaxException) {
                driverHomeDir = new File(url.getFile(), "drivers");
            }
        }
        return driverHomeDir;
    }

    private URL[] getDriverFileURLs(File driverHomeDir) throws MalformedURLException {
        String[] files = driverHomeDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return JDBCDataSourceUtil.this.isDriverFile(name);
            }
        });
        URL[] urls = new URL[files.length];
        int i = 0;
        while (i < files.length) {
            urls[i] = new URL("file", null, new File(driverHomeDir, files[i]).getAbsolutePath());
            ++i;
        }
        return urls;
    }

    private boolean isDriverFile(String fileName) {
        String lcName = fileName.toLowerCase();
        return lcName.endsWith(".jar") || lcName.endsWith(".zip");
    }

    private class DriverExt
    implements Driver {
        private Driver driver;

        DriverExt(Driver d) {
            this.driver = d;
        }

        @Override
        public boolean acceptsURL(String u) throws SQLException {
            return this.driver.acceptsURL(u);
        }

        @Override
        public Connection connect(String u, Properties p) throws SQLException {
            return this.driver.connect(u, p);
        }

        @Override
        public int getMajorVersion() {
            return this.driver.getMajorVersion();
        }

        @Override
        public int getMinorVersion() {
            return this.driver.getMinorVersion();
        }

        @Override
        public DriverPropertyInfo[] getPropertyInfo(String u, Properties p) throws SQLException {
            return this.driver.getPropertyInfo(u, p);
        }

        @Override
        public boolean jdbcCompliant() {
            return this.driver.jdbcCompliant();
        }
    }
}

