/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.APITestCase;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.BaseQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ColumnDefinition;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.JoinCondition;
import org.eclipse.birt.data.engine.api.querydefn.JointDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.ScriptDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.executor.DataSetCacheManager;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import testutil.ConfigText;

public class DataSetCacheTest
extends APITestCase {
    private List expectedValue;
    private String[] rowBeNames;
    private IBaseExpression[] rowBeArray;
    private String[] totalBeNames;
    private IBaseExpression[] totalBeArray;
    private DataEngineImpl dataEngine;
    Map appContextMap = new HashMap();
    private DataEngineImpl myDataEngine;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.expectedValue = new ArrayList();
        this.appContextMap.put(DataEngine.DATASET_CACHE_OPTION, "true");
        this.dataEngine = this.newDataEngine();
        this.dataEngine.clearCache((IBaseDataSourceDesign)this.dataSource, (IBaseDataSetDesign)this.dataSet);
    }

    @Override
    public void tearDown() throws Exception {
        this.getDataSetCacheManager(this.dataEngine).resetForTest();
        this.dataEngine.shutdown();
        if (this.myDataEngine != null) {
            this.myDataEngine.shutdown();
        }
        super.tearDown();
    }

    private DataSetCacheManager getDataSetCacheManager(DataEngineImpl dataEngine) {
        return dataEngine.getSession().getDataSetCacheManager();
    }

    @Override
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Api.TestData.TableName"), ConfigText.getString("Api.TestData.TableSQL"), ConfigText.getString("Api.TestData.TestDataFileName"));
    }

    public void testUseCache() throws BirtException {
        this.dataSet.setCacheRowCount(4);
        DataEngineImpl myDataEngine = this.newDataEngine();
        DataSetCacheTest.assertFalse((boolean)this.getDataSetCacheManager(myDataEngine).doesLoadFromCache());
        DataSetCacheTest.assertFalse((boolean)this.getDataSetCacheManager(myDataEngine).doesSaveToCache());
        QueryDefinition qd = this.newReportQuery();
        this.rowBeArray = this.getRowExpr();
        this.totalBeArray = this.getAggrExpr();
        this.prepareExprNameAndQuery(this.rowBeArray, this.totalBeArray, (BaseQueryDefinition)qd);
        IQueryResults qr = myDataEngine.prepare((IQueryDefinition)qd, this.appContextMap).execute(null);
        qr.getResultIterator().next();
        qr.close();
        DataSetCacheTest.assertTrue((boolean)this.getDataSetCacheManager(myDataEngine).doesLoadFromCache());
        DataSetCacheTest.assertFalse((boolean)this.getDataSetCacheManager(myDataEngine).doesSaveToCache());
        myDataEngine.shutdown();
    }

    public void testUseCacheWithMemoryCache() throws BirtException, IOException {
        int i;
        String str;
        HashMap<String, Integer> appContext = new HashMap<String, Integer>();
        appContext.put(DataEngine.MEMORY_DATA_SET_CACHE, 7);
        DataEngineImpl myDataEngine = this.newDataEngine();
        DataSetCacheTest.assertFalse((boolean)this.getDataSetCacheManager(myDataEngine).doesLoadFromCache());
        DataSetCacheTest.assertFalse((boolean)this.getDataSetCacheManager(myDataEngine).doesSaveToCache());
        QueryDefinition qd = this.newReportQuery();
        this.rowBeArray = this.getRowExpr();
        this.totalBeArray = this.getAggrExpr();
        this.prepareExprNameAndQuery(this.rowBeArray, this.totalBeArray, (BaseQueryDefinition)qd);
        IQueryResults qr = myDataEngine.prepare((IQueryDefinition)qd, appContext).execute(null);
        IResultIterator ri = qr.getResultIterator();
        while (ri.next()) {
            str = "";
            i = 0;
            while (i < this.rowBeNames.length) {
                str = String.valueOf(str) + ri.getValue(this.rowBeNames[i]);
                if (i < this.rowBeNames.length - 1) {
                    str = String.valueOf(str) + ", ";
                }
                ++i;
            }
            this.testPrintln(str);
        }
        ri.close();
        qr.close();
        this.testPrintln("##reset cache size##");
        appContext.put(DataEngine.MEMORY_DATA_SET_CACHE, 1);
        this.newReportQuery();
        this.rowBeArray = this.getRowExpr();
        this.totalBeArray = this.getAggrExpr();
        this.prepareExprNameAndQuery(this.rowBeArray, this.totalBeArray, (BaseQueryDefinition)qd);
        qr = myDataEngine.prepare((IQueryDefinition)qd, appContext).execute(null);
        DataSetCacheTest.assertTrue((boolean)this.getDataSetCacheManager(myDataEngine).doesLoadFromCache());
        DataSetCacheTest.assertFalse((boolean)this.getDataSetCacheManager(myDataEngine).doesSaveToCache());
        ri = qr.getResultIterator();
        while (ri.next()) {
            str = "";
            i = 0;
            while (i < this.rowBeNames.length) {
                str = String.valueOf(str) + ri.getValue(this.rowBeNames[i]);
                if (i < this.rowBeNames.length - 1) {
                    str = String.valueOf(str) + ", ";
                }
                ++i;
            }
            this.testPrintln(str);
        }
        this.checkOutputFile();
        ri.close();
        qr.close();
        myDataEngine.shutdown();
    }

    public void testClearCache() throws BirtException {
        this.dataSet.setCacheRowCount(4);
        DataEngineImpl myDataEngine = this.newDataEngine();
        DataSetCacheTest.assertFalse((boolean)this.getDataSetCacheManager(myDataEngine).doesLoadFromCache());
        DataSetCacheTest.assertFalse((boolean)this.getDataSetCacheManager(myDataEngine).doesSaveToCache());
        QueryDefinition qd = this.newReportQuery();
        this.rowBeArray = this.getRowExpr();
        this.totalBeArray = this.getAggrExpr();
        this.prepareExprNameAndQuery(this.rowBeArray, this.totalBeArray, (BaseQueryDefinition)qd);
        IQueryResults qr = myDataEngine.prepare((IQueryDefinition)qd, this.appContextMap).execute(null);
        qr.getResultIterator().next();
        qr.close();
        DataSetCacheTest.assertTrue((boolean)this.getDataSetCacheManager(myDataEngine).doesLoadFromCache());
        myDataEngine.clearCache((IBaseDataSourceDesign)this.dataSource, (IBaseDataSetDesign)this.dataSet);
        DataSetCacheTest.assertFalse((boolean)this.getDataSetCacheManager(myDataEngine).doesLoadFromCache());
        myDataEngine.shutdown();
    }

    public void testEnableCache() throws Exception {
        DataEngineImpl myDataEngine = this.newDataEngine();
        this.getDataSetCacheManager(myDataEngine).resetForTest();
        this.dataSet.setCacheRowCount(4);
        DataSetCacheTest.assertFalse((boolean)this.getDataSetCacheManager(myDataEngine).doesLoadFromCache());
        DataSetCacheTest.assertFalse((boolean)this.getDataSetCacheManager(myDataEngine).doesSaveToCache());
        QueryDefinition qd = this.newReportQuery();
        this.rowBeArray = this.getRowExpr();
        this.totalBeArray = this.getAggrExpr();
        this.prepareExprNameAndQuery(this.rowBeArray, this.totalBeArray, (BaseQueryDefinition)qd);
        IQueryResults qr = myDataEngine.prepare((IQueryDefinition)qd).execute(null);
        qr.getResultIterator().next();
        qr.close();
        DataSetCacheTest.assertFalse((boolean)this.getDataSetCacheManager(myDataEngine).doesLoadFromCache());
        DataSetCacheTest.assertFalse((boolean)this.getDataSetCacheManager(myDataEngine).doesSaveToCache());
        myDataEngine.shutdown();
    }

    public void testAlwaysCache() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        context.setCacheOption(3, 4);
        context.setTmpdir(DataSetCacheTest.getTempDir());
        DataEngineImpl myDataEngine2 = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        myDataEngine2.defineDataSource((IBaseDataSourceDesign)this.dataSource);
        myDataEngine2.defineDataSet((IBaseDataSetDesign)this.dataSet);
        QueryDefinition qd = this.newReportQuery();
        IQueryResults qr = myDataEngine2.prepare((IQueryDefinition)qd).execute(null);
        DataSetCacheTest.assertFalse((boolean)this.getDataSetCacheManager(myDataEngine2).doesLoadFromCache());
        qr.getResultIterator();
        DataSetCacheTest.assertTrue((boolean)this.getDataSetCacheManager(myDataEngine2).doesLoadFromCache());
        myDataEngine2.clearCache((IBaseDataSourceDesign)this.dataSource, (IBaseDataSetDesign)this.dataSet);
        qr.close();
        myDataEngine2.shutdown();
    }

    public void testSerializableJavaObjectCache() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        context.setCacheOption(3, 4);
        context.setTmpdir(DataSetCacheTest.getTempDir());
        DataEngineImpl myDataEngine2 = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        myDataEngine2.defineDataSource((IBaseDataSourceDesign)this.dataSource);
        myDataEngine2.defineDataSet((IBaseDataSetDesign)this.dataSet);
        QueryDefinition qd = this.newReportQuery();
        ScriptExpression se = new ScriptExpression("new java.lang.StringBuffer(\"ss\")");
        se.setDataType(11);
        Binding b = new Binding("serializable", (IBaseExpression)se);
        b.setDataType(11);
        qd.addBinding((IBinding)b);
        IQueryResults qr = myDataEngine2.prepare((IQueryDefinition)qd).execute(null);
        DataSetCacheTest.assertFalse((boolean)this.getDataSetCacheManager(myDataEngine2).doesLoadFromCache());
        qr.getResultIterator();
        DataSetCacheTest.assertTrue((boolean)this.getDataSetCacheManager(myDataEngine2).doesLoadFromCache());
        myDataEngine2.clearCache((IBaseDataSourceDesign)this.dataSource, (IBaseDataSetDesign)this.dataSet);
        qr.close();
        myDataEngine2.shutdown();
    }

    public void testUnserializableJavaObjectCache() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        context.setCacheOption(3, 4);
        context.setTmpdir(DataSetCacheTest.getTempDir());
        DataEngineImpl myDataEngine2 = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        myDataEngine2.defineDataSource((IBaseDataSourceDesign)this.dataSource);
        myDataEngine2.defineDataSet((IBaseDataSetDesign)this.dataSet);
        QueryDefinition qd = this.newReportQuery();
        ScriptExpression se = new ScriptExpression("new java.lang.ThreadGroup(\"ss\")");
        se.setDataType(11);
        Binding b = new Binding("unserializable", (IBaseExpression)se);
        b.setDataType(11);
        qd.addBinding((IBinding)b);
        IQueryResults qr = myDataEngine2.prepare((IQueryDefinition)qd).execute(null);
        DataSetCacheTest.assertFalse((boolean)this.getDataSetCacheManager(myDataEngine2).doesLoadFromCache());
        qr.getResultIterator();
        DataSetCacheTest.assertTrue((boolean)this.getDataSetCacheManager(myDataEngine2).doesLoadFromCache());
        myDataEngine2.clearCache((IBaseDataSourceDesign)this.dataSource, (IBaseDataSetDesign)this.dataSet);
        qr.close();
        myDataEngine2.shutdown();
    }

    public void testDisableCache() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        context.setCacheOption(2, 4);
        context.setTmpdir(DataSetCacheTest.getTempDir());
        DataEngineImpl myDataEngine2 = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        myDataEngine2.defineDataSource((IBaseDataSourceDesign)this.dataSource);
        myDataEngine2.defineDataSet((IBaseDataSetDesign)this.dataSet);
        QueryDefinition qd = this.newReportQuery();
        IQueryResults qr = myDataEngine2.prepare((IQueryDefinition)qd).execute(null);
        DataSetCacheTest.assertFalse((boolean)this.getDataSetCacheManager(myDataEngine2).doesLoadFromCache());
        qr.getResultIterator();
        DataSetCacheTest.assertFalse((boolean)this.getDataSetCacheManager(myDataEngine2).doesLoadFromCache());
        qr.close();
        myDataEngine2.shutdown();
    }

    public void testOdaCache() throws BirtException {
        this.genCache();
        this.useCache();
    }

    private void genCache() throws BirtException {
        this.dataSet.setCacheRowCount(4);
        DataEngineImpl myDataEngine = this.newDataEngine();
        IResultIterator ri = this.getResultIterator1((DataEngine)myDataEngine);
        while (ri.next()) {
            int i = 0;
            while (i < this.rowBeArray.length) {
                this.expectedValue.add(ri.getValue(this.rowBeNames[i]));
                ++i;
            }
            i = 0;
            while (i < this.totalBeArray.length) {
                this.expectedValue.add(ri.getValue(this.totalBeNames[i]));
                ++i;
            }
        }
        ri.close();
        myDataEngine.shutdown();
    }

    private void useCache() throws BirtException {
        DataEngineImpl myDataEngine = this.newDataEngine();
        IResultIterator ri = this.getResultIterator1((DataEngine)myDataEngine);
        this.checkResult(ri);
        ri.close();
        myDataEngine.shutdown();
    }

    public void testOdaCache2() throws BirtException {
        this.genCache();
        this.useCache3();
    }

    private void useCache3() throws BirtException {
        DataEngine myDataEngine = this.newDataEngine2();
        QueryDefinition qd = this.newReportQuery();
        GroupDefinition groupDefn = new GroupDefinition();
        groupDefn.setKeyExpression("row.COUNTRY1");
        qd.addGroup(groupDefn);
        groupDefn = new GroupDefinition();
        groupDefn.setKeyColumn("CITY1");
        qd.addGroup(groupDefn);
        this.rowBeArray = this.getRowExpr();
        this.totalBeArray = this.getAggrExpr();
        this.prepareExprNameAndQuery(this.rowBeArray, this.totalBeArray, (BaseQueryDefinition)qd);
        IQueryResults qr = myDataEngine.prepare((IQueryDefinition)qd, this.appContextMap).execute(null);
        DataSetCacheTest.assertTrue((qr.getResultMetaData() != null ? 1 : 0) != 0);
        IResultIterator ri = qr.getResultIterator();
        this.checkResult(ri);
        ri.close();
        myDataEngine.shutdown();
    }

    private IResultIterator getResultIterator1(DataEngine myDataEngine) throws BirtException {
        QueryDefinition qd = this.newReportQuery();
        GroupDefinition groupDefn = new GroupDefinition();
        groupDefn.setKeyExpression("row.COUNTRY1");
        qd.addGroup(groupDefn);
        groupDefn = new GroupDefinition();
        groupDefn.setKeyColumn("CITY1");
        qd.addGroup(groupDefn);
        this.rowBeArray = this.getRowExpr();
        this.totalBeArray = this.getAggrExpr();
        this.prepareExprNameAndQuery(this.rowBeArray, this.totalBeArray, (BaseQueryDefinition)qd);
        IQueryResults qr = myDataEngine.prepare((IQueryDefinition)qd, this.appContextMap).execute(null);
        DataSetCacheTest.assertTrue((qr.getResultMetaData() != null ? 1 : 0) != 0);
        return qr.getResultIterator();
    }

    public void testJointDataSetCache() throws Exception {
        QueryDefinition queryDefn = this.prepareForJointDataSet();
        this.prepareExprNameAndQuery(this.rowBeArray, this.totalBeArray, (BaseQueryDefinition)queryDefn);
        IPreparedQuery preparedQuery = this.myDataEngine.prepare((IQueryDefinition)queryDefn);
        IQueryResults qr = preparedQuery.execute(null);
        IResultIterator ri = qr.getResultIterator();
        while (ri.next()) {
            String s = "";
            int i = 0;
            while (i < this.rowBeArray.length) {
                s = String.valueOf(s) + ri.getValue(this.rowBeNames[i]);
                if (i != this.rowBeArray.length - 1) {
                    s = String.valueOf(s) + ", ";
                }
                ++i;
            }
            this.testPrintln(s);
        }
        qr.close();
        this.myDataEngine.shutdown();
        DataSetCacheTest.assertTrue((boolean)this.getDataSetCacheManager(this.myDataEngine).doesLoadFromCache());
        DataSetCacheTest.assertFalse((boolean)this.getDataSetCacheManager(this.myDataEngine).doesSaveToCache());
        this.checkOutputFile();
    }

    public void testJointDataSetCacheWithFilter() throws Exception {
        QueryDefinition queryDefn = this.prepareForJointDataSet();
        this.prepareExprNameAndQuery(this.rowBeArray, this.totalBeArray, (BaseQueryDefinition)queryDefn);
        IPreparedQuery preparedQuery = this.myDataEngine.prepare((IQueryDefinition)queryDefn);
        IQueryResults qr = preparedQuery.execute(null);
        IResultIterator ri = qr.getResultIterator();
        while (ri.next()) {
            int i = 0;
            while (i < this.rowBeArray.length) {
                ri.getValue(this.rowBeNames[i]);
                ++i;
            }
        }
        FilterDefinition filterDefn = new FilterDefinition((IBaseExpression)new ScriptExpression("dataSetRow[\"" + this.dataSet.getName() + "::COUNTRY\"]" + "==" + "\"CHINA\""));
        queryDefn.addFilter((IFilterDefinition)filterDefn);
        preparedQuery = this.myDataEngine.prepare((IQueryDefinition)queryDefn);
        qr = preparedQuery.execute(null);
        ri = qr.getResultIterator();
        while (ri.next()) {
            String s = "";
            int i = 0;
            while (i < this.rowBeArray.length) {
                s = String.valueOf(s) + ri.getValue(this.rowBeNames[i]);
                if (i != this.rowBeArray.length - 1) {
                    s = String.valueOf(s) + ", ";
                }
                ++i;
            }
            this.testPrintln(s);
        }
        this.myDataEngine.shutdown();
        this.checkOutputFile();
    }

    public void testJointDataSetCacheWithGroup() throws Exception {
        int i;
        String s;
        QueryDefinition queryDefn = this.prepareForJointDataSet();
        this.prepareExprNameAndQuery(this.rowBeArray, this.totalBeArray, (BaseQueryDefinition)queryDefn);
        IPreparedQuery preparedQuery = this.myDataEngine.prepare((IQueryDefinition)queryDefn);
        IQueryResults qr = preparedQuery.execute(null);
        IResultIterator ri = qr.getResultIterator();
        while (ri.next()) {
            int i2 = 0;
            while (i2 < this.rowBeArray.length) {
                ri.getValue(this.rowBeNames[i2]);
                ++i2;
            }
        }
        GroupDefinition gd = new GroupDefinition("G1");
        gd.setKeyExpression("row[\"" + this.dataSet.getName() + "::COUNTRY\"]");
        queryDefn.addGroup(gd);
        queryDefn.setAutoBinding(true);
        preparedQuery = this.myDataEngine.prepare((IQueryDefinition)queryDefn);
        qr = preparedQuery.execute(null);
        ri = qr.getResultIterator();
        while (ri.next()) {
            s = "";
            i = 0;
            while (i < this.rowBeArray.length) {
                s = String.valueOf(s) + ri.getValue(this.rowBeNames[i]);
                if (i != this.rowBeArray.length - 1) {
                    s = String.valueOf(s) + ", ";
                }
                ++i;
            }
            this.testPrintln(s);
        }
        gd = new GroupDefinition("G2");
        gd.setKeyExpression("row[\"" + this.dataSet.getName() + "::CITY\"]");
        queryDefn.addGroup(gd);
        preparedQuery = this.myDataEngine.prepare((IQueryDefinition)queryDefn);
        qr = preparedQuery.execute(null);
        ri = qr.getResultIterator();
        while (ri.next()) {
            s = "";
            i = 0;
            while (i < this.rowBeArray.length) {
                s = String.valueOf(s) + ri.getValue(this.rowBeNames[i]);
                if (i != this.rowBeArray.length - 1) {
                    s = String.valueOf(s) + ", ";
                }
                ++i;
            }
            this.testPrintln(s);
        }
        this.myDataEngine.shutdown();
        this.checkOutputFile();
    }

    public QueryDefinition prepareForJointDataSet() throws BirtException {
        OdaDataSetDesign dataSet2 = this.newDateSet((OdaDataSetDesign)this.dataSet);
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        context.setCacheOption(3, 400);
        context.setTmpdir(DataSetCacheTest.getTempDir());
        this.myDataEngine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        this.myDataEngine.defineDataSource((IBaseDataSourceDesign)this.dataSource);
        this.myDataEngine.defineDataSet((IBaseDataSetDesign)this.dataSet);
        this.myDataEngine.defineDataSet((IBaseDataSetDesign)dataSet2);
        ArrayList<JoinCondition> a = new ArrayList<JoinCondition>();
        a.add(new JoinCondition((IScriptExpression)new ScriptExpression("dataSetRow.CITY"), (IScriptExpression)new ScriptExpression("dataSetRow.CITY1"), 1));
        JointDataSetDesign dset3 = new JointDataSetDesign("dset13", this.dataSet.getName(), dataSet2.getName(), 1, a);
        this.myDataEngine.defineDataSet((IBaseDataSetDesign)dset3);
        QueryDefinition queryDefn = new QueryDefinition();
        queryDefn.setDataSetName(dset3.getName());
        int num = 4;
        this.rowBeArray = new IBaseExpression[num];
        this.rowBeArray[0] = new ScriptExpression("dataSetRow[\"" + this.dataSet.getName() + "::COUNTRY\"]");
        this.rowBeArray[1] = new ScriptExpression("dataSetRow[\"" + this.dataSet.getName() + "::CITY\"]");
        this.rowBeArray[2] = new ScriptExpression("dataSetRow[\"" + dataSet2.getName() + "::COUNTRY\"]");
        this.rowBeArray[3] = new ScriptExpression("dataSetRow[\"" + dataSet2.getName() + "::CITY1\"]");
        this.rowBeNames = new String[4];
        this.rowBeNames[0] = "COUNTRY3";
        this.rowBeNames[1] = "CITY3";
        this.rowBeNames[2] = "COUNTRY4";
        this.rowBeNames[3] = "CITY4";
        this.totalBeArray = new IBaseExpression[0];
        return queryDefn;
    }

    protected OdaDataSetDesign newDateSet(OdaDataSetDesign sDataSet) {
        OdaDataSetDesign copyDataSet = new OdaDataSetDesign(String.valueOf(sDataSet.getName()) + "1", sDataSet.getDataSourceName());
        copyDataSet.setEventHandler(sDataSet.getEventHandler());
        copyDataSet.setExtensionID(sDataSet.getExtensionID());
        copyDataSet.setQueryText("select COUNTRY, CITY as CITY1 " + sDataSet.getQueryText().substring(9));
        return copyDataSet;
    }

    public void testScriptedCache() throws BirtException {
        this.genCache2();
        this.useCache2();
    }

    private void genCache2() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        context.setCacheOption(3, 4);
        context.setTmpdir(DataSetCacheTest.getTempDir());
        DataEngine myDataEngine2 = DataEngine.newDataEngine((DataEngineContext)context);
        IResultIterator ri = this.getResultIterator2(myDataEngine2);
        while (ri.next()) {
            int i = 0;
            while (i < this.rowBeArray.length) {
                this.expectedValue.add(ri.getValue(this.rowBeNames[i]));
                ++i;
            }
        }
        ri.close();
        myDataEngine2.shutdown();
    }

    private void useCache2() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        context.setCacheOption(3, 4);
        context.setTmpdir(DataSetCacheTest.getTempDir());
        DataEngine myDataEngine2 = DataEngine.newDataEngine((DataEngineContext)context);
        IResultIterator ri = this.getResultIterator2(myDataEngine2);
        this.checkResult(ri);
        ri.close();
        myDataEngine2.shutdown();
    }

    private IResultIterator getResultIterator2(DataEngine myDataEngine2) throws BirtException {
        ScriptDataSourceDesign odaDataSource = new ScriptDataSourceDesign("JUST as place folder");
        ScriptDataSetDesign odaDataSet = new ScriptDataSetDesign("ScriptedDataSet");
        odaDataSet.setDataSource(odaDataSource.getName());
        odaDataSet.setOpenScript("count=100;");
        odaDataSet.setFetchScript("if (count==0) {return false; } else { row.NUM=count; row.SQUARE=count*count; row.STR=\"row#\" + count; --count; return true; }");
        String[] scriptColumnNames = new String[]{"NUM", "SQUARE", "STR"};
        int[] scriptColumnTypes = new int[]{2, 3, 5};
        int i = 0;
        while (i < scriptColumnNames.length) {
            ColumnDefinition colInfo = new ColumnDefinition(scriptColumnNames[i]);
            colInfo.setDataType(scriptColumnTypes[i]);
            odaDataSet.getResultSetHints().add(colInfo);
            ++i;
        }
        QueryDefinition queryDefinition = this.newReportQuery();
        queryDefinition.setDataSetName(odaDataSet.getName());
        this.rowBeArray = new IBaseExpression[3];
        ScriptExpression expr = new ScriptExpression("dataSetRow.NUM");
        this.rowBeArray[0] = expr;
        expr = new ScriptExpression("dataSetRow.SQUARE");
        this.rowBeArray[1] = expr;
        expr = new ScriptExpression("dataSetRow.STR");
        this.rowBeArray[2] = expr;
        this.rowBeNames = new String[3];
        this.rowBeNames[0] = "NUM1";
        this.rowBeNames[1] = "SQUARE1";
        this.rowBeNames[2] = "STR1";
        int i2 = 0;
        while (i2 < this.rowBeArray.length) {
            queryDefinition.addResultSetExpression(this.rowBeNames[i2], this.rowBeArray[i2]);
            ++i2;
        }
        myDataEngine2.defineDataSource((IBaseDataSourceDesign)odaDataSource);
        myDataEngine2.defineDataSet((IBaseDataSetDesign)odaDataSet);
        IQueryResults qr = myDataEngine2.prepare((IQueryDefinition)queryDefinition).execute(null);
        return qr.getResultIterator();
    }

    private DataEngineImpl newDataEngine() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        context.setTmpdir(DataSetCacheTest.getTempDir());
        DataEngineImpl myDataEngine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        OdaDataSetDesign odaDesign = new OdaDataSetDesign("Test DataSet2");
        odaDesign.setExtensionID(((OdaDataSetDesign)this.dataSet).getExtensionID());
        odaDesign.setQueryText(((OdaDataSetDesign)this.dataSet).getQueryText());
        myDataEngine.defineDataSource((IBaseDataSourceDesign)this.dataSource);
        myDataEngine.defineDataSet((IBaseDataSetDesign)this.dataSet);
        return myDataEngine;
    }

    private DataEngine newDataEngine2() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        context.setTmpdir(DataSetCacheTest.getTempDir());
        DataEngine myDataEngine = DataEngine.newDataEngine((DataEngineContext)context);
        myDataEngine.defineDataSource((IBaseDataSourceDesign)this.dataSource);
        OdaDataSetDesign odaDesign = new OdaDataSetDesign(this.dataSet.getName());
        odaDesign.setExtensionID(((OdaDataSetDesign)this.dataSet).getExtensionID());
        odaDesign.setQueryText(((OdaDataSetDesign)this.dataSet).getQueryText());
        odaDesign.setDataSource(this.dataSource.getName());
        odaDesign.setCacheRowCount(this.dataSet.getCacheRowCount());
        myDataEngine.defineDataSet((IBaseDataSetDesign)odaDesign);
        return myDataEngine;
    }

    private IBaseExpression[] getRowExpr() {
        int num = 4;
        IBaseExpression[] _rowBeArray = new IBaseExpression[num];
        _rowBeArray[0] = new ScriptExpression("dataSetRow.COUNTRY");
        _rowBeArray[1] = new ScriptExpression("dataSetRow.CITY");
        _rowBeArray[2] = new ScriptExpression("dataSetRow.SALE_DATE");
        _rowBeArray[3] = new ScriptExpression("dataSetRow.AMOUNT");
        this.rowBeNames = new String[num];
        this.rowBeNames[0] = "COUNTRY1";
        this.rowBeNames[1] = "CITY1";
        this.rowBeNames[2] = "SALE_DATE1";
        this.rowBeNames[3] = "AMOUNT1";
        return _rowBeArray;
    }

    private IBaseExpression[] getAggrExpr() {
        int num2 = 2;
        IBaseExpression[] _totalBeArray = new IBaseExpression[num2];
        _totalBeArray[0] = new ScriptExpression("Total.Count( )");
        _totalBeArray[1] = new ScriptExpression("Total.Sum( dataSetRow.AMOUNT )");
        this.totalBeNames = new String[num2];
        this.totalBeNames[0] = "Count( )";
        this.totalBeNames[1] = "Sum( )";
        return _totalBeArray;
    }

    private void prepareExprNameAndQuery(IBaseExpression[] rowBeArray, IBaseExpression[] totalBeArray, BaseQueryDefinition qd) {
        int num = rowBeArray.length;
        int num2 = totalBeArray.length;
        int i = 0;
        while (i < num) {
            qd.addResultSetExpression(this.rowBeNames[i], rowBeArray[i]);
            ++i;
        }
        i = 0;
        while (i < num2) {
            qd.addResultSetExpression(this.totalBeNames[i], totalBeArray[i]);
            ++i;
        }
    }

    private void checkResult(IResultIterator ri) throws BirtException {
        Iterator it = this.expectedValue.iterator();
        while (ri.next()) {
            Object ob2;
            Object ob1;
            String str = "";
            int i = 0;
            while (i < this.rowBeArray.length) {
                ob1 = it.next();
                ob2 = ri.getValue(this.rowBeNames[i]);
                DataSetCacheTest.assertEquals(ob1, (Object)ob2);
                str = String.valueOf(str) + " " + ob2.toString();
                ++i;
            }
            if (this.totalBeArray != null) {
                i = 0;
                while (i < this.totalBeArray.length) {
                    ob1 = it.next();
                    ob2 = ri.getValue(this.totalBeNames[i]);
                    DataSetCacheTest.assertEquals(ob1, (Object)ob2);
                    str = String.valueOf(str) + " " + ob2.toString();
                    ++i;
                }
            }
            System.out.println("row result set: " + str);
        }
    }
}

