/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.api;

import java.util.HashMap;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ColumnDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.ScriptDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import testutil.BaseTestCase;

public class DteLevelDataSetCacheTest
extends BaseTestCase {
    public void testDataSetWithDteLevelCache() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        context.setTmpdir(DteLevelDataSetCacheTest.getTempDir());
        DataEngine dataEngine = DataEngine.newDataEngine((DataEngineContext)context);
        ScriptDataSourceDesign dataSource = new ScriptDataSourceDesign("ds");
        dataSource.setOpenScript("i = 0;");
        ScriptDataSetDesign dataSet = new ScriptDataSetDesign("test");
        dataSet.setDataSource("ds");
        dataSet.addResultSetHint((IColumnDefinition)new ColumnDefinition("column1"));
        dataSet.setFetchScript(" i++; if ( i % 10 == 0 ) return false; row.column1 = i;return true;");
        dataEngine.defineDataSource((IBaseDataSourceDesign)dataSource);
        dataEngine.defineDataSet((IBaseDataSetDesign)dataSet);
        QueryDefinition qd = new QueryDefinition();
        qd.addBinding((IBinding)new Binding("column1", (IBaseExpression)new ScriptExpression("dataSetRow[\"column1\"]", 2)));
        qd.setDataSetName("test");
        QueryDefinition qd1 = new QueryDefinition();
        qd1.addBinding((IBinding)new Binding("column2", (IBaseExpression)new ScriptExpression("dataSetRow[\"column1\"]", 2)));
        qd1.setDataSetName("test");
        IDataQueryDefinition[] QueryDefinition2 = new IDataQueryDefinition[]{qd, qd1};
        dataEngine.registerQueries(QueryDefinition2);
        HashMap appContextMap = new HashMap();
        IResultIterator ri1 = dataEngine.prepare((IQueryDefinition)qd, appContextMap).execute(null).getResultIterator();
        IResultIterator ri2 = dataEngine.prepare((IQueryDefinition)qd1, appContextMap).execute(null).getResultIterator();
        DteLevelDataSetCacheTest.assertTrue((boolean)((DataEngineImpl)dataEngine).getSession().getDataSetCacheManager().doesLoadFromCache());
        while (ri1.next()) {
            DteLevelDataSetCacheTest.assertTrue((boolean)ri2.next());
            DteLevelDataSetCacheTest.assertEquals((Object)ri1.getValue("column1"), (Object)ri2.getValue("column2"));
        }
        dataEngine.shutdown();
    }

    public void testDataSetWithoutCache() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        context.setTmpdir(DteLevelDataSetCacheTest.getTempDir());
        DataEngine dataEngine = DataEngine.newDataEngine((DataEngineContext)context);
        ScriptDataSourceDesign dataSource = new ScriptDataSourceDesign("ds");
        dataSource.setOpenScript("i = 0;");
        ScriptDataSetDesign dataSet = new ScriptDataSetDesign("test");
        dataSet.setDataSource("ds");
        dataSet.addResultSetHint((IColumnDefinition)new ColumnDefinition("column1"));
        dataSet.setFetchScript(" i++; if ( i % 11 == 0 ) return false; row.column1 = i;return true;");
        dataEngine.defineDataSource((IBaseDataSourceDesign)dataSource);
        dataEngine.defineDataSet((IBaseDataSetDesign)dataSet);
        QueryDefinition qd = new QueryDefinition();
        qd.addBinding((IBinding)new Binding("column1", (IBaseExpression)new ScriptExpression("dataSetRow[\"column1\"]", 2)));
        qd.setDataSetName("test");
        HashMap appContextMap = new HashMap();
        IResultIterator ri1 = dataEngine.prepare((IQueryDefinition)qd, appContextMap).execute(null).getResultIterator();
        IResultIterator ri2 = dataEngine.prepare((IQueryDefinition)qd, appContextMap).execute(null).getResultIterator();
        DteLevelDataSetCacheTest.assertFalse((boolean)((DataEngineImpl)dataEngine).getSession().getDataSetCacheManager().doesLoadFromCache());
        while (ri1.next()) {
            DteLevelDataSetCacheTest.assertTrue((boolean)ri2.next());
            DteLevelDataSetCacheTest.assertEquals((int)((Integer)ri1.getValue("column1") + 1), (int)((Integer)ri2.getValue("column1")));
        }
        dataEngine.shutdown();
    }

    public void testDataSetWithJVMCache() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        context.setTmpdir(DteLevelDataSetCacheTest.getTempDir());
        DataEngine dataEngine = DataEngine.newDataEngine((DataEngineContext)context);
        ScriptDataSourceDesign dataSource = new ScriptDataSourceDesign("ds");
        dataSource.setOpenScript("i = 0;");
        ScriptDataSetDesign dataSet = new ScriptDataSetDesign("test");
        dataSet.setCacheRowCount(100);
        dataSet.setDataSource("ds");
        dataSet.addResultSetHint((IColumnDefinition)new ColumnDefinition("column1"));
        dataSet.setFetchScript(" i++; if ( i % 10 == 0 ) return false; row.column1 = i;return true;");
        dataEngine.defineDataSource((IBaseDataSourceDesign)dataSource);
        dataEngine.defineDataSet((IBaseDataSetDesign)dataSet);
        QueryDefinition qd = new QueryDefinition();
        qd.addBinding((IBinding)new Binding("column1", (IBaseExpression)new ScriptExpression("dataSetRow[\"column1\"]", 2)));
        qd.setDataSetName("test");
        HashMap<String, String> appContextMap = new HashMap<String, String>();
        appContextMap.put(DataEngine.DATA_SET_CACHE_ROW_LIMIT, "100");
        IResultIterator ri1 = dataEngine.prepare((IQueryDefinition)qd, appContextMap).execute(null).getResultIterator();
        IResultIterator ri2 = dataEngine.prepare((IQueryDefinition)qd, appContextMap).execute(null).getResultIterator();
        DteLevelDataSetCacheTest.assertTrue((boolean)((DataEngineImpl)dataEngine).getSession().getDataSetCacheManager().doesLoadFromCache());
        while (ri1.next()) {
            DteLevelDataSetCacheTest.assertTrue((boolean)ri2.next());
            DteLevelDataSetCacheTest.assertEquals((Object)ri1.getValue("column1"), (Object)ri2.getValue("column1"));
        }
        dataEngine.shutdown();
    }
}

