/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.api;

import java.util.ArrayList;
import org.eclipse.birt.core.archive.FileArchiveWriter;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.compound.ArchiveReader;
import org.eclipse.birt.data.engine.api.APITestCase;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import testutil.ConfigText;

public class NoUpdateAggrFilterTest
extends APITestCase {
    private DataEngine dte;
    private boolean consolePrint = true;

    @Override
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Api.TestNoUpdateFilter.TableName"), ConfigText.getString("Api.TestNoUpdateFilter.TableSQL"), ConfigText.getString("Api.TestNoUpdateFilter.TestDataFileName"));
    }

    protected QueryDefinition createQuery() throws DataException {
        QueryDefinition query = super.newReportQuery();
        query.addBinding((IBinding)new Binding("ID", (IBaseExpression)new ScriptExpression("dataSetRow[\"ID\"]")));
        query.addBinding((IBinding)new Binding("COUNTRY", (IBaseExpression)new ScriptExpression("dataSetRow[\"COUNTRY\"]")));
        query.addBinding((IBinding)new Binding("STATE", (IBaseExpression)new ScriptExpression("dataSetRow[\"STATE\"]")));
        query.addBinding((IBinding)new Binding("CITY", (IBaseExpression)new ScriptExpression("dataSetRow[\"CITY\"]")));
        query.addBinding((IBinding)new Binding("AMOUNT", (IBaseExpression)new ScriptExpression("dataSetRow[\"AMOUNT\"]")));
        GroupDefinition g1 = new GroupDefinition("G1");
        g1.setKeyExpression("row[\"COUNTRY\"]");
        query.addGroup(g1);
        GroupDefinition g2 = new GroupDefinition("G2");
        g2.setKeyExpression("row[\"STATE\"]");
        query.addGroup(g2);
        GroupDefinition g3 = new GroupDefinition("G3");
        g3.setKeyExpression("row[\"CITY\"]");
        query.addGroup(g3);
        SortDefinition sort = new SortDefinition();
        sort.setExpression("row[\"COUNTRY\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        sort.setExpression("row[\"STATE\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        sort.setExpression("row[\"CITY\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        return query;
    }

    public void testRowFilter1() throws Exception {
        QueryDefinition query = this.createQuery();
        Binding e5 = new Binding("CountG1");
        e5.setAggrFunction("COUNT");
        e5.addAggregateOn("G1");
        query.addBinding((IBinding)e5);
        Binding e6 = new Binding("CountG2");
        e6.setAggrFunction("COUNT");
        e6.addAggregateOn("G2");
        query.addBinding((IBinding)e6);
        Binding e7 = new Binding("CountG3");
        e7.setAggrFunction("COUNT");
        e7.addAggregateOn("G3");
        query.addBinding((IBinding)e7);
        Binding e81 = new Binding("SumAll", (IBaseExpression)new ScriptExpression("dataSetRow[\"AMOUNT\"]"));
        e81.setAggrFunction("SUM");
        query.addBinding((IBinding)e81);
        FilterDefinition f1 = new FilterDefinition((IBaseExpression)new ScriptExpression("row[\"AMOUNT\"] > 10"), false);
        query.addFilter((IFilterDefinition)f1);
        String[] exprs = new String[]{"ID", "COUNTRY", "STATE", "CITY", "AMOUNT", "CountG1", "CountG2", "CountG3", "SumAll"};
        this.outputQueryResult(this.executeQuery((IQueryDefinition)query), exprs);
        this.checkOutputFile();
    }

    public void testRowFilter2() throws Exception {
        QueryDefinition query = this.createQuery();
        Binding e5 = new Binding("CountG1");
        e5.setAggrFunction("COUNT");
        e5.addAggregateOn("G1");
        query.addBinding((IBinding)e5);
        Binding e6 = new Binding("CountG2");
        e6.setAggrFunction("COUNT");
        e6.addAggregateOn("G2");
        query.addBinding((IBinding)e6);
        Binding e7 = new Binding("CountG3");
        e7.setAggrFunction("COUNT");
        e7.addAggregateOn("G3");
        query.addBinding((IBinding)e7);
        Binding e81 = new Binding("SumAll", (IBaseExpression)new ScriptExpression("dataSetRow[\"AMOUNT\"]"));
        e81.setAggrFunction("SUM");
        query.addBinding((IBinding)e81);
        FilterDefinition f1 = new FilterDefinition((IBaseExpression)new ScriptExpression("row[\"CountG3\"] > 1"), false);
        query.addFilter((IFilterDefinition)f1);
        String[] exprs = new String[]{"ID", "COUNTRY", "STATE", "CITY", "AMOUNT", "CountG1", "CountG2", "CountG3", "SumAll"};
        this.outputQueryResult(this.executeQuery((IQueryDefinition)query), exprs);
        this.checkOutputFile();
    }

    public void testRowFilter3() throws Exception {
        QueryDefinition query = this.createQuery();
        Binding e5 = new Binding("CountG1");
        e5.setAggrFunction("COUNT");
        e5.addAggregateOn("G1");
        query.addBinding((IBinding)e5);
        Binding e6 = new Binding("CountG2");
        e6.setAggrFunction("COUNT");
        e6.addAggregateOn("G2");
        query.addBinding((IBinding)e6);
        Binding e7 = new Binding("CountG3");
        e7.setAggrFunction("COUNT");
        e7.addAggregateOn("G3");
        query.addBinding((IBinding)e7);
        Binding e81 = new Binding("SumAll", (IBaseExpression)new ScriptExpression("row[\"AMOUNT\"]"));
        e81.setAggrFunction("SUM");
        query.addBinding((IBinding)e81);
        Binding e9 = new Binding("TopN");
        e9.setAggrFunction("ISTOPN");
        e9.addAggregateOn("G2");
        e9.addArgument((IBaseExpression)new ScriptExpression("row[\"CountG3\"]"));
        e9.addArgument((IBaseExpression)new ScriptExpression("1"));
        query.addBinding((IBinding)e9);
        FilterDefinition f1 = new FilterDefinition((IBaseExpression)new ScriptExpression("row[\"TopN\"] == false"), false);
        query.addFilter((IFilterDefinition)f1);
        String[] exprs = new String[]{"ID", "COUNTRY", "STATE", "CITY", "AMOUNT", "CountG1", "CountG2", "CountG3", "SumAll", "TopN"};
        this.outputQueryResult(this.executeQuery((IQueryDefinition)query), exprs);
        this.checkOutputFile();
    }

    public void testRowFilter4() throws Exception {
        QueryDefinition query = this.createQuery();
        Binding e5 = new Binding("CountG1");
        e5.setAggrFunction("COUNT");
        e5.addAggregateOn("G1");
        query.addBinding((IBinding)e5);
        Binding e6 = new Binding("CountG2");
        e6.setAggrFunction("COUNT");
        e6.addAggregateOn("G2");
        query.addBinding((IBinding)e6);
        Binding e7 = new Binding("CountG3");
        e7.setAggrFunction("COUNT");
        e7.addAggregateOn("G3");
        query.addBinding((IBinding)e7);
        Binding e81 = new Binding("SumAll", (IBaseExpression)new ScriptExpression("row[\"AMOUNT\"]"));
        e81.setAggrFunction("SUM");
        query.addBinding((IBinding)e81);
        Binding e9 = new Binding("TopN");
        e9.setAggrFunction("ISTOPN");
        e9.addAggregateOn("G1");
        e9.addArgument((IBaseExpression)new ScriptExpression("row[\"CountG3\"]"));
        e9.addArgument((IBaseExpression)new ScriptExpression("1"));
        query.addBinding((IBinding)e9);
        FilterDefinition f1 = new FilterDefinition((IBaseExpression)new ScriptExpression("row[\"TopN\"] == true"), false);
        query.addFilter((IFilterDefinition)f1);
        FilterDefinition f2 = new FilterDefinition((IBaseExpression)new ScriptExpression("row[\"COUNTRY\"] != \"China\""), false);
        query.addFilter((IFilterDefinition)f2);
        FilterDefinition f3 = new FilterDefinition((IBaseExpression)new ScriptExpression("row[\"ID\"] > 15"), false);
        query.addFilter((IFilterDefinition)f3);
        String[] exprs = new String[]{"ID", "COUNTRY", "STATE", "CITY", "AMOUNT", "CountG1", "CountG2", "CountG3", "SumAll", "TopN"};
        this.outputQueryResult(this.executeQuery((IQueryDefinition)query), exprs);
        this.checkOutputFile();
    }

    public void testRowFilter5() throws Exception {
        QueryDefinition query = this.createQuery();
        Binding e5 = new Binding("CountG1");
        e5.setAggrFunction("COUNT");
        e5.addAggregateOn("G1");
        query.addBinding((IBinding)e5);
        Binding e6 = new Binding("CountG2");
        e6.setAggrFunction("COUNT");
        e6.addAggregateOn("G2");
        query.addBinding((IBinding)e6);
        Binding e7 = new Binding("CountG3");
        e7.setAggrFunction("COUNT");
        e7.addAggregateOn("G3");
        query.addBinding((IBinding)e7);
        Binding e81 = new Binding("SumAll", (IBaseExpression)new ScriptExpression("row[\"AMOUNT\"]"));
        e81.setAggrFunction("SUM");
        query.addBinding((IBinding)e81);
        Binding e9 = new Binding("TopN");
        e9.setAggrFunction("ISTOPN");
        e9.addAggregateOn("G1");
        e9.addArgument((IBaseExpression)new ScriptExpression("row[\"CountG3\"]"));
        e9.addArgument((IBaseExpression)new ScriptExpression("1"));
        query.addBinding((IBinding)e9);
        FilterDefinition f1 = new FilterDefinition((IBaseExpression)new ScriptExpression("row[\"TopN\"] == true"), false);
        query.addFilter((IFilterDefinition)f1);
        FilterDefinition f2 = new FilterDefinition((IBaseExpression)new ScriptExpression("row[\"COUNTRY\"] != \"China\""), false);
        query.addFilter((IFilterDefinition)f2);
        FilterDefinition f3 = new FilterDefinition((IBaseExpression)new ScriptExpression("row[\"ID\"] > 15"), false);
        query.addFilter((IFilterDefinition)f3);
        FilterDefinition f4 = new FilterDefinition((IBaseExpression)new ScriptExpression("row[\"CountG3\"] < 1"), false);
        query.addFilter((IFilterDefinition)f4);
        String[] exprs = new String[]{"ID", "COUNTRY", "STATE", "CITY", "AMOUNT", "CountG1", "CountG2", "CountG3", "SumAll", "TopN"};
        this.outputQueryResult(this.executeQuery((IQueryDefinition)query), exprs);
        this.checkOutputFile();
    }

    public void testRowFilter6() throws Exception {
        QueryDefinition query = this.createQuery();
        Binding e5 = new Binding("CountG1");
        e5.setAggrFunction("COUNT");
        e5.addAggregateOn("G1");
        query.addBinding((IBinding)e5);
        Binding e6 = new Binding("CountG2");
        e6.setAggrFunction("COUNT");
        e6.addAggregateOn("G2");
        query.addBinding((IBinding)e6);
        Binding e7 = new Binding("CountG3");
        e7.setAggrFunction("COUNT");
        e7.addAggregateOn("G3");
        query.addBinding((IBinding)e7);
        Binding e81 = new Binding("SumCity", (IBaseExpression)new ScriptExpression("dataSetRow[\"AMOUNT\"]"));
        e81.setAggrFunction("SUM");
        e81.addAggregateOn("G3");
        query.addBinding((IBinding)e81);
        FilterDefinition f1 = new FilterDefinition((IBaseExpression)new ConditionalExpression("row[\"AMOUNT\"]", 14, "1"), false);
        query.addFilter((IFilterDefinition)f1);
        String[] exprs = new String[]{"ID", "COUNTRY", "STATE", "CITY", "AMOUNT", "CountG1", "CountG2", "CountG3", "SumCity"};
        this.outputQueryResult(this.executeQuery((IQueryDefinition)query), exprs);
        this.checkOutputFile();
    }

    public void testRowFilter7() throws Exception {
        QueryDefinition query = this.createQuery();
        Binding e5 = new Binding("CountG1");
        e5.setAggrFunction("COUNT");
        e5.addAggregateOn("G1");
        query.addBinding((IBinding)e5);
        Binding e6 = new Binding("CountG2");
        e6.setAggrFunction("COUNT");
        e6.addAggregateOn("G2");
        query.addBinding((IBinding)e6);
        Binding e7 = new Binding("CountG3");
        e7.setAggrFunction("COUNT");
        e7.addAggregateOn("G3");
        query.addBinding((IBinding)e7);
        Binding e81 = new Binding("SumCity", (IBaseExpression)new ScriptExpression("dataSetRow[\"AMOUNT\"]"));
        e81.setAggrFunction("SUM");
        e81.addAggregateOn("G3");
        query.addBinding((IBinding)e81);
        FilterDefinition f1 = new FilterDefinition((IBaseExpression)new ConditionalExpression("row[\"AMOUNT\"]", 14, "1"), false);
        query.addFilter((IFilterDefinition)f1);
        ArrayList<String> operandList = new ArrayList<String>();
        operandList.add("\"China\"");
        FilterDefinition f2 = new FilterDefinition((IBaseExpression)new ConditionalExpression("row[\"COUNTRY\"]", 22, operandList), false);
        query.addFilter((IFilterDefinition)f2);
        String[] exprs = new String[]{"ID", "COUNTRY", "STATE", "CITY", "AMOUNT", "CountG1", "CountG2", "CountG3", "SumCity"};
        this.outputQueryResult(this.executeQuery((IQueryDefinition)query), exprs);
        this.checkOutputFile();
    }

    public void testGroupFilter1() throws Exception {
        QueryDefinition query = super.newReportQuery();
        query.addBinding((IBinding)new Binding("ID", (IBaseExpression)new ScriptExpression("dataSetRow[\"ID\"]")));
        query.addBinding((IBinding)new Binding("COUNTRY", (IBaseExpression)new ScriptExpression("dataSetRow[\"COUNTRY\"]")));
        query.addBinding((IBinding)new Binding("STATE", (IBaseExpression)new ScriptExpression("dataSetRow[\"STATE\"]")));
        query.addBinding((IBinding)new Binding("CITY", (IBaseExpression)new ScriptExpression("dataSetRow[\"CITY\"]")));
        query.addBinding((IBinding)new Binding("AMOUNT", (IBaseExpression)new ScriptExpression("dataSetRow[\"AMOUNT\"]")));
        GroupDefinition g1 = new GroupDefinition("G1");
        g1.setKeyExpression("row[\"COUNTRY\"]");
        query.addGroup(g1);
        g1.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ScriptExpression("row[\"CITY\"] != \"Beijing\""), false));
        GroupDefinition g2 = new GroupDefinition("G2");
        g2.setKeyExpression("row[\"STATE\"]");
        query.addGroup(g2);
        g2.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ScriptExpression("row[\"STATE\"] != \"Scotland\""), false));
        GroupDefinition g3 = new GroupDefinition("G3");
        g3.setKeyExpression("row[\"CITY\"]");
        query.addGroup(g3);
        g3.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ScriptExpression("row[\"CITY\"] != \"Los Angeles\""), false));
        g3.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ScriptExpression("row[\"CITY\"] != \"Washington\""), false));
        SortDefinition sort = new SortDefinition();
        sort.setExpression("row[\"COUNTRY\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        sort.setExpression("row[\"STATE\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        sort.setExpression("row[\"CITY\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        Binding e5 = new Binding("CountG1");
        e5.setAggrFunction("COUNT");
        e5.addAggregateOn("G1");
        query.addBinding((IBinding)e5);
        Binding e6 = new Binding("CountG2");
        e6.setAggrFunction("COUNT");
        e6.addAggregateOn("G2");
        query.addBinding((IBinding)e6);
        Binding e7 = new Binding("CountG3");
        e7.setAggrFunction("COUNT");
        e7.addAggregateOn("G3");
        query.addBinding((IBinding)e7);
        Binding e81 = new Binding("SumAll", (IBaseExpression)new ScriptExpression("row[\"AMOUNT\"]"));
        e81.setAggrFunction("SUM");
        query.addBinding((IBinding)e81);
        Binding e9 = new Binding("TopN");
        e9.setAggrFunction("ISTOPN");
        e9.addAggregateOn("G1");
        e9.addArgument((IBaseExpression)new ScriptExpression("row[\"CountG3\"]"));
        e9.addArgument((IBaseExpression)new ScriptExpression("1"));
        query.addBinding((IBinding)e9);
        String[] exprs = new String[]{"ID", "COUNTRY", "STATE", "CITY", "AMOUNT", "CountG1", "CountG2", "CountG3", "SumAll", "TopN"};
        this.outputQueryResult(this.executeQuery((IQueryDefinition)query), exprs);
        this.checkOutputFile();
    }

    public void testGroupFilter2() throws Exception {
        QueryDefinition query = super.newReportQuery();
        query.addBinding((IBinding)new Binding("ID", (IBaseExpression)new ScriptExpression("dataSetRow[\"ID\"]")));
        query.addBinding((IBinding)new Binding("COUNTRY", (IBaseExpression)new ScriptExpression("dataSetRow[\"COUNTRY\"]")));
        query.addBinding((IBinding)new Binding("STATE", (IBaseExpression)new ScriptExpression("dataSetRow[\"STATE\"]")));
        query.addBinding((IBinding)new Binding("CITY", (IBaseExpression)new ScriptExpression("dataSetRow[\"CITY\"]")));
        query.addBinding((IBinding)new Binding("AMOUNT", (IBaseExpression)new ScriptExpression("dataSetRow[\"AMOUNT\"]")));
        GroupDefinition g1 = new GroupDefinition("G1");
        g1.setKeyExpression("row[\"COUNTRY\"]");
        query.addGroup(g1);
        g1.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ScriptExpression("row[\"COUNTRY\"] == \"China\""), false));
        GroupDefinition g2 = new GroupDefinition("G2");
        g2.setKeyExpression("row[\"STATE\"]");
        query.addGroup(g2);
        g2.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ScriptExpression("row[\"STATE\"] != \"Scotland\""), false));
        GroupDefinition g3 = new GroupDefinition("G3");
        g3.setKeyExpression("row[\"CITY\"]");
        query.addGroup(g3);
        g3.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ScriptExpression("row[\"CITY\"] != \"Los Angeles\""), false));
        g3.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ScriptExpression("row[\"CITY\"] != \"Washington\""), false));
        SortDefinition sort = new SortDefinition();
        sort.setExpression("row[\"COUNTRY\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        sort.setExpression("row[\"STATE\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        sort.setExpression("row[\"CITY\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        Binding e5 = new Binding("CountG1");
        e5.setAggrFunction("COUNT");
        e5.addAggregateOn("G1");
        query.addBinding((IBinding)e5);
        Binding e6 = new Binding("CountG2");
        e6.setAggrFunction("COUNT");
        e6.addAggregateOn("G2");
        query.addBinding((IBinding)e6);
        Binding e7 = new Binding("CountG3");
        e7.setAggrFunction("COUNT");
        e7.addAggregateOn("G3");
        query.addBinding((IBinding)e7);
        Binding e81 = new Binding("SumAll", (IBaseExpression)new ScriptExpression("row[\"AMOUNT\"]"));
        e81.setAggrFunction("SUM");
        query.addBinding((IBinding)e81);
        Binding e9 = new Binding("TopN");
        e9.setAggrFunction("ISTOPN");
        e9.addAggregateOn("G1");
        e9.addArgument((IBaseExpression)new ScriptExpression("row[\"CountG3\"]"));
        e9.addArgument((IBaseExpression)new ScriptExpression("1"));
        query.addBinding((IBinding)e9);
        String[] exprs = new String[]{"ID", "COUNTRY", "STATE", "CITY", "AMOUNT", "CountG1", "CountG2", "CountG3", "SumAll", "TopN"};
        this.outputQueryResult(this.executeQuery((IQueryDefinition)query), exprs);
        this.checkOutputFile();
    }

    public void testGroupFilter3() throws Exception {
        QueryDefinition query = super.newReportQuery();
        query.addBinding((IBinding)new Binding("ID", (IBaseExpression)new ScriptExpression("dataSetRow[\"ID\"]")));
        query.addBinding((IBinding)new Binding("COUNTRY", (IBaseExpression)new ScriptExpression("dataSetRow[\"COUNTRY\"]")));
        query.addBinding((IBinding)new Binding("STATE", (IBaseExpression)new ScriptExpression("dataSetRow[\"STATE\"]")));
        query.addBinding((IBinding)new Binding("CITY", (IBaseExpression)new ScriptExpression("dataSetRow[\"CITY\"]")));
        query.addBinding((IBinding)new Binding("AMOUNT", (IBaseExpression)new ScriptExpression("dataSetRow[\"AMOUNT\"]")));
        GroupDefinition g1 = new GroupDefinition("G1");
        g1.setKeyExpression("row[\"COUNTRY\"]");
        query.addGroup(g1);
        GroupDefinition g2 = new GroupDefinition("G2");
        g2.setKeyExpression("row[\"STATE\"]");
        query.addGroup(g2);
        g2.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ConditionalExpression("row[\"SumAll\"]", 15, "1"), false));
        GroupDefinition g3 = new GroupDefinition("G3");
        g3.setKeyExpression("row[\"CITY\"]");
        query.addGroup(g3);
        SortDefinition sort = new SortDefinition();
        sort.setExpression("row[\"COUNTRY\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        sort.setExpression("row[\"STATE\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        sort.setExpression("row[\"CITY\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        Binding e5 = new Binding("CountG1");
        e5.setAggrFunction("COUNT");
        e5.addAggregateOn("G1");
        query.addBinding((IBinding)e5);
        Binding e6 = new Binding("CountG2");
        e6.setAggrFunction("COUNT");
        e6.addAggregateOn("G2");
        query.addBinding((IBinding)e6);
        Binding e7 = new Binding("CountG3");
        e7.setAggrFunction("COUNT");
        e7.addAggregateOn("G3");
        query.addBinding((IBinding)e7);
        Binding e81 = new Binding("SumAll", (IBaseExpression)new ScriptExpression("row[\"AMOUNT\"]"));
        e81.setAggrFunction("SUM");
        e81.addAggregateOn("G2");
        query.addBinding((IBinding)e81);
        Binding e9 = new Binding("TopN");
        e9.setAggrFunction("ISBOTTOMN");
        e9.addAggregateOn("G1");
        e9.addArgument((IBaseExpression)new ScriptExpression("row[\"SumAll\"]"));
        e9.addArgument((IBaseExpression)new ScriptExpression("1"));
        query.addBinding((IBinding)e9);
        String[] exprs = new String[]{"ID", "COUNTRY", "STATE", "CITY", "AMOUNT", "CountG1", "CountG2", "CountG3", "SumAll", "TopN"};
        this.outputQueryResult(this.executeQuery((IQueryDefinition)query), exprs);
        this.checkOutputFile();
    }

    public void testGroupFilter4() throws Exception {
        QueryDefinition query = super.newReportQuery();
        query.addBinding((IBinding)new Binding("ID", (IBaseExpression)new ScriptExpression("dataSetRow[\"ID\"]")));
        query.addBinding((IBinding)new Binding("COUNTRY", (IBaseExpression)new ScriptExpression("dataSetRow[\"COUNTRY\"]")));
        query.addBinding((IBinding)new Binding("STATE", (IBaseExpression)new ScriptExpression("dataSetRow[\"STATE\"]")));
        query.addBinding((IBinding)new Binding("CITY", (IBaseExpression)new ScriptExpression("dataSetRow[\"CITY\"]")));
        query.addBinding((IBinding)new Binding("AMOUNT", (IBaseExpression)new ScriptExpression("dataSetRow[\"AMOUNT\"]")));
        GroupDefinition g1 = new GroupDefinition("G1");
        g1.setKeyExpression("row[\"COUNTRY\"]");
        query.addGroup(g1);
        GroupDefinition g2 = new GroupDefinition("G2");
        g2.setKeyExpression("row[\"STATE\"]");
        query.addGroup(g2);
        GroupDefinition g3 = new GroupDefinition("G3");
        g3.setKeyExpression("row[\"CITY\"]");
        query.addGroup(g3);
        g3.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ScriptExpression("row[\"SumAll\"] < 53"), false));
        SortDefinition sort = new SortDefinition();
        sort.setExpression("row[\"COUNTRY\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        sort.setExpression("row[\"STATE\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        sort.setExpression("row[\"CITY\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        Binding e5 = new Binding("CountG1");
        e5.setAggrFunction("COUNT");
        e5.addAggregateOn("G1");
        query.addBinding((IBinding)e5);
        Binding e6 = new Binding("CountG2");
        e6.setAggrFunction("COUNT");
        e6.addAggregateOn("G2");
        query.addBinding((IBinding)e6);
        Binding e7 = new Binding("CountG3");
        e7.setAggrFunction("COUNT");
        e7.addAggregateOn("G3");
        query.addBinding((IBinding)e7);
        Binding e81 = new Binding("SumAll", (IBaseExpression)new ScriptExpression("row[\"AMOUNT\"]"));
        e81.setAggrFunction("SUM");
        e81.addAggregateOn("G2");
        query.addBinding((IBinding)e81);
        Binding e9 = new Binding("TopN");
        e9.setAggrFunction("ISBOTTOMN");
        e9.addAggregateOn("G1");
        e9.addArgument((IBaseExpression)new ScriptExpression("row[\"SumAll\"]"));
        e9.addArgument((IBaseExpression)new ScriptExpression("1"));
        query.addBinding((IBinding)e9);
        String[] exprs = new String[]{"ID", "COUNTRY", "STATE", "CITY", "AMOUNT", "CountG1", "CountG2", "CountG3", "SumAll", "TopN"};
        this.outputQueryResult(this.executeQuery((IQueryDefinition)query), exprs);
        this.checkOutputFile();
    }

    public void testGroupFilter5() throws Exception {
        QueryDefinition query = super.newReportQuery();
        query.addBinding((IBinding)new Binding("ID", (IBaseExpression)new ScriptExpression("dataSetRow[\"ID\"]")));
        query.addBinding((IBinding)new Binding("COUNTRY", (IBaseExpression)new ScriptExpression("dataSetRow[\"COUNTRY\"]")));
        query.addBinding((IBinding)new Binding("STATE", (IBaseExpression)new ScriptExpression("dataSetRow[\"STATE\"]")));
        query.addBinding((IBinding)new Binding("CITY", (IBaseExpression)new ScriptExpression("dataSetRow[\"CITY\"]")));
        query.addBinding((IBinding)new Binding("AMOUNT", (IBaseExpression)new ScriptExpression("dataSetRow[\"AMOUNT\"]")));
        GroupDefinition g1 = new GroupDefinition("G1");
        g1.setKeyExpression("row[\"COUNTRY\"]");
        query.addGroup(g1);
        GroupDefinition g2 = new GroupDefinition("G2");
        g2.setKeyExpression("row[\"STATE\"]");
        query.addGroup(g2);
        g2.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ScriptExpression("row[\"TopN\"] == false"), false));
        GroupDefinition g3 = new GroupDefinition("G3");
        g3.setKeyExpression("row[\"CITY\"]");
        query.addGroup(g3);
        g3.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ConditionalExpression("row[\"AMOUNT\"]", 14, "2"), false));
        SortDefinition sort = new SortDefinition();
        sort.setExpression("row[\"COUNTRY\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        sort.setExpression("row[\"STATE\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        sort.setExpression("row[\"CITY\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        Binding e5 = new Binding("CountG1");
        e5.setAggrFunction("COUNT");
        e5.addAggregateOn("G1");
        query.addBinding((IBinding)e5);
        Binding e6 = new Binding("CountG2");
        e6.setAggrFunction("COUNT");
        e6.addAggregateOn("G2");
        query.addBinding((IBinding)e6);
        Binding e7 = new Binding("CountG3");
        e7.setAggrFunction("COUNT");
        e7.addAggregateOn("G3");
        query.addBinding((IBinding)e7);
        Binding e81 = new Binding("SumAll", (IBaseExpression)new ScriptExpression("row[\"AMOUNT\"]"));
        e81.setAggrFunction("SUM");
        e81.addAggregateOn("G1");
        query.addBinding((IBinding)e81);
        Binding e9 = new Binding("TopN");
        e9.setAggrFunction("ISTOPN");
        e9.addArgument((IBaseExpression)new ScriptExpression("row[\"SumAll\"]"));
        e9.addArgument((IBaseExpression)new ScriptExpression("1"));
        query.addBinding((IBinding)e9);
        String[] exprs = new String[]{"ID", "COUNTRY", "STATE", "CITY", "AMOUNT", "CountG1", "CountG2", "CountG3", "SumAll", "TopN"};
        this.outputQueryResult(this.executeQuery((IQueryDefinition)query), exprs);
        this.checkOutputFile();
    }

    public void testGroupFilter6() throws Exception {
        QueryDefinition query = super.newReportQuery();
        query.addBinding((IBinding)new Binding("ID", (IBaseExpression)new ScriptExpression("dataSetRow[\"ID\"]")));
        query.addBinding((IBinding)new Binding("COUNTRY", (IBaseExpression)new ScriptExpression("dataSetRow[\"COUNTRY\"]")));
        query.addBinding((IBinding)new Binding("STATE", (IBaseExpression)new ScriptExpression("dataSetRow[\"STATE\"]")));
        query.addBinding((IBinding)new Binding("CITY", (IBaseExpression)new ScriptExpression("dataSetRow[\"CITY\"]")));
        query.addBinding((IBinding)new Binding("AMOUNT", (IBaseExpression)new ScriptExpression("dataSetRow[\"AMOUNT\"]")));
        GroupDefinition g1 = new GroupDefinition("G1");
        g1.setKeyExpression("row[\"COUNTRY\"]");
        query.addGroup(g1);
        GroupDefinition g2 = new GroupDefinition("G2");
        g2.setKeyExpression("row[\"STATE\"]");
        query.addGroup(g2);
        g2.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ScriptExpression("row[\"TopN\"] == false"), false));
        GroupDefinition g3 = new GroupDefinition("G3");
        g3.setKeyExpression("row[\"CITY\"]");
        query.addGroup(g3);
        g3.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ConditionalExpression("row[\"AMOUNT\"]", 14, "2"), false));
        SortDefinition sort = new SortDefinition();
        sort.setExpression("row[\"COUNTRY\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        sort.setExpression("row[\"STATE\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        sort.setExpression("row[\"CITY\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        Binding e5 = new Binding("CountG1");
        e5.setAggrFunction("COUNT");
        e5.addAggregateOn("G1");
        query.addBinding((IBinding)e5);
        Binding e6 = new Binding("CountG2");
        e6.setAggrFunction("COUNT");
        e6.addAggregateOn("G2");
        query.addBinding((IBinding)e6);
        Binding e7 = new Binding("CountG3");
        e7.setAggrFunction("COUNT");
        e7.addAggregateOn("G3");
        query.addBinding((IBinding)e7);
        Binding e81 = new Binding("SumAll", (IBaseExpression)new ScriptExpression("row[\"AMOUNT\"]"));
        e81.setAggrFunction("SUM");
        e81.addAggregateOn("G1");
        query.addBinding((IBinding)e81);
        Binding e9 = new Binding("TopN");
        e9.setAggrFunction("ISTOPN");
        e9.addArgument((IBaseExpression)new ScriptExpression("row[\"SumAll\"]"));
        e9.addArgument((IBaseExpression)new ScriptExpression("1"));
        query.addBinding((IBinding)e9);
        FilterDefinition f1 = new FilterDefinition((IBaseExpression)new ConditionalExpression("row[\"AMOUNT\"]", 14, "3"), false);
        query.addFilter((IFilterDefinition)f1);
        String[] exprs = new String[]{"ID", "COUNTRY", "STATE", "CITY", "AMOUNT", "CountG1", "CountG2", "CountG3", "SumAll", "TopN"};
        this.outputQueryResult(this.executeQuery((IQueryDefinition)query), exprs);
        this.checkOutputFile();
    }

    public void testGroupFilter7() throws Exception {
        QueryDefinition query = super.newReportQuery();
        query.addBinding((IBinding)new Binding("ID", (IBaseExpression)new ScriptExpression("dataSetRow[\"ID\"]")));
        query.addBinding((IBinding)new Binding("COUNTRY", (IBaseExpression)new ScriptExpression("dataSetRow[\"COUNTRY\"]")));
        query.addBinding((IBinding)new Binding("STATE", (IBaseExpression)new ScriptExpression("dataSetRow[\"STATE\"]")));
        query.addBinding((IBinding)new Binding("CITY", (IBaseExpression)new ScriptExpression("dataSetRow[\"CITY\"]")));
        query.addBinding((IBinding)new Binding("AMOUNT", (IBaseExpression)new ScriptExpression("dataSetRow[\"AMOUNT\"]")));
        GroupDefinition g1 = new GroupDefinition("G1");
        g1.setKeyExpression("row[\"COUNTRY\"]");
        query.addGroup(g1);
        g1.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ConditionalExpression("row[\"SumAll\"]", 14, "2"), false));
        GroupDefinition g2 = new GroupDefinition("G2");
        g2.setKeyExpression("row[\"STATE\"]");
        query.addGroup(g2);
        g2.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ConditionalExpression("row[\"CountG2\"]", 14, "2"), false));
        GroupDefinition g3 = new GroupDefinition("G3");
        g3.setKeyExpression("row[\"CITY\"]");
        query.addGroup(g3);
        g3.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ConditionalExpression("row[\"CountG3\"]", 14, "1"), false));
        SortDefinition sort = new SortDefinition();
        sort.setExpression("row[\"COUNTRY\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        sort.setExpression("row[\"STATE\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        sort.setExpression("row[\"CITY\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        Binding e5 = new Binding("CountG1");
        e5.setAggrFunction("COUNT");
        e5.addAggregateOn("G1");
        query.addBinding((IBinding)e5);
        Binding e6 = new Binding("CountG2");
        e6.setAggrFunction("COUNT");
        e6.addAggregateOn("G2");
        query.addBinding((IBinding)e6);
        Binding e7 = new Binding("CountG3");
        e7.setAggrFunction("COUNT");
        e7.addAggregateOn("G3");
        query.addBinding((IBinding)e7);
        Binding e81 = new Binding("SumAll", (IBaseExpression)new ScriptExpression("row[\"AMOUNT\"]"));
        e81.setAggrFunction("SUM");
        e81.addAggregateOn("G1");
        query.addBinding((IBinding)e81);
        Binding e9 = new Binding("TopN");
        e9.setAggrFunction("ISTOPN");
        e9.addArgument((IBaseExpression)new ScriptExpression("row[\"SumAll\"]"));
        e9.addArgument((IBaseExpression)new ScriptExpression("1"));
        query.addBinding((IBinding)e9);
        FilterDefinition f1 = new FilterDefinition((IBaseExpression)new ConditionalExpression("row[\"AMOUNT\"]", 14, "2"), false);
        query.addFilter((IFilterDefinition)f1);
        FilterDefinition f2 = new FilterDefinition((IBaseExpression)new ConditionalExpression("row[\"TopN\"]", 11), false);
        query.addFilter((IFilterDefinition)f2);
        String[] exprs = new String[]{"ID", "COUNTRY", "STATE", "CITY", "AMOUNT", "CountG1", "CountG2", "CountG3", "SumAll", "TopN"};
        this.outputQueryResult(this.executeQuery((IQueryDefinition)query), exprs);
        this.checkOutputFile();
    }

    public void testGroupFilter8() throws Exception {
        QueryDefinition query = super.newReportQuery();
        query.addBinding((IBinding)new Binding("ID", (IBaseExpression)new ScriptExpression("dataSetRow[\"ID\"]")));
        query.addBinding((IBinding)new Binding("COUNTRY", (IBaseExpression)new ScriptExpression("dataSetRow[\"COUNTRY\"]")));
        query.addBinding((IBinding)new Binding("STATE", (IBaseExpression)new ScriptExpression("dataSetRow[\"STATE\"]")));
        query.addBinding((IBinding)new Binding("CITY", (IBaseExpression)new ScriptExpression("dataSetRow[\"CITY\"]")));
        query.addBinding((IBinding)new Binding("AMOUNT", (IBaseExpression)new ScriptExpression("dataSetRow[\"AMOUNT\"]")));
        GroupDefinition g1 = new GroupDefinition("G1");
        g1.setKeyExpression("row[\"COUNTRY\"]");
        query.addGroup(g1);
        GroupDefinition g2 = new GroupDefinition("G2");
        g2.setKeyExpression("row[\"STATE\"]");
        query.addGroup(g2);
        GroupDefinition g3 = new GroupDefinition("G3");
        g3.setKeyExpression("row[\"CITY\"]");
        query.addGroup(g3);
        g3.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ScriptExpression("row[\"SumAll\"] < 100"), false));
        FilterDefinition f1 = new FilterDefinition((IBaseExpression)new ConditionalExpression("row[\"SumAll\"]", 14, "1"), false);
        query.addFilter((IFilterDefinition)f1);
        SortDefinition sort = new SortDefinition();
        sort.setExpression("row[\"COUNTRY\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        sort.setExpression("row[\"STATE\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        sort.setExpression("row[\"CITY\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        Binding e5 = new Binding("CountG1");
        e5.setAggrFunction("COUNT");
        e5.addAggregateOn("G1");
        query.addBinding((IBinding)e5);
        Binding e6 = new Binding("CountG2");
        e6.setAggrFunction("COUNT");
        e6.addAggregateOn("G2");
        query.addBinding((IBinding)e6);
        Binding e7 = new Binding("CountG3");
        e7.setAggrFunction("COUNT");
        e7.addAggregateOn("G3");
        query.addBinding((IBinding)e7);
        Binding e81 = new Binding("SumAll", (IBaseExpression)new ScriptExpression("row[\"AMOUNT\"]"));
        e81.setAggrFunction("SUM");
        e81.addAggregateOn("G2");
        query.addBinding((IBinding)e81);
        Binding e9 = new Binding("TopN");
        e9.setAggrFunction("ISBOTTOMN");
        e9.addAggregateOn("G1");
        e9.addArgument((IBaseExpression)new ScriptExpression("row[\"SumAll\"]"));
        e9.addArgument((IBaseExpression)new ScriptExpression("1"));
        query.addBinding((IBinding)e9);
        String[] exprs = new String[]{"ID", "COUNTRY", "STATE", "CITY", "AMOUNT", "CountG1", "CountG2", "CountG3", "SumAll", "TopN"};
        this.outputQueryResult(this.executeQuery((IQueryDefinition)query), exprs);
        this.checkOutputFile();
    }

    public void testGroupFilter9() throws Exception {
        QueryDefinition query = super.newReportQuery();
        query.addBinding((IBinding)new Binding("ID", (IBaseExpression)new ScriptExpression("dataSetRow[\"ID\"]")));
        query.addBinding((IBinding)new Binding("COUNTRY", (IBaseExpression)new ScriptExpression("dataSetRow[\"COUNTRY\"]")));
        query.addBinding((IBinding)new Binding("STATE", (IBaseExpression)new ScriptExpression("dataSetRow[\"STATE\"]")));
        query.addBinding((IBinding)new Binding("CITY", (IBaseExpression)new ScriptExpression("dataSetRow[\"CITY\"]")));
        query.addBinding((IBinding)new Binding("AMOUNT", (IBaseExpression)new ScriptExpression("dataSetRow[\"AMOUNT\"]")));
        GroupDefinition g1 = new GroupDefinition("G1");
        g1.setKeyExpression("row[\"COUNTRY\"]");
        query.addGroup(g1);
        GroupDefinition g2 = new GroupDefinition("G2");
        g2.setKeyExpression("row[\"STATE\"]");
        query.addGroup(g2);
        GroupDefinition g3 = new GroupDefinition("G3");
        g3.setKeyExpression("row[\"CITY\"]");
        query.addGroup(g3);
        g3.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ScriptExpression("row[\"SumAll\"] < 100")));
        FilterDefinition f1 = new FilterDefinition((IBaseExpression)new ConditionalExpression("row[\"SumAll\"]", 14, "1"), false);
        query.addFilter((IFilterDefinition)f1);
        SortDefinition sort = new SortDefinition();
        sort.setExpression("row[\"COUNTRY\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        sort.setExpression("row[\"STATE\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        sort.setExpression("row[\"CITY\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        Binding e5 = new Binding("CountG1");
        e5.setAggrFunction("COUNT");
        e5.addAggregateOn("G1");
        query.addBinding((IBinding)e5);
        Binding e6 = new Binding("CountG2");
        e6.setAggrFunction("COUNT");
        e6.addAggregateOn("G2");
        query.addBinding((IBinding)e6);
        Binding e7 = new Binding("CountG3");
        e7.setAggrFunction("COUNT");
        e7.addAggregateOn("G3");
        query.addBinding((IBinding)e7);
        Binding e81 = new Binding("SumAll", (IBaseExpression)new ScriptExpression("row[\"AMOUNT\"]"));
        e81.setAggrFunction("SUM");
        e81.addAggregateOn("G2");
        query.addBinding((IBinding)e81);
        Binding e9 = new Binding("TopN");
        e9.setAggrFunction("ISBOTTOMN");
        e9.addAggregateOn("G1");
        e9.addArgument((IBaseExpression)new ScriptExpression("row[\"SumAll\"]"));
        e9.addArgument((IBaseExpression)new ScriptExpression("1"));
        query.addBinding((IBinding)e9);
        String[] exprs = new String[]{"ID", "COUNTRY", "STATE", "CITY", "AMOUNT", "CountG1", "CountG2", "CountG3", "SumAll", "TopN"};
        this.outputQueryResult(this.executeQuery((IQueryDefinition)query), exprs);
        this.checkOutputFile();
    }

    public void testIV1() throws Exception {
        String fileName = NoUpdateAggrFilterTest.getOutputFolder() + "testIV1";
        FileArchiveWriter writer = new FileArchiveWriter(fileName);
        writer.initialize();
        DataEngineContext dteContext = DataEngineContext.newInstance((int)1, null, null, (IDocArchiveWriter)writer);
        dteContext.setTmpdir(NoUpdateAggrFilterTest.getTempDir());
        DataEngine dte = DataEngine.newDataEngine((DataEngineContext)dteContext);
        dte.defineDataSource((IBaseDataSourceDesign)this.dataSource);
        dte.defineDataSet((IBaseDataSetDesign)this.dataSet);
        String[] exprs = new String[]{"ID", "COUNTRY", "STATE", "CITY", "AMOUNT", "CountG1", "CountG2", "CountG3", "SumAll"};
        QueryDefinition query = this.getIVQueryDefn();
        FilterDefinition f1 = new FilterDefinition((IBaseExpression)new ScriptExpression("row[\"CountG3\"] > 1"), false);
        query.addFilter((IFilterDefinition)f1);
        IPreparedQuery preparedQuery = dte.prepare((IQueryDefinition)query, this.getAppContext());
        IQueryResults queryResults = preparedQuery.execute(null);
        queryResults.getID();
        this.iteratorQueryResult(queryResults, exprs);
        dte.shutdown();
        ArchiveReader reader = new ArchiveReader(writer.getArchive());
        dteContext = DataEngineContext.newInstance((int)4, null, (IDocArchiveReader)reader, (IDocArchiveWriter)writer);
        dteContext.setTmpdir(NoUpdateAggrFilterTest.getTempDir());
        dte = DataEngine.newDataEngine((DataEngineContext)dteContext);
        dte.defineDataSource((IBaseDataSourceDesign)this.dataSource);
        dte.defineDataSet((IBaseDataSetDesign)this.dataSet);
        query = this.getIVQueryDefn();
        f1 = new FilterDefinition((IBaseExpression)new ScriptExpression("row[\"CountG3\"] > 1"), false);
        query.addFilter((IFilterDefinition)f1);
        FilterDefinition f2 = new FilterDefinition((IBaseExpression)new ScriptExpression("row[\"CountG2\"] > 3"), false);
        query.addFilter((IFilterDefinition)f2);
        query.setQueryResultsID(queryResults.getID());
        preparedQuery = dte.prepare((IQueryDefinition)query, this.getAppContext());
        queryResults = preparedQuery.execute(null);
        this.iteratorQueryResult(queryResults, exprs);
        dte.shutdown();
        reader = new ArchiveReader(writer.getArchive());
        dteContext = DataEngineContext.newInstance((int)4, null, (IDocArchiveReader)reader, (IDocArchiveWriter)writer);
        dteContext.setTmpdir(NoUpdateAggrFilterTest.getTempDir());
        dte = DataEngine.newDataEngine((DataEngineContext)dteContext);
        dte.defineDataSource((IBaseDataSourceDesign)this.dataSource);
        dte.defineDataSet((IBaseDataSetDesign)this.dataSet);
        query = this.getIVQueryDefn();
        f1 = new FilterDefinition((IBaseExpression)new ScriptExpression("row[\"CountG3\"] > 1"), false);
        query.addFilter((IFilterDefinition)f1);
        f2 = new FilterDefinition((IBaseExpression)new ScriptExpression("row[\"CountG2\"] > 3"), false);
        query.addFilter((IFilterDefinition)f2);
        FilterDefinition f3 = new FilterDefinition((IBaseExpression)new ScriptExpression("row[\"CountG1\"] > 6"), false);
        query.addFilter((IFilterDefinition)f3);
        query.setQueryResultsID(queryResults.getID());
        preparedQuery = dte.prepare((IQueryDefinition)query, this.getAppContext());
        queryResults = preparedQuery.execute(null);
        this.outputQueryResult(queryResults.getResultIterator(), exprs);
        dte.shutdown();
        this.checkOutputFile();
    }

    private QueryDefinition getIVQueryDefn() throws Exception {
        QueryDefinition query = this.createQuery();
        Binding e5 = new Binding("CountG1");
        e5.setAggrFunction("COUNT");
        e5.addAggregateOn("G1");
        query.addBinding((IBinding)e5);
        Binding e6 = new Binding("CountG2");
        e6.setAggrFunction("COUNT");
        e6.addAggregateOn("G2");
        query.addBinding((IBinding)e6);
        Binding e7 = new Binding("CountG3");
        e7.setAggrFunction("COUNT");
        e7.addAggregateOn("G3");
        query.addBinding((IBinding)e7);
        Binding e81 = new Binding("SumAll", (IBaseExpression)new ScriptExpression("dataSetRow[\"AMOUNT\"]"));
        e81.setAggrFunction("SUM");
        query.addBinding((IBinding)e81);
        return query;
    }

    private void iteratorQueryResult(IQueryResults queryResults, String[] exprs) throws Exception {
        if (this.consolePrint) {
            System.out.println("####### Temporary query result #######");
        }
        IResultIterator itr = queryResults.getResultIterator();
        while (itr.next()) {
            if (!this.consolePrint) continue;
            int i = 0;
            while (i < exprs.length) {
                System.out.print(this.evalAsString(exprs[i], itr));
                System.out.print("    ");
                ++i;
            }
            System.out.println();
        }
        itr.close();
        queryResults.close();
    }
}

