/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.api;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IInputParameterBinding;
import org.eclipse.birt.data.engine.api.IParameterDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.InputParameterBinding;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.ParameterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import testutil.BaseTestCase;

public class OutputParamManualTest
extends BaseTestCase {
    private String url = "jdbc:jtds:sqlserver://linzhu:1433/pubs";
    private String driverClass = "net.sourceforge.jtds.jdbc.Driver";
    private String user = "sa";
    private String password = "sa";
    private String queryText = "{call sumTitle(?,?)}";
    private OdaDataSourceDesign odaDataSource;
    private OdaDataSetDesign odaDataSet;
    private QueryDefinition queryDefinition;
    private String[] expressionName;
    private IBaseExpression[] expressionArray;
    private static final String JDBC_DATA_SOURCE_TYPE = "org.eclipse.birt.report.data.oda.jdbc";
    private static final String JDBC_DATA_SET_TYPE = "org.eclipse.birt.report.data.oda.jdbc.SPSelectDataSet";

    private IBaseDataSourceDesign getDataSource() throws Exception {
        if (this.odaDataSource != null) {
            return this.odaDataSource;
        }
        this.odaDataSource = new OdaDataSourceDesign("Test Data Source");
        this.odaDataSource.setExtensionID(JDBC_DATA_SOURCE_TYPE);
        this.odaDataSource.addPublicProperty("odaURL", this.url);
        this.odaDataSource.addPublicProperty("odaDriverClass", this.driverClass);
        this.odaDataSource.addPublicProperty("odaUser", this.user);
        this.odaDataSource.addPublicProperty("odaPassword", this.password);
        return this.odaDataSource;
    }

    private IBaseDataSetDesign getDataSet() throws Exception {
        if (this.odaDataSet != null) {
            return this.odaDataSet;
        }
        this.odaDataSet = new OdaDataSetDesign("Test Data Set");
        this.odaDataSet.setDataSource(this.getDataSource().getName());
        this.odaDataSet.setExtensionID(JDBC_DATA_SET_TYPE);
        this.odaDataSet.setQueryText(this.queryText);
        ParameterDefinition pd1 = new ParameterDefinition("param1", 5, true, false);
        pd1.setPosition(1);
        ParameterDefinition pd2 = new ParameterDefinition("@@param2", 4, true, true);
        pd2.setPosition(2);
        InputParameterBinding pb1 = new InputParameterBinding("param1", (IBaseExpression)new ScriptExpression("'%'"));
        InputParameterBinding pb2 = new InputParameterBinding("@@param2", (IBaseExpression)new ScriptExpression("1"));
        this.odaDataSet.addParameter((IParameterDefinition)pd1);
        this.odaDataSet.addParameter((IParameterDefinition)pd2);
        this.odaDataSet.addInputParamBinding((IInputParameterBinding)pb1);
        this.odaDataSet.addInputParamBinding((IInputParameterBinding)pb2);
        return this.odaDataSet;
    }

    private QueryDefinition getQueryDefn() throws Exception {
        if (this.queryDefinition != null) {
            return this.queryDefinition;
        }
        this.queryDefinition = new QueryDefinition();
        this.queryDefinition.setDataSetName(this.getDataSet().getName());
        this.expressionArray = new IBaseExpression[2];
        this.expressionName = new String[2];
        this.expressionName[0] = "_outputParams1";
        ScriptExpression expr = new ScriptExpression("outputParams[1]");
        this.expressionArray[0] = expr;
        this.expressionName[1] = "_outputParams2";
        expr = new ScriptExpression("outputParams[\"@@param2\"]");
        this.expressionArray[1] = expr;
        int i = 0;
        while (i < this.expressionArray.length) {
            this.queryDefinition.addResultSetExpression(this.expressionName[i], this.expressionArray[i]);
            ++i;
        }
        return this.queryDefinition;
    }

    private IBaseExpression[] getExprArray() {
        return this.expressionArray;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("BIRT_HOME", "./test");
        System.setProperty("PROPERTY_RUN_UNDER_ECLIPSE", "false");
        Platform.startup(null);
    }

    public void testOutputParameter() throws BirtException, Exception {
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        context.setTmpdir(OutputParamManualTest.getTempDir());
        DataEngine de = DataEngine.newDataEngine((DataEngineContext)context);
        de.defineDataSource(this.getDataSource());
        de.defineDataSet(this.getDataSet());
        IPreparedQuery pq = de.prepare((IQueryDefinition)this.getQueryDefn());
        IQueryResults qr = pq.execute(null);
        IBaseExpression[] bes = this.getExprArray();
        IResultIterator ri = qr.getResultIterator();
        ri.next();
        int i = 0;
        while (i < bes.length) {
            Object ob = ri.getValue(this.expressionName[i]);
            OutputParamManualTest.assertTrue((ob != null ? 1 : 0) != 0);
            System.out.println(ob);
            ++i;
        }
        ri.close();
        qr.close();
        de.shutdown();
    }
}

