/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.api;

import java.util.HashMap;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ColumnDefinition;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.ScriptDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import testutil.BaseTestCase;

public class ProgressiveViewingTest
extends BaseTestCase {
    public void testProgressiveViewing1() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        context.setTmpdir(ProgressiveViewingTest.getTempDir());
        DataEngine dataEngine = DataEngine.newDataEngine((DataEngineContext)context);
        ScriptDataSourceDesign dataSource = new ScriptDataSourceDesign("ds");
        dataSource.setOpenScript("i = 0;");
        ScriptDataSetDesign dataSet = new ScriptDataSetDesign("test");
        dataSet.setDataSource("ds");
        dataSet.addResultSetHint((IColumnDefinition)new ColumnDefinition("column1"));
        dataSet.setFetchScript(" i++; if ( i % 11 == 0 ) return false; row.column1 = i;return true;");
        dataEngine.defineDataSource((IBaseDataSourceDesign)dataSource);
        dataEngine.defineDataSet((IBaseDataSetDesign)dataSet);
        QueryDefinition qd = new QueryDefinition();
        qd.addBinding((IBinding)new Binding("column1", (IBaseExpression)new ScriptExpression("i", 2)));
        qd.setDataSetName("test");
        HashMap appContextMap = new HashMap();
        IResultIterator ri1 = dataEngine.prepare((IQueryDefinition)qd, appContextMap).execute(null).getResultIterator();
        ProgressiveViewingTest.assertFalse((boolean)((DataEngineImpl)dataEngine).getSession().getDataSetCacheManager().doesLoadFromCache());
        int i = 0;
        while (ri1.next()) {
            ProgressiveViewingTest.assertEquals((int)((Integer)ri1.getValue("column1")), (int)(++i));
        }
        dataEngine.shutdown();
    }

    public void testProgressiveViewing2() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        context.setTmpdir(ProgressiveViewingTest.getTempDir());
        DataEngine dataEngine = DataEngine.newDataEngine((DataEngineContext)context);
        ScriptDataSourceDesign dataSource = new ScriptDataSourceDesign("ds");
        dataSource.setOpenScript("i = 0;");
        ScriptDataSetDesign dataSet = new ScriptDataSetDesign("test");
        dataSet.setDataSource("ds");
        dataSet.addResultSetHint((IColumnDefinition)new ColumnDefinition("column1"));
        dataSet.setFetchScript(" i++; if ( i % 11 == 0 ) return false; row.column1 = i;return true;");
        dataEngine.defineDataSource((IBaseDataSourceDesign)dataSource);
        dataEngine.defineDataSet((IBaseDataSetDesign)dataSet);
        QueryDefinition qd = new QueryDefinition();
        qd.setCacheQueryResults(true);
        qd.addBinding((IBinding)new Binding("column1", (IBaseExpression)new ScriptExpression("i", 2)));
        qd.setDataSetName("test");
        HashMap appContextMap = new HashMap();
        IResultIterator ri1 = dataEngine.prepare((IQueryDefinition)qd, appContextMap).execute(null).getResultIterator();
        ProgressiveViewingTest.assertFalse((boolean)((DataEngineImpl)dataEngine).getSession().getDataSetCacheManager().doesLoadFromCache());
        int i = 0;
        while (ri1.next()) {
            ProgressiveViewingTest.assertEquals((int)((Integer)ri1.getValue("column1")), (int)(++i + 1));
        }
        dataEngine.shutdown();
    }

    public void testProgressiveViewing3() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        context.setTmpdir(ProgressiveViewingTest.getTempDir());
        DataEngine dataEngine = DataEngine.newDataEngine((DataEngineContext)context);
        ScriptDataSourceDesign dataSource = new ScriptDataSourceDesign("ds");
        dataSource.setOpenScript("i = 0;");
        ScriptDataSetDesign dataSet = new ScriptDataSetDesign("test");
        dataSet.setDataSource("ds");
        dataSet.addResultSetHint((IColumnDefinition)new ColumnDefinition("column1"));
        dataSet.setFetchScript(" i++; if ( i % 11 == 0 ) return false; row.column1 = i;return true;");
        dataEngine.defineDataSource((IBaseDataSourceDesign)dataSource);
        dataEngine.defineDataSet((IBaseDataSetDesign)dataSet);
        QueryDefinition qd = new QueryDefinition();
        qd.setCacheQueryResults(true);
        Binding aggregation = new Binding("aggr", (IBaseExpression)new ScriptExpression("row[\"column1\"]"));
        aggregation.setAggrFunction("count");
        qd.addBinding((IBinding)new Binding("column1", (IBaseExpression)new ScriptExpression("i", 2)));
        qd.addBinding((IBinding)aggregation);
        qd.setDataSetName("test");
        HashMap appContextMap = new HashMap();
        IResultIterator ri1 = dataEngine.prepare((IQueryDefinition)qd, appContextMap).execute(null).getResultIterator();
        ProgressiveViewingTest.assertFalse((boolean)((DataEngineImpl)dataEngine).getSession().getDataSetCacheManager().doesLoadFromCache());
        while (ri1.next()) {
            ProgressiveViewingTest.assertEquals((int)((Integer)ri1.getValue("aggr")), (int)10);
            ProgressiveViewingTest.assertEquals((int)((Integer)ri1.getValue("column1")), (int)11);
        }
        dataEngine.shutdown();
    }

    public void testProgressiveViewing4() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        context.setTmpdir(ProgressiveViewingTest.getTempDir());
        DataEngine dataEngine = DataEngine.newDataEngine((DataEngineContext)context);
        ScriptDataSourceDesign dataSource = new ScriptDataSourceDesign("ds");
        dataSource.setOpenScript("i = 0;");
        ScriptDataSetDesign dataSet = new ScriptDataSetDesign("test");
        dataSet.setDataSource("ds");
        dataSet.addResultSetHint((IColumnDefinition)new ColumnDefinition("column1"));
        dataSet.setFetchScript(" i++; if ( i % 11 == 0 ) return false; row.column1 = i;return true;");
        dataEngine.defineDataSource((IBaseDataSourceDesign)dataSource);
        dataEngine.defineDataSet((IBaseDataSetDesign)dataSet);
        QueryDefinition qd = new QueryDefinition();
        qd.setCacheQueryResults(true);
        Binding aggregation = new Binding("aggr", (IBaseExpression)new ScriptExpression("row[\"column1\"]"));
        aggregation.setAggrFunction("count");
        qd.addBinding((IBinding)new Binding("column1", (IBaseExpression)new ScriptExpression("i", 2)));
        qd.addBinding((IBinding)aggregation);
        qd.setDataSetName("test");
        HashMap appContextMap = new HashMap();
        IResultIterator ri1 = dataEngine.prepare((IQueryDefinition)qd, appContextMap).execute(null).getResultIterator();
        ProgressiveViewingTest.assertFalse((boolean)((DataEngineImpl)dataEngine).getSession().getDataSetCacheManager().doesLoadFromCache());
        while (ri1.next()) {
            ProgressiveViewingTest.assertEquals((int)((Integer)ri1.getValue("column1")), (int)11);
        }
        ProgressiveViewingTest.assertEquals((int)((Integer)ri1.getValue("aggr")), (int)10);
        dataEngine.shutdown();
    }

    public void testProgressiveViewing5() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        context.setTmpdir(ProgressiveViewingTest.getTempDir());
        DataEngine dataEngine = DataEngine.newDataEngine((DataEngineContext)context);
        ScriptDataSourceDesign dataSource = new ScriptDataSourceDesign("ds");
        dataSource.setOpenScript("i = 0;");
        ScriptDataSetDesign dataSet = new ScriptDataSetDesign("test");
        dataSet.setDataSource("ds");
        dataSet.addResultSetHint((IColumnDefinition)new ColumnDefinition("column1"));
        dataSet.setFetchScript(" i++; if ( i % 11 == 0 ) return false; row.column1 = i;return true;");
        dataEngine.defineDataSource((IBaseDataSourceDesign)dataSource);
        dataEngine.defineDataSet((IBaseDataSetDesign)dataSet);
        QueryDefinition qd = new QueryDefinition();
        qd.setCacheQueryResults(true);
        Binding aggregation = new Binding("aggr", (IBaseExpression)new ScriptExpression("row[\"column1\"]"));
        aggregation.setAggrFunction("runningcount");
        qd.addBinding((IBinding)new Binding("column1", (IBaseExpression)new ScriptExpression("i", 2)));
        qd.addBinding((IBinding)aggregation);
        qd.setDataSetName("test");
        HashMap appContextMap = new HashMap();
        IResultIterator ri1 = dataEngine.prepare((IQueryDefinition)qd, appContextMap).execute(null).getResultIterator();
        ProgressiveViewingTest.assertFalse((boolean)((DataEngineImpl)dataEngine).getSession().getDataSetCacheManager().doesLoadFromCache());
        int i = 1;
        while (ri1.next()) {
            ProgressiveViewingTest.assertEquals((int)((Integer)ri1.getValue("aggr")), (int)i);
            ++i;
        }
        dataEngine.shutdown();
    }

    public void testProgressiveViewing6() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        context.setTmpdir(ProgressiveViewingTest.getTempDir());
        DataEngine dataEngine = DataEngine.newDataEngine((DataEngineContext)context);
        ScriptDataSourceDesign dataSource = new ScriptDataSourceDesign("ds");
        dataSource.setOpenScript("i = 0;");
        ScriptDataSetDesign dataSet = new ScriptDataSetDesign("test");
        dataSet.setDataSource("ds");
        dataSet.addResultSetHint((IColumnDefinition)new ColumnDefinition("column1"));
        dataSet.setFetchScript(" i++; if ( i % 11 == 0 ) return false; row.column1 = i;return true;");
        dataEngine.defineDataSource((IBaseDataSourceDesign)dataSource);
        dataEngine.defineDataSet((IBaseDataSetDesign)dataSet);
        QueryDefinition qd = new QueryDefinition();
        qd.setCacheQueryResults(true);
        qd.addBinding((IBinding)new Binding("column1", (IBaseExpression)new ScriptExpression("i", 2)));
        qd.setDataSetName("test");
        FilterDefinition filter = new FilterDefinition((IBaseExpression)new ScriptExpression("row.column1 != 5;"));
        qd.addFilter((IFilterDefinition)filter);
        HashMap appContextMap = new HashMap();
        IResultIterator ri1 = dataEngine.prepare((IQueryDefinition)qd, appContextMap).execute(null).getResultIterator();
        ProgressiveViewingTest.assertFalse((boolean)((DataEngineImpl)dataEngine).getSession().getDataSetCacheManager().doesLoadFromCache());
        int i = 0;
        while (ri1.next()) {
            int resultValue = (Integer)ri1.getValue("column1");
            if (resultValue == 6) {
                ++i;
            }
            int targetValue = ++i + 1;
            ProgressiveViewingTest.assertEquals((int)resultValue, (int)targetValue);
        }
        dataEngine.shutdown();
    }

    public void testProgressiveViewing7() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        context.setTmpdir(ProgressiveViewingTest.getTempDir());
        DataEngine dataEngine = DataEngine.newDataEngine((DataEngineContext)context);
        ScriptDataSourceDesign dataSource = new ScriptDataSourceDesign("ds");
        dataSource.setOpenScript("i = 0;");
        ScriptDataSetDesign dataSet = new ScriptDataSetDesign("test");
        dataSet.setDataSource("ds");
        dataSet.addResultSetHint((IColumnDefinition)new ColumnDefinition("column1"));
        dataSet.setFetchScript(" i++; if ( i % 11 == 0 ) return false; row.column1 = i;return true;");
        dataEngine.defineDataSource((IBaseDataSourceDesign)dataSource);
        dataEngine.defineDataSet((IBaseDataSetDesign)dataSet);
        QueryDefinition qd = new QueryDefinition();
        qd.setCacheQueryResults(true);
        Binding aggregation = new Binding("aggr", (IBaseExpression)new ScriptExpression("row[\"column1\"]"));
        aggregation.setAggrFunction("count");
        qd.addBinding((IBinding)new Binding("column1", (IBaseExpression)new ScriptExpression("i", 2)));
        qd.addBinding((IBinding)aggregation);
        qd.setDataSetName("test");
        FilterDefinition filter = new FilterDefinition((IBaseExpression)new ScriptExpression("row.aggr != 5;"));
        qd.addFilter((IFilterDefinition)filter);
        HashMap appContextMap = new HashMap();
        IResultIterator ri1 = dataEngine.prepare((IQueryDefinition)qd, appContextMap).execute(null).getResultIterator();
        ProgressiveViewingTest.assertFalse((boolean)((DataEngineImpl)dataEngine).getSession().getDataSetCacheManager().doesLoadFromCache());
        while (ri1.next()) {
            ProgressiveViewingTest.assertEquals((int)((Integer)ri1.getValue("column1")), (int)11);
        }
        ProgressiveViewingTest.assertEquals((int)((Integer)ri1.getValue("aggr")), (int)10);
        dataEngine.shutdown();
    }

    public void testProgressiveViewing8() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        context.setTmpdir(ProgressiveViewingTest.getTempDir());
        DataEngine dataEngine = DataEngine.newDataEngine((DataEngineContext)context);
        ScriptDataSourceDesign dataSource = new ScriptDataSourceDesign("ds");
        dataSource.setOpenScript("i = 0;");
        ScriptDataSetDesign dataSet = new ScriptDataSetDesign("test");
        dataSet.setDataSource("ds");
        dataSet.addResultSetHint((IColumnDefinition)new ColumnDefinition("column1"));
        dataSet.setFetchScript(" i++; if ( i % 11 == 0 ) return false; row.column1 = i;return true;");
        dataEngine.defineDataSource((IBaseDataSourceDesign)dataSource);
        dataEngine.defineDataSet((IBaseDataSetDesign)dataSet);
        QueryDefinition qd = new QueryDefinition();
        qd.setCacheQueryResults(true);
        Binding aggregation = new Binding("aggr", (IBaseExpression)new ScriptExpression("row[\"column1\"]"));
        aggregation.setAggrFunction("count");
        Binding indirectAggregation = new Binding("column2", (IBaseExpression)new ScriptExpression("row[\"aggr\"]"));
        qd.addBinding((IBinding)new Binding("column1", (IBaseExpression)new ScriptExpression("i", 2)));
        qd.addBinding((IBinding)aggregation);
        qd.addBinding((IBinding)indirectAggregation);
        qd.setDataSetName("test");
        FilterDefinition filter = new FilterDefinition((IBaseExpression)new ScriptExpression("row.column2 != 5;"));
        qd.addFilter((IFilterDefinition)filter);
        HashMap appContextMap = new HashMap();
        IResultIterator ri1 = dataEngine.prepare((IQueryDefinition)qd, appContextMap).execute(null).getResultIterator();
        ProgressiveViewingTest.assertFalse((boolean)((DataEngineImpl)dataEngine).getSession().getDataSetCacheManager().doesLoadFromCache());
        while (ri1.next()) {
            ProgressiveViewingTest.assertEquals((int)((Integer)ri1.getValue("column1")), (int)11);
        }
        ProgressiveViewingTest.assertEquals((int)((Integer)ri1.getValue("aggr")), (int)10);
        dataEngine.shutdown();
    }
}

