/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.api;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.api.APITestCase;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryDefinition;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import testutil.ConfigText;

public class UsesDetailFalseTest
extends APITestCase {
    private final IScriptExpression keyExpr1 = new ScriptExpression("dataSetRow.COL0");
    private final IScriptExpression keyExpr2 = new ScriptExpression("dataSetRow.COL1");
    private final IScriptExpression keyExpr3 = new ScriptExpression("dataSetRow.COL2");
    private final String keyName1 = "_COL0";
    private final String keyName2 = "_COL1";
    private final String keyName3 = "_COL2";
    private final IScriptExpression aggrExpr1 = new ScriptExpression("Total.Sum( dataSetRow.COL0 )");
    private final IScriptExpression aggrExpr2 = new ScriptExpression("Total.Sum( dataSetRow.COL1 + dataSetRow.COL2 )");
    private final String aggrName1 = "_COL3";
    private final String aggrName2 = "_COL4";

    @Override
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Api.TestData1.TableName"), ConfigText.getString("Api.TestData1.TableSQL"), ConfigText.getString("Api.TestData1.TestDataFileName"));
    }

    public void test() throws Exception {
        IQueryDefinition queryDefn = this.prepareReportQueryDefn(this.dataSet.getName());
        IResultIterator resultIt = this.executeQuery(queryDefn);
        List[] resultList = this.getQueryResult(resultIt);
        this.baseTest(resultList);
    }

    public void test2() throws Exception {
        IQueryDefinition queryDefn = this.prepareReportQueryDefn(this.dataSet.getName());
        IResultIterator resultIt = this.executeQuery(queryDefn);
        resultIt.next();
        resultIt.skipToEnd(0);
        UsesDetailFalseTest.assertFalse((boolean)resultIt.next());
    }

    public void baseTest(List[] resultList) throws Exception {
        Number value;
        List rowList = resultList[0];
        List sumList = resultList[1];
        List sglList = resultList[2];
        List eglList = resultList[3];
        List subList = resultList[4];
        this.testPrintln("---row data");
        int i = 0;
        while (i < rowList.size()) {
            value = (Integer)rowList.get(i);
            this.testPrintln(String.valueOf(((Integer)value).toString()) + " (row0)");
            List subKeyRow1List = (List)subList.get(i * 3);
            List subKeyRow2List = (List)subList.get(i * 3 + 1);
            List subAggregaList = (List)subList.get(i * 3 + 2);
            this.testPrintln("   ---sub query data");
            this.testPrintln("   row1   row2  aggr value(col0+col1)");
            int k = 0;
            while (k < subKeyRow1List.size()) {
                String k1Value = subKeyRow1List.get(k).toString();
                String k2Value = subKeyRow2List.get(k).toString();
                String a1Value = subAggregaList.get(k).toString();
                this.testPrintln("    " + k1Value + "     " + k2Value + "        " + a1Value);
                ++k;
            }
            ++i;
        }
        this.testPrintln("---sum data (col0)");
        i = 0;
        while (i < sumList.size()) {
            value = (Double)sumList.get(i);
            this.testPrintln(((Double)value).toString());
            ++i;
        }
        this.testPrintln("---starting group level data");
        i = 0;
        while (i < sglList.size()) {
            value = (Integer)sglList.get(i);
            this.testPrintln(((Integer)value).toString());
            ++i;
        }
        this.testPrintln("---ending group level data");
        i = 0;
        while (i < eglList.size()) {
            value = (Integer)eglList.get(i);
            this.testPrintln(((Integer)value).toString());
            ++i;
        }
        this.checkOutputFile();
    }

    private IQueryDefinition prepareReportQueryDefn(String dataSetName) {
        QueryDefinition queryDefn = new QueryDefinition(null);
        queryDefn.setDataSetName(dataSetName);
        queryDefn.setUsesDetails(false);
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group1")};
        this.keyExpr1.setGroupName("group1");
        groupDefn[0].setKeyColumn("_COL0");
        queryDefn.addResultSetExpression("_COL0", (IBaseExpression)this.keyExpr1);
        this.aggrExpr1.setGroupName("group1");
        queryDefn.addResultSetExpression("_COL3", (IBaseExpression)this.aggrExpr1);
        SubqueryDefinition subqueryDefn = new SubqueryDefinition("IAMTEST", (IBaseQueryDefinition)queryDefn);
        subqueryDefn.setUsesDetails(false);
        GroupDefinition[] subGroupDefn = new GroupDefinition[]{new GroupDefinition("group2"), new GroupDefinition("group3")};
        this.keyExpr2.setGroupName("group2");
        this.keyExpr3.setGroupName("group3");
        subGroupDefn[0].setKeyColumn("_COL1");
        subqueryDefn.addResultSetExpression("_COL1", (IBaseExpression)this.keyExpr2);
        this.aggrExpr2.setGroupName("group2");
        subqueryDefn.addResultSetExpression("_COL4", (IBaseExpression)this.aggrExpr2);
        subGroupDefn[1].setKeyColumn("_COL2");
        subqueryDefn.addResultSetExpression("_COL2", (IBaseExpression)this.keyExpr3);
        int i = 0;
        while (i < subGroupDefn.length) {
            subqueryDefn.addGroup(subGroupDefn[i]);
            ++i;
        }
        groupDefn[0].addSubquery(subqueryDefn);
        i = 0;
        while (i < groupDefn.length) {
            queryDefn.addGroup(groupDefn[i]);
            ++i;
        }
        return queryDefn;
    }

    private List[] getQueryResult(IResultIterator resultIt) throws Exception {
        ArrayList<Object> rowList = new ArrayList<Object>();
        ArrayList<Object> sumList = new ArrayList<Object>();
        ArrayList<Integer> sglList = new ArrayList<Integer>();
        ArrayList<Integer> eglList = new ArrayList<Integer>();
        ArrayList subList = new ArrayList();
        NativeObject subScope = new NativeObject();
        subScope.setPrototype(this.jsScope);
        subScope.setParentScope(this.jsScope);
        while (resultIt.next()) {
            rowList.add(resultIt.getValue("_COL0"));
            sumList.add(resultIt.getValue("_COL3"));
            sglList.add(new Integer(resultIt.getStartingGroupLevel()));
            eglList.add(new Integer(resultIt.getEndingGroupLevel()));
            ArrayList<Object> subKeyRow1List = new ArrayList<Object>();
            ArrayList<Object> subKeyRow2List = new ArrayList<Object>();
            ArrayList<Object> subAggregaList = new ArrayList<Object>();
            IResultIterator subIterator = resultIt.getSecondaryIterator("IAMTEST", (Scriptable)subScope);
            while (subIterator.next()) {
                subKeyRow1List.add(subIterator.getValue("_COL1"));
                subKeyRow2List.add(subIterator.getValue("_COL2"));
                subAggregaList.add(subIterator.getValue("_COL4"));
            }
            subList.add(subKeyRow1List);
            subList.add(subKeyRow2List);
            subList.add(subAggregaList);
        }
        return new List[]{rowList, sumList, sglList, eglList, subList};
    }
}

