/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.binding;

import org.eclipse.birt.data.engine.api.APITestCase;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import testutil.ConfigText;

public class DefineDataSourceTest
extends APITestCase {
    @Override
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Binding.TestData.TableName"), ConfigText.getString("Binding.TestData.TableSQL"), ConfigText.getString("Binding.TestData.TestDataFileName"));
    }

    public void testDefineDataSource() throws Exception {
        DataEngineImpl testEngine = new DataEngineImpl(DataEngineContext.newInstance((int)3, null, null, null));
        testEngine.defineDataSource((IBaseDataSourceDesign)this.dataSource);
        testEngine.defineDataSet((IBaseDataSetDesign)this.dataSet);
        IPreparedQuery preparedQuery = testEngine.prepare(this.newQueryDefn());
        IQueryResults queryResults = preparedQuery.execute(null);
        IResultMetaData meta = queryResults.getResultMetaData();
        DefineDataSourceTest.assertTrue((meta != null ? 1 : 0) != 0);
        testEngine.defineDataSource((IBaseDataSourceDesign)this.dataSource);
        testEngine.defineDataSet((IBaseDataSetDesign)this.dataSet);
        IResultIterator ri2 = testEngine.prepare(this.newQueryDefn()).execute(null).getResultIterator();
        while (ri2.next()) {
        }
        ri2.close();
        IResultIterator ri = queryResults.getResultIterator();
        ri.close();
        testEngine.shutdown();
    }

    private IQueryDefinition newQueryDefn() {
        QueryDefinition queryDefn = new QueryDefinition();
        queryDefn.setDataSetName(this.dataSet.getName());
        String[] name = new String[]{"testColumn1"};
        ScriptExpression[] se = new ScriptExpression[name.length];
        se[0] = new ScriptExpression("dataSetRow.COUNTRY");
        int i = 0;
        while (i < name.length) {
            queryDefn.addResultSetExpression(name[i], (IBaseExpression)se[i]);
            ++i;
        }
        return queryDefn;
    }
}

