/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.binding;

import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.binding.APITestCase;
import testutil.ConfigText;

public class MaxRowsTest
extends APITestCase {
    @Override
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Api.TestData1.TableName"), ConfigText.getString("Api.TestData1.TableSQL"), ConfigText.getString("Api.TestData1.TestDataFileName"));
    }

    public void test() throws Exception {
        QueryDefinition queryDefn = this.newReportQuery();
        IResultIterator resultIt = this.executeQuery((IQueryDefinition)queryDefn);
        int realRows = 0;
        while (resultIt.next()) {
            ++realRows;
        }
        String bindingNameFilter = "FILTER_COL0";
        ScriptExpression bindingExprFilter = new ScriptExpression("dataSetRow.COL0");
        FilterDefinition filterDefn = new FilterDefinition((IBaseExpression)new ScriptExpression("row.FILTER_COL0 > 0"));
        int MAX_ROW = realRows / 2;
        queryDefn = this.newReportQuery();
        this.addFilterDefinition(bindingNameFilter, (IBaseExpression)bindingExprFilter, filterDefn, queryDefn);
        queryDefn.setMaxRows(MAX_ROW);
        resultIt = this.executeQuery((IQueryDefinition)queryDefn);
        int count = 0;
        while (resultIt.next()) {
            ++count;
        }
        MaxRowsTest.assertTrue((count == MAX_ROW ? 1 : 0) != 0);
        MAX_ROW = realRows / 3;
        queryDefn = this.newReportQuery();
        this.addFilterDefinition(bindingNameFilter, (IBaseExpression)bindingExprFilter, filterDefn, queryDefn);
        queryDefn.setMaxRows(MAX_ROW);
        resultIt = this.executeQuery((IQueryDefinition)queryDefn);
        count = 0;
        while (resultIt.next()) {
            ++count;
        }
        MaxRowsTest.assertTrue((count == MAX_ROW ? 1 : 0) != 0);
        bindingNameFilter = "FILTER_COL0";
        bindingExprFilter = new ScriptExpression("dataSetRow.COL0");
        filterDefn = new FilterDefinition((IBaseExpression)new ScriptExpression("row.FILTER_COL0 > 3"));
        MAX_ROW = realRows / 3;
        queryDefn = this.newReportQuery();
        this.addFilterDefinition(bindingNameFilter, (IBaseExpression)bindingExprFilter, filterDefn, queryDefn);
        queryDefn.addFilter((IFilterDefinition)filterDefn);
        queryDefn.setMaxRows(MAX_ROW);
        resultIt = this.executeQuery((IQueryDefinition)queryDefn);
        count = 0;
        while (resultIt.next()) {
            ++count;
        }
        MaxRowsTest.assertTrue((count < MAX_ROW ? 1 : 0) != 0);
    }

    private void addFilterDefinition(String bindingNameFilter, IBaseExpression bindingExprFilter, FilterDefinition filterDefn, QueryDefinition queryDefn) {
        if (filterDefn != null) {
            if (bindingNameFilter != null) {
                queryDefn.addResultSetExpression(bindingNameFilter, bindingExprFilter);
            }
            queryDefn.addFilter((IFilterDefinition)filterDefn);
        }
    }
}

