/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.binding;

import java.io.IOException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ColumnDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.binding.APITestCase;
import org.eclipse.birt.data.engine.core.DataException;
import testutil.ConfigText;

public class MultiplePassTest
extends APITestCase {
    @Override
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Api.TestData.TableName"), ConfigText.getString("Api.TestData.TableSQL"), ConfigText.getString("Api.TestData.TestDataFileName"));
    }

    public void testTopBottomN() throws Exception {
        String[] bindingNameGroup = null;
        IBaseExpression[] bindingExprGroup = null;
        String[] bindingNameSort = null;
        IBaseExpression[] bindingExprSort = null;
        String[] bindingNameFilter = new String[]{"FILTER_AMOUNT", "FILTER_COUNTRY", "FILTER_SALE_DATE"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("dataSetRow.AMOUNT"), new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.SALE_DATE")};
        String[] bindingNameRow = new String[]{"ROW_0", "ROW_rowPosition", "ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow[0]"), new ScriptExpression("dataSetRow._rowPosition"), new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = null;
        SortDefinition[] sortDefn = null;
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.ROW_0", 0), new ScriptExpression("row.ROW_rowPosition ", 0), new ScriptExpression("row.ROW_COUNTRY", 0), new ScriptExpression("row.ROW_CITY", 0), new ScriptExpression("row.ROW_SALE_DATE", 0), new ScriptExpression("row.ROW_AMOUNT", 0)};
        FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_AMOUNT", 15, "6")), new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_COUNTRY", 15, "5")), new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_SALE_DATE", 14, "3"))};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, sortDefn, filters);
    }

    private void createAndRunQuery(String[] bindingNameGroup, IBaseExpression[] bindingExprGroup, String[] bindingNameSort, IBaseExpression[] bindingExprSort, String[] bindingNameFilter, IBaseExpression[] bindingExprFilter, String[] bindingNameRow, IBaseExpression[] bindingExprRow, IBaseExpression[] expressions, GroupDefinition[] groupDefn, SortDefinition[] sortDefn, FilterDefinition[] filters) throws Exception, IOException {
        QueryDefinition queryDefn = this.createQueryDefn(bindingNameRow, expressions, groupDefn, sortDefn, filters);
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, queryDefn);
    }

    private void populateBindings(String[] bindingNameGroup, IBaseExpression[] bindingExprGroup, String[] bindingNameSort, IBaseExpression[] bindingExprSort, String[] bindingNameFilter, IBaseExpression[] bindingExprFilter, String[] bindingNameRow, IBaseExpression[] bindingExprRow, QueryDefinition queryDefn) {
        this.populateBindings(queryDefn, bindingNameGroup, bindingExprGroup);
        this.populateBindings(queryDefn, bindingNameSort, bindingExprSort);
        this.populateBindings(queryDefn, bindingNameFilter, bindingExprFilter);
        this.populateBindings(queryDefn, bindingNameRow, bindingExprRow);
    }

    private void populateBindings(QueryDefinition queryDefn, String[] name, IBaseExpression[] expr) {
        if (name != null && expr != null) {
            int i = 0;
            while (i < name.length) {
                queryDefn.addResultSetExpression(name[i], expr[i]);
                ++i;
            }
        }
    }

    public void testTopBottomPercent() throws Exception {
        String[] bindingNameGroup = null;
        IBaseExpression[] bindingExprGroup = null;
        String[] bindingNameSort = null;
        IBaseExpression[] bindingExprSort = null;
        String[] bindingNameFilter = new String[]{"FILTER_AMOUNT", "FILTER_COUNTRY", "FILTER_SALE_DATE"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("dataSetRow.AMOUNT"), new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.SALE_DATE")};
        String[] bindingNameRow = new String[]{"ROW_0", "ROW_rowPosition", "ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow[0]"), new ScriptExpression("dataSetRow._rowPosition"), new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = null;
        SortDefinition[] sortDefn = null;
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.ROW_0", 0), new ScriptExpression("row.ROW_rowPosition ", 0), new ScriptExpression("row.ROW_COUNTRY", 0), new ScriptExpression("row.ROW_CITY", 0), new ScriptExpression("row.ROW_SALE_DATE", 0), new ScriptExpression("row.ROW_AMOUNT", 0)};
        FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_AMOUNT", 17, "75")), new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_COUNTRY", 15, "5")), new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_SALE_DATE", 16, "60"))};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, sortDefn, filters);
    }

    public void testTopBottmNwithOtherFilters() throws Exception {
        String[] bindingNameGroup = null;
        IBaseExpression[] bindingExprGroup = null;
        String[] bindingNameSort = null;
        IBaseExpression[] bindingExprSort = null;
        String[] bindingNameFilter = new String[]{"FILTER_AMOUNT", "FILTER_COUNTRY"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("dataSetRow.AMOUNT"), new ScriptExpression("dataSetRow.COUNTRY")};
        String[] bindingNameRow = new String[]{"ROW_0", "ROW_rowPosition", "ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow[0]"), new ScriptExpression("dataSetRow._rowPosition"), new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = null;
        SortDefinition[] sortDefn = null;
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.ROW_0", 0), new ScriptExpression("row.ROW_rowPosition ", 0), new ScriptExpression("row.ROW_COUNTRY", 0), new ScriptExpression("row.ROW_CITY", 0), new ScriptExpression("row.ROW_SALE_DATE", 0), new ScriptExpression("row.ROW_AMOUNT", 0)};
        FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_AMOUNT", 6, "100")), new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_AMOUNT", 6, "400")), new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_AMOUNT", 15, "16")), new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_COUNTRY", 15, "1"))};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, sortDefn, filters);
    }

    private void createAndRunQuery(String[] bindingNameGroup, IBaseExpression[] bindingExprGroup, String[] bindingNameSort, IBaseExpression[] bindingExprSort, String[] bindingNameFilter, IBaseExpression[] bindingExprFilter, String[] bindingNameRow, IBaseExpression[] bindingExprRow, IBaseExpression[] expressions, QueryDefinition queryDefn) throws Exception, IOException {
        this.populateBindings(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, queryDefn);
        this.executeQuery(queryDefn, bindingNameRow);
        this.checkOutputFile();
    }

    public void testTopBottmPercentWithOtherFilters() throws Exception {
        String[] bindingNameGroup = null;
        IBaseExpression[] bindingExprGroup = null;
        String[] bindingNameSort = null;
        IBaseExpression[] bindingExprSort = null;
        String[] bindingNameFilter = new String[]{"FILTER_AMOUNT", "FILTER_COUNTRY"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("dataSetRow.AMOUNT"), new ScriptExpression("dataSetRow.COUNTRY")};
        String[] bindingNameRow = new String[]{"ROW_0", "ROW_rowPosition", "ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow[0]"), new ScriptExpression("dataSetRow._rowPosition"), new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = null;
        SortDefinition[] sortDefn = null;
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.ROW_0", 0), new ScriptExpression("row.ROW_rowPosition ", 0), new ScriptExpression("row.ROW_COUNTRY", 0), new ScriptExpression("row.ROW_CITY", 0), new ScriptExpression("row.ROW_SALE_DATE", 0), new ScriptExpression("row.ROW_AMOUNT", 0)};
        FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_AMOUNT", 17, "100")), new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_AMOUNT", 6, "100")), new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_COUNTRY", 17, "75")), new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_AMOUNT", 6, "400"))};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, sortDefn, filters);
    }

    public void testInvalidFilter() throws Exception {
        String[] bindingNameGroup = null;
        IBaseExpression[] bindingExprGroup = null;
        String[] bindingNameSort = null;
        IBaseExpression[] bindingExprSort = null;
        String[] bindingNameFilter = new String[]{"FILTER_AMOUNT"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("dataSetRow.AMOUNT")};
        String[] bindingNameRow = new String[]{"ROW_0", "ROW_rowPosition", "ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow[0]"), new ScriptExpression("dataSetRow._rowPosition"), new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = null;
        SortDefinition[] sortDefn = null;
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.ROW_0", 0), new ScriptExpression("row.ROW_rowPosition ", 0), new ScriptExpression("row.ROW_COUNTRY", 0), new ScriptExpression("row.ROW_CITY", 0), new ScriptExpression("row.ROW_SALE_DATE", 0), new ScriptExpression("row.ROW_AMOUNT", 0)};
        FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_AMOUNT", 14, "-1"))};
        try {
            this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, sortDefn, filters);
            MultiplePassTest.fail((String)"Should not reach here");
        }
        catch (Exception exception) {}
        filters = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_AMOUNT", 14, "abc"))};
        try {
            this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, sortDefn, filters);
            MultiplePassTest.fail((String)"Should not reach here");
        }
        catch (Exception exception) {}
    }

    public void testGroupFiltering() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_GROUP0", "GROUP_GROUP1"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        String[] bindingNameSort = null;
        IBaseExpression[] bindingExprSort = null;
        String[] bindingNameFilter = null;
        IBaseExpression[] bindingExprFilter = null;
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_GROUP0");
        FilterDefinition filterDefn = new FilterDefinition((IBaseExpression)new ScriptExpression("Total.sum(row.ROW_AMOUNT,Total.NO_FILTER)>7000"));
        groupDefn[0].addFilter((IFilterDefinition)filterDefn);
        filterDefn = new FilterDefinition((IBaseExpression)new ScriptExpression("Total.sum(row.ROW_AMOUNT,Total.NO_FILTER,2)<=400"));
        groupDefn[1].setKeyExpression("row.GROUP_GROUP1");
        groupDefn[1].addFilter((IFilterDefinition)filterDefn);
        ConditionalExpression ce = new ConditionalExpression("Total.sum(row.ROW_AMOUNT)", 15, "1");
        ce.setGroupName("group1");
        filterDefn = new FilterDefinition((IBaseExpression)ce);
        groupDefn[1].addFilter((IFilterDefinition)filterDefn);
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.ROW_COUNTRY", 0), new ScriptExpression("row.ROW_CITY", 0), new ScriptExpression("row.ROW_SALE_DATE", 0), new ScriptExpression("row.ROW_AMOUNT", 0)};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, null, null);
    }

    public void testGroupSorting() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_GROUP0", "GROUP_GROUP1"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        String[] bindingNameSort = new String[]{};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{};
        String[] bindingNameFilter = null;
        IBaseExpression[] bindingExprFilter = null;
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_GROUP0");
        SortDefinition sortDefn = new SortDefinition();
        sortDefn.setExpression("Total.sum(dataSetRow.AMOUNT,Total.NO_FILTER,1)");
        sortDefn.setSortDirection(0);
        groupDefn[0].addSort(sortDefn);
        groupDefn[0].setSortDirection(1);
        groupDefn[1].setKeyExpression("row.GROUP_GROUP1");
        sortDefn = new SortDefinition();
        sortDefn.setExpression("Total.sum(dataSetRow.AMOUNT,Total.NO_FILTER,Total.CURRENT_GROUP)");
        sortDefn.setSortDirection(0);
        groupDefn[1].addSort(sortDefn);
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.ROW_COUNTRY", 0), new ScriptExpression("row.ROW_CITY", 0), new ScriptExpression("row.ROW_SALE_DATE", 0), new ScriptExpression("row.ROW_AMOUNT", 0)};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, null, null);
    }

    public void testGroupSorting2() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_GROUP0", "GROUP_GROUP1"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        String[] bindingNameSort = new String[]{};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{};
        String[] bindingNameFilter = null;
        IBaseExpression[] bindingExprFilter = null;
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_GROUP0");
        groupDefn[0].setSortDirection(1);
        groupDefn[1].setKeyExpression("row.GROUP_GROUP1");
        groupDefn[1].setSortDirection(1);
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.ROW_COUNTRY", 0), new ScriptExpression("row.ROW_CITY", 0), new ScriptExpression("row.ROW_SALE_DATE", 0), new ScriptExpression("row.ROW_AMOUNT", 0)};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, null, null);
    }

    public void testGroupFilteringSorting1() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_GROUP0", "GROUP_GROUP1"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        String[] bindingNameSort = new String[]{};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{};
        String[] bindingNameFilter = null;
        IBaseExpression[] bindingExprFilter = null;
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_GROUP0");
        SortDefinition sortDefn = new SortDefinition();
        sortDefn.setExpression("Total.sum(dataSetRow.AMOUNT,null,Total.CURRENT_GROUP)");
        sortDefn.setSortDirection(0);
        groupDefn[0].addSort(sortDefn);
        FilterDefinition filterDefn = new FilterDefinition((IBaseExpression)new ScriptExpression("Total.sum(dataSetRow.AMOUNT,null,2)>400"));
        groupDefn[1].setKeyExpression("row.GROUP_GROUP1");
        groupDefn[1].addFilter((IFilterDefinition)filterDefn);
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.ROW_COUNTRY", 0), new ScriptExpression("row.ROW_CITY", 0), new ScriptExpression("row.ROW_SALE_DATE", 0), new ScriptExpression("row.ROW_AMOUNT", 0)};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, null, null);
    }

    public void testGroupFilteringSorting2() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_GROUP0", "GROUP_GROUP1"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        String[] bindingNameSort = new String[]{};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{};
        String[] bindingNameFilter = new String[]{"FILTER_1", "FILTER_2", "FILTER_3"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("Total.sum(dataSetRow.AMOUNT,null,1)"), new ScriptExpression("Total.sum(dataSetRow.AMOUNT,null,2)"), new ScriptExpression("Total.sum(dataSetRow.AMOUNT,null,2)<7400")};
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_GROUP0");
        FilterDefinition filterDefn = new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_1", 15, "2"));
        groupDefn[0].addFilter((IFilterDefinition)filterDefn);
        SortDefinition sortDefn = new SortDefinition();
        sortDefn.setExpression("Total.sum(dataSetRow.AMOUNT)");
        sortDefn.setSortDirection(0);
        groupDefn[0].addSort(sortDefn);
        groupDefn[1].setKeyExpression("row.GROUP_GROUP1");
        filterDefn = new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_2", 14, "1"));
        groupDefn[1].addFilter((IFilterDefinition)filterDefn);
        filterDefn = new FilterDefinition((IBaseExpression)new ScriptExpression("row.FILTER_3"));
        groupDefn[1].addFilter((IFilterDefinition)filterDefn);
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.ROW_COUNTRY", 0), new ScriptExpression("row.ROW_CITY", 0), new ScriptExpression("row.ROW_SALE_DATE", 0), new ScriptExpression("row.ROW_AMOUNT", 0)};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, null, null);
    }

    public void testGroupFilteringSorting3() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_GROUP0"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.CITY")};
        String[] bindingNameSort = new String[]{};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{};
        String[] bindingNameFilter = null;
        IBaseExpression[] bindingExprFilter = null;
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0")};
        groupDefn[0].setKeyExpression("row.GROUP_GROUP0");
        groupDefn[0].addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ConditionalExpression("Total.sum(dataSetRow.AMOUNT,null,1)", 17, "75")));
        groupDefn[0].addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ConditionalExpression("Total.sum(dataSetRow.AMOUNT,null,1)", 14, "2")));
        SortDefinition sortDefn = new SortDefinition();
        sortDefn.setExpression("Total.sum(dataSetRow.AMOUNT,null,1)");
        sortDefn.setSortDirection(0);
        groupDefn[0].addSort(sortDefn);
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.ROW_COUNTRY", 0), new ScriptExpression("row.ROW_CITY", 0), new ScriptExpression("row.ROW_SALE_DATE", 0), new ScriptExpression("row.ROW_AMOUNT", 0)};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, null, null);
    }

    public void testGroupFilteringSorting4() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_GROUP0"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.CITY")};
        String[] bindingNameSort = new String[]{};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{};
        String[] bindingNameFilter = null;
        IBaseExpression[] bindingExprFilter = null;
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0")};
        groupDefn[0].setKeyExpression("row.GROUP_GROUP0");
        groupDefn[0].addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ConditionalExpression("Total.sum(dataSetRow.AMOUNT,null,1)", 17, "75")));
        groupDefn[0].addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ConditionalExpression("Total.sum(dataSetRow.AMOUNT,null,1)", 14, "2")));
        SortDefinition sortDefn = new SortDefinition();
        sortDefn.setExpression("Total.sum(dataSetRow.AMOUNT,null,1)");
        sortDefn.setSortDirection(0);
        groupDefn[0].addSort(sortDefn);
        QueryDefinition queryDefn = this.createQueryDefn(bindingNameRow, bindingExprRow, groupDefn, null, null);
        this.populateBindings(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, queryDefn);
        this.executeQuery(queryDefn, bindingNameRow);
        this.executeQuery(queryDefn, bindingNameRow);
        this.checkOutputFile();
    }

    public void testMixedFiltering() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_GROUP0"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.CITY")};
        String[] bindingNameSort = new String[]{};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{};
        String[] bindingNameFilter = new String[]{"FILTER_1", "FILTER_2"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("dataSetRow.AMOUNT"), new ScriptExpression("dataSetRow.AMOUNT")};
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0")};
        groupDefn[0].setKeyExpression("row.GROUP_GROUP0");
        groupDefn[0].addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ConditionalExpression("Total.sum(dataSetRow.AMOUNT,null,1)", 17, "75")));
        SortDefinition sortDefn = new SortDefinition();
        sortDefn.setExpression("Total.sum(dataSetRow.AMOUNT,null,1)");
        sortDefn.setSortDirection(0);
        groupDefn[0].addSort(sortDefn);
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.ROW_COUNTRY", 0), new ScriptExpression("row.ROW_CITY", 0), new ScriptExpression("row.ROW_SALE_DATE", 0), new ScriptExpression("row.ROW_AMOUNT", 0)};
        FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_1", 15, "7")), new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_2", 3, "700"))};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, null, filters);
    }

    public void testIndirectNestedTotal() throws Exception {
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT", "ROW_TOPN"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("Total.sum(dataSetRow.AMOUNT)"), new ScriptExpression("Total.isTopN(row.ROW_AMOUNT,3)")};
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.ROW_COUNTRY", 0), new ScriptExpression("row.ROW_CITY", 0), new ScriptExpression("row.ROW_SALE_DATE", 0), new ScriptExpression("row.ROW_AMOUNT", 0), new ScriptExpression("row.ROW_TOPN", 0)};
        this.createAndRunQuery(null, null, null, null, null, null, bindingNameRow, bindingExprRow, expressions, null, null, null);
    }

    public void testNestedTotal() throws IOException, Exception {
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT", "ROW_TOPN", "ROW_TOTALALL1", "ROW_TOTALALL2", "ROW_TOTALALL3", "ROW_TOTALALL4", "ROW_TOTALALL5", "ROW_TOTALALL6", "ROW_TOTALALL7", "ROW_TOTALALL8", "ROW_TOTALALL9", "ROW_TOTALALL10", "ROW_TOTALALL11"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT"), new ScriptExpression("Total.isTopN(Total.sum(dataSetRow.AMOUNT,null,2),2)"), new ScriptExpression("Total.sum(dataSetRow.AMOUNT)"), new ScriptExpression("Total.sum(Total.sum(dataSetRow.AMOUNT,null,1))"), new ScriptExpression("Total.sum(Total.sum(Total.sum(dataSetRow.AMOUNT,null,2),null,1))"), new ScriptExpression("Total.sum(Total.sum(Total.sum(dataSetRow.AMOUNT,null,2)+1,null,1))"), new ScriptExpression("Total.sum(Total.sum(Total.sum(dataSetRow.AMOUNT,null,2),null,1)+1)"), new ScriptExpression("Total.sum(Total.sum(Total.sum(dataSetRow.AMOUNT,null,2),null,1)+dataSetRow.AMOUNT)"), new ScriptExpression("Total.sum(Total.sum(Total.sum(dataSetRow.AMOUNT,null,2)+dataSetRow.AMOUNT,null,1))"), new ScriptExpression("Total.sum(Total.sum(Total.sum(dataSetRow.AMOUNT,null,2),null,1)+row.ROW_AMOUNT)"), new ScriptExpression("Total.sum(Total.sum(Total.sum(dataSetRow.AMOUNT,null,2)+row.ROW_AMOUNT,null,1))"), new ScriptExpression("Total.sum(dataSetRow.AMOUNT/Total.sum(dataSetRow.AMOUNT,null,1))"), new ScriptExpression("Total.sum(row.ROW_AMOUNT/Total.sum(dataSetRow.AMOUNT,null,1))")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.ROW_COUNTRY");
        groupDefn[1].setKeyExpression("row.ROW_CITY");
        this.createAndRunQuery(null, null, null, null, null, null, bindingNameRow, bindingExprRow, null, groupDefn, null, null);
    }

    public void testNestedTotal1() throws IOException, Exception {
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT", "ROW_TOPN", "ROW_TOTALALL1", "ROW_TOTALALL2", "ROW_TOTALALL3", "ROW_TOTALALL4", "ROW_TOTALALL5", "ROW_TOTALALL6", "ROW_TOTALALL7", "ROW_TOTALALL8", "ROW_TOTALALL9", "ROW_TOTALALL10", "ROW_TOTALALL11"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[16];
        bindingExprRow[0] = new ScriptExpression("dataSetRow.COUNTRY");
        bindingExprRow[1] = new ScriptExpression("dataSetRow.CITY");
        bindingExprRow[2] = new ScriptExpression("dataSetRow.SALE_DATE");
        bindingExprRow[3] = new ScriptExpression("dataSetRow.AMOUNT");
        bindingExprRow[4] = new ScriptExpression("Total.isTopN(Total.sum(dataSetRow.AMOUNT),2,null, 0)");
        bindingExprRow[4].setGroupName("group1");
        bindingExprRow[5] = new ScriptExpression("Total.sum(dataSetRow.AMOUNT)");
        bindingExprRow[6] = new ScriptExpression("Total.sum(Total.sum(dataSetRow.AMOUNT),null,0)");
        bindingExprRow[6].setGroupName("group0");
        bindingExprRow[7] = new ScriptExpression("Total.sum(Total.sum(Total.sum(dataSetRow.AMOUNT),null,1),null,0)");
        bindingExprRow[7].setGroupName("group1");
        bindingExprRow[8] = new ScriptExpression("Total.sum(Total.sum(Total.sum(dataSetRow.AMOUNT,null,2)+1),null,0)");
        bindingExprRow[8].setGroupName("group0");
        bindingExprRow[9] = new ScriptExpression("Total.sum(Total.sum(Total.sum(dataSetRow.AMOUNT,null,2))+1,null,0)");
        bindingExprRow[9].setGroupName("group0");
        bindingExprRow[10] = new ScriptExpression("Total.sum(Total.sum(Total.sum(dataSetRow.AMOUNT,null,2))+dataSetRow.AMOUNT,null,0)");
        bindingExprRow[10].setGroupName("group0");
        bindingExprRow[11] = new ScriptExpression("Total.sum(Total.sum(Total.sum(dataSetRow.AMOUNT,null,2)+dataSetRow.AMOUNT,null,1))");
        bindingExprRow[12] = new ScriptExpression("Total.sum(Total.sum(Total.sum(dataSetRow.AMOUNT,null,2),null,1)+row.ROW_AMOUNT)");
        bindingExprRow[13] = new ScriptExpression("Total.sum(Total.sum(Total.sum(dataSetRow.AMOUNT,null,2)+row.ROW_AMOUNT,null,1))");
        bindingExprRow[14] = new ScriptExpression("Total.sum(dataSetRow.AMOUNT/Total.sum(dataSetRow.AMOUNT,null,1))");
        bindingExprRow[15] = new ScriptExpression("Total.sum(row.ROW_AMOUNT/Total.sum(dataSetRow.AMOUNT),null,0)");
        bindingExprRow[15].setGroupName("group0");
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.ROW_COUNTRY");
        groupDefn[1].setKeyExpression("row.ROW_CITY");
        this.createAndRunQuery(null, null, null, null, null, null, bindingNameRow, bindingExprRow, null, groupDefn, null, null);
    }

    public void testNestedTotal2() throws IOException, Exception {
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT", "ROW_TOPN", "ROW_TOTALALL1", "ROW_TOTALALL2", "ROW_TOTALALL3", "ROW_TOTALALL4", "ROW_TOTALALL5", "ROW_TOTALALL6", "ROW_TOTALALL7", "ROW_TOTALALL8", "ROW_TOTALALL9", "ROW_TOTALALL10", "ROW_TOTALALL11"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[16];
        bindingExprRow[0] = new ScriptExpression("dataSetRow.COUNTRY");
        bindingExprRow[1] = new ScriptExpression("dataSetRow.CITY");
        bindingExprRow[2] = new ScriptExpression("dataSetRow.SALE_DATE");
        bindingExprRow[3] = new ScriptExpression("dataSetRow.AMOUNT");
        bindingExprRow[4] = new ScriptExpression("Total.isTopN(Total.sum(dataSetRow.AMOUNT), 1, null, 0)");
        bindingExprRow[4].setGroupName("group1");
        bindingExprRow[5] = new ScriptExpression("Total.sum(dataSetRow.AMOUNT, dataSetRow.AMOUNT>100, 0)");
        bindingExprRow[6] = new ScriptExpression("Total.sum(Total.sum(dataSetRow.AMOUNT),Total.sum(dataSetRow.AMOUNT)>2000,0)");
        bindingExprRow[6].setGroupName("group0");
        bindingExprRow[7] = new ScriptExpression("Total.sum(Total.sum(Total.sum(dataSetRow.AMOUNT, dataSetRow.AMOUNT>400),null,1),null,0)");
        bindingExprRow[7].setGroupName("group1");
        bindingExprRow[8] = new ScriptExpression("Total.sum(Total.sum(Total.sum(dataSetRow.AMOUNT,dataSetRow.AMOUNT>100,2)),null,0)");
        bindingExprRow[8].setGroupName("group0");
        bindingExprRow[9] = new ScriptExpression("Total.sum(Total.sum(Total.sum(dataSetRow.AMOUNT,null,2),Total.sum(dataSetRow.AMOUNT,null,2)>1,1),null,0)");
        bindingExprRow[9].setGroupName("group0");
        bindingExprRow[10] = new ScriptExpression("Total.sum(Total.sum(Total.sum(dataSetRow.AMOUNT,null,2))+dataSetRow.AMOUNT,null,0)");
        bindingExprRow[10].setGroupName("group0");
        bindingExprRow[11] = new ScriptExpression("Total.sum(Total.sum(Total.sum(dataSetRow.AMOUNT,null,2),null,1),Total.sum(Total.sum(dataSetRow.AMOUNT,null,2),null,1)>7000,0)");
        bindingExprRow[12] = new ScriptExpression("Total.sum(Total.sum(Total.sum(dataSetRow.AMOUNT,null,2),null,1)+row.ROW_AMOUNT)");
        bindingExprRow[13] = new ScriptExpression("Total.sum(Total.sum(Total.sum(dataSetRow.AMOUNT,null,2)+row.ROW_AMOUNT,null,1))");
        bindingExprRow[14] = new ScriptExpression("Total.sum(dataSetRow.AMOUNT/Total.sum(dataSetRow.AMOUNT,null,1))");
        bindingExprRow[15] = new ScriptExpression("Total.sum(row.ROW_AMOUNT/Total.sum(dataSetRow.AMOUNT),null,0)");
        bindingExprRow[15].setGroupName("group0");
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.ROW_COUNTRY");
        groupDefn[1].setKeyExpression("row.ROW_CITY");
        this.createAndRunQuery(null, null, null, null, null, null, bindingNameRow, bindingExprRow, null, groupDefn, null, null);
    }

    public void testNestedTotal3() throws IOException, Exception {
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT", "ROW_TOPN"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT"), new ScriptExpression("Total.sum(Total.sum(Total.sum(dataSetRow.AMOUNT,null,2),null,1),Total.sum(Total.sum(dataSetRow.AMOUNT,null,2),null,1)>7000,0)")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.ROW_COUNTRY");
        groupDefn[1].setKeyExpression("row.ROW_CITY");
        this.createAndRunQuery(null, null, null, null, null, null, bindingNameRow, bindingExprRow, null, groupDefn, null, null);
    }

    public void testNestedTotal4() throws IOException, Exception {
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT", "ROW_5"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT"), new ScriptExpression("Total.sum(Total.sum(dataSetRow.AMOUNT,null,0),null,1)")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.ROW_COUNTRY");
        groupDefn[1].setKeyExpression("row.ROW_CITY");
        this.createAndRunQuery(null, null, null, null, null, null, bindingNameRow, bindingExprRow, null, groupDefn, null, null);
        try {
            bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_TOPN"};
            bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("Total.sum(Total.sum(Total.sum(dataSetRow.AMOUNT,null,2),null,1),dataSetRow.AMOUNT>10,0)")};
            this.createAndRunQuery(null, null, null, null, null, null, bindingNameRow, bindingExprRow, null, groupDefn, null, null);
            MultiplePassTest.fail((String)"expected error here");
        }
        catch (DataException e) {
            MultiplePassTest.assertTrue((e.getErrorCode() == "data.engine.InvalidJSExpr" ? 1 : 0) != 0);
        }
    }

    public void testMixedMultipassFilting() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_GROUP0"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.CITY")};
        String[] bindingNameSort = new String[]{};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{};
        String[] bindingNameFilter = new String[]{"FILTER_1", "FILTER_2", "FILTER_3"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("dataSetRow.AMOUNT"), new ScriptExpression("dataSetRow.AMOUNT"), new ScriptExpression("Total.isTopN(dataSetRow.AMOUNT,1,null,1)")};
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0")};
        groupDefn[0].setKeyExpression("row.GROUP_GROUP0");
        groupDefn[0].addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ConditionalExpression("Total.sum(dataSetRow.AMOUNT,null,1)", 17, "75")));
        SortDefinition sortDefn = new SortDefinition();
        sortDefn.setExpression("Total.sum(dataSetRow.AMOUNT,null,1)");
        sortDefn.setSortDirection(0);
        groupDefn[0].addSort(sortDefn);
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.ROW_COUNTRY", 0), new ScriptExpression("row.ROW_CITY", 0), new ScriptExpression("row.ROW_SALE_DATE", 0), new ScriptExpression("row.ROW_AMOUNT", 0)};
        FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_1", 15, "7")), new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_2", 3, "700")), new FilterDefinition((IBaseExpression)new ConditionalExpression("Total.isTopN(dataSetRow.AMOUNT,1,null,1)", 11))};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, null, filters);
    }

    public void testTop_Bottom_FilteringInGroupInstance_1() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_GROUP0", "GROUP_GROUP1"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        String[] bindingNameSort = new String[]{};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{};
        String[] bindingNameFilter = null;
        IBaseExpression[] bindingExprFilter = null;
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_GROUP0");
        groupDefn[1].setKeyExpression("row.GROUP_GROUP1");
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.ROW_COUNTRY", 0), new ScriptExpression("row.ROW_CITY", 0), new ScriptExpression("row.ROW_SALE_DATE", 0), new ScriptExpression("row.ROW_AMOUNT", 0)};
        FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("Total.isTopN(row.ROW_AMOUNT,3,null,1)", 11))};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, null, filters);
    }

    public void testTop_Bottom_FilteringInGroupInstance_2() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_GROUP0", "GROUP_GROUP1"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        String[] bindingNameSort = new String[]{};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{};
        String[] bindingNameFilter = null;
        IBaseExpression[] bindingExprFilter = null;
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_GROUP0");
        groupDefn[1].setKeyExpression("row.GROUP_GROUP1");
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.COUNTRY", 0), new ScriptExpression("row.CITY", 0), new ScriptExpression("row.SALE_DATE", 0), new ScriptExpression("row.AMOUNT", 0)};
        FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("Total.isTopN(dataSetRow.AMOUNT,3,null,1)", 11)), new FilterDefinition((IBaseExpression)new ConditionalExpression("Total.isBottomN(dataSetRow.AMOUNT,2,null,2)", 11)), new FilterDefinition((IBaseExpression)new ConditionalExpression("dataSetRow.CITY", 2, "\"Chicago\""))};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, null, filters);
    }

    public void testMultipassWithAlias() throws Exception {
        ColumnDefinition cd = new ColumnDefinition("AMOUNT");
        cd.setAlias("A");
        this.dataSet.addResultSetHint((IColumnDefinition)cd);
        String[] bindingNameGroup = new String[]{"GROUP_GROUP0"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.CITY")};
        String[] bindingNameSort = new String[]{};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{};
        String[] bindingNameFilter = new String[]{"FILTER_1", "FILTER_2", "FILTER_3"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("dataSetRow.A"), new ScriptExpression("dataSetRow.A"), new ScriptExpression("Total.isTopN(dataSetRow.A,1,null,1)")};
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.A")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0")};
        groupDefn[0].setKeyExpression("row.GROUP_GROUP0");
        groupDefn[0].addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ConditionalExpression("Total.sum(dataSetRow.A,null,1)", 17, "75")));
        SortDefinition sortDefn = new SortDefinition();
        sortDefn.setExpression("Total.sum(dataSetRow.A,null,1)");
        sortDefn.setSortDirection(0);
        groupDefn[0].addSort(sortDefn);
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.ROW_COUNTRY", 0), new ScriptExpression("row.ROW_CITY", 0), new ScriptExpression("row.ROW_SALE_DATE", 0), new ScriptExpression("row.ROW_AMOUNT", 0)};
        FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_1", 15, "7")), new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_2", 3, "700")), new FilterDefinition((IBaseExpression)new ConditionalExpression("Total.isTopN(dataSetRow.A,1,null,1)", 11))};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, null, filters);
    }

    private QueryDefinition createQueryDefn(String[] exprNames, IBaseExpression[] expressions, GroupDefinition[] groupDefn, SortDefinition[] sortDefn, FilterDefinition[] filters) {
        int i;
        QueryDefinition queryDefn = this.newReportQuery();
        if (groupDefn != null) {
            i = 0;
            while (i < groupDefn.length) {
                queryDefn.addGroup(groupDefn[i]);
                ++i;
            }
        }
        if (sortDefn != null) {
            i = 0;
            while (i < sortDefn.length) {
                queryDefn.addSort(sortDefn[i]);
                ++i;
            }
        }
        if (expressions != null) {
            i = 0;
            while (i < expressions.length) {
                queryDefn.addResultSetExpression(exprNames[i], expressions[i]);
                ++i;
            }
        }
        if (filters != null) {
            i = 0;
            while (i < filters.length) {
                queryDefn.addFilter((IFilterDefinition)filters[i]);
                ++i;
            }
        }
        return queryDefn;
    }
}

