/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.binding;

import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.BaseExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryDefinition;
import org.eclipse.birt.data.engine.binding.APITestCase;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import testutil.ConfigText;

public class SubQueryTest
extends APITestCase {
    private BaseExpression[] expressions;
    private String[] bindingNameRow;

    @Override
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Api.TestData1.TableName"), ConfigText.getString("Api.TestData1.TableSQL"), ConfigText.getString("Api.TestData1.TestDataFileName"));
    }

    public void test() throws Exception {
        Context cx = Context.enter();
        ScriptableObject sharedScope = cx.initStandardObjects();
        Scriptable subScope = cx.newObject((Scriptable)sharedScope);
        subScope.setParentScope((Scriptable)sharedScope);
        IQueryDefinition queryDefn = this.getDefaultQueryDefnWithSubQuery(this.dataSet.getName());
        this.expressions = this.getExpressionsOfDefaultQuery();
        IResultIterator resultIt = this.executeQuery(queryDefn);
        resultIt.next();
        IResultIterator subIterator = resultIt.getSecondaryIterator("IAMTEST", (Scriptable)sharedScope);
        subIterator.next();
        IResultIterator subSubIterator = subIterator.getSecondaryIterator("IAMTEST2", subScope);
        this.bindingNameRow = this.getBindingExpressionName();
        this.testPrintln("sub query data");
        this.outputData(subIterator);
        this.testPrintln("");
        this.testPrintln("sub query of sub query data");
        this.outputData(subSubIterator);
        this.testPrintln("");
        this.checkOutputFile();
    }

    public void test2() throws Exception {
        IResultIterator resultIt = this.executeQuery((IQueryDefinition)this.getAnotherSubQuery());
        resultIt.next();
        resultIt.getSecondaryIterator("IAMTEST", null);
        this.testPrintln("query data");
        this.outputData(resultIt);
        this.checkOutputFile();
    }

    public void test3() throws Exception {
        IResultIterator resultIt = this.executeQuery((IQueryDefinition)this.getAnotherSubQuery());
        resultIt.getSecondaryIterator("IAMTEST", null);
        this.testPrintln("query data");
        this.outputData(resultIt);
        this.checkOutputFile();
    }

    public void test4() throws Exception {
        IResultIterator resultIt = this.executeQuery((IQueryDefinition)this.getAnotherSubQuery(false));
        this.testPrintln("query data");
        while (resultIt.next()) {
            IResultIterator resultIt2 = resultIt.getSecondaryIterator("IAMTEST", null);
            this.outputData(resultIt2);
        }
    }

    private QueryDefinition getAnotherSubQuery() {
        return this.getAnotherSubQuery(true);
    }

    private QueryDefinition getAnotherSubQuery(boolean onGroup) {
        QueryDefinition queryDefn = (QueryDefinition)this.getDefaultQueryDefn(this.dataSet.getName());
        SubqueryDefinition subqueryDefn = new SubqueryDefinition("IAMTEST", (IBaseQueryDefinition)queryDefn);
        if (!onGroup) {
            subqueryDefn.setApplyOnGroupFlag(false);
        }
        String[] bindingNameGroup = new String[]{"GROUP_COL2"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COL2")};
        GroupDefinition[] subGroupDefn = new GroupDefinition[]{new GroupDefinition("group1")};
        subGroupDefn[0].setKeyExpression("row.GROUP_COL2");
        this.bindingNameRow = new String[4];
        this.bindingNameRow[0] = "ROW_COL0";
        this.bindingNameRow[1] = "ROW_COL1";
        this.bindingNameRow[2] = "ROW_COL2";
        this.bindingNameRow[3] = "ROW_COL3";
        this.expressions = new BaseExpression[]{new ScriptExpression("dataSetRow[\"COL0\"]", 0), new ScriptExpression("dataSetRow[\"COL1\"]", 0), new ScriptExpression("dataSetRow.COL2", 0), new ScriptExpression("dataSetRow[\"COL3\"]", 0)};
        int i = 0;
        while (i < subGroupDefn.length) {
            subqueryDefn.addGroup(subGroupDefn[i]);
            subqueryDefn.addResultSetExpression(bindingNameGroup[i], bindingExprGroup[i]);
            ++i;
        }
        i = 0;
        while (i < this.bindingNameRow.length) {
            subqueryDefn.addResultSetExpression(this.bindingNameRow[i], (IBaseExpression)this.expressions[i]);
            ++i;
        }
        this.bindingNameRow = new String[4];
        this.bindingNameRow[0] = "ROW_COL0";
        this.bindingNameRow[1] = "ROW_COL1";
        this.bindingNameRow[2] = "ROW_COL2";
        this.bindingNameRow[3] = "ROW_COL3";
        this.expressions = new BaseExpression[]{new ScriptExpression("row[\"ROW_COL0\"]", 0), new ScriptExpression("row[\"ROW_COL1\"]", 0), new ScriptExpression("dataSetRow.COL2", 0), new ScriptExpression("row._outer[\"ROW_COL3\"]", 0)};
        queryDefn.addSubquery(subqueryDefn);
        return queryDefn;
    }

    public void testMaxRow() throws Exception {
        int i;
        QueryDefinition queryDefn = (QueryDefinition)this.getDefaultQueryDefn(this.dataSet.getName());
        SubqueryDefinition subqueryDefn = new SubqueryDefinition("IAMTEST", (IBaseQueryDefinition)queryDefn);
        subqueryDefn.setMaxRows(10);
        String[] bindingNameGroup = new String[]{"GROUP_COL2"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COL2")};
        GroupDefinition[] subGroupDefn = new GroupDefinition[]{new GroupDefinition("group1")};
        subGroupDefn[0].setKeyExpression("row.GROUP_COL2");
        int k = 0;
        while (k < subGroupDefn.length) {
            if (bindingNameGroup != null) {
                i = 0;
                while (i < bindingNameGroup.length) {
                    subqueryDefn.addResultSetExpression(bindingNameGroup[i], bindingExprGroup[i]);
                    ++i;
                }
            }
            i = 0;
            while (i < subGroupDefn.length) {
                subqueryDefn.addGroup(subGroupDefn[i]);
                ++i;
            }
            ++k;
        }
        FilterDefinition exprFilter = new FilterDefinition((IBaseExpression)new ScriptExpression("row.ROW_COL0+row.ROW_COL2>0"));
        subqueryDefn.addFilter((IFilterDefinition)exprFilter);
        this.bindingNameRow = new String[4];
        this.bindingNameRow[0] = "ROW_COL0";
        this.bindingNameRow[1] = "ROW_COL1";
        this.bindingNameRow[2] = "ROW_COL2";
        this.bindingNameRow[3] = "ROW_COL3";
        this.expressions = new BaseExpression[]{new ScriptExpression("dataSetRow.COL0", 0), new ScriptExpression("dataSetRow.COL1", 0), new ScriptExpression("dataSetRow.COL2", 0), new ScriptExpression("dataSetRow.COL3", 0)};
        i = 0;
        while (i < this.expressions.length) {
            queryDefn.addResultSetExpression(this.bindingNameRow[i], (IBaseExpression)this.expressions[i]);
            ++i;
        }
        queryDefn.addSubquery(subqueryDefn);
        IResultIterator resultIt = this.executeQuery((IQueryDefinition)queryDefn);
        resultIt.next();
        this.bindingNameRow = this.getBindingExpressionName();
        IResultIterator subIterator = resultIt.getSecondaryIterator("IAMTEST", null);
        this.testPrintln("query data");
        this.outputData(subIterator);
        this.checkOutputFile();
    }

    public void testUseParentColumnBindings() throws Exception {
        this.useParentColumnBindings(false);
        this.checkOutputFile();
    }

    public void testUseParentColumnBindingWithAggregation() {
        try {
            this.useParentColumnBindings(true);
            SubQueryTest.fail((String)"Should not arrive here!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void useParentColumnBindings(boolean includeTotal) throws Exception {
        QueryDefinition qd = new QueryDefinition();
        qd.setDataSetName(this.dataSet.getName());
        this.bindingNameRow = new String[4];
        this.bindingNameRow[0] = "ROW_COL0";
        this.bindingNameRow[1] = "ROW_COL1";
        this.bindingNameRow[2] = "ROW_COL2";
        this.bindingNameRow[3] = "ROW_COL3";
        this.expressions = new BaseExpression[]{new ScriptExpression("dataSetRow.COL0", 0), new ScriptExpression("dataSetRow.COL1", 0), new ScriptExpression("dataSetRow.COL2", 0), new ScriptExpression("dataSetRow.COL3", 0)};
        int i = 0;
        while (i < this.bindingNameRow.length) {
            qd.addResultSetExpression(this.bindingNameRow[i], (IBaseExpression)this.expressions[i]);
            ++i;
        }
        GroupDefinition groupDefn = new GroupDefinition();
        groupDefn.setKeyExpression("row.ROW_COL0");
        qd.addGroup(groupDefn);
        SubqueryDefinition subqueryDefn = new SubqueryDefinition("IAMTEST", (IBaseQueryDefinition)qd);
        groupDefn.addSubquery(subqueryDefn);
        String[] bindingNameGroup = new String[]{"sub1Group"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("row.ROW_COL1")};
        GroupDefinition subGroupDefn = new GroupDefinition("group2");
        subGroupDefn.setKeyExpression("row.sub1Group");
        if (bindingNameGroup != null) {
            int i2 = 0;
            while (i2 < bindingNameGroup.length) {
                subqueryDefn.addResultSetExpression(bindingNameGroup[i2], bindingExprGroup[i2]);
                ++i2;
            }
        }
        subqueryDefn.addGroup(subGroupDefn);
        subqueryDefn.addResultSetExpression("sub1Binding1", (IBaseExpression)new ScriptExpression(includeTotal ? "Total.sum(row.ROW_COL2,null,1)" : "row.ROW_COL2"));
        SubqueryDefinition subSubqueryDefn = new SubqueryDefinition("IAMTEST2", (IBaseQueryDefinition)subqueryDefn);
        subGroupDefn.addSubquery(subSubqueryDefn);
        subSubqueryDefn.addResultSetExpression("subsubBinding1", (IBaseExpression)new ScriptExpression("row.sub1Group"));
        subSubqueryDefn.addResultSetExpression("subsubBinding2", (IBaseExpression)new ScriptExpression("row.ROW_COL2"));
        subSubqueryDefn.addResultSetExpression("subsubBinding3", (IBaseExpression)new ScriptExpression("row.sub1Binding1"));
        IResultIterator resultIt = this.executeQuery((IQueryDefinition)qd);
        resultIt.next();
        String outputStr = "";
        int i3 = 0;
        while (i3 < this.expressions.length) {
            Object object = resultIt.getValue(this.bindingNameRow[i3]);
            outputStr = String.valueOf(outputStr) + object.toString() + "    ";
            ++i3;
        }
        this.testPrintln(outputStr);
        IResultIterator subIt = resultIt.getSecondaryIterator("IAMTEST", null);
        subIt.next();
        outputStr = "\t";
        int i4 = 0;
        while (i4 < this.expressions.length) {
            Object object = subIt.getValue(this.bindingNameRow[i4]);
            outputStr = String.valueOf(outputStr) + object.toString() + "    ";
            ++i4;
        }
        outputStr = String.valueOf(outputStr) + subIt.getValue("sub1Binding1").toString();
        this.testPrintln(outputStr);
        IResultIterator subsubIt = subIt.getSecondaryIterator("IAMTEST2", null);
        while (subsubIt.next()) {
            outputStr = "\t\t";
            int i5 = 0;
            while (i5 < this.expressions.length) {
                Object object = subsubIt.getValue(this.bindingNameRow[i5]);
                outputStr = String.valueOf(outputStr) + object.toString() + "    ";
                ++i5;
            }
            outputStr = String.valueOf(outputStr) + subsubIt.getValue("sub1Binding1").toString() + "\t";
            outputStr = String.valueOf(outputStr) + subsubIt.getValue("subsubBinding1").toString() + "\t";
            outputStr = String.valueOf(outputStr) + subsubIt.getValue("subsubBinding2").toString() + "\t";
            outputStr = String.valueOf(outputStr) + subsubIt.getValue("subsubBinding3").toString() + "\t";
            this.testPrintln(outputStr);
        }
    }

    private void outputData(IResultIterator resultIt) throws Exception {
        while (resultIt.next()) {
            String outputStr = "";
            int i = 0;
            while (i < this.expressions.length) {
                Object object = resultIt.getValue(this.bindingNameRow[i]);
                outputStr = String.valueOf(outputStr) + object.toString() + "    ";
                ++i;
            }
            this.testPrintln(outputStr);
        }
    }
}

