/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ColumnDefinition;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.binding.APITestCase;
import testutil.ConfigText;

public class ScopedCacheTest
extends APITestCase {
    private String tableName;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.tableName = ConfigText.getString("Api.TestData.TableName");
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.dataEngine.clearCache("12345");
    }

    @Override
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Api.TestData.TableName"), ConfigText.getString("Api.TestData.TableSQL"), ConfigText.getString("Api.TestData.TestDataFileName"));
    }

    public void test1() throws Exception {
        OdaDataSetDesign design = this.newDataSet("testCache", "select COUNTRY from " + this.tableName);
        design.addResultSetHint((IColumnDefinition)new ColumnDefinition("COUNTRY"));
        this.dataEngine.defineDataSet((IBaseDataSetDesign)design);
        QueryDefinition query = this.newReportQuery((IBaseDataSetDesign)design);
        query.setAutoBinding(true);
        this.executeQuery(query, new String[]{"COUNTRY"});
        this.testPrintln("Cache Complete");
        design = this.newDataSet("testCache", "select COUNTRY, CITY from " + this.tableName);
        design.addResultSetHint((IColumnDefinition)new ColumnDefinition("COUNTRY"));
        design.addResultSetHint((IColumnDefinition)new ColumnDefinition("CITY"));
        this.dataEngine.defineDataSet((IBaseDataSetDesign)design);
        query = this.newReportQuery((IBaseDataSetDesign)design);
        query.setAutoBinding(true);
        this.executeQuery(query, new String[]{"COUNTRY", "CITY"});
        this.checkOutputFile();
    }

    public void test2() throws Exception {
        OdaDataSetDesign design = this.newDataSet("testCache", "select COUNTRY from " + this.tableName);
        design.addResultSetHint((IColumnDefinition)new ColumnDefinition("COUNTRY"));
        this.dataEngine.defineDataSet((IBaseDataSetDesign)design);
        QueryDefinition query = this.newReportQuery((IBaseDataSetDesign)design);
        query.setAutoBinding(true);
        this.executeQuery(query, new String[]{"COUNTRY"});
        this.testPrintln("Cache Complete");
        design = this.newDataSet("testCache", "select COUNTRY, CITY from " + this.tableName);
        design.addResultSetHint((IColumnDefinition)new ColumnDefinition("COUNTRY"));
        ColumnDefinition city = new ColumnDefinition("CITY");
        city.setDisplayName("City Display");
        design.addResultSetHint((IColumnDefinition)city);
        this.dataEngine.defineDataSet((IBaseDataSetDesign)design);
        query = this.newReportQuery((IBaseDataSetDesign)design);
        query.setAutoBinding(true);
        this.executeQuery(query, new String[]{"COUNTRY", "CITY"});
        this.checkOutputFile();
    }

    public void test3() throws Exception {
        OdaDataSetDesign design = this.newDataSet("testCache", "select COUNTRY from " + this.tableName);
        design.addResultSetHint((IColumnDefinition)new ColumnDefinition("COUNTRY"));
        this.dataEngine.defineDataSet((IBaseDataSetDesign)design);
        QueryDefinition query = this.newReportQuery((IBaseDataSetDesign)design);
        query.setAutoBinding(true);
        this.executeQuery(query, new String[]{"COUNTRY"});
        this.testPrintln("Cache Complete");
        design = this.newDataSet("testCache", "select COUNTRY, CITY from " + this.tableName);
        design.addResultSetHint((IColumnDefinition)new ColumnDefinition("COUNTRY"));
        ColumnDefinition city = new ColumnDefinition("CITY");
        city.setDisplayName("City Display");
        design.addResultSetHint((IColumnDefinition)city);
        this.dataEngine.defineDataSet((IBaseDataSetDesign)design);
        query = this.newReportQuery((IBaseDataSetDesign)design);
        query.setAutoBinding(true);
        this.executeQuery(query, new String[]{"COUNTRY", "CITY"});
        this.testPrintln("Clear Cache");
        this.dataEngine.clearCache("12345");
        this.executeQuery(query, new String[]{"COUNTRY", "CITY"});
        this.checkOutputFile();
    }

    public void test4() throws Exception {
        OdaDataSetDesign design = this.newDataSet("testCache", "select COUNTRY from " + this.tableName);
        design.addResultSetHint((IColumnDefinition)new ColumnDefinition("COUNTRY"));
        this.dataEngine.defineDataSet((IBaseDataSetDesign)design);
        QueryDefinition query = this.newReportQuery((IBaseDataSetDesign)design);
        query.setAutoBinding(true);
        this.executeQuery(query, new String[]{"COUNTRY"});
        this.testPrintln("Cache Complete");
        design = this.newDataSet("testCache", "select COUNTRY, AMOUNT from " + this.tableName);
        design.addResultSetHint((IColumnDefinition)new ColumnDefinition("COUNTRY"));
        ColumnDefinition amount = new ColumnDefinition("AMOUNT");
        amount.setDisplayName("AMOUNT DISPLAY");
        amount.setDataType(3);
        design.addResultSetHint((IColumnDefinition)amount);
        this.dataEngine.defineDataSet((IBaseDataSetDesign)design);
        query = this.newReportQuery((IBaseDataSetDesign)design);
        query.setAutoBinding(true);
        this.executeQuery(query, new String[]{"COUNTRY", "AMOUNT"});
        this.testPrintln("Clear Cache");
        this.dataEngine.clearCache("12345");
        this.executeQuery(query, new String[]{"COUNTRY", "AMOUNT"});
        this.checkOutputFile();
    }

    public void test5() throws Exception {
        OdaDataSetDesign design = this.newDataSet("testCache", "select COUNTRY from " + this.tableName);
        design.addResultSetHint((IColumnDefinition)new ColumnDefinition("COUNTRY"));
        this.dataEngine.defineDataSet((IBaseDataSetDesign)design);
        QueryDefinition query = this.newReportQuery((IBaseDataSetDesign)design);
        query.setAutoBinding(true);
        this.executeQuery(query, new String[]{"COUNTRY"});
        this.testPrintln("Cache Complete");
        design = this.newDataSet("testCache", "select COUNTRY, AMOUNT from " + this.tableName);
        design.addResultSetHint((IColumnDefinition)new ColumnDefinition("COUNTRY"));
        ColumnDefinition amount = new ColumnDefinition("AMOUNT");
        amount.setDisplayName("AMOUNT DISPLAY");
        amount.setDataType(4);
        design.addResultSetHint((IColumnDefinition)amount);
        this.dataEngine.defineDataSet((IBaseDataSetDesign)design);
        query = this.newReportQuery((IBaseDataSetDesign)design);
        query.setAutoBinding(true);
        this.executeQuery(query, new String[]{"COUNTRY", "AMOUNT"});
        this.testPrintln("Clear Cache");
        this.dataEngine.clearCache("12345");
        this.executeQuery(query, new String[]{"COUNTRY", "AMOUNT"});
        this.checkOutputFile();
    }

    @Override
    protected Map getAppContext() {
        HashMap<String, Object> appContext = new HashMap<String, Object>();
        appContext.put(DataEngine.MEMORY_DATA_SET_CACHE, 5);
        appContext.put(DataEngine.QUERY_EXECUTION_SESSION_ID, "12345");
        return appContext;
    }
}

