/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import com.ibm.icu.util.Calendar;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import junit.framework.TestCase;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.executor.cache.SizeOfUtil;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class SizeOfUtilTest
extends TestCase {
    private ResultClass resultClass;
    private SizeOfUtil sizeOfUtil;

    public void setUp() throws DataException {
        this.resultClass = this.getResultClass();
        this.sizeOfUtil = new SizeOfUtil((IResultClass)this.resultClass);
    }

    public void testSizeOfUtil() throws DataException {
        if (System.getProperty("java.version").startsWith("1.5")) {
            this.runWithJDK15();
        } else {
            this.runWithJDK14();
        }
    }

    private void runWithJDK14() throws DataException {
        SizeOfUtilTest.assertEquals((int)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObject(1, 1)), (int)304);
        SizeOfUtilTest.assertEquals((int)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObject(3, 3)), (int)312);
        SizeOfUtilTest.assertEquals((int)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObject(3, 7)), (int)320);
        SizeOfUtilTest.assertEquals((int)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObject(5, 8)), (int)320);
        SizeOfUtilTest.assertEquals((int)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObject(12, 7)), (int)336);
        SizeOfUtilTest.assertEquals((int)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObject(7, 12)), (int)328);
        SizeOfUtilTest.assertEquals((int)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObject(18, 22)), (int)360);
        SizeOfUtilTest.assertEquals((int)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObject(38, 42)), (int)416);
        SizeOfUtilTest.assertEquals((int)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObjectWithNull(3, 3, new int[]{2, 4, 6, 7})), (int)144);
        SizeOfUtilTest.assertEquals((int)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObjectWithNull(3, 3, new int[]{2, 4})), (int)208);
        SizeOfUtilTest.assertEquals((int)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObjectWithNull(3, 7, new int[]{2, 7})), (int)192);
        SizeOfUtilTest.assertEquals((int)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObjectWithNull(5, 8, new int[]{3, 6})), (int)272);
        SizeOfUtilTest.assertEquals((int)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObjectWithNull(12, 7, new int[]{1, 4, 5})), (int)272);
    }

    private void runWithJDK15() throws DataException {
        SizeOfUtilTest.assertEquals((int)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObject(1, 1)), (int)328);
        SizeOfUtilTest.assertEquals((int)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObject(3, 3)), (int)336);
        SizeOfUtilTest.assertEquals((int)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObject(3, 7)), (int)344);
        SizeOfUtilTest.assertEquals((int)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObject(5, 8)), (int)344);
        SizeOfUtilTest.assertEquals((int)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObject(12, 7)), (int)360);
        SizeOfUtilTest.assertEquals((int)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObject(7, 12)), (int)352);
        SizeOfUtilTest.assertEquals((int)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObject(18, 22)), (int)384);
        SizeOfUtilTest.assertEquals((int)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObject(38, 42)), (int)440);
        SizeOfUtilTest.assertEquals((int)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObjectWithNull(3, 3, new int[]{2, 4, 6, 7})), (int)152);
        SizeOfUtilTest.assertEquals((int)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObjectWithNull(3, 3, new int[]{2, 4})), (int)216);
        SizeOfUtilTest.assertEquals((int)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObjectWithNull(3, 7, new int[]{2, 7})), (int)200);
        SizeOfUtilTest.assertEquals((int)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObjectWithNull(5, 8, new int[]{3, 6})), (int)296);
        SizeOfUtilTest.assertEquals((int)this.sizeOfUtil.sizeOf((IResultObject)this.getResultObjectWithNull(12, 7, new int[]{1, 4, 5})), (int)288);
    }

    private ResultClass getResultClass() throws DataException {
        ArrayList<ResultFieldMetadata> columnList = new ArrayList<ResultFieldMetadata>();
        ResultFieldMetadata metaData = null;
        metaData = new ResultFieldMetadata(1, "1", "1", Integer.class, Integer.class.getName(), false);
        columnList.add(metaData);
        metaData = new ResultFieldMetadata(2, "2", "2", Double.class, Double.class.getName(), false);
        columnList.add(metaData);
        metaData = new ResultFieldMetadata(3, "3", "3", BigDecimal.class, BigDecimal.class.getName(), false);
        columnList.add(metaData);
        metaData = new ResultFieldMetadata(4, "4", "4", Date.class, Date.class.getName(), false);
        columnList.add(metaData);
        metaData = new ResultFieldMetadata(5, "5", "5", Time.class, Time.class.getName(), false);
        columnList.add(metaData);
        metaData = new ResultFieldMetadata(6, "6", "6", Timestamp.class, Timestamp.class.getName(), false);
        columnList.add(metaData);
        metaData = new ResultFieldMetadata(7, "7", "7", byte[].class, byte[].class.getName(), false);
        columnList.add(metaData);
        metaData = new ResultFieldMetadata(8, "8", "8", String.class, String.class.getName(), false);
        columnList.add(metaData);
        ResultClass reClass = new ResultClass(columnList);
        return reClass;
    }

    private ResultObject getResultObject(int strLen, int byteLen) {
        return this.getResultObjectWithNull(strLen, byteLen, new int[0]);
    }

    private ResultObject getResultObjectWithNull(int strLen, int byteLen, int[] nullPos) {
        Object[] objectArray = new Object[8];
        Calendar calendar = Calendar.getInstance();
        objectArray[0] = new Integer(10);
        objectArray[1] = new Double(10.0);
        objectArray[2] = new BigDecimal("1111111111111111111111111111");
        calendar.clear();
        calendar.set(1919, 2, 2);
        objectArray[3] = calendar.getTime();
        calendar.clear();
        calendar.set(1970, 0, 1, 19, 2, 2);
        objectArray[4] = new Time(calendar.getTimeInMillis());
        calendar.clear();
        calendar.set(1919, 2, 2, 2, 2, 2);
        objectArray[5] = new Timestamp(calendar.getTimeInMillis());
        ((Timestamp)objectArray[5]).setNanos(2);
        objectArray[6] = new byte[byteLen];
        objectArray[7] = org.eclipse.birt.data.engine.perf.util.SizeOfUtil.newString(strLen);
        int i = 0;
        while (i < nullPos.length) {
            objectArray[nullPos[i]] = null;
            ++i;
        }
        ResultObject object = new ResultObject((IResultClass)this.resultClass, objectArray);
        return object;
    }
}

