/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.group;

import junit.framework.TestCase;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.transform.group.GroupBy;
import org.eclipse.birt.data.engine.odi.IQuery;

public class GroupByDistinctValueTest
extends TestCase {
    protected GroupDefinition groupDefn;
    protected GroupBy groupBy;

    protected void setUp() throws Exception {
        this.groupDefn = new GroupDefinition();
        this.groupDefn.setInterval(0);
        this.groupDefn.setIntervalRange(0.0);
        this.groupBy = this.getInstance(this.groupDefn);
        super.setUp();
    }

    public void testIsInSameGroup() throws DataException {
        Object currentGroupKey = null;
        Object previousGroupKey = null;
        GroupByDistinctValueTest.assertTrue((boolean)this.groupBy.isInSameGroup(currentGroupKey, previousGroupKey));
        currentGroupKey = "test";
        previousGroupKey = null;
        GroupByDistinctValueTest.assertFalse((boolean)this.groupBy.isInSameGroup(currentGroupKey, previousGroupKey));
        currentGroupKey = "test";
        previousGroupKey = "test";
        GroupByDistinctValueTest.assertTrue((boolean)this.groupBy.isInSameGroup(currentGroupKey, previousGroupKey));
        currentGroupKey = "test";
        previousGroupKey = "test2";
        GroupByDistinctValueTest.assertFalse((boolean)this.groupBy.isInSameGroup(currentGroupKey, previousGroupKey));
        currentGroupKey = new Integer("1");
        previousGroupKey = new Integer("1");
        GroupByDistinctValueTest.assertTrue((boolean)this.groupBy.isInSameGroup(currentGroupKey, previousGroupKey));
        currentGroupKey = new Integer("1");
        previousGroupKey = new Integer("2");
        GroupByDistinctValueTest.assertFalse((boolean)this.groupBy.isInSameGroup(currentGroupKey, previousGroupKey));
        currentGroupKey = new Integer("1");
        previousGroupKey = new Double("1");
        GroupByDistinctValueTest.assertFalse((boolean)this.groupBy.isInSameGroup(currentGroupKey, previousGroupKey));
    }

    protected GroupBy getInstance(GroupDefinition groupDefn) throws DataException {
        String groupKey = groupDefn.getKeyColumn();
        IQuery.GroupSpec groupSpec = new IQuery.GroupSpec(groupKey);
        groupSpec.setName(groupDefn.getName());
        groupSpec.setInterval(groupDefn.getInterval());
        groupSpec.setIntervalRange(groupDefn.getIntervalRange());
        groupSpec.setIntervalStart(groupDefn.getIntervalStart());
        groupSpec.setSortDirection(groupDefn.getSortDirection());
        return GroupBy.newInstance((IQuery.GroupSpec)groupSpec, (int)0, null, null);
    }
}

