/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.expression;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.expression.Messages;

public class ExpressionCompilerUtilTest
extends TestCase {
    String[] oldExpressions;

    public ExpressionCompilerUtilTest() {
        String[] stringArray = new String[13];
        stringArray[1] = "   " + Messages.getString("ExpressionUtilTest.old.0");
        stringArray[2] = Messages.getString("ExpressionUtilTest.old.1");
        stringArray[3] = Messages.getString("ExpressionUtilTest.old.2");
        stringArray[4] = Messages.getString("ExpressionUtilTest.old.3");
        stringArray[5] = Messages.getString("ExpressionUtilTest.old.4");
        stringArray[6] = Messages.getString("ExpressionUtilTest.old.5");
        stringArray[7] = Messages.getString("ExpressionUtilTest.old.6");
        stringArray[8] = Messages.getString("ExpressionUtilTest.old.7");
        stringArray[9] = Messages.getString("ExpressionUtilTest.old.8");
        stringArray[10] = Messages.getString("ExpressionUtilTest.old.9");
        stringArray[11] = Messages.getString("ExpressionUtilTest.old.10");
        stringArray[12] = Messages.getString("ExpressionUtilTest.old.11");
        this.oldExpressions = stringArray;
    }

    public void testExpression1() {
        String expression = this.oldExpressions[1];
        try {
            List list = ExpressionCompilerUtilTest.extractColumnExpression((IBaseExpression)new ScriptExpression(expression));
            ExpressionCompilerUtilTest.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        }
        catch (BirtException birtException) {
            ExpressionCompilerUtilTest.fail((String)"An exception occurs");
        }
    }

    public void testExpression2() {
        String expression = this.oldExpressions[2];
        try {
            List list = ExpressionCompilerUtilTest.extractColumnExpression((IBaseExpression)new ScriptExpression(expression));
            ExpressionCompilerUtilTest.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        }
        catch (BirtException birtException) {
            ExpressionCompilerUtilTest.fail((String)"An exception occurs");
        }
    }

    public void testExpression3() {
        String expression = this.oldExpressions[3];
        try {
            List list = ExpressionCompilerUtilTest.extractColumnExpression((IBaseExpression)new ScriptExpression(expression));
            ExpressionCompilerUtilTest.assertTrue((list.size() == 2 ? 1 : 0) != 0);
        }
        catch (BirtException birtException) {
            ExpressionCompilerUtilTest.fail((String)"An exception occurs");
        }
    }

    public void testExpression4() {
        String expression = this.oldExpressions[4];
        try {
            List list = ExpressionCompilerUtilTest.extractColumnExpression((IBaseExpression)new ScriptExpression(expression));
            ExpressionCompilerUtilTest.assertTrue((boolean)list.isEmpty());
        }
        catch (BirtException birtException) {}
    }

    public void testExpression5() {
        String expression = this.oldExpressions[5];
        try {
            List list = ExpressionCompilerUtilTest.extractColumnExpression((IBaseExpression)new ScriptExpression(expression));
            ExpressionCompilerUtilTest.assertTrue((boolean)list.isEmpty());
        }
        catch (BirtException birtException) {}
    }

    public void testExpression6() {
        String expression = this.oldExpressions[6];
        try {
            List list = ExpressionCompilerUtilTest.extractColumnExpression((IBaseExpression)new ScriptExpression(expression));
            ExpressionCompilerUtilTest.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        }
        catch (BirtException birtException) {
            ExpressionCompilerUtilTest.fail((String)"An exception occurs");
        }
    }

    public void testExpression7() {
        String expression = this.oldExpressions[7];
        try {
            List list = ExpressionCompilerUtilTest.extractColumnExpression((IBaseExpression)new ScriptExpression(expression));
            ExpressionCompilerUtilTest.assertTrue((boolean)list.isEmpty());
        }
        catch (BirtException birtException) {}
    }

    public void testExpression8() {
        String expression = this.oldExpressions[8];
        try {
            List list = ExpressionCompilerUtilTest.extractColumnExpression((IBaseExpression)new ScriptExpression(expression));
            ExpressionCompilerUtilTest.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        }
        catch (BirtException birtException) {
            ExpressionCompilerUtilTest.fail((String)"An exception occurs");
        }
    }

    public void testExpression9() {
        String expression = this.oldExpressions[9];
        try {
            List list = ExpressionCompilerUtilTest.extractColumnExpression((IBaseExpression)new ScriptExpression(expression));
            ExpressionCompilerUtilTest.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        }
        catch (BirtException birtException) {
            ExpressionCompilerUtilTest.fail((String)"An exception occurs");
        }
    }

    public void testExpression10() {
        String expression = this.oldExpressions[10];
        try {
            List list = ExpressionCompilerUtilTest.extractColumnExpression((IBaseExpression)new ScriptExpression(expression));
            ExpressionCompilerUtilTest.assertTrue((list.size() == 2 ? 1 : 0) != 0);
        }
        catch (BirtException birtException) {
            ExpressionCompilerUtilTest.fail((String)"An exception occurs");
        }
    }

    public void testExpression11() {
        String expression = this.oldExpressions[11];
        try {
            List list = ExpressionCompilerUtilTest.extractColumnExpression((IBaseExpression)new ScriptExpression(expression));
            ExpressionCompilerUtilTest.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        }
        catch (BirtException birtException) {
            ExpressionCompilerUtilTest.fail((String)"An exception occurs");
        }
    }

    public void testExpression12() {
        String expression = this.oldExpressions[12];
        try {
            List list = ExpressionCompilerUtilTest.extractColumnExpression((IBaseExpression)new ScriptExpression(expression));
            ExpressionCompilerUtilTest.assertTrue((list.size() == 2 ? 1 : 0) != 0);
        }
        catch (BirtException birtException) {
            ExpressionCompilerUtilTest.fail((String)"An exception occurs");
        }
    }

    public void testAggregationExpression13() {
        String expression = "row[\"customer\"].replace(\"aa\",\"bb\")";
        String expression2 = "( row[\"customer\"]+ row.customer ).replace(\"aa\",\"bb\")";
        String expression3 = "( row[\"customer\"]+ row.customer ).replace(row.aaa.replace(\"aa\",\"bb\"), row.bbb );";
        try {
            List list = ExpressionCompilerUtilTest.extractColumnExpression((IBaseExpression)new ScriptExpression(expression));
            ExpressionCompilerUtilTest.assertTrue((list.size() == 1 ? 1 : 0) != 0);
            list = ExpressionCompilerUtilTest.extractColumnExpression((IBaseExpression)new ScriptExpression(expression2));
            ExpressionCompilerUtilTest.assertTrue((list.size() == 1 ? 1 : 0) != 0);
            list = ExpressionCompilerUtilTest.extractColumnExpression((IBaseExpression)new ScriptExpression(expression3));
            ExpressionCompilerUtilTest.assertTrue((list.size() == 3 ? 1 : 0) != 0);
        }
        catch (BirtException birtException) {
            ExpressionCompilerUtilTest.fail((String)"An exception occurs");
        }
    }

    public void testConditionalExpression() {
        ConditionalExpression ce1 = new ConditionalExpression("row[\"abc\"]", 1, "row[\"abc1\"]");
        ConditionalExpression ce2 = new ConditionalExpression("row[\"abc\"]+row[\"abc\"]", 1, "row[\"abc\"]");
        ConditionalExpression ce3 = new ConditionalExpression("row[\"abc\"] + row[\"abc3\"]", 1, "row[\"abc2\"]");
        try {
            List list = ExpressionCompilerUtilTest.extractColumnExpression((IBaseExpression)ce1);
            ExpressionCompilerUtilTest.assertEquals((int)list.size(), (int)2);
            list = ExpressionCompilerUtilTest.extractColumnExpression((IBaseExpression)ce2);
            ExpressionCompilerUtilTest.assertEquals((int)list.size(), (int)1);
            list = ExpressionCompilerUtilTest.extractColumnExpression((IBaseExpression)ce3);
            ExpressionCompilerUtilTest.assertEquals((int)list.size(), (int)3);
        }
        catch (DataException dataException) {
            ExpressionCompilerUtilTest.fail((String)"An exception occurs");
        }
    }

    public void testHasRowExprInAggregation() {
        String expression1 = "row[\"customer\"].replace( Total.sum( row.aa ),\"bb\")";
        String expression2 = "Total.sum( row.aaa + row.bbb )+ ccc";
        String expression3 = "Total.count( abc )+ ccc";
        String expression4 = "row.aaa + Total.sum( Total.sum(row.aaa)+1)";
        String expression5 = "row.aaa + Total.sum( Total.sum(dataSetRow.aaa)+1)";
        String expression6 = " dataSetRow.aaa + Total.sum( row.abc + dataSetRow.abc )";
        String expression7 = " Total.sum( abc + dataSetRow.abc, row.aaa>0, 1 )";
        String expression8 = " row.aaa + row.bbb + \"Total\"";
        ConditionalExpression ce1 = new ConditionalExpression(expression3, 0, expression5, expression7);
        ConditionalExpression ce2 = new ConditionalExpression(expression1, 0, expression5, expression7);
        ConditionalExpression ce3 = new ConditionalExpression(expression3, 0, expression5, null);
        ExpressionCompilerUtilTest.assertTrue((boolean)ExpressionCompilerUtil.hasAggregationInExpr((IBaseExpression)new ScriptExpression(expression1)));
        ExpressionCompilerUtilTest.assertTrue((boolean)ExpressionCompilerUtil.hasAggregationInExpr((IBaseExpression)new ScriptExpression(expression2)));
        ExpressionCompilerUtilTest.assertTrue((boolean)ExpressionCompilerUtil.hasAggregationInExpr((IBaseExpression)new ScriptExpression(expression3)));
        ExpressionCompilerUtilTest.assertTrue((boolean)ExpressionCompilerUtil.hasAggregationInExpr((IBaseExpression)new ScriptExpression(expression4)));
        ExpressionCompilerUtilTest.assertTrue((boolean)ExpressionCompilerUtil.hasAggregationInExpr((IBaseExpression)new ScriptExpression(expression5)));
        ExpressionCompilerUtilTest.assertTrue((boolean)ExpressionCompilerUtil.hasAggregationInExpr((IBaseExpression)new ScriptExpression(expression6)));
        ExpressionCompilerUtilTest.assertTrue((boolean)ExpressionCompilerUtil.hasAggregationInExpr((IBaseExpression)new ScriptExpression(expression7)));
        ExpressionCompilerUtilTest.assertFalse((boolean)ExpressionCompilerUtil.hasAggregationInExpr((IBaseExpression)new ScriptExpression(expression8)));
        ExpressionCompilerUtilTest.assertTrue((boolean)ExpressionCompilerUtil.hasAggregationInExpr((IBaseExpression)ce1));
        ExpressionCompilerUtilTest.assertTrue((boolean)ExpressionCompilerUtil.hasAggregationInExpr((IBaseExpression)ce2));
        ExpressionCompilerUtilTest.assertTrue((boolean)ExpressionCompilerUtil.hasAggregationInExpr((IBaseExpression)ce3));
    }

    private static List extractColumnExpression(IBaseExpression expression) throws DataException {
        return ExpressionCompilerUtil.extractColumnExpression((IBaseExpression)expression, (String)"row");
    }
}

