/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.ExprManager;
import org.eclipse.birt.data.engine.impl.ExprManagerUtil;
import org.mozilla.javascript.Context;

public class ExprManagerUtilTest
extends TestCase {
    ScriptContext cx;

    protected void setUp() throws Exception {
        super.setUp();
        this.cx = new ScriptContext();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        Context.exit();
    }

    private Map getBindingMap(Map exprMap) throws DataException {
        HashMap result = new HashMap();
        for (Object o : exprMap.keySet()) {
            if (!(exprMap.get(o) instanceof IBaseExpression)) continue;
            Binding b = new Binding(o.toString());
            b.setExpression((IBaseExpression)exprMap.get(o));
            result.put(o, b);
        }
        return result;
    }

    public void testValidateNodes1() throws DataException {
        ExprManager em = new ExprManager(null, this.cx);
        HashMap<String, ScriptExpression> m = new HashMap<String, ScriptExpression>();
        m.put("COL0", new ScriptExpression("row[\"COL1\"]+row[\"COL2\"]+row[\"COL3\"]"));
        m.put("COL2", new ScriptExpression("dataSetRow[\"COL2\"]"));
        m.put("COL1", new ScriptExpression("row[\"COL2\"]+row[\"COL3\"]+dataSetRow[\"COL3\"]"));
        m.put("COL3", new ScriptExpression("row[\"COL2\"]+row[\"COL4\"]"));
        m.put("COL4", new ScriptExpression("row[\"COL2\"]"));
        em.addBindingExpr(null, this.getBindingMap(m), 0);
        try {
            ExprManagerUtil.validateColumnBinding((ExprManager)em, null, (ScriptContext)this.cx);
        }
        catch (DataException dataException) {
            ExprManagerUtilTest.fail((String)"Should not arrive here");
        }
    }

    public void testValidateNodes2() throws DataException {
        ExprManager em = new ExprManager(null, this.cx);
        HashMap<String, ScriptExpression> m = new HashMap<String, ScriptExpression>();
        m.put("COL0", new ScriptExpression("row[\"COL1\"]+row[\"COL2\"]+row[\"COL3\"]"));
        m.put("COL2", new ScriptExpression("dataSetRow[\"COL2\"]"));
        m.put("COL1", new ScriptExpression("row[\"COL0\"]+row[\"COL3\"]+dataSetRow[\"COL3\"]"));
        m.put("COL3", new ScriptExpression("row[\"COL2\"]+row[\"COL4\"]"));
        m.put("COL4", new ScriptExpression("row[\"COL2\"]"));
        em.addBindingExpr(null, this.getBindingMap(m), 0);
        try {
            ExprManagerUtil.validateColumnBinding((ExprManager)em, null, (ScriptContext)this.cx);
            ExprManagerUtilTest.fail((String)"Should not arrive here");
        }
        catch (DataException dataException) {}
    }

    public void testValidateNodes3() throws DataException {
        ExprManager em = new ExprManager(null, this.cx);
        HashMap<String, ScriptExpression> m = new HashMap<String, ScriptExpression>();
        m.put("COL0", new ScriptExpression("row[\"COL1\"]+row[\"COL2\"]+row[\"COL3\"]"));
        m.put("COL2", new ScriptExpression("dataSetRow[\"COL2\"]"));
        m.put("COL1", new ScriptExpression("row[\"COL2\"]+row[\"COL3\"]+dataSetRow[\"COL3\"]"));
        m.put("COL3", new ScriptExpression("row[\"COL2\"]+row[\"COL4\"]"));
        m.put("COL4", new ScriptExpression("row[\"COL0\"]"));
        em.addBindingExpr(null, this.getBindingMap(m), 0);
        try {
            ExprManagerUtil.validateColumnBinding((ExprManager)em, null, (ScriptContext)this.cx);
            ExprManagerUtilTest.fail((String)"Should not arrive here");
        }
        catch (DataException dataException) {}
    }

    public void testValidateNodes4() throws DataException {
        ExprManager em = new ExprManager(null, this.cx);
        HashMap<String, ScriptExpression> m = new HashMap<String, ScriptExpression>();
        m.put("COL0", new ScriptExpression("row[\"COL1\"]+row[\"COL2\"]+row[\"COL3\"]"));
        m.put("COL2", new ScriptExpression("dataSetRow[\"COL2\"]"));
        m.put("COL1", new ScriptExpression("row[\"COL1\"]+row[\"COL3\"]+dataSetRow[\"COL3\"]"));
        m.put("COL3", new ScriptExpression("row[\"COL2\"]+row[\"COL4\"]"));
        m.put("COL4", new ScriptExpression("row[\"COL0\"]"));
        em.addBindingExpr(null, this.getBindingMap(m), 0);
        try {
            ExprManagerUtil.validateColumnBinding((ExprManager)em, null, (ScriptContext)this.cx);
            ExprManagerUtilTest.fail((String)"Should not arrive here");
        }
        catch (DataException dataException) {}
    }

    public void testValidateNodes5() throws DataException {
        ExprManager em = new ExprManager(null, this.cx);
        HashMap<String, ScriptExpression> m = new HashMap<String, ScriptExpression>();
        m.put("COL0", new ScriptExpression("row[\"COL1\"]+row[\"COL2\"]+row[\"COL3\"]"));
        m.put("COL2", new ScriptExpression("dataSetRow[\"COL2\"]"));
        m.put("COL1", new ScriptExpression("row[\"COL2\"]+row[\"COL3\"]+dataSetRow[\"COL3\"]"));
        m.put("COL3", new ScriptExpression("row[\"COL2\"]+row[\"COL4\"]"));
        m.put("COL4", new ScriptExpression("row[\"COL2\"]"));
        em.addBindingExpr("COL0", this.getBindingMap(m), 1);
        m = new HashMap();
        m.put("COL5", new ScriptExpression("row[\"COL1\"]+row[\"COL2\"]+row[\"COL3\"]"));
        m.put("COL6", new ScriptExpression("dataSetRow[\"COL2\"]"));
        m.put("COL7", new ScriptExpression("row[\"COL2\"]+row[\"COL3\"]+dataSetRow[\"COL3\"]"));
        m.put("COL8", new ScriptExpression("row[\"COL2\"]+row[\"COL4\"]"));
        m.put("COL9", new ScriptExpression("row[\"COL8\"]"));
        em.addBindingExpr("COL2", this.getBindingMap(m), 2);
        m = new HashMap();
        m.put("COL10", new ScriptExpression("row[\"COL1\"]+row[\"COL2\"]+row[\"COL3\"]"));
        m.put("COL11", new ScriptExpression("dataSetRow[\"COL2\"]"));
        m.put("COL12", new ScriptExpression("row[\"COL2\"]+row[\"COL3\"]+dataSetRow[\"COL3\"]"));
        m.put("COL13", new ScriptExpression("row[\"COL2\"]+row[\"COL4\"]"));
        m.put("COL14", new ScriptExpression("row[\"COL8\"]"));
        em.addBindingExpr("COL10", this.getBindingMap(m), 3);
        try {
            ExprManagerUtil.validateColumnBinding((ExprManager)em, null, (ScriptContext)this.cx);
        }
        catch (DataException dataException) {
            ExprManagerUtilTest.fail((String)"Should not arrive here");
        }
    }

    public void testValidateNodes6() throws DataException {
        ExprManager em = new ExprManager(null, this.cx);
        HashMap<String, ScriptExpression> m = new HashMap<String, ScriptExpression>();
        m.put("COL0", new ScriptExpression("row[\"COL1\"]+row[\"COL2\"]+row[\"COL3\"]"));
        m.put("COL2", new ScriptExpression("dataSetRow[\"COL2\"]"));
        m.put("COL1", new ScriptExpression("row[\"COL2\"]+row[\"COL3\"]+dataSetRow[\"COL3\"]"));
        m.put("COL3", new ScriptExpression("row[\"COL2\"]+row[\"COL4\"]"));
        m.put("COL4", new ScriptExpression("row[\"COL2\"]"));
        em.addBindingExpr("row.COL0", this.getBindingMap(m), 1);
        m = new HashMap();
        m.put("row.COL5", new ScriptExpression("row[\"COL1\"]+row[\"COL2\"]+row[\"COL3\"]"));
        m.put("COL6", new ScriptExpression("dataSetRow[\"COL2\"]"));
        m.put("COL7", new ScriptExpression("row[\"COL2\"]+row[\"COL3\"]+dataSetRow[\"COL3\"]"));
        m.put("COL8", new ScriptExpression("row[\"COL2\"]+row[\"COL4\"]"));
        m.put("COL9", new ScriptExpression("row[\"COL8\"]"));
        em.addBindingExpr("row.COL10", this.getBindingMap(m), 2);
        m = new HashMap();
        m.put("COL10", new ScriptExpression("row[\"COL1\"]+row[\"COL2\"]+row[\"COL3\"]"));
        m.put("COL11", new ScriptExpression("dataSetRow[\"COL2\"]"));
        m.put("COL12", new ScriptExpression("row[\"COL2\"]+row[\"COL3\"]+dataSetRow[\"COL3\"]"));
        m.put("COL13", new ScriptExpression("row[\"COL2\"]+row[\"COL4\"]"));
        m.put("COL14", new ScriptExpression("row[\"COL8\"]"));
        em.addBindingExpr("row.COL10", this.getBindingMap(m), 3);
        try {
            ExprManagerUtil.validateColumnBinding((ExprManager)em, null, (ScriptContext)this.cx);
            ExprManagerUtilTest.fail((String)"Should not arrive here");
        }
        catch (DataException dataException) {}
    }

    public void testValidateNodes7() throws DataException {
        ExprManager em = new ExprManager(null, this.cx);
        HashMap<String, ScriptExpression> m = new HashMap<String, ScriptExpression>();
        m.put("COL0", new ScriptExpression("row[\"COL1\"]+row[\"COL2\"]+row[\"COL3\"]"));
        m.put("COL2", new ScriptExpression("dataSetRow[\"COL2\"]"));
        m.put("COL1", new ScriptExpression("row[\"COL2\"]+row[\"COL3\"]+dataSetRow[\"COL3\"]"));
        m.put("COL3", new ScriptExpression("row[\"COL2\"]+row[\"COL4\"]"));
        m.put("COL4", new ScriptExpression("row[\"COL2\"]"));
        em.addBindingExpr("COL0", this.getBindingMap(m), 1);
        m = new HashMap();
        m.put("COL5", new ScriptExpression("row[\"COL1\"]+row[\"COL2\"]+row[\"COL3\"]"));
        m.put("COL6", new ScriptExpression("dataSetRow[\"COL2\"]"));
        m.put("COL7", new ScriptExpression("row[\"COL2\"]+row[\"COL3\"]+dataSetRow[\"COL3\"]"));
        m.put("COL8", new ScriptExpression("row[\"COL2\"]+row[\"COL4\"]"));
        m.put("COL9", new ScriptExpression("row[\"COL10\"]"));
        em.addBindingExpr("COL5", this.getBindingMap(m), 2);
        m = new HashMap();
        m.put("COL10", new ScriptExpression("row[\"COL1\"]+row[\"COL2\"]+row[\"COL3\"]"));
        m.put("COL11", new ScriptExpression("dataSetRow[\"COL2\"]"));
        m.put("COL12", new ScriptExpression("row[\"COL2\"]+row[\"COL3\"]+dataSetRow[\"COL3\"]"));
        m.put("COL13", new ScriptExpression("row[\"COL2\"]+row[\"COL4\"]"));
        m.put("COL14", new ScriptExpression("row[\"COL8\"]"));
        em.addBindingExpr("COL10", this.getBindingMap(m), 3);
        try {
            ExprManagerUtil.validateColumnBinding((ExprManager)em, null, (ScriptContext)this.cx);
        }
        catch (DataException dataException) {
            ExprManagerUtilTest.fail((String)"Should not arrive here");
        }
    }

    public void testValidateNodes8() throws DataException {
        ExprManager em = new ExprManager(null, this.cx);
        HashMap<String, ScriptExpression> m = new HashMap<String, ScriptExpression>();
        m.put("COL0", new ScriptExpression("row[\"COL1\"]+row[\"COL2\"]+row[\"COL3\"]"));
        m.put("COL2", new ScriptExpression("dataSetRow[\"COL2\"]"));
        m.put("COL1", new ScriptExpression("row[\"COL2\"]+row[\"COL3\"]+dataSetRow[\"COL3\"]"));
        m.put("COL3", new ScriptExpression("row[\"COL2\"]+row[\"COL4\"]"));
        m.put("COL4", new ScriptExpression("row[\"COL2\"]"));
        em.addBindingExpr("row.COL0", this.getBindingMap(m), 1);
        m = new HashMap();
        m.put("row.COL5", new ScriptExpression("row[\"COL1\"]+row[\"COL11\"]+row[\"COL3\"]"));
        m.put("COL6", new ScriptExpression("dataSetRow[\"COL2\"]"));
        m.put("COL7", new ScriptExpression("row[\"COL2\"]+row[\"COL3\"]+dataSetRow[\"COL3\"]"));
        m.put("COL8", new ScriptExpression("row[\"COL2\"]+row[\"COL4\"]"));
        m.put("COL9", new ScriptExpression("row[\"COL10\"]"));
        em.addBindingExpr("row.COL5", this.getBindingMap(m), 2);
        m = new HashMap();
        m.put("row.COL10", new ScriptExpression("row[\"COL1\"]+row[\"COL2\"]+row[\"COL3\"]"));
        m.put("COL11", new ScriptExpression("dataSetRow[\"COL2\"]"));
        m.put("COL12", new ScriptExpression("row[\"COL2\"]+row[\"COL3\"]+dataSetRow[\"COL3\"]"));
        m.put("COL13", new ScriptExpression("row[\"COL2\"]+row[\"COL4\"]"));
        m.put("COL14", new ScriptExpression("row[\"COL8\"]"));
        em.addBindingExpr("row.COL10", this.getBindingMap(m), 3);
        try {
            ExprManagerUtil.validateColumnBinding((ExprManager)em, null, (ScriptContext)this.cx);
            ExprManagerUtilTest.fail((String)"Should not arrive here");
        }
        catch (DataException dataException) {}
    }

    public void testValidateNodes9() throws DataException {
        ExprManager em = new ExprManager(null, this.cx);
        HashMap<String, ScriptExpression> m = new HashMap<String, ScriptExpression>();
        m.put("COL0", new ScriptExpression("row[\"COL1\"]+row[\"COL11\"]+row[\"COL3\"]"));
        m.put("COL2", new ScriptExpression("dataSetRow[\"COL2\"]"));
        m.put("COL1", new ScriptExpression("row[\"COL2\"]+row[\"COL3\"]+dataSetRow[\"COL3\"]"));
        m.put("COL3", new ScriptExpression("row[\"COL2\"]+row[\"COL4\"]"));
        m.put("COL4", new ScriptExpression("row[\"COL11\"]"));
        em.addBindingExpr("row.COL0", this.getBindingMap(m), 1);
        m = new HashMap();
        m.put("COL5", new ScriptExpression("row[\"COL1\"]+row[\"COL11\"]+row[\"COL3\"]"));
        m.put("COL6", new ScriptExpression("dataSetRow[\"COL2\"]"));
        m.put("COL7", new ScriptExpression("row[\"COL2\"]+row[\"COL3\"]+dataSetRow[\"COL3\"]"));
        m.put("COL8", new ScriptExpression("row[\"COL2\"]+row[\"COL4\"]"));
        m.put("COL9", new ScriptExpression("row[\"COL10\"]"));
        em.addBindingExpr("row.COL5", this.getBindingMap(m), 2);
        m = new HashMap();
        m.put("COL10", new ScriptExpression("row[\"COL1\"]+row[\"COL2\"]+row[\"COL3\"]"));
        m.put("COL11", new ScriptExpression("dataSetRow[\"COL2\"]"));
        m.put("COL12", new ScriptExpression("row[\"COL2\"]+row[\"COL3\"]+dataSetRow[\"COL3\"]"));
        m.put("COL13", new ScriptExpression("row[\"COL2\"]+row[\"COL4\"]"));
        m.put("COL14", new ScriptExpression("row[\"COL8\"]"));
        em.addBindingExpr("row.COL10", this.getBindingMap(m), 3);
        try {
            ExprManagerUtil.validateColumnBinding((ExprManager)em, null, (ScriptContext)this.cx);
            ExprManagerUtilTest.fail((String)"Should not arrive here");
        }
        catch (DataException dataException) {}
    }

    public void testValidateNodes10() throws DataException {
        ExprManager em = new ExprManager(null, this.cx);
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("COL0", new ScriptExpression("row[\"COL1\"]+row[\"COL2\"]+row[\"COL3\"]"));
        m.put("COL2", new ScriptExpression("dataSetRow[\"COL2\"]"));
        m.put("COL1", new ScriptExpression("row[\"COL2\"]+row[\"COL3\"]+dataSetRow[\"COL3\"]"));
        m.put("COL3", new ScriptExpression("row[\"COL2\"]+row[\"COL4\"]"));
        m.put("COL4", new ScriptExpression("row[\"COL2\"]"));
        m.put("COL5", new ConditionalExpression("row[\"COL2\"]", 1, "2"));
        em.addBindingExpr(null, this.getBindingMap(m), 0);
        try {
            ExprManagerUtil.validateColumnBinding((ExprManager)em, null, (ScriptContext)this.cx);
        }
        catch (DataException dataException) {
            ExprManagerUtilTest.fail((String)"Should not arrive here");
        }
    }

    public void testValidateNodes11() throws DataException {
        ExprManager em = new ExprManager(null, this.cx);
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("COL0", new ScriptExpression("row[\"COL1\"]+row[\"COL2\"]+row[\"COL3\"]"));
        m.put("COL2", new ScriptExpression("dataSetRow[\"COL2\"]"));
        m.put("COL1", new ScriptExpression("row[\"COL2\"]+row[\"COL3\"]+dataSetRow[\"COL3\"]"));
        m.put("COL3", new ScriptExpression("row[\"COL2\"]+row[\"COL4\"]"));
        m.put("COL4", new ScriptExpression("row[\"COL2\"]"));
        m.put("COL5", new ConditionalExpression("row[\"COL5\"]", 1, "2"));
        em.addBindingExpr(null, this.getBindingMap(m), 0);
        try {
            ExprManagerUtil.validateColumnBinding((ExprManager)em, null, (ScriptContext)this.cx);
            ExprManagerUtilTest.fail((String)"Should not arrive here");
        }
        catch (DataException dataException) {}
    }

    public void testValidateNodes12() throws DataException {
        ExprManager em = new ExprManager(null, this.cx);
        HashMap<String, ScriptExpression> m = new HashMap<String, ScriptExpression>();
        m.put("COL0", new ScriptExpression("1111row[\"COL1\"]+row[\"COL2\"]+row[\"COL3\"]"));
        m.put("COL2", new ScriptExpression("dataSetRow[\"COL2\"]"));
        m.put("COL1", new ScriptExpression("row[\"COL2\"]+row[\"COL3\"]+dataSetRow[\"COL3\"]"));
        m.put("COL3", new ScriptExpression("row[\"COL2\"]+row[\"COL4\"]"));
        m.put("COL4", new ScriptExpression("row[\"COL2\"]"));
        em.addBindingExpr(null, this.getBindingMap(m), 0);
        try {
            ExprManagerUtil.validateColumnBinding((ExprManager)em, null, (ScriptContext)this.cx);
        }
        catch (DataException dataException) {
            ExprManagerUtilTest.fail((String)"Should not arrive here");
        }
    }

    public void testValidateNodes13() throws DataException {
        ExprManager em = new ExprManager(null, this.cx);
        HashMap<String, ScriptExpression> m = new HashMap<String, ScriptExpression>();
        m.put("COL0", new ScriptExpression("row[\"COL1\"]"));
        m.put("COL1", new ScriptExpression("row[\"COL2\"]"));
        m.put("COL2", new ScriptExpression("row[\"COL3\"]"));
        m.put("COL3", new ScriptExpression("row[\"COL4\"]"));
        m.put("COL4", new ScriptExpression("row[\"COL\"]"));
        em.addBindingExpr(null, this.getBindingMap(m), 0);
        try {
            ExprManagerUtil.validateColumnBinding((ExprManager)em, null, (ScriptContext)this.cx);
            ExprManagerUtilTest.fail((String)"Should not arrive here");
        }
        catch (DataException e) {
            e.printStackTrace();
        }
    }

    public void testValidateNodes0() throws DataException {
        ExprManager em = new ExprManager(null, this.cx);
        HashMap<String, ScriptExpression> m = new HashMap<String, ScriptExpression>();
        m.put("COL0", new ScriptExpression("row[\"COL1\"]"));
        m.put("COL1", new ScriptExpression("row[\"COL0\"]"));
        em.addBindingExpr(null, this.getBindingMap(m), 0);
        try {
            ExprManagerUtil.validateColumnBinding((ExprManager)em, null, (ScriptContext)this.cx);
            ExprManagerUtilTest.fail((String)"Should not arrive here");
        }
        catch (DataException e) {
            e.printStackTrace();
        }
    }
}

