/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import org.eclipse.birt.data.engine.api.APITestCase;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.querydefn.ColumnDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.Util;
import testutil.ConfigText;

public class ResultMetaDataTest
extends APITestCase {
    @Override
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Impl.TestData3.TableName"), ConfigText.getString("Impl.TestData3.TableSQL"), ConfigText.getString("Impl.TestData3.TestDataFileName"));
    }

    public void test1_SelectAll() throws Exception {
        OdaDataSetDesign dset = this.newDataSet("dset1", "Select * FROM " + this.getTestTableName());
        QueryDefinition query = this.newReportQuery((IBaseDataSetDesign)dset);
        query.setAutoBinding(true);
        IPreparedQuery pq = this.dataEngine.prepare((IQueryDefinition)query);
        IQueryResults qr = pq.execute(null);
        IResultMetaData md = qr.getResultMetaData();
        this.testPrint(Util.getMetaDadataInfo(md));
        this.checkOutputFile();
        this.closeOutputFile();
        this.openOutputFile();
        md = qr.getResultIterator().getResultMetaData();
        this.testPrint(Util.getMetaDadataInfo(md));
        this.checkOutputFile();
        ResultMetaDataTest.assertEquals((int)17, (int)md.getColumnCount());
        try {
            md.getColumnName(-1);
            ResultMetaDataTest.fail((String)"Exception expected");
        }
        catch (DataException dataException) {}
        try {
            md.getColumnName(18);
            ResultMetaDataTest.fail((String)"Exception expected");
        }
        catch (DataException dataException) {}
    }

    public void test2_ResultHints() throws Exception {
        OdaDataSetDesign dset = this.newDataSet("dset2", "Select * FROM " + this.getTestTableName());
        QueryDefinition query = this.newReportQuery((IBaseDataSetDesign)dset);
        query.setAutoBinding(true);
        ColumnDefinition coldef = new ColumnDefinition("name1");
        coldef.setColumnPosition(1);
        coldef.setAlias("colAlias1");
        coldef.setDataType(3);
        dset.addResultSetHint((IColumnDefinition)coldef);
        coldef = new ColumnDefinition("textCol");
        coldef.setAlias("colAlias2");
        dset.addResultSetHint((IColumnDefinition)coldef);
        coldef = new ColumnDefinition("invalidCol1");
        coldef.setAlias("invalidColAlias1");
        dset.addResultSetHint((IColumnDefinition)coldef);
        coldef = new ColumnDefinition("invalidCol2");
        coldef.setAlias("invalidColAlias2");
        coldef.setColumnPosition(30);
        dset.addResultSetHint((IColumnDefinition)coldef);
        IPreparedQuery pq = this.dataEngine.prepare((IQueryDefinition)query);
        IQueryResults qr = pq.execute(null);
        IResultMetaData md = qr.getResultMetaData();
        this.testPrint(Util.getMetaDadataInfo(md));
        this.checkOutputFile();
    }

    public void test4_ProjectedCol() throws Exception {
        OdaDataSetDesign dset = this.newDataSet("dset4", "Select * FROM " + this.getTestTableName());
        QueryDefinition query = this.newReportQuery((IBaseDataSetDesign)dset);
        query.setAutoBinding(true);
        ComputedColumn compCol = new ComputedColumn("ComputedCol1", "row.intCol * 2", 0);
        dset.addComputedColumn((IComputedColumn)compCol);
        ColumnDefinition coldef = new ColumnDefinition("intCol");
        coldef.setAlias("intCol_alias");
        dset.addResultSetHint((IColumnDefinition)coldef);
        query.setColumnProjection(new String[]{"floatCol", "varbinaryCol", "intCol_alias", "ComputedCol1"});
        IPreparedQuery pq = this.dataEngine.prepare((IQueryDefinition)query);
        IQueryResults qr = pq.execute(null);
        IResultMetaData md = qr.getResultMetaData();
        this.testPrint(Util.getMetaDadataInfo(md));
        this.checkOutputFile();
        query.setColumnProjection(new String[0]);
        pq = this.dataEngine.prepare((IQueryDefinition)query);
        qr = pq.execute(null);
        ResultMetaDataTest.assertTrue((qr.getResultMetaData().getColumnCount() == 18 ? 1 : 0) != 0);
        ResultMetaDataTest.assertTrue((qr.getResultIterator().getResultMetaData().getColumnCount() == 18 ? 1 : 0) != 0);
        query.setColumnProjection(new String[]{"invalid_col"});
        pq = this.dataEngine.prepare((IQueryDefinition)query);
        try {
            qr = pq.execute(null);
        }
        catch (DataException dataException) {}
    }
}

